/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.data.undo;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.ORIGINATOR_ID;
import com.spss.java_client.core.documents.data.cache.CacheColumnInfo;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.core.server.messages.DataEditorMsg.CellValue;
import com.spss.java_client.core.server.messages.DataEditorMsg.SetCellValuesMsg;
import com.spss.java_client.core.server.messages.IDataMsg;
import com.spss.java_client.core.server.packages.IPackage;
import com.spss.java_client.core.server.packages.PackageMgr;
import com.spss.java_client.ui.doc_types.data.DataViewTable;
import com.spss.java_client.ui.doc_types.data.DataViewTableModel;
import com.spss.java_client.ui.doc_types.data.TablePropertyManager;
import com.spss.java_client.ui.undo.SpssUndoManager;
import java.util.Vector;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class ClearCellsEdit
extends AbstractUndoableEdit {
    private SpssUndoManager mManager;
    private DataViewTableModel mDataTableModel;
    private ISpssDataSrc mDataSource;
    private int[] mRows;
    private int[] mColumns;
    private boolean mWasDirty;
    private Vector<OBS[]> mObsVector;
    private TablePropertyManager mUndoTablePropertyManager;

    public ClearCellsEdit(DataViewTable dataViewTable, SpssUndoManager spssUndoManager, int[] nArray, int[] nArray2) {
        this.mDataTableModel = (DataViewTableModel)dataViewTable.getModel();
        this.mManager = spssUndoManager;
        this.mColumns = nArray;
        this.mRows = nArray2;
        this.mDataSource = this.mDataTableModel.getDataSource();
        this.mManager.addEdit(this);
        this.mWasDirty = this.mDataSource.isModified();
        this.mObsVector = new Vector();
        this.doAction(false);
        this.mDataSource.setModified(true);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.doAction(false);
        this.mDataSource.setModified(true);
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.doAction(true);
        this.mDataSource.setModified(this.mWasDirty);
    }

    @Override
    public void die() {
        super.die();
        this.mManager = null;
        this.mDataTableModel = null;
        this.mDataSource = null;
        this.mRows = null;
        this.mColumns = null;
        this.mObsVector.clear();
        this.mObsVector = null;
    }

    private void doAction(boolean bl) {
        SetCellValuesMsg setCellValuesMsg = new SetCellValuesMsg();
        setCellValuesMsg.initialize();
        setCellValuesMsg.setDataSetId(this.mDataSource.getDataSetId());
        setCellValuesMsg.setOriginator(ORIGINATOR_ID.DATAMGR_ORIGINATOR);
        setCellValuesMsg.setDataSetVersion(this.mDataSource.currentCaseSequenceNumber());
        setCellValuesMsg.setUndoFlag(bl);
        int n = 0;
        for (int n2 : this.mColumns) {
            CacheColumnInfo.Type type;
            ISpssVariable iSpssVariable = this.mDataSource.getVariable(n2);
            if (iSpssVariable == null) continue;
            LocallyUniqueId locallyUniqueId = iSpssVariable.getId();
            CacheColumnInfo.Type type2 = type = iSpssVariable.getType() == 0 ? CacheColumnInfo.Type.Double : CacheColumnInfo.Type.String;
            if (!bl && this.mObsVector.size() <= n) {
                this.mObsVector.add(new OBS[this.mRows.length]);
            }
            for (int n3 : this.mRows) {
                if ((long)n3 >= this.mDataSource.rowCount()) continue;
                OBS oBS = iSpssVariable.getType() == 0 ? new OBS(this.mDataSource.getSystemMissing()) : new OBS("");
                setCellValuesMsg.addCellValue(new CellValue((long)n3, locallyUniqueId, type, oBS));
            }
            ++n;
        }
        if (setCellValuesMsg.getCellValues() != null && setCellValuesMsg.getCellValues().size() > 0) {
            IPackage iPackage = PackageMgr.getPkgMgr().getPackage(null, "DataEditorPkg");
            iPackage.sendAsyncMessage((IDataMsg)setCellValuesMsg);
            this.mDataSource.getCacheMgr().clearCache();
            this.mDataTableModel.fireTableDataChanged();
            this.mManager.getSpssFrame().updateToolbarEnableStatus();
        }
    }
}

