/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.data.serialize;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.comp_util.InDataStream;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.doc_types.data.DataView;
import com.spss.java_client.ui.doc_types.data.VarViewTable;
import com.spss.java_client.ui.doc_types.data.VarViewTableModel;
import com.spss.java_client.ui.doc_types.data.serialize.DataSerializer;
import com.spss.java_client.ui.doc_types.data.undo.DeleteVariablesEdit;
import com.spss.java_client.ui.doc_types.data.undo.VariableInsertEdit;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.java_client.ui.undo.SpssUndoManager;
import com.spss.uitools.clipboard.AppClipboard;
import java.awt.datatransfer.DataFlavor;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.undo.CompoundEdit;

public class DataSerializerPasteVariables
extends DataSerializer {
    private Vector<ISpssVariable> mCopiedItems;

    public Vector<ISpssVariable> getCopiedItems() {
        return this.mCopiedItems;
    }

    public int numberOfElementsSelected(DataFlavor dataFlavor) {
        Object object;
        AppClipboard appClipboard = AppClipboard.getAppClipboard();
        if (appClipboard.isFlavorAvailable(dataFlavor) && (object = appClipboard.getClipboardData(dataFlavor)) instanceof DataSerializer.DEData) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(((DataSerializer.DEData)object).getBytes());
            this.mInStream = new InDataStream(byteBuffer);
            this.mInStream.setCharSetName(ComponentState.getCurrentCharsetName());
            this.mInStream.retrieveString();
            this.mCopiedItems = this.readVariables();
            return this.mCopiedItems.size();
        }
        return 0;
    }

    @Override
    protected void applyVarViewVariables(VarViewTable varViewTable, Vector<ISpssVariable> vector) {
        int n;
        int n2;
        int[] nArray = varViewTable.getSelectedRows();
        SpssUndoManager spssUndoManager = ((VarViewTableModel)varViewTable.getModel()).getUndoManager();
        CompoundEdit compoundEdit = new CompoundEdit();
        spssUndoManager.addEdit(compoundEdit);
        JTable jTable = varViewTable.getDataView().getDataTables()[1];
        varViewTable.clearSelection();
        jTable.clearSelection();
        ISpssDataSrc iSpssDataSrc = ((VarViewTableModel)varViewTable.getModel()).getDataSource();
        boolean bl = true;
        if (nArray[0] < iSpssDataSrc.columnCount() - 1 && vector.size() > 1 && (n2 = SpssAlertOptionPane.showConfirmDialog(varViewTable, ResUtil.getCommonDlgString("ERR_REPLACE_EXISITING_VARIABLE_IN_DATASET"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eWarning, SpssAlertOptionPane.OptionType.YES_NO_OPTION)) == 2) {
            bl = false;
        }
        if (!bl) {
            for (int n3 : nArray) {
                varViewTable.addColumnSelectionInterval(varViewTable.getColumnCount() - 1, 0);
                varViewTable.addRowSelectionInterval(n3, n3);
                jTable.addColumnSelectionInterval(0, 0);
                jTable.addRowSelectionInterval(n3, n3);
            }
            return;
        }
        for (ISpssVariable object2 : vector) {
            if (iSpssDataSrc.findVarIndex(object2.getName()) == -1) continue;
            SpssAlertOptionPane.showWarningMessageDialog(varViewTable, ResUtil.getCommonDlgString("ERR_DUP_VARIABLE_IN_DATASET"), VersionInfo.getAppVersionString());
            compoundEdit.die();
            for (int serializable : nArray) {
                varViewTable.addColumnSelectionInterval(varViewTable.getColumnCount() - 1, 0);
                varViewTable.addRowSelectionInterval(serializable, serializable);
                jTable.addColumnSelectionInterval(0, 0);
                jTable.addRowSelectionInterval(serializable, serializable);
            }
            return;
        }
        int n4 = n = nArray.length < vector.size() ? nArray.length : vector.size();
        if (n > 0 && iSpssDataSrc.columnCount() < nArray[n - 1] && !varViewTable.getDataView().canAddNewVariable()) {
            compoundEdit.die();
            return;
        }
        DataFrame dataFrame = (DataFrame)spssUndoManager.getSpssFrame();
        int n5 = nArray[0];
        for (ISpssVariable iSpssVariable : vector) {
            Serializable cloneNotSupportedException;
            ISpssVariable iSpssVariable2;
            if (nArray[0] > iSpssDataSrc.columnCount()) {
                while (iSpssDataSrc.columnCount() < nArray[0]) {
                    if (!dataFrame.checkDataLimit(false, 1L)) {
                        compoundEdit.die();
                        return;
                    }
                    new VariableInsertEdit(spssUndoManager, iSpssDataSrc, iSpssDataSrc.columnCount(), 1, 0);
                }
            }
            try {
                iSpssVariable2 = iSpssVariable.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException2) {
                cloneNotSupportedException2.printStackTrace();
                compoundEdit.die();
                return;
            }
            if (!dataFrame.checkDataLimit(false, 1L)) {
                compoundEdit.die();
                return;
            }
            if (n5 < iSpssDataSrc.columnCount()) {
                cloneNotSupportedException = (VarViewTableModel)varViewTable.getModel();
                DataView dataView = varViewTable.getDataView();
                new DeleteVariablesEdit(spssUndoManager, (VarViewTableModel)cloneNotSupportedException, iSpssDataSrc, new int[]{n5}, dataView);
                Vector<ISpssVariable> vector2 = new Vector<ISpssVariable>();
                vector2.add(iSpssVariable2);
                new VariableInsertEdit(spssUndoManager, iSpssDataSrc, n5, vector2);
            } else {
                cloneNotSupportedException = new Vector();
                ((Vector)cloneNotSupportedException).add(iSpssVariable2);
                new VariableInsertEdit(spssUndoManager, iSpssDataSrc, n5, (Vector<ISpssVariable>)cloneNotSupportedException);
            }
            varViewTable.addColumnSelectionInterval(varViewTable.getColumnCount() - 1, 0);
            varViewTable.addRowSelectionInterval(n5, n5);
            jTable.addColumnSelectionInterval(0, 0);
            jTable.addRowSelectionInterval(n5, n5);
            ++n5;
        }
        compoundEdit.end();
    }
}

