/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.data.serialize;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.comp_util.InDataStream;
import com.spss.java_client.core.comp_util.OutDataStream;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.core.documents.data.dictionary.CaseIterator;
import com.spss.java_client.core.documents.data.dictionary.ColumnDataProvider;
import com.spss.java_client.core.documents.data.dictionary.DisplayAlignment;
import com.spss.java_client.core.documents.data.dictionary.FormatType;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.core.documents.data.dictionary.Role;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.core.documents.data.dictionary.SpssVariable;
import com.spss.java_client.core.documents.data.dictionary.value_labels.IValueLabelMap;
import com.spss.java_client.core.documents.data.dictionary.value_labels.SpssVLMapId;
import com.spss.java_client.core.documents.data.dictionary.value_labels.ValueLabelMap;
import com.spss.java_client.core.server.IDataStream;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.doc_types.data.DataViewTable;
import com.spss.java_client.ui.doc_types.data.DataViewTableModel;
import com.spss.java_client.ui.doc_types.data.VarViewTable;
import com.spss.java_client.ui.doc_types.data.VarViewTableModel;
import com.spss.java_client.ui.doc_types.data.undo.DeleteVariablesEdit;
import com.spss.java_client.ui.doc_types.data.undo.ModifyVariableEdit;
import com.spss.java_client.ui.doc_types.data.undo.RowInsertEdit;
import com.spss.java_client.ui.doc_types.data.undo.TableColumnEdit;
import com.spss.java_client.ui.doc_types.data.undo.VariableInsertEdit;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.java_client.ui.undo.SpssUndoManager;
import com.spss.shared.core_tools.format.CellValueFormatter;
import com.spss.shared.core_tools.format.ValueFormatter;
import com.spss.uitools.clipboard.AppClipboard;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.undo.CompoundEdit;

public class DataSerializer {
    public static final DataFlavor DATA_CELL_FLAVOR = new DataFlavor(DataCells.class, "DEData Cells");
    public static final DataFlavor DATA_COL_FLAVOR = new DataFlavor(DataCols.class, "DEData Columns");
    public static final DataFlavor DATA_ROW_FLAVOR = new DataFlavor(DataRows.class, "DEData Rows");
    public static final DataFlavor VAR_CELL_FLAVOR = new DataFlavor(VariableCells.class, "Variable Cells");
    public static final DataFlavor VAR_ROW_FLAVOR = new DataFlavor(VariableRows.class, "Variable Rows");
    protected OutDataStream mOutStream = new OutDataStream();
    protected InDataStream mInStream = null;

    public DataSerializer() {
        this.mOutStream.setCharSetName(ComponentState.getCurrentCharsetName());
    }

    public DEData serializeDataViewSelection(DataViewTable dataViewTable) {
        DEData dEData = null;
        try {
            String string;
            int[] nArray = dataViewTable.getSelectedRows();
            int[] nArray2 = dataViewTable.getSelectedColumns();
            SelectionType selectionType = DataSerializer.selectionType(dataViewTable, true, nArray, nArray2);
            if (!(selectionType.equals((Object)SelectionType.DATA_CELLS) || selectionType.equals((Object)SelectionType.DATA_COLS) || selectionType.equals((Object)SelectionType.DATA_ROWS))) {
                return dEData;
            }
            if (dataViewTable instanceof DataViewTable) {
                int[] nArray3;
                long l;
                string = ((DataViewTableModel)dataViewTable.getModel()).getDataSource();
                long l2 = (long)nArray.length > string.rowCount() ? string.rowCount() : (long)nArray.length;
                long l3 = l = nArray2.length > string.columnCount() ? (long)string.columnCount() : (long)nArray2.length;
                if (l2 > 0L && l2 < (long)nArray.length) {
                    nArray3 = new int[(int)l2];
                    System.arraycopy(nArray, 0, nArray3, 0, (int)l2);
                    nArray = nArray3;
                }
                if (l > 0L && l < (long)nArray2.length) {
                    nArray3 = new int[(int)l];
                    System.arraycopy(nArray2, 0, nArray3, 0, (int)l);
                    nArray2 = nArray3;
                }
            }
            string = selectionType.name();
            this.mOutStream.process(string);
            ISpssDataSrc iSpssDataSrc = ((DataViewTableModel)dataViewTable.getModel()).getDataSource();
            if (selectionType.equals((Object)SelectionType.DATA_COLS)) {
                this.writeVariables(iSpssDataSrc, nArray2);
            }
            this.writeDataCells(dataViewTable, nArray, nArray2, selectionType);
            byte[] byArray = this.mOutStream.getStreamAsBytes();
            this.mOutStream.reset();
            dEData = selectionType.equals((Object)SelectionType.DATA_COLS) ? new DataCols(byArray) : (selectionType.equals((Object)SelectionType.DATA_ROWS) ? new DataRows(byArray) : new DataCells(byArray));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return dEData;
    }

    public boolean deserializeDataViewSelection(DataViewTable dataViewTable, DEData dEData) {
        try {
            ByteBuffer byteBuffer = ByteBuffer.wrap(dEData.getBytes());
            this.mInStream = new InDataStream(byteBuffer);
            this.mInStream.setCharSetName(ComponentState.getCurrentCharsetName());
            String string = this.mInStream.retrieveString();
            SelectionType selectionType = SelectionType.valueOf(string);
            Vector<ISpssVariable> vector = null;
            if (selectionType.equals((Object)SelectionType.DATA_COLS)) {
                vector = this.readVariables();
            }
            this.readDataCells(dataViewTable, vector, selectionType);
            this.mInStream = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.mInStream = null;
            return false;
        }
        return true;
    }

    public DEData serializeVariableViewSelection(VarViewTable varViewTable) {
        DEData dEData = null;
        try {
            int[] nArray = varViewTable.getSelectedRows();
            int[] nArray2 = varViewTable.getSelectedColumns();
            SelectionType selectionType = DataSerializer.selectionType(varViewTable, false, nArray, nArray2);
            if (!selectionType.equals((Object)SelectionType.VAR_CELLS) && !selectionType.equals((Object)SelectionType.VAR_ROWS)) {
                return dEData;
            }
            String string = selectionType.name();
            this.mOutStream.process(string);
            ISpssDataSrc iSpssDataSrc = ((VarViewTableModel)varViewTable.getModel()).getDataSource();
            if (selectionType.equals((Object)SelectionType.VAR_ROWS)) {
                this.writeVariables(iSpssDataSrc, nArray);
            } else {
                this.writeVarCells(varViewTable, nArray, nArray2);
            }
            byte[] byArray = this.mOutStream.getStreamAsBytes();
            this.mOutStream.reset();
            dEData = selectionType.equals((Object)SelectionType.VAR_ROWS) ? new VariableRows(byArray) : new VariableCells(byArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return dEData;
    }

    public boolean deserializeVariableViewSelection(VarViewTable varViewTable, DEData dEData) {
        try {
            ByteBuffer byteBuffer = ByteBuffer.wrap(dEData.getBytes());
            this.mInStream = new InDataStream(byteBuffer);
            this.mInStream.setCharSetName(ComponentState.getCurrentCharsetName());
            String string = this.mInStream.retrieveString();
            SelectionType selectionType = SelectionType.valueOf(string);
            if (selectionType.equals((Object)SelectionType.VAR_ROWS) || selectionType.equals((Object)SelectionType.DATA_COLS)) {
                Vector<ISpssVariable> vector = this.readVariables();
                this.applyVarViewVariables(varViewTable, vector);
            } else {
                this.readVarCells(varViewTable);
            }
            this.mInStream = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.mInStream = null;
            return false;
        }
        return true;
    }

    public static SelectionType getSelectionType(JTable jTable, boolean bl) {
        return DataSerializer.selectionType(jTable, bl, jTable.getSelectedRows(), jTable.getSelectedColumns());
    }

    public static boolean canCopy(JTable jTable) {
        int[] nArray = jTable.getSelectedRows();
        int[] nArray2 = jTable.getSelectedColumns();
        if (jTable instanceof DataViewTable) {
            if (DataMgr.getDataMgr().isDataFreeClient()) {
                return false;
            }
            ISpssDataSrc iSpssDataSrc = ((DataViewTableModel)jTable.getModel()).getDataSource();
            return nArray.length > 0 && (long)nArray[0] < iSpssDataSrc.rowCount() && nArray2.length > 0 && nArray2[0] < iSpssDataSrc.columnCount();
        }
        if (jTable instanceof VarViewTable) {
            VarViewTableModel varViewTableModel = (VarViewTableModel)jTable.getModel();
            ISpssDataSrc iSpssDataSrc = varViewTableModel.getDataSource();
            return nArray.length > 0 && nArray[0] < iSpssDataSrc.columnCount() && nArray2.length > 0 && nArray2[0] < varViewTableModel.getColumnCount();
        }
        return false;
    }

    public static boolean canPaste(JTable jTable) {
        AppClipboard appClipboard = AppClipboard.getAppClipboard();
        boolean bl = jTable instanceof DataViewTable;
        SelectionType selectionType = DataSerializer.getSelectionType(jTable, bl);
        if (selectionType.equals((Object)SelectionType.DATA_CELLS)) {
            return DataSerializer.dataCellsAvailable() || appClipboard.isFlavorAvailable(AppClipboard.STRING_FLAVOR) && !DataSerializer.dataColsAvailable() && !DataSerializer.dataRowsAvailable();
        }
        if (selectionType.equals((Object)SelectionType.DATA_COLS)) {
            return DataSerializer.dataColsAvailable();
        }
        if (selectionType.equals((Object)SelectionType.DATA_ROWS)) {
            return DataSerializer.dataRowsAvailable();
        }
        if (selectionType.equals((Object)SelectionType.VAR_ROWS)) {
            return DataSerializer.varRowsAvailable() || DataSerializer.dataColsAvailable();
        }
        if (selectionType.equals((Object)SelectionType.VAR_CELLS)) {
            if (DataSerializer.dataRowsAvailable()) {
                return false;
            }
            if (DataSerializer.varCellsAvailable()) {
                return DataSerializer.canPasteVarCells(jTable);
            }
            return appClipboard.isFlavorAvailable(AppClipboard.STRING_FLAVOR);
        }
        return false;
    }

    public static boolean dataRowsAvailable() {
        return AppClipboard.getAppClipboard().isFlavorAvailable(DATA_ROW_FLAVOR);
    }

    public static boolean dataColsAvailable() {
        return AppClipboard.getAppClipboard().isFlavorAvailable(DATA_COL_FLAVOR);
    }

    public static boolean dataCellsAvailable() {
        return AppClipboard.getAppClipboard().isFlavorAvailable(DATA_CELL_FLAVOR);
    }

    public static boolean varRowsAvailable() {
        return AppClipboard.getAppClipboard().isFlavorAvailable(VAR_ROW_FLAVOR);
    }

    public static boolean varCellsAvailable() {
        return AppClipboard.getAppClipboard().isFlavorAvailable(VAR_CELL_FLAVOR);
    }

    public Integer integerFromString(Object object) {
        Integer n = 0;
        if (object instanceof String) {
            try {
                n = Integer.valueOf((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        }
        return n;
    }

    protected Vector<ISpssVariable> readVariables() {
        int n = this.mInStream.retrieveInt();
        Vector<ISpssVariable> vector = new Vector<ISpssVariable>(n);
        for (int i = 0; i < n; ++i) {
            SpssVariable spssVariable = new SpssVariable();
            spssVariable.serialize((IDataStream)this.mInStream);
            vector.add((ISpssVariable)spssVariable);
        }
        return vector;
    }

    protected void applyVarViewVariables(VarViewTable varViewTable, Vector<ISpssVariable> vector) {
        int n;
        int[] nArray = varViewTable.getSelectedRows();
        boolean bl = vector.size() == 1;
        VarViewTableModel varViewTableModel = (VarViewTableModel)varViewTable.getModel();
        SpssUndoManager spssUndoManager = varViewTableModel.getUndoManager();
        CompoundEdit compoundEdit = new CompoundEdit();
        spssUndoManager.addEdit(compoundEdit);
        JTable jTable = varViewTable.getDataView().getDataTables()[1];
        varViewTable.clearSelection();
        jTable.clearSelection();
        ISpssDataSrc iSpssDataSrc = varViewTableModel.getDataSource();
        int n2 = n = nArray.length < vector.size() || bl ? nArray.length : vector.size();
        if (n > 0 && iSpssDataSrc.columnCount() < nArray[n - 1] && !varViewTable.getDataView().canAddNewVariable()) {
            compoundEdit.die();
            return;
        }
        DataFrame dataFrame = (DataFrame)spssUndoManager.getSpssFrame();
        for (int i = 0; i < n; ++i) {
            Object object;
            ISpssVariable iSpssVariable;
            block13: {
                while (iSpssDataSrc.columnCount() < nArray[i]) {
                    if (!dataFrame.checkDataLimit(false, 1L)) {
                        compoundEdit.end();
                        return;
                    }
                    new VariableInsertEdit(spssUndoManager, iSpssDataSrc, iSpssDataSrc.columnCount(), 1, 0);
                }
                try {
                    if (bl) {
                        iSpssVariable = vector.get(0).clone();
                        break block13;
                    }
                    if (i < vector.size()) {
                        iSpssVariable = vector.get(i).clone();
                        break block13;
                    }
                    compoundEdit.die();
                    assert (false);
                    return;
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    cloneNotSupportedException.printStackTrace();
                    compoundEdit.die();
                    return;
                }
            }
            if (nArray[i] >= iSpssDataSrc.columnCount()) {
                if (!dataFrame.checkDataLimit(false, nArray[i] - iSpssDataSrc.columnCount() + 1)) {
                    compoundEdit.end();
                    return;
                }
                object = new Vector();
                ((Vector)object).add(iSpssVariable);
                new VariableInsertEdit(spssUndoManager, iSpssDataSrc, nArray[i], (Vector<ISpssVariable>)object);
            } else {
                object = iSpssDataSrc.getVariable(nArray[i]);
                iSpssVariable.setId(object.getId());
                if (iSpssDataSrc.findVarIndex(iSpssVariable.getName()) != -1) {
                    iSpssVariable.setName(object.getName());
                }
                Vector<ISpssVariable> vector2 = new Vector<ISpssVariable>();
                vector2.add(iSpssVariable);
                new ModifyVariableEdit(spssUndoManager, nArray[i], vector2);
            }
            varViewTable.addColumnSelectionInterval(varViewTable.getColumnCount() - 1, 0);
            varViewTable.addRowSelectionInterval(nArray[i], nArray[i]);
            jTable.addColumnSelectionInterval(0, 0);
            jTable.addRowSelectionInterval(nArray[i], nArray[i]);
        }
        compoundEdit.end();
    }

    private static SelectionType selectionType(JTable jTable, boolean bl, int[] nArray, int[] nArray2) {
        SelectionType selectionType = SelectionType.NONE;
        if (nArray.length == jTable.getRowCount() && nArray[0] == 0 && nArray[nArray.length - 1] == jTable.getRowCount() - 1) {
            selectionType = bl ? SelectionType.DATA_COLS : SelectionType.VAR_CELLS;
        } else if (nArray2.length == jTable.getColumnCount() && nArray2[0] == 0 && nArray2[nArray2.length - 1] == jTable.getColumnCount() - 1) {
            selectionType = bl ? SelectionType.DATA_ROWS : SelectionType.VAR_ROWS;
        } else if (nArray2.length > 0 && nArray2.length > 0) {
            selectionType = bl ? SelectionType.DATA_CELLS : SelectionType.VAR_CELLS;
        }
        return selectionType;
    }

    private static boolean canPasteVarCells(JTable jTable) {
        AppClipboard appClipboard = AppClipboard.getAppClipboard();
        Object object = appClipboard.getClipboardData(VAR_CELL_FLAVOR);
        if (object instanceof DEData) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(((DEData)object).getBytes());
            InDataStream inDataStream = new InDataStream(byteBuffer);
            inDataStream.retrieveString();
            int[] nArray = jTable.getSelectedColumns();
            if (nArray == null || nArray.length == 0) {
                return false;
            }
            int n = inDataStream.retrieveInt();
            int n2 = inDataStream.retrieveInt();
            if (n2 == 0 || n == 0) {
                return false;
            }
            VarViewTableModel varViewTableModel = (VarViewTableModel)jTable.getModel();
            String string = inDataStream.retrieveString();
            String string2 = varViewTableModel.columnIndexToColumnId(nArray[0]);
            return DataSerializer.canPasteVarColumn(string, string2);
        }
        return false;
    }

    private void writeDataCells(DataViewTable dataViewTable, int[] nArray, int[] nArray2, SelectionType selectionType) {
        OBS[] oBSArray;
        ISpssDataSrc iSpssDataSrc = ((DataViewTableModel)dataViewTable.getModel()).getDataSource();
        int n = nArray2.length > iSpssDataSrc.columnCount() ? iSpssDataSrc.columnCount() : nArray2.length;
        int n2 = (long)nArray.length > iSpssDataSrc.rowCount() ? (int)iSpssDataSrc.rowCount() : nArray.length;
        int n3 = n2 * n;
        this.mOutStream.process(n);
        this.mOutStream.process(n2);
        if (n2 == 0 || n == 0) {
            return;
        }
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n && nArray2[i] < iSpssDataSrc.columnCount(); ++i) {
            oBSArray = iSpssDataSrc.getVariable(nArray2[i]);
            blArray[i] = oBSArray.getType() != 0;
            this.mOutStream.process(blArray[i]);
        }
        ColumnDataProvider columnDataProvider = null;
        if (selectionType == SelectionType.DATA_ROWS) {
            for (int i = 0; i < n2; ++i) {
                CaseIterator caseIterator = new CaseIterator(iSpssDataSrc, (long)nArray[i], 0, iSpssDataSrc.columnCount());
                for (int j = 0; j < n; ++j) {
                    Object object;
                    Object object2 = object = blArray[j] ? caseIterator.getStringValue(nArray2[j]) : Double.valueOf(caseIterator.getNumericValue(nArray2[j]));
                    if (blArray[j]) {
                        this.mOutStream.processStringUTF8(object.toString());
                        continue;
                    }
                    if (object instanceof Double) {
                        this.mOutStream.process(((Double)object).doubleValue());
                        continue;
                    }
                    this.mOutStream.process(iSpssDataSrc.getSystemMissing());
                }
            }
        } else {
            for (int i = 0; i < n && nArray2[i] < iSpssDataSrc.columnCount(); ++i) {
                oBSArray = null;
                if (selectionType == SelectionType.DATA_COLS || selectionType == SelectionType.DATA_CELLS && n3 > 10) {
                    if (columnDataProvider == null) {
                        columnDataProvider = new ColumnDataProvider(iSpssDataSrc);
                    }
                    if ((oBSArray = selectionType == SelectionType.DATA_COLS ? columnDataProvider.getColumn(nArray2[i]) : columnDataProvider.getColumnData(nArray2[i], (long)nArray[0], (long)nArray[nArray.length - 1])) == null) assert (false);
                }
                for (int j = 0; j < n2; ++j) {
                    Object object = oBSArray != null && oBSArray.length > j ? (blArray[i] ? oBSArray[j].getString() : Double.valueOf(oBSArray[j].getNum())) : dataViewTable.getValueAt(nArray[j], nArray2[i]);
                    if (blArray[i]) {
                        this.mOutStream.processStringUTF8(object.toString());
                        continue;
                    }
                    if (object instanceof Double) {
                        this.mOutStream.process(((Double)object).doubleValue());
                        continue;
                    }
                    this.mOutStream.process(iSpssDataSrc.getSystemMissing());
                }
            }
        }
    }

    private void writeVariables(ISpssDataSrc iSpssDataSrc, int[] nArray) {
        this.mOutStream.process(nArray.length);
        for (int n : nArray) {
            ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(n);
            iSpssVariable.serialize((IDataStream)this.mOutStream);
        }
    }

    private void writeVarCells(VarViewTable varViewTable, int[] nArray, int[] nArray2) {
        VarViewTableModel varViewTableModel = (VarViewTableModel)varViewTable.getModel();
        ISpssDataSrc iSpssDataSrc = varViewTableModel.getDataSource();
        if (nArray[0] >= iSpssDataSrc.columnCount() || nArray2.length > 1) {
            this.mOutStream.process(0);
            this.mOutStream.process(0);
            if (nArray2.length > 1) assert (false);
            return;
        }
        int n = iSpssDataSrc.columnCount();
        int n2 = nArray2.length > n ? n : nArray2.length;
        int n3 = 0;
        int[] object = nArray;
        int n4 = object.length;
        for (int iSpssVariable = 0; iSpssVariable < n4; ++iSpssVariable) {
            int n5 = object[iSpssVariable];
            if (n5 >= n) continue;
            ++n3;
        }
        this.mOutStream.process(n2);
        this.mOutStream.process(n3);
        if (n3 == 0 || n2 == 0) {
            return;
        }
        String string = varViewTableModel.columnIndexToColumnId(nArray2[0]);
        this.mOutStream.process(string);
        for (n4 = 0; n4 < n3; ++n4) {
            ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(nArray[n4]);
            if (iSpssVariable == null) continue;
            this.writeVarColumnValue(varViewTable, nArray2[0], iSpssVariable);
        }
    }

    private void writeVarColumnValue(VarViewTable varViewTable, int n, ISpssVariable iSpssVariable) {
        VarViewTableModel varViewTableModel = (VarViewTableModel)varViewTable.getModel();
        String string = varViewTableModel.columnIndexToColumnId(n);
        if (string.equals("name")) {
            this.mOutStream.process(iSpssVariable.getName());
        } else if (string.equals("type")) {
            this.mOutStream.process(iSpssVariable.getFormat().getFormatType().value());
        } else if (string.equals("width")) {
            this.mOutStream.process(iSpssVariable.getFormat().getWidth());
        } else if (string.equals("decimals")) {
            this.mOutStream.process((short)iSpssVariable.getFormat().getDecimals());
        } else if (string.equals("label")) {
            this.mOutStream.process(iSpssVariable.getLabel());
        } else if (string.equals("values")) {
            this.writeValueLabels(iSpssVariable);
        } else if (string.equals("missing")) {
            this.writeMissingValues(iSpssVariable);
        } else if (string.equals("columns")) {
            this.mOutStream.process(iSpssVariable.getDisplayWidth());
        } else if (string.equals("alignment")) {
            this.mOutStream.process(iSpssVariable.getDisplayAlignment().value());
        } else if (string.equals("measure")) {
            this.mOutStream.process(iSpssVariable.getMeasurementLevel().value());
        } else if (string.equals("role")) {
            this.mOutStream.process(iSpssVariable.getRole().value());
        } else if (string.startsWith("@")) {
            // empty if block
        }
    }

    private void writeValueLabels(ISpssVariable iSpssVariable) {
        IValueLabelMap iValueLabelMap = iSpssVariable.getValueLabels();
        if (iValueLabelMap instanceof ValueLabelMap) {
            ValueLabelMap.serialize((ValueLabelMap)((ValueLabelMap)iValueLabelMap), (IDataStream)this.mOutStream, (int)iSpssVariable.getType());
        }
    }

    private void writeMissingValues(ISpssVariable iSpssVariable) {
        OBS[] oBSArray = new OBS[]{new OBS(), new OBS(), new OBS()};
        this.mOutStream.process(iSpssVariable.getType());
        ISpssVariable.Rule rule = iSpssVariable.getMissingValues(oBSArray[0], oBSArray[1], oBSArray[2]);
        this.mOutStream.process((short)rule.value());
        short s = (short)Math.abs(rule.value());
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            SpssVariable.serializeOBS((IDataStream)this.mOutStream, (OBS)oBSArray[s2], (int)iSpssVariable.getType(), (boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readDataCells(DataViewTable dataViewTable, Vector<ISpssVariable> vector, SelectionType selectionType) {
        boolean bl;
        ISpssDataSrc iSpssDataSrc = ((DataViewTableModel)dataViewTable.getModel()).getDataSource();
        int[] nArray = dataViewTable.getSelectedRows();
        int[] nArray2 = dataViewTable.getSelectedColumns();
        int n = this.mInStream.retrieveInt();
        int n2 = this.mInStream.retrieveInt();
        if (vector != null && n != vector.size()) {
            assert (false);
            return;
        }
        if (n2 == 0 || n == 0) {
            return;
        }
        int n3 = nArray2[0];
        int n4 = nArray[0];
        int n5 = nArray2[nArray2.length - 1];
        int n6 = nArray[nArray.length - 1];
        if (n3 == n5 || selectionType.equals((Object)SelectionType.DATA_ROWS)) {
            n5 = n3 + n - 1;
        }
        if (n4 == n6 || selectionType.equals((Object)SelectionType.DATA_COLS)) {
            n6 = n4 + n2 - 1;
        }
        boolean bl2 = selectionType == SelectionType.DATA_COLS || selectionType == SelectionType.DATA_CELLS && n4 == 0;
        boolean bl3 = !(selectionType != SelectionType.DATA_CELLS || n != 1 && n2 != 1 || nArray.length <= 1 && nArray2.length <= 1);
        boolean bl4 = selectionType == SelectionType.DATA_ROWS && n2 == 1;
        boolean bl5 = bl = bl2 && n == 1;
        if (iSpssDataSrc.columnCount() < n5 && !dataViewTable.getDataView().canAddNewVariable()) {
            return;
        }
        SpssUndoManager spssUndoManager = ((DataViewTableModel)dataViewTable.getModel()).getUndoManager();
        CompoundEdit compoundEdit = new CompoundEdit();
        try {
            int n7;
            Object object;
            Object object2;
            int n8;
            int n9;
            spssUndoManager.addEdit(compoundEdit);
            boolean[] blArray = new boolean[n];
            Vector<ISpssVariable> vector2 = new Vector<ISpssVariable>();
            Vector<ISpssVariable> vector3 = new Vector<ISpssVariable>();
            for (n9 = 0; n9 < n; ++n9) {
                blArray[n9] = this.mInStream.retrieveBoolean();
                int n10 = n8 = bl ? nArray2.length : 1;
                if (vector == null || vector.size() <= n9) continue;
                object2 = vector.get(n9);
                for (int i = 0; i < n8 && n3 + n9 + i <= n5; ++i) {
                    if (n3 + n9 + i >= iSpssDataSrc.columnCount()) {
                        object = (DataFrame)spssUndoManager.getSpssFrame();
                        if (!object.checkDataLimit(false, n3 + n9 + i - iSpssDataSrc.columnCount() + 1)) {
                            compoundEdit.end();
                            return;
                        }
                        vector2.add((ISpssVariable)object2);
                        continue;
                    }
                    object = iSpssDataSrc.getVariable(n3 + n9 + i);
                    if (iSpssDataSrc.findVarIndex(object2.getName()) != -1) {
                        object2.setName(object.getName());
                    }
                    object2.setId(object.getId());
                    vector3.add((ISpssVariable)object2);
                }
            }
            if (vector3.size() > 0) {
                new ModifyVariableEdit(spssUndoManager, n3, vector3);
            }
            if (vector2.size() > 0) {
                new VariableInsertEdit(spssUndoManager, iSpssDataSrc, n3, vector2);
            }
            if ((long)n6 >= iSpssDataSrc.rowCount()) {
                n9 = bl3 || bl4 ? nArray.length : n2;
                n8 = n4 + n9;
                object2 = (DataFrame)spssUndoManager.getSpssFrame();
                if (!((DataFrame)object2).checkDataLimit(true, (long)n8 - iSpssDataSrc.rowCount())) {
                    compoundEdit.end();
                    return;
                }
                new RowInsertEdit((DataFrame)object2, iSpssDataSrc.rowCount(), (long)n8 - iSpssDataSrc.rowCount());
            }
            iSpssDataSrc.getCacheMgr().setCacheState(false);
            OBS[] oBSArray = null;
            Object[][] objectArray = null;
            if (bl3) {
                objectArray = new Object[n][n2];
            }
            ColumnDataProvider columnDataProvider = new ColumnDataProvider(iSpssDataSrc);
            if (selectionType == SelectionType.DATA_ROWS) {
                object = new ArrayList();
                for (n7 = 0; n7 < n; ++n7) {
                    OBS[] oBSArray2 = columnDataProvider.getColumnData(n3 + n7, (long)nArray[0], (long)(nArray[0] + n2 - 1));
                    object.add(oBSArray2);
                }
                for (n7 = 0; n7 < n2; ++n7) {
                    for (int i = 0; i < n; ++i) {
                        Object object3;
                        object2 = blArray[i] ? this.mInStream.retrieveStringUTF8() : Double.valueOf(this.mInStream.retrieveDouble());
                        if (n7 == 0 && n3 + i >= iSpssDataSrc.columnCount()) {
                            object3 = (DataFrame)spssUndoManager.getSpssFrame();
                            if (!((DataFrame)object3).checkDataLimit(false, n3 + i - iSpssDataSrc.columnCount() + 1)) {
                                compoundEdit.end();
                                return;
                            }
                            ISpssDataSrc.ReturnIndex returnIndex = new ISpssDataSrc.ReturnIndex();
                            ISpssVariable iSpssVariable = iSpssDataSrc.makeVariable(blArray[i] ? object2.toString().length() : 0, returnIndex);
                            vector2.clear();
                            vector2.add(iSpssVariable);
                            new VariableInsertEdit(spssUndoManager, iSpssDataSrc, n3 + i, vector2);
                        }
                        if (bl4) {
                            for (int n11 : nArray) {
                                dataViewTable.setValueAt(object2, n11, n3 + i);
                            }
                            continue;
                        }
                        object3 = (OBS[])object.get(i);
                        if (n3 + i > n5 || n4 + n7 > n6) continue;
                        if (bl2) {
                            oBSArray[n7] = this.objectToOBS(iSpssDataSrc, object2, n3 + i, !blArray[i]);
                            continue;
                        }
                        dataViewTable.setValueAt(object2, (OBS)(object3 != null ? object3[n7] : null), n4 + n7, n3 + i);
                    }
                }
            } else {
                int n12 = n;
                if (n5 < n3 + n) {
                    n12 = n5 - n3 + 1;
                }
                for (n7 = 0; n7 < n12; ++n7) {
                    OBS[] oBSArray3 = columnDataProvider.getColumnData(n3 + n7, (long)nArray[0], (long)(nArray[0] + n2 - 1));
                    if (bl2) {
                        oBSArray = new OBS[n2];
                    }
                    for (int i = 0; i < n2; ++i) {
                        object2 = blArray[n7] ? this.mInStream.retrieveStringUTF8() : Double.valueOf(this.mInStream.retrieveDouble());
                        if (i == 0 && n3 + n7 >= iSpssDataSrc.columnCount()) {
                            Object object4 = (DataFrame)spssUndoManager.getSpssFrame();
                            if (!((DataFrame)object4).checkDataLimit(false, n3 + n7 - iSpssDataSrc.columnCount() + 1)) {
                                compoundEdit.end();
                                return;
                            }
                            ISpssDataSrc.ReturnIndex returnIndex = new ISpssDataSrc.ReturnIndex();
                            ISpssVariable iSpssVariable = iSpssDataSrc.makeVariable(blArray[n7] ? object2.toString().length() : 0, returnIndex);
                            vector2.clear();
                            vector2.add(iSpssVariable);
                            new VariableInsertEdit(spssUndoManager, iSpssDataSrc, n3 + n7, vector2);
                        }
                        if (bl3) {
                            objectArray[n7][i] = object2;
                            continue;
                        }
                        if (bl) {
                            if (bl2) {
                                oBSArray[i] = this.objectToOBS(iSpssDataSrc, object2, n3 + n7, !blArray[n7]);
                                continue;
                            }
                            for (int n13 : nArray2) {
                                dataViewTable.setValueAt(object2, oBSArray3[i], n4 + i, n13);
                            }
                            continue;
                        }
                        if (n3 + n7 > n5 || n4 + i > n6) continue;
                        if (bl2) {
                            oBSArray[i] = this.objectToOBS(iSpssDataSrc, object2, n3 + n7, !blArray[n7]);
                            continue;
                        }
                        dataViewTable.setValueAt(object2, oBSArray3 != null ? oBSArray3[i] : null, n4 + i, n3 + n7);
                    }
                    if (!bl2 || !this.hasData(oBSArray)) continue;
                    new TableColumnEdit(n3 + n7, dataViewTable, oBSArray);
                }
            }
            if (bl3) {
                this.replicateIntoSelections(dataViewTable, nArray, nArray2, objectArray);
            }
            if (bl2 && bl && this.hasData(oBSArray)) {
                for (int i = 1; i < nArray2.length; ++i) {
                    new TableColumnEdit(n3 + i, dataViewTable, oBSArray);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            compoundEdit.end();
            iSpssDataSrc.getCacheMgr().setCacheState(true);
            this.reselectCells(dataViewTable, nArray, nArray2);
            spssUndoManager.getSpssFrame().repaint(200L);
        }
    }

    private boolean hasData(OBS[] oBSArray) {
        boolean bl = false;
        if (oBSArray != null) {
            for (OBS oBS : oBSArray) {
                if (oBS == null) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private void reselectCells(DataViewTable dataViewTable, int[] nArray, int[] nArray2) {
        dataViewTable.getSelectionModel().clearSelection();
        int n = -1;
        int n2 = -2;
        for (int n3 : nArray) {
            if (n == -1) {
                n = n3;
            } else if (n3 != n2 + 1) {
                dataViewTable.getSelectionModel().addSelectionInterval(n, n2);
                n = n3;
            }
            n2 = n3;
        }
        if (n > -1) {
            dataViewTable.getSelectionModel().addSelectionInterval(n, n2);
        }
        n = -1;
        n2 = -2;
        for (int n3 : nArray2) {
            if (n == -1) {
                n = n3;
            } else if (n3 != n2 + 1) {
                dataViewTable.getColumnModel().getSelectionModel().addSelectionInterval(n, n2);
                n = n3;
            }
            n2 = n3;
        }
        if (n > -1) {
            dataViewTable.getColumnModel().getSelectionModel().addSelectionInterval(n, n2);
        }
    }

    private OBS objectToOBS(ISpssDataSrc iSpssDataSrc, Object object, int n, boolean bl) {
        OBS oBS = null;
        boolean bl2 = true;
        try {
            if (object == null || object.toString().length() == 0 || bl && object.toString().equals(".")) {
                oBS = bl ? new OBS(iSpssDataSrc.getSystemMissing()) : new OBS("");
            } else if (bl) {
                if (object instanceof Date) {
                    long l = ((Date)object).getTime();
                    double d = ValueFormatter.convertJavaDateLongToDouble((long)l);
                    oBS = new OBS(d);
                } else if (object instanceof Double) {
                    oBS = new OBS(((Double)object).doubleValue());
                } else {
                    oBS = new OBS();
                    bl2 = CellValueFormatter.stringToObs((String)object.toString(), (SPSS_Format)iSpssDataSrc.getVariable(n).getFormat(), (OBS)oBS);
                }
            } else {
                oBS = new OBS(object.toString());
            }
        }
        catch (NumberFormatException numberFormatException) {
            bl2 = false;
        }
        if (!bl2) {
            oBS = bl ? new OBS(iSpssDataSrc.getSystemMissing()) : new OBS("");
        }
        return oBS;
    }

    private void replicateIntoSelections(DataViewTable dataViewTable, int[] nArray, int[] nArray2, Object[][] objectArray) {
        int n = 0;
        int n2 = objectArray.length;
        int n3 = objectArray[0].length;
        boolean bl = n2 == 1 && n3 > 1;
        ISpssDataSrc iSpssDataSrc = ((DataViewTableModel)dataViewTable.getModel()).getDataSource();
        ColumnDataProvider columnDataProvider = new ColumnDataProvider(iSpssDataSrc);
        for (int n4 : nArray2) {
            OBS[] oBSArray = columnDataProvider.getColumnData(n4, (long)nArray[0], (long)nArray[nArray.length - 1]);
            int n5 = 0;
            for (int i = 0; i < nArray.length; ++i) {
                int n6 = nArray[i];
                if (!bl || n5 < n3) {
                    dataViewTable.setValueAt(objectArray[n % n2][n5 % n3], oBSArray[i], n6, n4);
                }
                ++n5;
            }
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readVarCells(VarViewTable varViewTable) {
        int n;
        int n2;
        int[] nArray = varViewTable.getSelectedRows();
        int[] nArray2 = varViewTable.getSelectedColumns();
        int n3 = this.mInStream.retrieveInt();
        int n4 = this.mInStream.retrieveInt();
        if (n4 == 0 || n3 == 0) {
            return;
        }
        VarViewTableModel varViewTableModel = (VarViewTableModel)varViewTable.getModel();
        String string = this.mInStream.retrieveString();
        String string2 = varViewTableModel.columnIndexToColumnId(nArray2[0]);
        if (nArray2 == null || !DataSerializer.canPasteVarColumn(string, string2)) {
            return;
        }
        ISpssDataSrc iSpssDataSrc = varViewTableModel.getDataSource();
        int n5 = n2 = nArray.length >= 1 && nArray.length < n4 ? nArray.length : n4;
        if (n2 > 0 && iSpssDataSrc.columnCount() < nArray[n2 - 1] && !varViewTable.getDataView().canAddNewVariable()) {
            return;
        }
        SpssUndoManager spssUndoManager = varViewTableModel.getUndoManager();
        CompoundEdit compoundEdit = new CompoundEdit();
        spssUndoManager.addEdit(compoundEdit);
        String string3 = null;
        Integer n6 = null;
        Short s = null;
        Byte by = null;
        boolean bl = n4 == 1 && n3 == 1 && nArray.length > 1;
        int n7 = 0;
        ISpssVariable iSpssVariable = null;
        Vector<ISpssVariable> vector = new Vector<ISpssVariable>();
        DataFrame dataFrame = (DataFrame)spssUndoManager.getSpssFrame();
        boolean bl2 = true;
        boolean bl3 = false;
        for (int i = 0; i < nArray.length && (n4 <= 1 || n4 > i); ++i, ++n7) {
            String string4;
            ISpssVariable iSpssVariable2;
            block58: {
                block67: {
                    block68: {
                        block66: {
                            block65: {
                                block64: {
                                    SPSS_Format sPSS_Format;
                                    block63: {
                                        block62: {
                                            block59: {
                                                block60: {
                                                    block61: {
                                                        n = 0;
                                                        while (iSpssDataSrc.columnCount() <= nArray[i]) {
                                                            if (!dataFrame.checkDataLimit(false, 1L)) {
                                                                compoundEdit.end();
                                                                return;
                                                            }
                                                            new VariableInsertEdit(spssUndoManager, iSpssDataSrc, iSpssDataSrc.columnCount(), 1, 0);
                                                            ++n;
                                                        }
                                                        try {
                                                            iSpssVariable2 = iSpssDataSrc.getVariable(nArray[i]).clone();
                                                        }
                                                        catch (Exception exception) {
                                                            exception.printStackTrace();
                                                            compoundEdit.die();
                                                            return;
                                                        }
                                                        string4 = null;
                                                        if (!string2.equals("name")) break block59;
                                                        if (string3 == null || n4 > 1) {
                                                            string3 = this.mInStream.retrieveString();
                                                        }
                                                        if ((string4 = this.getBadVarErrorMessage(string3)) != null || iSpssDataSrc.findVarIndex(string3) == -1 || string3.compareToIgnoreCase(iSpssVariable2.getName()) == 0) break block60;
                                                        if (nArray.length != 1) break block61;
                                                        string4 = ResUtil.getCommonDlgString("ERR_BADVAR_DUPLICATE_ERROR_MESSAGE");
                                                        break block58;
                                                    }
                                                    if (!bl2) break block58;
                                                    int n8 = JOptionPane.showConfirmDialog(varViewTableModel.getUndoManager().getSpssFrame(), ResUtil.getCommonDlgString("ERR_BADVAR_MULTIPLE_PASTE_WARNING"), VersionInfo.getAppVersionString(), 2);
                                                    if (n8 == 0) {
                                                        bl2 = false;
                                                        break block58;
                                                    } else {
                                                        for (int j = 0; j < n; ++j) {
                                                            new DeleteVariablesEdit(spssUndoManager, varViewTableModel, iSpssDataSrc, new int[]{iSpssDataSrc.columnCount() - 1}, varViewTable.getDataView());
                                                        }
                                                        break;
                                                    }
                                                }
                                                if (string4 == null) {
                                                    iSpssVariable2.setName(string3);
                                                }
                                                break block58;
                                            }
                                            if (!string2.equals("type")) break block62;
                                            sPSS_Format = iSpssVariable2.getFormat();
                                            if (n6 == null || n4 > 1) {
                                                n6 = this.mInStream.retrieveInt();
                                            }
                                            FormatType formatType = FormatType.fromByte((byte)n6.byteValue());
                                            boolean bl4 = this.checkTypeMismatch(formatType, iSpssVariable2, varViewTableModel);
                                            string4 = this.checkTypePrecision(formatType, iSpssVariable2);
                                            if (bl4 && string4 == null) {
                                                iSpssVariable2.setFormat(new SPSS_Format(formatType, sPSS_Format.getWidth(), sPSS_Format.getDecimals()));
                                                iSpssVariable2.setWriteFormat(new SPSS_Format(formatType, sPSS_Format.getWidth(), sPSS_Format.getDecimals()));
                                                iSpssVariable2.setType(formatType.isStringFormat() ? sPSS_Format.getWidth() : (short)0);
                                                iSpssVariable2.setMeasurementLevel(formatType.isStringFormat() ? MeasurementLevel.nominal : MeasurementLevel.scale);
                                                iSpssVariable2.setDisplayAlignment(formatType.isStringFormat() ? DisplayAlignment.left : DisplayAlignment.right);
                                            }
                                            break block58;
                                        }
                                        if (!string2.equals("width")) break block63;
                                        sPSS_Format = iSpssVariable2.getFormat();
                                        if (s == null || n4 > 1) {
                                            s = this.mInStream.retrieveShort();
                                        }
                                        if (!sPSS_Format.getFormatType().isDateOrTimeFormat()) {
                                            short s2 = sPSS_Format.getDecimals();
                                            if (sPSS_Format.getFormatType().isDollarFormat() && s - s2 < 2) {
                                                string4 = ResUtil.getString("ERR_DOLLAR_VAR_WIDTH_ERROR");
                                                break block58;
                                            } else if (s <= s2) {
                                                string4 = ResUtil.getString("ERR_DECIMALS_TOO_BIG");
                                                break block58;
                                            } else {
                                                SPSS_Format sPSS_Format2 = iSpssVariable2.getFormat();
                                                SPSS_Format sPSS_Format3 = iSpssVariable2.getWriteFormat();
                                                sPSS_Format2.setWidth(s.shortValue());
                                                sPSS_Format3.setWidth(s.shortValue());
                                                iSpssVariable2.setType(sPSS_Format2.getFormatType().isStringFormat() ? s : (short)0);
                                                iSpssVariable2.setFormat(sPSS_Format2);
                                                iSpssVariable2.setWriteFormat(sPSS_Format3);
                                            }
                                        }
                                        break block58;
                                    }
                                    if (!string2.equals("decimals")) break block64;
                                    sPSS_Format = iSpssVariable2.getFormat();
                                    if (by == null || n4 > 1) {
                                        by = (byte)this.mInStream.retrieveShort();
                                    }
                                    if (sPSS_Format.getFormatType().isNumericFormat()) {
                                        short s3 = sPSS_Format.getWidth();
                                        if (sPSS_Format.getFormatType().isDollarFormat() && s3 - by < 2) {
                                            string4 = ResUtil.getString("ERR_DOLLAR_VAR_WIDTH_ERROR");
                                            break block58;
                                        } else if (by >= s3) {
                                            string4 = ResUtil.getString("ERR_DECIMALS_TOO_BIG");
                                            break block58;
                                        } else {
                                            iSpssVariable2.setFormat(new SPSS_Format(sPSS_Format.getFormatType(), sPSS_Format.getWidth(), by.byteValue()));
                                            iSpssVariable2.setWriteFormat(new SPSS_Format(sPSS_Format.getFormatType(), sPSS_Format.getWidth(), by.byteValue()));
                                        }
                                    }
                                    break block58;
                                }
                                if (!string2.equals("label")) break block65;
                                if (string3 == null || n4 > 1) {
                                    string3 = this.mInStream.retrieveString();
                                }
                                iSpssVariable2.setLabel(string3);
                                break block58;
                            }
                            if (!string2.equals("values")) break block66;
                            if (iSpssVariable == null || n4 > 1) {
                                if (!this.readValueLabels(iSpssVariable2)) {
                                    string4 = ResUtil.getString("ERR_TYPE_MISMATCH");
                                }
                                if (bl && i == 0) {
                                    iSpssVariable = iSpssVariable2;
                                }
                                break block58;
                            } else if (iSpssVariable != null) {
                                try {
                                    IValueLabelMap iValueLabelMap = iSpssVariable.getValueLabels();
                                    TreeMap treeMap = new TreeMap();
                                    for (Map.Entry entry : iValueLabelMap.getValueLabelEntries()) {
                                        treeMap.put((OBS)((OBS)entry.getKey()).clone(), entry.getValue());
                                    }
                                    ValueLabelMap valueLabelMap = new ValueLabelMap(SpssVLMapId.next(), treeMap);
                                    iSpssVariable2.setValueLabels((IValueLabelMap)valueLabelMap);
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                            }
                            break block58;
                        }
                        if (!string2.equals("missing")) break block67;
                        if (iSpssVariable != null && n4 <= 1) break block68;
                        if (!this.readMissingValues(iSpssVariable2)) {
                            string4 = ResUtil.getString("ERR_TYPE_MISMATCH");
                        }
                        if (bl && i == 0) {
                            iSpssVariable = iSpssVariable2;
                        }
                        break block58;
                    }
                    if (iSpssVariable != null) {
                        boolean bl5;
                        OBS[] oBSArray = new OBS[3];
                        for (int j = 0; j < 3; ++j) {
                            oBSArray[j] = new OBS();
                        }
                        ISpssVariable.Rule rule = iSpssVariable.getMissingValues(oBSArray[0], oBSArray[1], oBSArray[2]);
                        int n9 = rule != ISpssVariable.Rule.none ? (oBSArray[0].isString() ? oBSArray[0].getString().length() : 0) : iSpssVariable2.getType();
                        boolean bl6 = bl5 = n9 == iSpssVariable2.getType() || n9 != 0 && iSpssVariable2.getType() != 0;
                        if (bl5) {
                            iSpssVariable2.setMissingValues(rule, oBSArray[0], oBSArray[1], oBSArray[2]);
                            break block58;
                        } else {
                            string4 = ResUtil.getString("ERR_TYPE_MISMATCH");
                        }
                    }
                    break block58;
                }
                if (string2.equals("columns")) {
                    if (s == null || n4 > 1) {
                        s = this.mInStream.retrieveShort();
                    }
                    iSpssVariable2.setDisplayWidth(s.shortValue());
                } else if (string2.equals("alignment")) {
                    if (n6 == null || n4 > 1) {
                        n6 = this.mInStream.retrieveInt();
                    }
                    iSpssVariable2.setDisplayAlignment(DisplayAlignment.fromShort((short)n6.shortValue()));
                } else if (string2.equals("measure")) {
                    if (n6 == null || n4 > 1) {
                        n6 = this.mInStream.retrieveInt();
                    }
                    iSpssVariable2.setMeasurementLevel(MeasurementLevel.fromShort((short)n6.shortValue()));
                } else if (string2.equals("role")) {
                    if (n6 == null || n4 > 1) {
                        n6 = this.mInStream.retrieveInt();
                    }
                    iSpssVariable2.setRole(Role.fromShort((short)n6.shortValue()));
                } else if (string2.startsWith("@")) {
                    // empty if block
                }
            }
            if (string4 != null && !bl3) {
                SpssAlertOptionPane.showInformationMessageDialog(varViewTableModel.getUndoManager().getSpssFrame(), string4, VersionInfo.getAppVersionString());
                bl3 = true;
            }
            if (string4 != null && vector.size() <= 0) continue;
            vector.add(iSpssVariable2);
        }
        if (vector.size() > 0) {
            new ModifyVariableEdit(spssUndoManager, nArray[0], vector);
        }
        compoundEdit.end();
        if (n7 > 0) {
            JTable jTable = varViewTable.getDataView().getDataTables()[1];
            varViewTable.clearSelection();
            jTable.clearSelection();
            n = varViewTableModel.columnIdToColumnIndex(string2);
            varViewTable.setColumnSelectionInterval(n, n);
            varViewTable.setRowSelectionInterval(nArray[0], nArray[n7 - 1]);
        }
    }

    private String checkTypePrecision(FormatType formatType, ISpssVariable iSpssVariable) {
        String string = null;
        short s = iSpssVariable.getFormat().getWidth();
        byte by = iSpssVariable.getFormat().getDecimals();
        if (formatType == FormatType.DOLLAR && s - by < 2) {
            string = ResUtil.getCommonDlgString("ERR_DOLLAR_VAR_WIDTH_ERROR");
        }
        return string;
    }

    private boolean checkTypeMismatch(FormatType formatType, ISpssVariable iSpssVariable, VarViewTableModel varViewTableModel) {
        boolean bl;
        boolean bl2 = true;
        FormatType formatType2 = iSpssVariable.getFormat().getFormatType();
        boolean bl3 = formatType.isStringFormat() && iSpssVariable.getType() == 0 || !formatType.isStringFormat() && iSpssVariable.getType() != 0;
        boolean bl4 = bl = formatType.isDateOrTimeFormat() && !formatType2.isDateOrTimeFormat() || !formatType.isDateOrTimeFormat() && formatType2.isDateOrTimeFormat();
        if (bl3 || bl) {
            IValueLabelMap iValueLabelMap = iSpssVariable.getValueLabels();
            OBS oBS = new OBS();
            OBS oBS2 = new OBS();
            OBS oBS3 = new OBS();
            ISpssVariable.Rule rule = iSpssVariable.getMissingValues(oBS, oBS2, oBS3);
            if (iValueLabelMap != null && iValueLabelMap.size() > 0 || !rule.equals((Object)ISpssVariable.Rule.none)) {
                Toolkit.getDefaultToolkit().beep();
                int n = JOptionPane.showConfirmDialog(varViewTableModel.getUndoManager().getSpssFrame(), String.format(ResUtil.getString("ERR_CLEAR_SPECIFICATIONS_WARNING"), iSpssVariable.getName()), VersionInfo.getAppVersionString(), 2, 3);
                if (n == 0) {
                    if (iValueLabelMap != null && iValueLabelMap.size() > 0) {
                        if (!formatType.isStringFormat() && iSpssVariable.getType() != 0) {
                            SPSS_Format sPSS_Format = new SPSS_Format(formatType, iSpssVariable.getType(), 0);
                            HashMap hashMap = new HashMap();
                            Set set = iValueLabelMap.getValueLabelEntries();
                            for (Map.Entry entry : set) {
                                OBS oBS4 = CellValueFormatter.stringObsToObs((OBS)((OBS)entry.getKey()), (SPSS_Format)sPSS_Format);
                                if (oBS4 == null) continue;
                                hashMap.put(oBS4, entry.getValue());
                            }
                            ValueLabelMap valueLabelMap = new ValueLabelMap(SpssVLMapId.next(), hashMap);
                            iSpssVariable.setValueLabels((IValueLabelMap)valueLabelMap);
                            if (!rule.equals((Object)ISpssVariable.Rule.none)) {
                                rule = ISpssVariable.Rule.none;
                                if (CellValueFormatter.stringObsToObs((OBS)oBS, (SPSS_Format)sPSS_Format) != null) {
                                    rule = ISpssVariable.Rule.one;
                                    if (CellValueFormatter.stringObsToObs((OBS)oBS2, (SPSS_Format)sPSS_Format) != null) {
                                        rule = ISpssVariable.Rule.two;
                                        if (CellValueFormatter.stringObsToObs((OBS)oBS3, (SPSS_Format)sPSS_Format) != null) {
                                            rule = ISpssVariable.Rule.three;
                                        }
                                    }
                                }
                                iSpssVariable.setMissingValues(rule, CellValueFormatter.stringObsToObs((OBS)oBS, (SPSS_Format)sPSS_Format), CellValueFormatter.stringObsToObs((OBS)oBS2, (SPSS_Format)sPSS_Format), CellValueFormatter.stringObsToObs((OBS)oBS3, (SPSS_Format)sPSS_Format));
                            }
                        } else if (formatType.isStringFormat() && iSpssVariable.getType() == 0) {
                            HashMap hashMap = new HashMap();
                            Set set = iValueLabelMap.getValueLabelEntries();
                            for (Map.Entry entry : set) {
                                hashMap.put(CellValueFormatter.obsToStringObs((OBS)((OBS)entry.getKey()), (SPSS_Format)iSpssVariable.getFormat()), entry.getValue());
                            }
                            ValueLabelMap valueLabelMap = new ValueLabelMap(SpssVLMapId.next(), hashMap);
                            iSpssVariable.setValueLabels((IValueLabelMap)valueLabelMap);
                            if (!rule.equals((Object)ISpssVariable.Rule.none)) {
                                iSpssVariable.setMissingValues(ISpssVariable.Rule.none, null, null, null);
                                if (!rule.equals((Object)ISpssVariable.Rule.range) && !rule.equals((Object)ISpssVariable.Rule.range_plus) && CellValueFormatter.obsToStringObs((OBS)oBS, (SPSS_Format)iSpssVariable.getFormat()) != null && CellValueFormatter.obsToStringObs((OBS)oBS, (SPSS_Format)iSpssVariable.getFormat()).getString().length() <= 8) {
                                    iSpssVariable.setMissingValues(ISpssVariable.Rule.one, CellValueFormatter.obsToStringObs((OBS)oBS, (SPSS_Format)iSpssVariable.getFormat()), null, null);
                                    if (CellValueFormatter.obsToStringObs((OBS)oBS2, (SPSS_Format)iSpssVariable.getFormat()) != null && CellValueFormatter.obsToStringObs((OBS)oBS2, (SPSS_Format)iSpssVariable.getFormat()).getString().length() <= 8) {
                                        iSpssVariable.setMissingValues(ISpssVariable.Rule.two, CellValueFormatter.obsToStringObs((OBS)oBS, (SPSS_Format)iSpssVariable.getFormat()), CellValueFormatter.obsToStringObs((OBS)oBS2, (SPSS_Format)iSpssVariable.getFormat()), null);
                                        if (CellValueFormatter.obsToStringObs((OBS)oBS3, (SPSS_Format)iSpssVariable.getFormat()) != null && CellValueFormatter.obsToStringObs((OBS)oBS3, (SPSS_Format)iSpssVariable.getFormat()).getString().length() <= 8) {
                                            iSpssVariable.setMissingValues(ISpssVariable.Rule.three, CellValueFormatter.obsToStringObs((OBS)oBS, (SPSS_Format)iSpssVariable.getFormat()), CellValueFormatter.obsToStringObs((OBS)oBS2, (SPSS_Format)iSpssVariable.getFormat()), CellValueFormatter.obsToStringObs((OBS)oBS3, (SPSS_Format)iSpssVariable.getFormat()));
                                        }
                                    }
                                }
                            }
                        }
                    }
                } else {
                    bl2 = false;
                }
            }
        }
        return bl2;
    }

    private String getBadVarErrorMessage(String string) {
        VarNameValidator.ValidNameCode validNameCode = VarNameValidator.validateSPSSName((String)string, (boolean)true);
        String string2 = null;
        switch (validNameCode) {
            case SPSSNAME_SCRATCH: {
                string2 = ResUtil.getCommonDlgString("ERR_BADVAR_SCRATCH_ERROR_MESSAGE");
                break;
            }
            case SPSSNAME_SYSTEM: {
                string2 = ResUtil.getCommonDlgString("ERR_BADVAR_SYSTEM_ERROR_MESSAGE");
                break;
            }
            case SPSSNAME_BADLTH: {
                string2 = ResUtil.getCommonDlgString("ERR_BADVAR_BAD_LENGTH_ERROR_MESSAGE");
                break;
            }
            case SPSSNAME_BADCHAR: {
                string2 = ResUtil.getCommonDlgString("ERR_BADVAR_MIDDLE_ERROR_MESSAGE");
                break;
            }
            case SPSSNAME_RESERVED: {
                string2 = ResUtil.getCommonDlgString("ERR_BADVAR_RESERVED_ERROR_MESSAGE");
                break;
            }
            case SPSSNAME_BADFIRST: {
                string2 = ResUtil.getCommonDlgString("ERR_BADVAR_FIRST_ERROR_MESSAGE");
                break;
            }
            case SPSSNAME_BADLAST: {
                string2 = ResUtil.getCommonDlgString("ERR_BADVAR_LAST_ERROR_MESSAGE");
                break;
            }
        }
        return string2;
    }

    private static boolean canPasteVarColumn(String string, String string2) {
        boolean bl = string2.equals("name") || string2.equals("label") ? string.equals("name") || string.equals("label") : (string2.equals("width") || string2.equals("decimals") || string2.equals("columns") ? string.equals("width") || string.equals("decimals") || string.equals("columns") : string.equals(string2));
        return bl;
    }

    private boolean readMissingValues(ISpssVariable iSpssVariable) {
        boolean bl;
        short s;
        OBS[] oBSArray = new OBS[3];
        short s2 = this.mInStream.retrieveShort();
        ISpssVariable.Rule rule = ISpssVariable.Rule.fromShort((short)this.mInStream.retrieveShort());
        short s3 = (short)Math.abs(rule.value());
        for (s = 0; s < 3; s = (short)(s + 1)) {
            oBSArray[s] = new OBS();
            if (s >= s3) continue;
            SpssVariable.serializeOBS((IDataStream)this.mInStream, (OBS)oBSArray[s], (int)iSpssVariable.getType(), (boolean)true);
        }
        s = rule != ISpssVariable.Rule.none ? s2 : iSpssVariable.getType();
        boolean bl2 = bl = s == iSpssVariable.getType() || s != 0 && iSpssVariable.getType() != 0;
        if (bl) {
            iSpssVariable.setMissingValues(rule, oBSArray[0], oBSArray[1], oBSArray[2]);
        }
        return bl;
    }

    private boolean readValueLabels(ISpssVariable iSpssVariable) {
        boolean bl = true;
        IValueLabelMap iValueLabelMap = iSpssVariable.getValueLabels();
        if (iValueLabelMap instanceof ValueLabelMap) {
            iValueLabelMap = ValueLabelMap.serialize((ValueLabelMap)((ValueLabelMap)iValueLabelMap), (IDataStream)this.mInStream, (int)iSpssVariable.getType());
            Set set = iValueLabelMap.getValueLabelEntries();
            for (Map.Entry entry : set) {
                OBS oBS = (OBS)entry.getKey();
                if ((iSpssVariable.getType() != 0 || !oBS.isString()) && (iSpssVariable.getType() == 0 || oBS.isString())) continue;
                bl = false;
                break;
            }
            if (bl) {
                iSpssVariable.setValueLabels(iValueLabelMap);
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public static class VariableRows
    extends DEData {
        public VariableRows(byte[] byArray) {
            super(byArray);
        }

        @Override
        public DataFlavor getDataFlavor() {
            return VAR_ROW_FLAVOR;
        }
    }

    public static class VariableCells
    extends DEData {
        public VariableCells(byte[] byArray) {
            super(byArray);
        }

        @Override
        public DataFlavor getDataFlavor() {
            return VAR_CELL_FLAVOR;
        }
    }

    public static class DataRows
    extends DEData {
        public DataRows(byte[] byArray) {
            super(byArray);
        }

        @Override
        public DataFlavor getDataFlavor() {
            return DATA_ROW_FLAVOR;
        }
    }

    public static class DataCols
    extends DEData {
        public DataCols(byte[] byArray) {
            super(byArray);
        }

        @Override
        public DataFlavor getDataFlavor() {
            return DATA_COL_FLAVOR;
        }
    }

    public static class DataCells
    extends DEData {
        public DataCells(byte[] byArray) {
            super(byArray);
        }

        @Override
        public DataFlavor getDataFlavor() {
            return DATA_CELL_FLAVOR;
        }
    }

    public static abstract class DEData
    implements Serializable {
        protected byte[] mBytes;

        DEData(byte[] byArray) {
            this.mBytes = byArray;
        }

        public byte[] getBytes() {
            return this.mBytes;
        }

        public abstract DataFlavor getDataFlavor();
    }

    public static enum SelectionType {
        NONE,
        DATA_CELLS,
        DATA_ROWS,
        DATA_COLS,
        VAR_CELLS,
        VAR_ROWS;

    }
}

