/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.data;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.DisplayAlignment;
import com.spss.java_client.core.documents.data.dictionary.FormatType;
import com.spss.java_client.core.documents.data.dictionary.IDatasourceAttributes;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.core.documents.data.dictionary.Role;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.core.documents.data.dictionary.value_labels.IValueLabelMap;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.doc_types.data.DataTableCellRenderer;
import com.spss.java_client.ui.doc_types.data.undo.ModifyVariableEdit;
import com.spss.java_client.ui.doc_types.data.undo.VariableInsertEdit;
import com.spss.java_client.ui.doc_types.data.undo.VariableViewCellEdit;
import com.spss.java_client.ui.resources.AlignmentResources;
import com.spss.java_client.ui.resources.MeasurementLevelResources;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.java_client.ui.resources.RoleResources;
import com.spss.java_client.ui.undo.SpssUndoManager;
import com.spss.shared.core_tools.format.CellValueFormatter;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.undo.CompoundEdit;

public class VarViewTableModel
extends AbstractTableModel {
    public static final int MAXMVVLLIMIT = Short.MAX_VALUE;
    public static final String CUSTOM_ATTR_LEADER = "@";
    private static final String BACK_ACTION_KEY = "selectPreviousColumnCell";
    protected static final int NUM_STATIC_COLUMNS = 10;
    private static final SPSS_Format DEF_FORMAT = new SPSS_Format(FormatType.F, 8, 2);
    protected static String[] COL_NAMES = new String[]{ResUtil.getString("IDS_NAME"), ResUtil.getString("IDS_TYPE"), ResUtil.getString("IDS_WIDTH"), ResUtil.getString("IDS_DECIMALS"), ResUtil.getString("IDS_LABEL"), ResUtil.getString("IDS_VALUES"), ResUtil.getString("IDS_MISSING"), ResUtil.getString("IDS_COLUMNS"), ResUtil.getString("IDS_ALIGN"), ResUtil.getString("IDS_MEASURE"), ResUtil.getString("IDS_ROLE")};
    static final int VAR_NAME = 0;
    static final int VAR_TYPE = 1;
    static final int VAR_WIDTH = 2;
    static final int VAR_PRECISION = 3;
    static final int VAR_LABEL = 4;
    static final int VAR_VALUES = 5;
    static final int VAR_MISSING = 6;
    static final int VAR_COLUMNS = 7;
    static final int VAR_ALIGN = 8;
    static final int VAR_MEASURE = 9;
    static final int VAR_ROLE = 10;
    private ISpssDataSrc mDataSource = null;
    private boolean mReadOnly = false;
    private DataTableCellRenderer mCellRenderer = new DataTableCellRenderer();
    private SpssUndoManager mUndoManager;
    private Point mCellDisplayOverrideLocation = null;
    private String mCellDisplayOverrideString = null;
    private Vector<String> mDisplayedAttributes;

    public VarViewTableModel() {
        this.updateDisplayedAttributes();
    }

    public void connectData(LocallyUniqueId locallyUniqueId) {
        Vector vector;
        this.mDataSource = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        assert (this.mDataSource != null);
        IDatasourceAttributes iDatasourceAttributes = this.mDataSource.getAttributes();
        Vector vector2 = vector = iDatasourceAttributes != null ? iDatasourceAttributes.values("$VariableView2") : null;
        if (vector != null && vector.size() > 0) {
            this.mDisplayedAttributes = (Vector)vector.clone();
            this.fireTableStructureChanged();
        }
    }

    public void disconnect() {
        this.mCellRenderer = null;
        this.mUndoManager = null;
        this.mDataSource = null;
    }

    public boolean isReadOnly() {
        return this.mReadOnly;
    }

    public void setReadOnly(boolean bl) {
        this.mReadOnly = bl;
    }

    @Override
    public int getRowCount() {
        if (this.mDataSource == null) {
            return 40;
        }
        return this.mDataSource.columnCount() + 40;
    }

    @Override
    public int getColumnCount() {
        return this.mDisplayedAttributes.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        ISpssVariable iSpssVariable;
        String string = this.columnIndexToColumnId(n2);
        if (string == null || string.length() == 0) {
            return null;
        }
        boolean bl = string.charAt(0) == CUSTOM_ATTR_LEADER.charAt(0);
        ISpssVariable iSpssVariable2 = iSpssVariable = this.mDataSource != null ? this.mDataSource.getVariable(n) : null;
        if (this.mCellDisplayOverrideLocation != null && this.mCellDisplayOverrideString != null && this.mCellDisplayOverrideLocation.y == n && this.mCellDisplayOverrideLocation.x == n2) {
            if (bl) {
                AttributeDisplayInfo attributeDisplayInfo = this.getAttributesDisplayInfo(iSpssVariable, string);
                attributeDisplayInfo.setDisplayText(this.mCellDisplayOverrideString);
                return attributeDisplayInfo;
            }
            return this.mCellDisplayOverrideString;
        }
        if (bl) {
            return this.getAttributesDisplayInfo(iSpssVariable, string);
        }
        if (string.equals("name")) {
            return iSpssVariable == null ? "" : iSpssVariable.getName();
        }
        if (string.equals("type")) {
            return iSpssVariable == null ? "" : this.varTypeName(iSpssVariable);
        }
        if (string.equals("width")) {
            return iSpssVariable == null ? "" : Integer.toString(iSpssVariable.getFormat().getWidth());
        }
        if (string.equals("decimals")) {
            return iSpssVariable == null ? "" : Integer.toString(iSpssVariable.getFormat().getDecimals());
        }
        if (string.equals("label")) {
            return iSpssVariable == null ? "" : CharacterUtil.rightTrim((String)iSpssVariable.getLabel());
        }
        if (string.equals("values")) {
            return iSpssVariable == null ? "" : this.formatVarValue(iSpssVariable);
        }
        if (string.equals("missing")) {
            return iSpssVariable == null ? "" : this.formatMissing(iSpssVariable);
        }
        if (string.equals("columns")) {
            return iSpssVariable == null ? "" : Integer.toString(iSpssVariable.getDisplayWidth());
        }
        if (string.equals("alignment")) {
            return iSpssVariable == null ? null : iSpssVariable.getDisplayAlignment();
        }
        if (string.equals("measure")) {
            return iSpssVariable == null ? null : iSpssVariable.getMeasurementLevel();
        }
        if (string.equals("role")) {
            return iSpssVariable == null ? null : iSpssVariable.getRole();
        }
        assert (false);
        return null;
    }

    public String getValueAsString(int n, int n2) {
        Object object = this.getValueAt(n, n2);
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof DisplayAlignment) {
            return AlignmentResources.getInstance().getText(object);
        }
        if (object instanceof MeasurementLevel) {
            return MeasurementLevelResources.getInstance().getText(object);
        }
        if (object instanceof Role) {
            return RoleResources.getInstance().getText(object);
        }
        return "";
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (this.mReadOnly) {
            return;
        }
        String string = this.columnIndexToColumnId(n2);
        if (string == null || string.length() == 0) {
            assert (false);
            return;
        }
        boolean bl = string.startsWith(CUSTOM_ATTR_LEADER);
        if (bl && string.length() > 1 && string.charAt(1) == '$') {
            return;
        }
        Object object2 = this.getValueAt(n, n2);
        if (bl) {
            if (object2 instanceof AttributeDisplayInfo && ((AttributeDisplayInfo)object2).isArray()) {
                return;
            }
            ISpssVariable iSpssVariable = this.mDataSource != null ? this.mDataSource.getVariable(n) : null;
            if ((iSpssVariable = this.setAttributeValue(iSpssVariable, string, object.toString())) != null) {
                Vector<ISpssVariable> vector = new Vector<ISpssVariable>();
                vector.add(iSpssVariable);
                new ModifyVariableEdit(this.mUndoManager, new int[]{n}, vector);
            }
        } else {
            String string2 = object != null ? object.toString() : "";
            boolean bl2 = object2 == null && (string2.equals("0") || string2.equals(""));
            boolean bl3 = bl2 = !bl2 ? string2.equals(object2) : bl2;
            if (bl2) {
                return;
            }
            if ((string.equals("width") || string.equals("decimals") || string.equals("columns")) && n >= this.mDataSource.columnCount() && string2.equals("0")) {
                return;
            }
            DataFrame dataFrame = (DataFrame)this.mUndoManager.getSpssFrame();
            if (!dataFrame.getDataView().canChangeCellValue()) {
                return;
            }
            if (n >= this.mDataSource.columnCount() && !dataFrame.getDataView().canAddNewVariable()) {
                return;
            }
            if (!dataFrame.checkDataLimit(false, n - this.mDataSource.columnCount() + 1)) {
                return;
            }
            SpssUndoManager spssUndoManager = this.getUndoManager();
            CompoundEdit compoundEdit = new CompoundEdit();
            spssUndoManager.addEdit(compoundEdit);
            String string3 = null;
            if (n >= this.mDataSource.columnCount()) {
                int n3 = 0;
                String string4 = string3 = string.equals("name") && object != null ? object.toString() : null;
                if (string3 != null && !DialogUtil.checkNewVarName(this.mUndoManager.getSpssFrame(), this.mDataSource, string3)) {
                    compoundEdit.die();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ActionListener actionListener = ((DataFrame)VarViewTableModel.this.mUndoManager.getSpssFrame()).getDataView().getDataTable(1).getActionForKeyStroke(KeyStroke.getKeyStroke(37, 0));
                            if (actionListener != null) {
                                actionListener.actionPerformed(new ActionEvent(((DataFrame)VarViewTableModel.this.mUndoManager.getSpssFrame()).getDataView().getDataTable(1), 0, VarViewTableModel.BACK_ACTION_KEY));
                            }
                        }
                    });
                    return;
                }
                this.addRows(n - this.mDataSource.columnCount() + 1, n3, string3);
            }
            if (!(string.equals("type") || string.equals("values") || string.equals("missing"))) {
                if (string3 == null) {
                    new VariableViewCellEdit(this, object, n, string);
                    if (string.equals("name")) {
                        dataFrame.getDataView().queryVarSetsNewVariableName(object.toString());
                    }
                }
                compoundEdit.end();
            } else {
                compoundEdit.die();
            }
        }
    }

    public int getMinValue(int n) {
        String string = this.columnIndexToColumnId(n);
        if (string == null) {
            return 0;
        }
        return string.equals("width") || string.equals("columns") ? 1 : 0;
    }

    public int getMaxValue(int n, int n2) {
        SPSS_Format sPSS_Format;
        String string = this.columnIndexToColumnId(n2);
        if (string == null) {
            return 0;
        }
        int n3 = 16;
        ISpssVariable iSpssVariable = this.mDataSource != null ? this.mDataSource.getVariable(n) : null;
        SPSS_Format sPSS_Format2 = sPSS_Format = iSpssVariable != null ? iSpssVariable.getFormat() : null;
        if (sPSS_Format == null) {
            sPSS_Format = DEF_FORMAT;
        }
        if (string.equals("width")) {
            if (sPSS_Format.getFormatType().isNumericFormat()) {
                n3 = 40;
            } else if (sPSS_Format.getFormatType().isStringFormat()) {
                n3 = Short.MAX_VALUE;
            }
        } else if (string.equals("decimals")) {
            n3 = 16;
        } else if (string.equals("columns")) {
            n3 = 255;
        }
        return n3;
    }

    @Override
    public String getColumnName(int n) {
        String string = this.columnIndexToColumnId(n);
        if (string == null) {
            return "";
        }
        return VarViewTableModel.columnIdToColumnName(string);
    }

    @Override
    public Class<?> getColumnClass(int n) {
        String string = this.columnIndexToColumnId(n);
        if (string != null && string.startsWith(CUSTOM_ATTR_LEADER)) {
            return AttributeDisplayInfo.class;
        }
        return super.getColumnClass(n);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        ISpssVariable iSpssVariable;
        boolean bl = true;
        String string = this.columnIndexToColumnId(n2);
        ISpssVariable iSpssVariable2 = iSpssVariable = this.mDataSource != null ? this.mDataSource.getVariable(n) : null;
        if (iSpssVariable == null || string == null) {
            return bl;
        }
        boolean bl2 = iSpssVariable.getFormat().getFormatType().isDateOrTimeFormat();
        if (bl2 && (string.equals("width") || string.equals("decimals"))) {
            return false;
        }
        boolean bl3 = iSpssVariable.getFormat().getFormatType().isStringFormat();
        boolean bl4 = iSpssVariable.getFormat().getFormatType().isRestrictedNumericFormat();
        if ((bl3 || bl4) && string.equals("decimals")) {
            return false;
        }
        if (string.equals("values") || string.equals("missing")) {
            bl = iSpssVariable.getFormat().getWidth() <= Short.MAX_VALUE;
        }
        return bl;
    }

    public ISpssDataSrc getDataSource() {
        return this.mDataSource;
    }

    public void setUndoManager(SpssUndoManager spssUndoManager) {
        this.mUndoManager = spssUndoManager;
    }

    public SpssUndoManager getUndoManager() {
        return this.mUndoManager;
    }

    public void fireTableVariableAdded(int n) {
        this.fireTableChanged(new TableModelEvent(this, n, n, -1, 1));
    }

    public void fireTableVariableChanged(int n) {
        this.fireTableChanged(new TableModelEvent(this, n, n, -1, 0));
    }

    public void fireTableVariablesDeleted(int n, int n2) {
        this.fireTableChanged(new TableModelEvent(this, n, n2, -1, -1));
    }

    public void setButtonCellOverrideText(Point point, String string) {
        if (point == null || point.x < 0 || point.y < 0 || string == null || string.length() == 0) {
            this.mCellDisplayOverrideLocation = null;
            this.mCellDisplayOverrideString = null;
        } else {
            this.mCellDisplayOverrideLocation = point;
            this.mCellDisplayOverrideString = string;
        }
    }

    public Vector<String> getDisplayedAttributes() {
        return this.mDisplayedAttributes;
    }

    public void setDisplayedAttributes(Vector<String> vector) {
        this.mDisplayedAttributes = (Vector)vector.clone();
        this.fireTableStructureChanged();
    }

    public String columnIndexToColumnId(int n) {
        if (n < 0 || n >= this.mDisplayedAttributes.size()) {
            return null;
        }
        return this.mDisplayedAttributes.get(n);
    }

    public int columnIdToColumnIndex(String string) {
        int n = -1;
        int n2 = 0;
        for (String string2 : this.mDisplayedAttributes) {
            if (string2.equals(string)) {
                n = n2;
                break;
            }
            ++n2;
        }
        return n;
    }

    public static void reloadColumnNames() {
        COL_NAMES = new String[]{ResUtil.getString("IDS_NAME"), ResUtil.getString("IDS_TYPE"), ResUtil.getString("IDS_WIDTH"), ResUtil.getString("IDS_DECIMALS"), ResUtil.getString("IDS_LABEL"), ResUtil.getString("IDS_VALUES"), ResUtil.getString("IDS_MISSING"), ResUtil.getString("IDS_COLUMNS"), ResUtil.getString("IDS_ALIGN"), ResUtil.getString("IDS_MEASURE"), ResUtil.getString("IDS_ROLE")};
    }

    public static String columnIdToColumnName(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        String string2 = !string.startsWith(CUSTOM_ATTR_LEADER) ? (string.equals("name") ? COL_NAMES[0] : (string.equals("type") ? COL_NAMES[1] : (string.equals("width") ? COL_NAMES[2] : (string.equals("decimals") ? COL_NAMES[3] : (string.equals("label") ? COL_NAMES[4] : (string.equals("values") ? COL_NAMES[5] : (string.equals("missing") ? COL_NAMES[6] : (string.equals("columns") ? COL_NAMES[7] : (string.equals("alignment") ? COL_NAMES[8] : (string.equals("measure") ? COL_NAMES[9] : (string.equals("role") ? COL_NAMES[10] : ""))))))))))) : string.substring(1);
        return string2;
    }

    public int getNameColumn() {
        return this.columnIdToColumnIndex("name");
    }

    public int getTypeColumn() {
        return this.columnIdToColumnIndex("type");
    }

    public int getWidthColumn() {
        return this.columnIdToColumnIndex("width");
    }

    public int getDecimalsColumn() {
        return this.columnIdToColumnIndex("decimals");
    }

    public int getLabelColumn() {
        return this.columnIdToColumnIndex("label");
    }

    public int getValuesColumn() {
        return this.columnIdToColumnIndex("values");
    }

    public int getMissingColumn() {
        return this.columnIdToColumnIndex("missing");
    }

    public int getColumnsColumn() {
        return this.columnIdToColumnIndex("columns");
    }

    public int getAlignColumn() {
        return this.columnIdToColumnIndex("alignment");
    }

    public int getMeasureColumn() {
        return this.columnIdToColumnIndex("measure");
    }

    public void updateDisplayedAttributes() {
        this.mDisplayedAttributes = null;
        if (this.mDataSource != null) {
            Vector vector;
            Vector vector2;
            IDatasourceAttributes iDatasourceAttributes = this.mDataSource.getAttributes();
            Vector vector3 = vector2 = iDatasourceAttributes != null ? iDatasourceAttributes.values("$VariableView2") : null;
            if (vector2 != null && vector2.size() > 0) {
                this.mDisplayedAttributes = (Vector)vector2.clone();
            } else if (iDatasourceAttributes != null && (vector = iDatasourceAttributes.values("$de.displayedattributes")) != null && vector.size() > 0) {
                vector2 = PrefsMgr.getPrefsMgr().getDefaultVarViewDisplayColumns();
                for (String string : vector) {
                    vector2.add(CUSTOM_ATTR_LEADER + string);
                }
                this.mDisplayedAttributes = vector2;
            }
        }
        if (this.mDisplayedAttributes == null) {
            this.mDisplayedAttributes = PrefsMgr.getPrefsMgr().getDefaultVarViewDisplayColumns();
        }
        this.fireTableStructureChanged();
    }

    public boolean addVariable(int n, int n2, String string) {
        int n3 = this.mDataSource.columnCount();
        if (n < n3) {
            return false;
        }
        this.addRows(n - n3 + 1, n2, string);
        return true;
    }

    private void addRows(long l, int n, String string) {
        int n2 = this.mDataSource.columnCount();
        if (string == null) {
            ISpssDataSrc.ReturnIndex returnIndex = new ISpssDataSrc.ReturnIndex();
            Vector<ISpssVariable> vector = new Vector<ISpssVariable>();
            ISpssVariable iSpssVariable = null;
            iSpssVariable = ComponentState.isBtdRtlOrLtr() && n > 0 ? this.mDataSource.makeVariable(n, returnIndex) : this.mDataSource.makeVariable(0, returnIndex);
            vector.add(iSpssVariable);
            int n3 = (int)l + this.mDataSource.columnCount() - 1;
            if (ComponentState.isBtdRtlOrLtr() && n > 0) {
                new VariableInsertEdit(this.mUndoManager, this.mDataSource, n3, vector).setLastColType(n);
            } else {
                new VariableInsertEdit(this.mUndoManager, this.mDataSource, n3, vector);
            }
        } else {
            new VariableInsertEdit(this.mUndoManager, this.mDataSource, n2, (int)l, n, string);
        }
    }

    protected String varTypeName(ISpssVariable iSpssVariable) {
        FormatType formatType = iSpssVariable.getFormat().getFormatType();
        String string = formatType == FormatType.AHEX ? "" : (formatType.isStringFormat() ? ResUtil.getString("IDS_STRING") : (formatType.isDateOrTimeFormat() ? ResUtil.getString("IDS_DATE") : (formatType.isCurrencyFormat() ? ResUtil.getString(formatType.equals((Object)FormatType.DOLLAR) ? "IDS_DOLLAR" : "IDS_CUSTOM") : (formatType.equals((Object)FormatType.COMMA) ? ResUtil.getString("IDS_COMMA") : (formatType.equals((Object)FormatType.DOT) ? ResUtil.getString("IDS_DOT") : (formatType.equals((Object)FormatType.E) ? ResUtil.getString("IDS_SCIENTIFIC") : (formatType.isRestrictedNumericFormat() ? ResUtil.getString("IDS_RESTRICTED_NUMERIC") : (formatType.equals((Object)FormatType.PERCENT) ? ResUtil.getString("IDS_PERCENT") : (this.isDataEditorFormatType(formatType) ? ResUtil.getString("IDS_NUMERIC") : "")))))))));
        return string;
    }

    boolean isDataEditorFormatType(FormatType formatType) {
        return formatType == FormatType.N || formatType == FormatType.A || formatType == FormatType.COMMA || formatType == FormatType.DOLLAR || formatType == FormatType.F || formatType == FormatType.E || formatType == FormatType.DATE || formatType == FormatType.TIME || formatType == FormatType.DATETIME || formatType == FormatType.ADATE || formatType == FormatType.JDATE || formatType == FormatType.DTIME || formatType == FormatType.WKDAY || formatType == FormatType.MONTH || formatType == FormatType.MOYR || formatType == FormatType.QYR || formatType == FormatType.WKYR || formatType == FormatType.DOT || formatType == FormatType.CCA || formatType == FormatType.CCB || formatType == FormatType.CCC || formatType == FormatType.CCD || formatType == FormatType.CCE || formatType == FormatType.EDATE || formatType == FormatType.SDATE || formatType == FormatType.YMDHMS || formatType == FormatType.MTIME;
    }

    private String formatVarValue(ISpssVariable iSpssVariable) {
        String string = "";
        IValueLabelMap iValueLabelMap = iSpssVariable.getValueLabels();
        if (iValueLabelMap != null && iValueLabelMap.size() > 0) {
            Set set = iValueLabelMap.getValueLabelEntries();
            if (set.iterator().hasNext()) {
                Map.Entry entry = (Map.Entry)set.iterator().next();
                OBS oBS = (OBS)entry.getKey();
                String string2 = (String)entry.getValue();
                this.mCellRenderer.setCellFormat(iSpssVariable);
                this.mCellRenderer.setValue(CellValueFormatter.obsToString((OBS)oBS, (SPSS_Format)iSpssVariable.getFormat()));
                string = "{" + this.mCellRenderer.getText() + ", " + string2 + "}...";
            }
        } else {
            string = ResUtil.getString("IDS_NONE");
        }
        return string;
    }

    private String formatMissing(ISpssVariable iSpssVariable) {
        String string;
        OBS oBS = new OBS();
        OBS oBS2 = new OBS();
        OBS oBS3 = new OBS();
        ISpssVariable.Rule rule = iSpssVariable.getMissingValues(oBS, oBS2, oBS3);
        if (rule.equals((Object)ISpssVariable.Rule.none)) {
            string = ResUtil.getString("IDS_NONE");
        } else {
            this.mCellRenderer.setCellFormat(iSpssVariable);
            if (rule.equals((Object)ISpssVariable.Rule.one) || rule.equals((Object)ISpssVariable.Rule.two) || rule.equals((Object)ISpssVariable.Rule.three)) {
                assert (!oBS.isEmpty());
                this.mCellRenderer.setValue(CellValueFormatter.obsToString((OBS)oBS, (SPSS_Format)iSpssVariable.getFormat()));
                string = this.mCellRenderer.getText();
                if (rule.equals((Object)ISpssVariable.Rule.two) || rule.equals((Object)ISpssVariable.Rule.three)) {
                    assert (!oBS2.isEmpty());
                    this.mCellRenderer.setValue(CellValueFormatter.obsToString((OBS)oBS2, (SPSS_Format)iSpssVariable.getFormat()));
                    string = string + ", " + this.mCellRenderer.getText();
                    if (rule.equals((Object)ISpssVariable.Rule.three)) {
                        assert (!oBS3.isEmpty());
                        this.mCellRenderer.setValue(CellValueFormatter.obsToString((OBS)oBS3, (SPSS_Format)iSpssVariable.getFormat()));
                        string = string + ", " + this.mCellRenderer.getText();
                    }
                }
            } else if (rule.equals((Object)ISpssVariable.Rule.range) || rule.equals((Object)ISpssVariable.Rule.range_plus)) {
                assert (!oBS.isEmpty());
                this.mCellRenderer.setValue(this.obsWithLowHighToString(oBS, iSpssVariable.getFormat()));
                string = this.mCellRenderer.getText() + " - ";
                assert (!oBS2.isEmpty());
                this.mCellRenderer.setValue(this.obsWithLowHighToString(oBS2, iSpssVariable.getFormat()));
                string = string + this.mCellRenderer.getText();
                if (rule.equals((Object)ISpssVariable.Rule.range_plus)) {
                    assert (!oBS3.isEmpty());
                    this.mCellRenderer.setValue(CellValueFormatter.obsToString((OBS)oBS3, (SPSS_Format)iSpssVariable.getFormat()));
                    string = string + ", " + this.mCellRenderer.getText();
                }
            } else {
                assert (false);
                string = "";
            }
        }
        return string;
    }

    private String obsWithLowHighToString(OBS oBS, SPSS_Format sPSS_Format) {
        if (sPSS_Format.getFormatType().isNumericFormat()) {
            ISpssDataSrc iSpssDataSrc = this.getDataSource();
            double d = iSpssDataSrc.getObslo();
            double d2 = iSpssDataSrc.getObshi();
            if (d == oBS.getNum()) {
                return "LO";
            }
            if (d2 == oBS.getNum()) {
                return "HI";
            }
        }
        return CellValueFormatter.obsToString((OBS)oBS, (SPSS_Format)sPSS_Format);
    }

    private ISpssVariable setAttributeValue(ISpssVariable iSpssVariable, String string, String string2) {
        assert (string != null && string.length() > 0 && string.charAt(0) == CUSTOM_ATTR_LEADER.charAt(0));
        ISpssVariable iSpssVariable2 = null;
        if (iSpssVariable != null) {
            String string3 = string.substring(1);
            Vector<String> vector = iSpssVariable.getAttributeValues(string3);
            if (vector == null) {
                vector = new Vector<String>();
            }
            if (vector.size() == 0 && (string2 == null || string2.length() == 0)) {
                return null;
            }
            if (string2 != null && vector.size() == 1 && ((String)vector.get(0)).equals(string2)) {
                return null;
            }
            try {
                iSpssVariable2 = iSpssVariable.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
                return null;
            }
            if (vector.size() == 1) {
                vector.remove(0);
            }
            vector.add(string2);
            iSpssVariable2.getAttributes().put(string3, vector);
        }
        return iSpssVariable2;
    }

    private AttributeDisplayInfo getAttributesDisplayInfo(ISpssVariable iSpssVariable, String string) {
        String string2;
        Vector vector;
        AttributeDisplayInfo attributeDisplayInfo = new AttributeDisplayInfo();
        String string3 = "";
        if (iSpssVariable != null && string != null && string.charAt(0) == CUSTOM_ATTR_LEADER.charAt(0) && (vector = iSpssVariable.getAttributeValues(string2 = string.substring(1))) != null) {
            if (vector.size() == 1) {
                string3 = (String)vector.get(0);
                if (string3.length() == 0) {
                    string3 = ResUtil.getString("IDS_EMPTY_ATTRIBUTE");
                    attributeDisplayInfo.setIsEmpty(true);
                }
            } else if (vector.size() > 1) {
                string3 = ResUtil.getString("IDS_ARRAY_ATTRIBUTE");
                attributeDisplayInfo.setIsArray(true);
            }
        }
        attributeDisplayInfo.setDisplayText(string3);
        return attributeDisplayInfo;
    }

    class AttributeDisplayInfo {
        private String mDisplayText = "";
        private boolean mIsEmpty = false;
        private boolean mIsArray = false;

        AttributeDisplayInfo() {
        }

        public String getDisplayText() {
            return this.mDisplayText;
        }

        public void setDisplayText(String string) {
            this.mDisplayText = string;
        }

        public boolean isEmpty() {
            return this.mIsEmpty;
        }

        public void setIsEmpty(boolean bl) {
            this.mIsEmpty = bl;
        }

        public boolean isArray() {
            return this.mIsArray;
        }

        public void setIsArray(boolean bl) {
            this.mIsArray = bl;
        }
    }
}

