/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.data;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.DisplayAlignment;
import com.spss.java_client.core.documents.data.dictionary.ExtensionType;
import com.spss.java_client.core.documents.data.dictionary.FormatType;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.core.documents.data.dictionary.Role;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.core.documents.data.dictionary.value_labels.IValueLabelMap;
import com.spss.java_client.ui.command.ActionCatalog;
import com.spss.java_client.ui.controls.AlignmentRenderer;
import com.spss.java_client.ui.controls.ButtonEditCtrl;
import com.spss.java_client.ui.controls.IButtonEditListener;
import com.spss.java_client.ui.controls.IconTextRenderer;
import com.spss.java_client.ui.controls.MeasurementLevelRenderer;
import com.spss.java_client.ui.controls.RoleRenderer;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.dialogs.base.edit.find.DataFindDlg;
import com.spss.java_client.ui.dialogs.base.edit.find.DataSearchOptions;
import com.spss.java_client.ui.dialogs.base.edit.find.SearchOptions;
import com.spss.java_client.ui.dialogs.common.CustomAttributeArrayDlg;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.documents.data.MissingValuesDlg;
import com.spss.java_client.ui.dialogs.documents.data.ValueLabelsDlg;
import com.spss.java_client.ui.dialogs.documents.data.VariableTypeDlg;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.actions.SpssAction;
import com.spss.java_client.ui.doc_types.data.DataCellEdit;
import com.spss.java_client.ui.doc_types.data.DataEditContextMenu;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.doc_types.data.DataView;
import com.spss.java_client.ui.doc_types.data.DragTableColumnRenderer;
import com.spss.java_client.ui.doc_types.data.SpssRowHeaderTable;
import com.spss.java_client.ui.doc_types.data.SpssTable;
import com.spss.java_client.ui.doc_types.data.TableColMoveTransferHandler;
import com.spss.java_client.ui.doc_types.data.TableHeaderPrintRender;
import com.spss.java_client.ui.doc_types.data.VarTableColMoveDropTargetHandler;
import com.spss.java_client.ui.doc_types.data.VarViewTableModel;
import com.spss.java_client.ui.doc_types.data.undo.MissingValueBucket;
import com.spss.java_client.ui.doc_types.data.undo.ModifyVariableEdit;
import com.spss.java_client.ui.doc_types.data.undo.TableColumnWidthEdit;
import com.spss.java_client.ui.doc_types.data.undo.VarViewMissingValueEdit;
import com.spss.java_client.ui.doc_types.data.undo.VarViewValueLabelsEdit;
import com.spss.java_client.ui.doc_types.doc_util.DocUtil;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.format.CellValueFormatter;
import com.spss.shared.core_tools.system.OSInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JMenuItem;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.text.NumberFormatter;
import javax.swing.undo.CompoundEdit;

public class VarViewTable
extends SpssTable
implements IButtonEditListener {
    public static String[] sMeasurementValues = new String[]{ResUtil.getString("IDS_SCALE"), ResUtil.getString("IDS_ORDINAL"), ResUtil.getString("IDS_NOMINAL"), ResUtil.getCommonDlgString("IDS_MEASUREMENT_UNKNOWN")};
    private static final String[] HEADER_CONTEXT_MENU_IDS = new String[]{"context_sort_ascend", "context_sort_descend"};
    private static final String[] TABLE_CONTEXT_MENU_IDS = new String[]{"context_data_copy", "context_data_paste", "separator", "context_var_info", "context_data_descriptives", "separator", "context_grid_font"};
    private static int sHighlightColumn = -1;
    private static int sCurrentHeaderCol = -1;
    private static Border sDefaultBorder = null;
    private static Border sHighlightBorder = null;
    private static Border sLeadCellBorder = null;
    private static final String ENTER_ACTION_KEY = "selectNextColumnCell";
    private static final String UP_ACTION_KEY = "selectPreviousRowCell";
    private static final String DOWN_ACTION_KEY = "selectNextRowCell";
    private static DataView.SelectMode sPrevSelMode = DataView.SelectMode.CELL_SELECT;
    private KeyAdapter mKeyAdapter = null;
    private Component mLabelEditor = null;
    private boolean mInLabelEdit = false;
    private boolean mDefaultWidthsSet = false;
    private AlignmentRenderer mAlignmentRenderer = new AlignmentRenderer();
    private MeasurementLevelRenderer mMeasurementLevelRenderer = new MeasurementLevelRenderer();
    private RoleRenderer mRoleRenderer = new RoleRenderer();

    public VarViewTable(VarViewTableModel varViewTableModel, DataView dataView) {
        super((TableModel)varViewTableModel, dataView);
        MouseMotionListener[] mouseMotionListenerArray;
        this.setIntercellSpacing(new Dimension(3, 1));
        VarViewCellRenderer varViewCellRenderer = new VarViewCellRenderer();
        varViewCellRenderer.setVerticalAlignment(0);
        this.setDefaultRenderer(Object.class, varViewCellRenderer);
        this.getTableHeader().setDefaultRenderer(new VarViewHeaderCellRenderer());
        TableColMoveTransferHandler tableColMoveTransferHandler = new TableColMoveTransferHandler();
        VarTableColMoveDropTargetHandler varTableColMoveDropTargetHandler = new VarTableColMoveDropTargetHandler(this.mDataView.getUndoManager(), this);
        TableHeaderMouseHandler tableHeaderMouseHandler = new TableHeaderMouseHandler();
        JTableHeader jTableHeader = this.getTableHeader();
        jTableHeader.addMouseMotionListener(tableHeaderMouseHandler);
        jTableHeader.addMouseListener(tableHeaderMouseHandler);
        jTableHeader.setTransferHandler(tableColMoveTransferHandler);
        new DropTarget(jTableHeader, 2, varTableColMoveDropTargetHandler, true, null);
        new DropTarget(this, 2, varTableColMoveDropTargetHandler, true, null);
        jTableHeader.setReorderingAllowed(false);
        jTableHeader.setFocusable(false);
        for (MouseMotionListener mouseMotionListener : mouseMotionListenerArray = this.getMouseMotionListeners()) {
            this.removeMouseMotionListener(mouseMotionListener);
        }
        VarViewListSelectionListener varViewListSelectionListener = new VarViewListSelectionListener();
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        listSelectionModel.addListSelectionListener(varViewListSelectionListener);
        ListSelectionModel listSelectionModel2 = this.getColumnModel().getSelectionModel();
        listSelectionModel2.addListSelectionListener(varViewListSelectionListener);
        this.rebuildColumns(new HashMap<String, Integer>());
        this.addKeyListener(new VarTableKeyHandler());
    }

    @Override
    public void repaint(Rectangle rectangle) {
        super.repaint(rectangle);
        if (this.getTableHeader() != null) {
            this.getTableHeader().repaint();
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        JTable[] jTableArray = null;
        int[] nArray = null;
        int[] nArray2 = null;
        int[] nArray3 = null;
        int[] nArray4 = null;
        if (this.mDataView != null && this.mDataView.getActiveView() == 1) {
            jTableArray = this.mDataView.getDataTables();
            nArray = jTableArray[0].getSelectedRows();
            nArray2 = jTableArray[0].getSelectedColumns();
            nArray3 = jTableArray[1].getSelectedRows();
            nArray4 = jTableArray[1].getSelectedColumns();
        }
        super.tableChanged(tableModelEvent);
        if (jTableArray != null) {
            this.reselectRowsAndColumns(jTableArray[0], nArray, nArray2);
            this.reselectRowsAndColumns(jTableArray[1], nArray3, nArray4);
        }
    }

    protected void reselectRowsAndColumns(JTable jTable, int[] nArray, int[] nArray2) {
        if (jTable != null && nArray != null && nArray2 != null) {
            jTable.getSelectionModel().clearSelection();
            jTable.getColumnModel().getSelectionModel().clearSelection();
            int n = -1;
            int n2 = -2;
            for (int n3 : nArray) {
                if (n == -1) {
                    n = n3;
                } else if (n3 != n2 + 1) {
                    jTable.getSelectionModel().addSelectionInterval(n, n2);
                    n = n3;
                }
                n2 = n3;
            }
            if (n > -1) {
                jTable.getSelectionModel().addSelectionInterval(n, n2);
            }
            n = -1;
            n2 = -2;
            for (int n3 : nArray2) {
                if (n == -1) {
                    n = n3;
                } else if (n3 != n2 + 1) {
                    jTable.getColumnModel().getSelectionModel().addSelectionInterval(n, n2);
                    n = n3;
                }
                n2 = n3;
            }
            if (n > -1) {
                jTable.getColumnModel().getSelectionModel().addSelectionInterval(n, n2);
            }
        }
    }

    @Override
    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        if (keyEvent.isControlDown() || keyEvent.isMetaDown()) {
            ActionCatalog.getActionCatalog().enableActions(this.mDataView.getUndoManager().getSpssFrame(), ActionCatalog.getActionCatalog().getMneumonicActions());
        }
        if ((keyStroke.getModifiers() & 8) != 0) {
            return false;
        }
        KeyStroke keyStroke2 = ResUtil.getShortcut("edit_undo");
        KeyStroke keyStroke3 = ResUtil.getShortcut("edit_redo");
        if (keyStroke.equals(keyStroke2) || keyStroke.equals(keyStroke3)) {
            return false;
        }
        if ((keyStroke.getModifiers() & 2) != 0) {
            return false;
        }
        if (OSCheck.getOSType() == OSInfo.OSType.MAC && (keyStroke.getModifiers() & 4) != 0) {
            return false;
        }
        if (keyEvent.getKeyCode() == 525 || keyEvent.isShiftDown() && keyEvent.getKeyCode() == 121) {
            int n2;
            DataEditContextMenu dataEditContextMenu = new DataEditContextMenu(TABLE_CONTEXT_MENU_IDS);
            Point point = keyEvent.getComponent().getLocation();
            int n3 = (int)point.getX();
            int n4 = this.getSelectedColumn();
            for (n2 = 0; n2 < n4; ++n2) {
                n3 += this.getColumnModel().getColumn(n2).getWidth();
            }
            n2 = (int)point.getY() + this.getRowHeight() * this.getSelectedRow() + (int)(0.5 * (double)this.getRowHeight());
            dataEditContextMenu.show(this, n3 += (int)(0.5 * (double)this.getColumnModel().getColumn(n4).getWidth()), n2);
            keyEvent.consume();
            return true;
        }
        if (n == 1 && keyEvent.getKeyChar() > '\u007f' && keyEvent.getID() == 400 && keyEvent.getModifiers() == 0) {
            keyEvent = new KeyEvent(this, 401, keyEvent.getWhen(), keyEvent.getModifiers(), keyEvent.getKeyCode(), keyEvent.getKeyChar());
        }
        Component component = this.getEditorComponent();
        boolean bl2 = super.processKeyBinding(keyStroke, keyEvent, n, bl);
        Component component2 = this.getEditorComponent();
        if (bl && component2 instanceof JSpinner && !keyEvent.isActionKey() && n == 1) {
            final String string = new String(new char[]{keyEvent.getKeyChar()});
            final boolean bl3 = component == null;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Component component = VarViewTable.this.getEditorComponent();
                    if (component instanceof JSpinner) {
                        JSpinner jSpinner = (JSpinner)component;
                        final JSpinner.DefaultEditor defaultEditor = (JSpinner.DefaultEditor)jSpinner.getEditor();
                        if (bl3) {
                            Integer n;
                            try {
                                n = Integer.valueOf(string);
                            }
                            catch (NumberFormatException numberFormatException) {
                                return;
                            }
                            jSpinner.setValue(n);
                            defaultEditor.getTextField().requestFocusInWindow();
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    int n = defaultEditor.getTextField().getText().length();
                                    defaultEditor.getTextField().setSelectionStart(n);
                                    defaultEditor.getTextField().setSelectionEnd(n);
                                    defaultEditor.getTextField().setCaretPosition(n);
                                }
                            });
                        } else if (!defaultEditor.getTextField().hasFocus()) {
                            defaultEditor.getTextField().requestFocusInWindow();
                            defaultEditor.getTextField().setText(string);
                        }
                    }
                }
            });
        }
        return bl2;
    }

    public void reloadStrings() {
        this.mAlignmentRenderer.updateTextResources();
        this.mMeasurementLevelRenderer.updateTextResources();
        this.mRoleRenderer.updateTextResources();
    }

    public void selectAndScrollToVariable(int n) {
        if (n < 0) {
            return;
        }
        this.scrollToTop(n);
        JTable[] jTableArray = this.mDataView.getDataTables();
        jTableArray[0].clearSelection();
        jTableArray[1].clearSelection();
        jTableArray[0].setColumnSelectionInterval(0, this.getColumnCount() - 1);
        jTableArray[1].setColumnSelectionInterval(0, 0);
        jTableArray[0].setRowSelectionInterval(n, n);
        jTableArray[1].setRowSelectionInterval(n, n);
        this.requestFocusInWindow();
    }

    @Override
    public void clearSelection() {
        JTable[] jTableArray;
        super.clearSelection();
        if (this.mDataView != null && (jTableArray = this.mDataView.getDataTables()) != null && jTableArray.length > 1 && jTableArray[1] != null) {
            jTableArray[1].clearSelection();
        }
    }

    @Override
    public JTable clone() throws CloneNotSupportedException {
        JTable jTable = super.clone();
        TableHeaderPrintRender tableHeaderPrintRender = new TableHeaderPrintRender(this);
        int n = jTable.getColumnCount();
        for (int i = 0; i < n; ++i) {
            jTable.getColumnModel().getColumn(i).setHeaderRenderer(tableHeaderPrintRender);
        }
        return jTable;
    }

    @Override
    public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
        Component component = super.prepareEditor(tableCellEditor, n, n2);
        VarViewTableModel varViewTableModel = this.getVarViewTableModel();
        String string = varViewTableModel.columnIndexToColumnId(n2);
        varViewTableModel.setButtonCellOverrideText(null, null);
        if (string.equals("name") || string.equals("label")) {
            InputMap inputMap = ((JComponent)component).getInputMap(0);
            inputMap.put(KeyStroke.getKeyStroke(10, 0), ENTER_ACTION_KEY);
            if (component instanceof JTextField) {
                ((JTextField)component).selectAll();
                if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                    ((JTextField)component).setCaretPosition(0);
                }
            }
            this.mLabelEditor = component;
            this.mKeyAdapter = new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    final int n = VarViewTable.this.getEditingColumn();
                    if (n < 0) {
                        return;
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (VarViewTable.this.mLabelEditor != null) {
                                TableColumn tableColumn = VarViewTable.this.getTableHeader().getColumnModel().getColumn(n);
                                Dimension dimension = VarViewTable.this.mLabelEditor.getPreferredSize();
                                int n2 = VarViewTable.this.getIntercellSpacing().width;
                                if (dimension.width + n2 >= tableColumn.getWidth()) {
                                    VarViewTable.this.mInLabelEdit = true;
                                    tableColumn.setPreferredWidth(dimension.width + n2);
                                }
                            }
                        }
                    });
                }
            };
            component.removeKeyListener(this.mKeyAdapter);
            component.addKeyListener(this.mKeyAdapter);
            if (ComponentState.isBtdRtlOrLtr() && component instanceof JTextField && this.checkCondForBidiRunDirProp(string, n)) {
                DataCellEdit.setJTxtFldRunDirProp((JTextField)component);
            }
        }
        if (component instanceof JComponent) {
            component.setFont(this.getFont());
        }
        return component;
    }

    private boolean checkCondForBidiRunDirProp(String string, int n) {
        return string.equals("name") || string.equals("label") || string.equals("values") && this.getVarTypeFromRowInd(n).isStringFormat();
    }

    @Override
    public void removeEditor() {
        if (this.mLabelEditor != null) {
            this.mLabelEditor.removeKeyListener(this.mKeyAdapter);
            this.mLabelEditor = null;
            this.mKeyAdapter = null;
            this.mInLabelEdit = false;
        }
        super.removeEditor();
    }

    public void updateDisplayedAttributes() {
        VarViewTableModel varViewTableModel = this.getVarViewTableModel();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        int n = this.getColumnModel().getColumnCount();
        for (int i = n - 1; i >= 0; --i) {
            TableColumn tableColumn = this.getColumnModel().getColumn(i);
            hashMap.put(varViewTableModel.columnIndexToColumnId(i), tableColumn.getWidth());
            this.removeColumn(tableColumn);
        }
        varViewTableModel.updateDisplayedAttributes();
        this.rebuildColumns(hashMap);
    }

    public void checkDisplayAttributes() {
        VarViewTableModel varViewTableModel = this.getVarViewTableModel();
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = varViewTableModel.getDisplayedAttributes();
        for (String string2 : vector2) {
            if (!string2.startsWith("@") || this.varsHaveAttribute(string2.substring(1))) continue;
            vector.add(string2);
        }
        if (vector.size() > 0) {
            String string2;
            for (String string2 : vector) {
                vector2.remove(string2);
            }
            if (vector2.size() == 0) {
                vector2.add("name");
            }
            Iterator<String> iterator = varViewTableModel.getDataSource();
            string2 = iterator.getAttributes();
            string2.put("$VariableView2", vector2);
            DataMgr.getDataMgr().sendDataSrcExtensionsMsg(iterator.getDataSetId(), string2.toString(), ExtensionType.kDatasetAttributes, 1);
            this.updateDisplayedAttributes();
        }
    }

    @Override
    public void columnMarginChanged(ChangeEvent changeEvent) {
        if (this.mInLabelEdit) {
            return;
        }
        super.columnMarginChanged(changeEvent);
    }

    @Override
    public void doLayout() {
        super.doLayout();
        if (!this.mDefaultWidthsSet) {
            this.mDefaultWidthsSet = true;
            this.setColumnWidths();
        }
    }

    public boolean isSearchableColumnSelected(boolean bl) {
        int[] nArray;
        boolean bl2 = false;
        VarViewTableModel varViewTableModel = this.getVarViewTableModel();
        for (int n : nArray = this.getSelectedColumns()) {
            String string = varViewTableModel.columnIndexToColumnId(n);
            if (string.equals("label") || string.equals("values") || string.startsWith("@")) {
                bl2 = true;
                continue;
            }
            if (!bl && (string.equals("name") || string.equals("missing"))) {
                bl2 = true;
                continue;
            }
            return false;
        }
        return bl2;
    }

    public boolean canSpellCheck() {
        boolean bl = false;
        int[] nArray = this.getSelectedColumns();
        int n = this.getSelectedRowCount();
        VarViewTableModel varViewTableModel = this.getVarViewTableModel();
        int n2 = varViewTableModel.getLabelColumn();
        int n3 = varViewTableModel.getValuesColumn();
        if (nArray.length == 1 && n == 1) {
            bl = true;
        } else {
            for (int n4 : nArray) {
                if (n4 != n2 && n4 != n3) {
                    bl = false;
                    break;
                }
                bl = true;
            }
        }
        return bl;
    }

    public boolean findNext(String string, DataSearchOptions dataSearchOptions) {
        int n;
        int n2 = this.getSelectionModel().getLeadSelectionIndex();
        int n3 = dataSearchOptions.getFocusedCol();
        int n4 = n2;
        VarViewTableModel varViewTableModel = this.getVarViewTableModel();
        String string2 = varViewTableModel.columnIndexToColumnId(n3);
        if ((long)n4 >= this.getDataRowCount()) {
            n4 = 0;
            n = 0;
        } else {
            n = dataSearchOptions.getFocusedRow();
        }
        Pattern pattern = this.makeSearchPattern(dataSearchOptions, string);
        if (string2.equals("name") || string2.equals("label")) {
            n4 = this.getNextSearchRow(n4, dataSearchOptions);
            if (!dataSearchOptions.isFirstSearch() && n4 == dataSearchOptions.getFocusedRow()) {
                return false;
            }
        }
        boolean bl = false;
        while (!bl) {
            bl = this.findInCell(dataSearchOptions, pattern, n4, n3);
            dataSearchOptions.setFirstSearch(false);
            if (bl || (n4 = this.getNextSearchRow(n4, dataSearchOptions)) != n) continue;
        }
        if (bl) {
            this.mDataView.doSelectVarViewCell(n3, n4);
            Rectangle rectangle = this.getCellRect(n4, n3, false);
            this.scrollRectToVisible(rectangle);
            this.repaint(rectangle);
            DataFindDlg dataFindDlg = ((DataFrame)this.mDataView.getUndoManager().getSpssFrame()).getSearchDialog();
            if (dataFindDlg.isVisible()) {
                Point point = new Point(rectangle.x, rectangle.y);
                SwingUtilities.convertPointToScreen(point, this);
                rectangle = new Rectangle(point.x, point.y, rectangle.width, rectangle.height);
                dataFindDlg.adjustPosition(rectangle);
            }
        } else {
            varViewTableModel.setButtonCellOverrideText(null, null);
        }
        return bl;
    }

    public boolean replaceNext(String string, String string2, DataSearchOptions dataSearchOptions) {
        boolean bl = false;
        boolean bl2 = dataSearchOptions.isFirstSearch();
        if (bl2) {
            return this.findNext(string, dataSearchOptions);
        }
        Container container = this.getTopLevelAncestor();
        container.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.replaceCellWith(dataSearchOptions, string, string2);
            int n = string2.length() - string.length();
            dataSearchOptions.setItemOffset(dataSearchOptions.getItemOffset() + n);
            bl = this.findNext(string, dataSearchOptions);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        container.setCursor(null);
        return bl;
    }

    public int replaceAll(String string, String string2, DataSearchOptions dataSearchOptions) {
        CompoundEdit compoundEdit = new CompoundEdit();
        this.mDataView.getUndoManager().addEdit(compoundEdit);
        int n = 0;
        boolean bl = this.replaceNext(string, string2, dataSearchOptions);
        while (bl) {
            ++n;
            dataSearchOptions.setFirstSearch(false);
            bl = this.replaceNext(string, string2, dataSearchOptions);
        }
        if (n > 0) {
            compoundEdit.end();
        } else {
            compoundEdit.die();
        }
        Container container = this.getTopLevelAncestor();
        if (container instanceof SpssFrame) {
            ((SpssFrame)container).updateToolbarEnableStatus();
        }
        return n;
    }

    @Override
    public void buttonPressed(long l, int n) {
        TableModel tableModel = this.getModel();
        if (!(tableModel instanceof VarViewTableModel)) {
            return;
        }
        VarViewTableModel varViewTableModel = (VarViewTableModel)tableModel;
        String string = varViewTableModel.columnIndexToColumnId(n);
        boolean bl = string.startsWith("@");
        varViewTableModel.setButtonCellOverrideText(null, null);
        if (bl) {
            this.processAttributeButtonClick(varViewTableModel, l, n);
        } else {
            Object object;
            ISpssVariable iSpssVariable = varViewTableModel.getDataSource().getVariable((int)l);
            if (iSpssVariable == null && !((DataFrame)this.mDataView.getUndoManager().getSpssFrame()).checkDataLimit(false, l - (long)varViewTableModel.getDataSource().columnCount() + 1L)) {
                return;
            }
            if (string.equals("type")) {
                if (iSpssVariable != null && !varViewTableModel.isDataEditorFormatType(iSpssVariable.getFormat().getFormatType())) {
                    String string2 = ResUtil.getString("IDS_NOT_EDITABLE_FORMAT");
                    SpssAlertOptionPane.showWarningMessageDialog(this.mDataView.getUndoManager().getSpssFrame(), string2, VersionInfo.getAppVersionString());
                    this.editCellAt((int)l, n);
                    Component component = this.getEditorComponent();
                    if (component != null) {
                        component.requestFocusInWindow();
                    }
                    return;
                }
                object = new VariableTypeDlg(this.mDataView.getUndoManager().getSpssFrame(), varViewTableModel, (int)l, n);
                object.setVisible(true);
            } else if (string.equals("values")) {
                object = new ValueLabelsDlg(this.mDataView.getUndoManager().getSpssFrame(), varViewTableModel, (int)l, n);
                object.setVisible(true);
            } else if (string.equals("missing")) {
                object = new MissingValuesDlg(this.mDataView.getUndoManager().getSpssFrame(), varViewTableModel, (int)l, n);
                object.setVisible(true);
            } else {
                assert (false);
                return;
            }
            this.editCellAt((int)l, n);
            object = this.getEditorComponent();
            if (object != null) {
                ((Component)object).requestFocusInWindow();
            }
        }
    }

    private void processAttributeButtonClick(VarViewTableModel varViewTableModel, long l, int n) {
        if (l >= 0L) {
            Object object;
            ISpssVariable iSpssVariable = varViewTableModel.getDataSource().getVariable((int)l);
            try {
                iSpssVariable = iSpssVariable.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
            }
            String string = varViewTableModel.getColumnName(n);
            Vector<String> vector = iSpssVariable.getAttributeValues(string);
            if (vector == null) {
                vector = new Vector<String>();
            }
            CustomAttributeArrayDlg customAttributeArrayDlg = new CustomAttributeArrayDlg(this.mDataView.getUndoManager().getSpssFrame(), vector, string);
            customAttributeArrayDlg.setVisible(true);
            if (customAttributeArrayDlg.wasOkPressed()) {
                object = iSpssVariable.getAttributes();
                object.put(string, vector);
                Vector<ISpssVariable> vector2 = new Vector<ISpssVariable>();
                vector2.add(iSpssVariable);
                new ModifyVariableEdit(this.mDataView.getUndoManager(), new int[]{(int)l}, vector2);
            }
            object = this.getColumnModel().getColumn(n);
            ((TableColumn)object).getCellEditor().cancelCellEditing();
        }
    }

    @Override
    protected long getDataRowCount() {
        long l = 0L;
        TableModel tableModel = this.getModel();
        if (tableModel instanceof VarViewTableModel) {
            VarViewTableModel varViewTableModel = (VarViewTableModel)tableModel;
            l = varViewTableModel.getDataSource().columnCount();
        }
        return l;
    }

    @Override
    protected int getDataColumnCount() {
        int n = 0;
        TableModel tableModel = this.getModel();
        if (tableModel instanceof VarViewTableModel) {
            n = ((VarViewTableModel)tableModel).getDisplayedAttributes().size();
        }
        return n;
    }

    protected void addSpinners() {
        VarViewTableModel varViewTableModel = this.getVarViewTableModel();
        int n = varViewTableModel.columnIdToColumnIndex("width");
        TableColumn tableColumn = this.getColumnModel().getColumn(n);
        tableColumn.setIdentifier("width");
        tableColumn.setCellEditor(new SpinnerEditor(1, 0, 100, 1));
        n = varViewTableModel.columnIdToColumnIndex("decimals");
        tableColumn = this.getColumnModel().getColumn(n);
        tableColumn.setIdentifier("decimals");
        tableColumn.setCellEditor(new SpinnerEditor(1, 0, 100, 1));
        n = varViewTableModel.columnIdToColumnIndex("columns");
        tableColumn = this.getColumnModel().getColumn(n);
        tableColumn.setIdentifier("columns");
        tableColumn.setCellEditor(new SpinnerEditor(1, 0, 100, 1));
    }

    protected void setColumnWidths() {
        for (int i = 0; i < this.getColumnModel().getColumnCount(); ++i) {
            TableColumn tableColumn = this.getColumnModel().getColumn(i);
            tableColumn.setPreferredWidth(this.getPreferredColumnWidth(i));
        }
    }

    protected int getPreferredColumnWidth(int n) {
        int[] nArray = new int[]{8, 8, 6, 6, 10, 8, 8, 6, 9, 10, 8};
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n2 = fontMetrics.charWidth('Q');
        int n3 = this.getColumnModel().getColumnMargin();
        int n4 = 0;
        String string = ((VarViewTableModel)this.getModel()).columnIndexToColumnId(n);
        if (string != null) {
            if (string.equals("name")) {
                n4 = 0;
            } else if (string.equals("type")) {
                n4 = 1;
            } else if (string.equals("width")) {
                n4 = 2;
            } else if (string.equals("decimals")) {
                n4 = 3;
            } else if (string.equals("label")) {
                n4 = 4;
            } else if (string.equals("values")) {
                n4 = 5;
            } else if (string.equals("missing")) {
                n4 = 6;
            } else if (string.equals("columns")) {
                n4 = 7;
            } else if (string.equals("alignment")) {
                n4 = 8;
            } else if (string.equals("measure")) {
                n4 = 9;
            } else if (string.equals("role")) {
                n4 = 10;
            }
        }
        return n2 * nArray[n4] + n3 * 2 + 2;
    }

    protected void scrollToTop(int n) {
        if (!(this.getParent() instanceof JViewport)) {
            return;
        }
        JViewport jViewport = (JViewport)this.getParent();
        Rectangle rectangle = this.getCellRect(n, 0, true);
        Rectangle rectangle2 = jViewport.getViewRect();
        rectangle.setLocation(rectangle.x - rectangle2.x, rectangle.y - rectangle2.y);
        int n2 = 0;
        int n3 = rectangle2.height - rectangle.height;
        if (rectangle.y < 0) {
            n3 = 0;
        }
        rectangle.translate(n2, n3);
        jViewport.scrollRectToVisible(rectangle);
    }

    public void initPopup(MouseEvent mouseEvent) {
        DataEditContextMenu dataEditContextMenu = new DataEditContextMenu(TABLE_CONTEXT_MENU_IDS);
        if (mouseEvent.isPopupTrigger()) {
            SpssAction spssAction = DocUtil.getActionFromMenu(dataEditContextMenu, "context_data_copy");
            if (spssAction != null) {
                spssAction.setEnabled(spssAction.getMenuItemEnableStatus(this.mDataView.getUndoManager().getSpssFrame()));
            }
            if ((spssAction = DocUtil.getActionFromMenu(dataEditContextMenu, "context_data_paste")) != null) {
                spssAction.setEnabled(spssAction.getMenuItemEnableStatus(this.mDataView.getUndoManager().getSpssFrame()));
            }
            if ((spssAction = DocUtil.getActionFromMenu(dataEditContextMenu, "context_var_info")) != null) {
                spssAction.setEnabled(spssAction.getMenuItemEnableStatus(this.mDataView.getUndoManager().getSpssFrame()));
            }
            if ((spssAction = DocUtil.getActionFromMenu(dataEditContextMenu, "context_data_descriptives")) != null) {
                spssAction.setEnabled(spssAction.getMenuItemEnableStatus(this.mDataView.getUndoManager().getSpssFrame()));
            }
            dataEditContextMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private void executeHeaderPopup(MouseEvent mouseEvent) {
        JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
        JTable jTable = jTableHeader.getTable();
        int n = jTable.columnAtPoint(new Point(mouseEvent.getPoint().x, mouseEvent.getPoint().y));
        DataEditContextMenu dataEditContextMenu = new DataEditContextMenu(HEADER_CONTEXT_MENU_IDS);
        boolean bl = this.getDataView().getDataSrc().columnCount() > 0;
        dataEditContextMenu.getComponents();
        dataEditContextMenu.getComponent(0).setEnabled(bl);
        dataEditContextMenu.getComponent(1).setEnabled(bl);
        VarViewTableModel varViewTableModel = this.getVarViewTableModel();
        if (n == varViewTableModel.getLabelColumn() || n == varViewTableModel.getValuesColumn()) {
            dataEditContextMenu.addSeparator();
            JMenuItem jMenuItem = dataEditContextMenu.addMenuItem("utilities_spellcheck");
            bl = this.canSpellCheck();
            jMenuItem.setEnabled(bl);
        }
        dataEditContextMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        mouseEvent.consume();
    }

    private boolean varsHaveAttribute(String string) {
        VarViewTableModel varViewTableModel = this.getVarViewTableModel();
        ISpssDataSrc iSpssDataSrc = varViewTableModel.getDataSource();
        int n = iSpssDataSrc.columnCount();
        for (int i = 0; i < n; ++i) {
            if (iSpssDataSrc.getVariable(i).getAttributeIndex(string) <= -1) continue;
            return true;
        }
        return false;
    }

    private Pattern makeSearchPattern(DataSearchOptions dataSearchOptions, String string) {
        String string2 = "";
        String string3 = "";
        DataSearchOptions.SearchType searchType = dataSearchOptions.getSearchType();
        if (searchType == DataSearchOptions.SearchType.startsWith || searchType == DataSearchOptions.SearchType.exact) {
            string2 = "^";
        }
        if (searchType == DataSearchOptions.SearchType.endsWith || searchType == DataSearchOptions.SearchType.exact) {
            string3 = "$";
        }
        string = string.replace("\\", "\\\\");
        string = string.replace(".", "\\x2E");
        string = string.replace("*", "\\x2A");
        string = string.replace("$", "\\x24");
        string = string.replace("^", "\\x5E");
        string = string.replace("(", "\\x28");
        string = string.replace(")", "\\x29");
        string = string.replace("?", "\\x3F");
        String string4 = !dataSearchOptions.getMatchCase() ? "(?i)(?u)" + string2 + string + string3 : string2 + string + string3;
        return Pattern.compile(string4);
    }

    private int getNextSearchRow(int n, DataSearchOptions dataSearchOptions) {
        boolean bl;
        int n2 = n;
        int[] nArray = dataSearchOptions.getSelectedRows();
        boolean bl2 = dataSearchOptions.getSearchDown();
        boolean bl3 = bl = dataSearchOptions.getSearchArea() == SearchOptions.SearchArea.selected;
        if (!dataSearchOptions.isFirstSearch()) {
            if (bl2) {
                ++n2;
                if (bl) {
                    if (n2 > nArray[nArray.length - 1]) {
                        n2 = nArray[0];
                    }
                } else if ((long)n2 >= this.getDataRowCount()) {
                    n2 = 0;
                }
            } else {
                --n2;
                if (bl) {
                    if (n2 < nArray[0]) {
                        n2 = nArray[nArray.length - 1];
                    }
                } else if (n2 < 0) {
                    n2 = (int)this.getDataRowCount() - 1;
                }
            }
        }
        return n2;
    }

    private boolean findInCell(DataSearchOptions dataSearchOptions, Pattern pattern, int n, int n2) {
        boolean bl = false;
        try {
            VarViewTableModel varViewTableModel = this.getVarViewTableModel();
            String string = varViewTableModel.columnIndexToColumnId(n2);
            if (string.equals("name") || string.equals("label")) {
                bl = this.findInCellText(pattern, n, n2);
            } else if (string.equals("values")) {
                bl = this.findInValueLabels(dataSearchOptions, pattern, n);
            } else if (string.equals("missing")) {
                bl = this.findInMissingValues(dataSearchOptions, pattern, n);
            } else if (string.startsWith("@")) {
                bl = this.findInVariableAttributes(dataSearchOptions, pattern, n, n2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    private boolean findInCellText(Pattern pattern, int n, int n2) {
        Object object = this.getModel().getValueAt(n, n2);
        if (!(object instanceof String)) {
            return false;
        }
        Matcher matcher = pattern.matcher(object.toString());
        return matcher.find();
    }

    private boolean findInValueLabels(DataSearchOptions dataSearchOptions, Pattern pattern, int n) {
        int n2;
        VarViewTableModel varViewTableModel = this.getVarViewTableModel();
        ISpssVariable iSpssVariable = varViewTableModel.getDataSource().getVariable(n);
        IValueLabelMap iValueLabelMap = iSpssVariable.getValueLabels();
        Object[] objectArray = iValueLabelMap.getValueLabelEntries().toArray();
        SPSS_Format sPSS_Format = iSpssVariable.getFormat();
        boolean bl = dataSearchOptions.getSearchDown();
        boolean bl2 = false;
        String string = null;
        String string2 = null;
        int n3 = dataSearchOptions.getItemIndex();
        if (n3 == -1) {
            n3 = bl ? 0 : objectArray.length - 1;
        }
        int n4 = dataSearchOptions.getItemOffset();
        if (!bl && n4 == 0) {
            --n3;
        }
        n4 = bl ? ++n4 : --n4;
        int n5 = -1;
        for (int i = 0; i < objectArray.length; ++i) {
            Matcher matcher;
            int n6 = bl ? i : objectArray.length - i - 1;
            Map.Entry entry = (Map.Entry)objectArray[n6];
            if (bl) {
                if (n6 < n3) continue;
                string = CellValueFormatter.obsToString((OBS)((OBS)entry.getKey()), (SPSS_Format)sPSS_Format);
                string2 = (String)entry.getValue();
                if (dataSearchOptions.getSearchingKey()) {
                    matcher = pattern.matcher(string);
                    if (matcher.find(n4)) {
                        n5 = matcher.start();
                        n3 = n6;
                        bl2 = true;
                        break;
                    }
                    n4 = 0;
                }
                dataSearchOptions.setSearchingKey(false);
                matcher = pattern.matcher(string2);
                if (matcher.find(n4)) {
                    n5 = matcher.start();
                    n3 = n6;
                    bl2 = true;
                    break;
                }
                n4 = 0;
                dataSearchOptions.setSearchingKey(true);
                ++n3;
                continue;
            }
            if (n6 > n3) continue;
            string = CellValueFormatter.obsToString((OBS)((OBS)entry.getKey()), (SPSS_Format)sPSS_Format);
            string2 = (String)entry.getValue();
            int n7 = 0;
            if (!dataSearchOptions.getSearchingKey()) {
                if (n4 <= -1) {
                    n4 = string2.length() - 1;
                }
                matcher = pattern.matcher(string2);
                while (matcher.find(n7)) {
                    n2 = matcher.start();
                    n7 = matcher.end();
                    if (n2 >= n4) continue;
                    n5 = n2;
                    n3 = n6;
                    bl2 = true;
                }
                if (bl2) break;
                n4 = -1;
            }
            dataSearchOptions.setSearchingKey(true);
            if (n4 <= -1) {
                n4 = string.length() - 1;
            }
            matcher = pattern.matcher(string);
            n7 = 0;
            while (matcher.find(n7)) {
                n2 = matcher.start();
                n7 = matcher.end();
                if (n2 >= n4) continue;
                n5 = n2;
                n3 = n6;
                bl2 = true;
            }
            if (bl2) break;
            dataSearchOptions.setSearchingKey(false);
            --n3;
            n4 = -1;
        }
        if (bl2) {
            dataSearchOptions.setItemIndex(n3);
            dataSearchOptions.setItemOffset(n5);
            String string3 = "{" + string + ", " + string2 + "}...";
            n2 = varViewTableModel.columnIdToColumnIndex("values");
            varViewTableModel.setButtonCellOverrideText(new Point(n2, n), string3);
        } else {
            dataSearchOptions.setItemIndex(-1);
            dataSearchOptions.setItemOffset(-1);
        }
        return bl2;
    }

    private boolean findInMissingValues(DataSearchOptions dataSearchOptions, Pattern pattern, int n) {
        Matcher matcher;
        String string;
        int n2;
        boolean bl = false;
        VarViewTableModel varViewTableModel = this.getVarViewTableModel();
        ISpssVariable iSpssVariable = varViewTableModel.getDataSource().getVariable(n);
        OBS[] oBSArray = new OBS[]{new OBS(), new OBS(), new OBS()};
        ISpssVariable.Rule rule = iSpssVariable.getMissingValues(oBSArray[0], oBSArray[1], oBSArray[2]);
        SPSS_Format sPSS_Format = iSpssVariable.getFormat();
        int n3 = Math.abs(rule.value());
        int n4 = dataSearchOptions.getItemIndex();
        boolean bl2 = dataSearchOptions.getSearchDown();
        if (bl2) {
            for (n2 = n4 + 1; n2 < n3; ++n2) {
                string = CellValueFormatter.obsToString((OBS)oBSArray[n2], (SPSS_Format)sPSS_Format);
                matcher = pattern.matcher(string);
                if (!matcher.find()) continue;
                dataSearchOptions.setItemIndex(n2);
                dataSearchOptions.setItemOffset(matcher.start());
                bl = true;
                break;
            }
        } else {
            n4 = n4 == -1 ? n3 : Math.min(n4, n3);
            for (n2 = n4 - 1; n2 >= 0; --n2) {
                string = CellValueFormatter.obsToString((OBS)oBSArray[n2], (SPSS_Format)sPSS_Format);
                matcher = pattern.matcher(string);
                if (!matcher.find()) continue;
                dataSearchOptions.setItemIndex(n2);
                dataSearchOptions.setItemOffset(matcher.start());
                bl = true;
                break;
            }
        }
        if (bl) {
            int n5;
            n2 = dataSearchOptions.getItemIndex();
            String string2 = CellValueFormatter.obsToString((OBS)oBSArray[n2], (SPSS_Format)sPSS_Format);
            for (n5 = 0; n5 < n3; ++n5) {
                if (n5 == n2) continue;
                string2 = string2 + ", " + CellValueFormatter.obsToString((OBS)oBSArray[n5], (SPSS_Format)sPSS_Format);
            }
            n5 = varViewTableModel.columnIdToColumnIndex("missing");
            varViewTableModel.setButtonCellOverrideText(new Point(n5, n), string2);
        } else {
            dataSearchOptions.setItemIndex(-1);
            dataSearchOptions.setItemOffset(-1);
        }
        return bl;
    }

    private VarViewTableModel getVarViewTableModel() {
        return (VarViewTableModel)this.getModel();
    }

    private boolean findInVariableAttributes(DataSearchOptions dataSearchOptions, Pattern pattern, int n, int n2) {
        VarViewTableModel varViewTableModel = this.getVarViewTableModel();
        ISpssVariable iSpssVariable = varViewTableModel.getDataSource().getVariable(n);
        if (iSpssVariable == null) {
            return false;
        }
        String string = varViewTableModel.columnIndexToColumnId(n2);
        Vector<String> vector = varViewTableModel.getDisplayedAttributes();
        if (string == null || !string.startsWith("@")) {
            return false;
        }
        int n3 = vector.indexOf(string);
        if (n3 < 0 || n3 >= vector.size()) {
            return false;
        }
        Vector vector2 = iSpssVariable.getAttributeValues(string.substring(1));
        if (vector2 == null || vector2.size() == 0) {
            return false;
        }
        int n4 = dataSearchOptions.getItemIndex();
        boolean bl = dataSearchOptions.getSearchDown();
        int n5 = dataSearchOptions.getItemOffset();
        if (!bl && n5 == 0 && --n4 < 0) {
            return false;
        }
        n5 = bl ? ++n5 : --n5;
        int n6 = -1;
        int n7 = -1;
        boolean bl2 = false;
        String string2 = "";
        if (bl) {
            if (n4 == -1) {
                n4 = 0;
            }
            for (int i = n4; i < vector2.size(); ++i) {
                String string3 = (String)vector2.get(i);
                Matcher matcher = pattern.matcher(string3);
                if (matcher.find(n5)) {
                    string2 = string3;
                    n7 = matcher.start();
                    n6 = i;
                    bl2 = true;
                    break;
                }
                n5 = 0;
            }
        } else {
            if (n4 <= -1) {
                n4 = vector2.size() - 1;
            }
            for (int i = n4; i >= 0; --i) {
                String string4 = (String)vector2.get(i);
                if (n5 <= -1) {
                    n5 = string4.length() - 1;
                }
                Matcher matcher = pattern.matcher(string4);
                int n8 = 0;
                while (matcher.find(n8)) {
                    int n9 = matcher.start();
                    n8 = matcher.end();
                    if (n9 >= n5) continue;
                    string2 = string4;
                    n7 = n9;
                    n6 = i;
                    bl2 = true;
                }
                if (!bl2) {
                    n5 = -1;
                    continue;
                }
                break;
            }
        }
        if (bl2) {
            dataSearchOptions.setItemIndex(n6);
            dataSearchOptions.setItemOffset(n7);
            varViewTableModel.setButtonCellOverrideText(new Point(n2, n), string2);
        } else {
            dataSearchOptions.setItemIndex(-1);
            dataSearchOptions.setItemOffset(-1);
        }
        return bl2;
    }

    private void replaceCellWith(DataSearchOptions dataSearchOptions, String string, String string2) {
        Pattern pattern = this.makeSearchPattern(dataSearchOptions, string);
        int n = this.getSelectionModel().getLeadSelectionIndex();
        int n2 = dataSearchOptions.getFocusedCol();
        VarViewTableModel varViewTableModel = this.getVarViewTableModel();
        String string3 = varViewTableModel.columnIndexToColumnId(n2);
        if (string3.equals("name") || string3.equals("label")) {
            this.replaceInCellText(pattern, n, n2, string2);
        } else if (string3.equals("values")) {
            this.replaceInValueLabels(dataSearchOptions, pattern, n, string.length(), string2);
        } else if (string3.equals("missing")) {
            this.replaceInMissingValues(dataSearchOptions, pattern, n, string.length(), string2);
        } else if (string3.startsWith("@")) {
            this.replaceInVariableAttributes(dataSearchOptions, pattern, n, n2, string.length(), string2);
        }
    }

    private void replaceInCellText(Pattern pattern, int n, int n2, String string) {
        String string2 = this.getModel().getValueAt(n, n2).toString();
        Matcher matcher = pattern.matcher(string2);
        string2 = matcher.replaceAll(string);
        this.getModel().setValueAt(string2, n, n2);
    }

    private void replaceInValueLabels(DataSearchOptions dataSearchOptions, Pattern pattern, int n, int n2, String string) {
        VarViewTableModel varViewTableModel = this.getVarViewTableModel();
        ISpssVariable iSpssVariable = varViewTableModel.getDataSource().getVariable(n);
        IValueLabelMap iValueLabelMap = iSpssVariable.getValueLabels();
        Object[] objectArray = iValueLabelMap.getValueLabelEntries().toArray();
        HashMap<OBS, String> hashMap = this.createDuplicateOBStoLabelMap(iValueLabelMap);
        int n3 = 0;
        int n4 = dataSearchOptions.getItemOffset();
        Map.Entry entry = (Map.Entry)objectArray[dataSearchOptions.getItemIndex()];
        if (dataSearchOptions.getSearchingKey()) {
            String string2 = CellValueFormatter.obsToString((OBS)((OBS)entry.getKey()), (SPSS_Format)iSpssVariable.getFormat());
            Matcher matcher = pattern.matcher(string2);
            if (matcher.find(n4)) {
                int n5 = matcher.start();
                StringBuilder stringBuilder = new StringBuilder(string2);
                stringBuilder.replace(n5, n5 + n2, string);
                string2 = stringBuilder.toString();
                OBS oBS = new OBS();
                if (CellValueFormatter.stringToObs((String)string2, (SPSS_Format)iSpssVariable.getFormat(), (OBS)oBS)) {
                    hashMap.remove(entry.getKey());
                    if (!oBS.isEmpty()) {
                        hashMap.put(oBS, (String)entry.getValue());
                    }
                    dataSearchOptions.setItemsSearched(dataSearchOptions.getItemsSearched() + 1);
                    ++n3;
                }
            }
        } else {
            String string3 = (String)entry.getValue();
            Matcher matcher = pattern.matcher(string3);
            if (matcher.find(n4)) {
                int n6 = matcher.start();
                StringBuilder stringBuilder = new StringBuilder(string3);
                stringBuilder.replace(n6, n6 + n2, string);
                string3 = stringBuilder.toString();
                hashMap.put((OBS)entry.getKey(), string3);
                dataSearchOptions.setItemsSearched(dataSearchOptions.getItemsSearched() + 1);
                ++n3;
            }
        }
        if (n3 > 0) {
            new VarViewValueLabelsEdit(varViewTableModel, hashMap, n, varViewTableModel.columnIdToColumnIndex("values"));
        }
    }

    public HashMap<OBS, String> createDuplicateOBStoLabelMap(IValueLabelMap iValueLabelMap) {
        HashMap<OBS, String> hashMap = new HashMap<OBS, String>();
        for (Map.Entry entry : iValueLabelMap.getValueLabelEntries()) {
            hashMap.put((OBS)entry.getKey(), (String)entry.getValue());
        }
        return hashMap;
    }

    private void replaceInMissingValues(DataSearchOptions dataSearchOptions, Pattern pattern, int n, int n2, String string) {
        VarViewTableModel varViewTableModel = this.getVarViewTableModel();
        ISpssVariable iSpssVariable = varViewTableModel.getDataSource().getVariable(n);
        OBS[] oBSArray = new OBS[]{new OBS(), new OBS(), new OBS()};
        ISpssVariable.Rule rule = iSpssVariable.getMissingValues(oBSArray[0], oBSArray[1], oBSArray[2]);
        SPSS_Format sPSS_Format = iSpssVariable.getFormat();
        int n3 = dataSearchOptions.getItemIndex();
        String string2 = CellValueFormatter.obsToString((OBS)oBSArray[n3], (SPSS_Format)sPSS_Format);
        Matcher matcher = pattern.matcher(string2);
        if (matcher.find(dataSearchOptions.getItemOffset())) {
            int n4 = matcher.start();
            StringBuilder stringBuilder = new StringBuilder(string2);
            stringBuilder.replace(n4, n4 + n2, string);
            string2 = stringBuilder.toString();
            if (CellValueFormatter.stringToObs((String)string2, (SPSS_Format)sPSS_Format, (OBS)oBSArray[n3])) {
                dataSearchOptions.setItemsSearched(dataSearchOptions.getItemsSearched() + 1);
                MissingValueBucket missingValueBucket = new MissingValueBucket(rule, oBSArray[0], oBSArray[1], oBSArray[2]);
                new VarViewMissingValueEdit(varViewTableModel, missingValueBucket, n, varViewTableModel.columnIdToColumnIndex("missing"));
            }
        }
    }

    private void replaceInVariableAttributes(DataSearchOptions dataSearchOptions, Pattern pattern, int n, int n2, int n3, String string) {
        ISpssVariable iSpssVariable;
        VarViewTableModel varViewTableModel = this.getVarViewTableModel();
        try {
            iSpssVariable = varViewTableModel.getDataSource().getVariable(n).clone();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        int n4 = dataSearchOptions.getItemIndex();
        int n5 = dataSearchOptions.getItemOffset();
        String string2 = varViewTableModel.columnIndexToColumnId(n2);
        Vector<String> vector = varViewTableModel.getDisplayedAttributes();
        if (string2 == null || !string2.startsWith("@")) {
            return;
        }
        int n6 = vector.indexOf(string2);
        if (n6 < 0 || n6 >= vector.size()) {
            return;
        }
        Vector vector2 = iSpssVariable.getAttributeValues(string2.substring(1));
        if (vector2 == null || vector2.size() == 0) {
            return;
        }
        String string3 = (String)vector2.get(n4);
        Matcher matcher = pattern.matcher(string3);
        if (matcher.find(n5)) {
            dataSearchOptions.setItemsSearched(dataSearchOptions.getItemsSearched() + 1);
            int n7 = matcher.start();
            StringBuilder stringBuilder = new StringBuilder(string3);
            stringBuilder.replace(n7, n7 + n3, string);
            string3 = stringBuilder.toString();
            vector2.set(n4, string3);
            Vector<ISpssVariable> vector3 = new Vector<ISpssVariable>();
            vector3.add(iSpssVariable);
            new ModifyVariableEdit(varViewTableModel.getUndoManager(), new int[]{n}, vector3);
        }
    }

    private void rebuildColumns(HashMap<String, Integer> hashMap) {
        VarViewTableModel varViewTableModel = this.getVarViewTableModel();
        Vector<String> vector = varViewTableModel.getDisplayedAttributes();
        int n = 0;
        for (String string : vector) {
            Object[] objectArray;
            Integer n2;
            TableColumn tableColumn;
            TableColumn tableColumn2 = new TableColumn();
            String string2 = varViewTableModel.getColumnName(varViewTableModel.columnIdToColumnIndex(string));
            tableColumn2.setModelIndex(n);
            this.addColumn(tableColumn2);
            CellSelectionMouseHandler cellSelectionMouseHandler = new CellSelectionMouseHandler();
            this.addMouseListener(cellSelectionMouseHandler);
            this.addMouseMotionListener(cellSelectionMouseHandler);
            if (!string.startsWith("@")) {
                tableColumn2.setHeaderValue(string2);
                if (string.equals("name")) {
                    tableColumn = this.getColumnModel().getColumn(n);
                    tableColumn.setIdentifier("name");
                    tableColumn.setCellEditor(new GenericEditor());
                    n2 = hashMap.get("name");
                    tableColumn.setPreferredWidth(n2 != null ? n2.intValue() : this.getPreferredColumnWidth(n));
                    tableColumn.setCellRenderer(new VarTableCellRenderer());
                } else if (string.equals("type")) {
                    objectArray = new ButtonEditCtrl(n);
                    objectArray.getTextField().addMouseListener(new PopupMouseHandler());
                    tableColumn = this.getColumnModel().getColumn(n);
                    tableColumn.setIdentifier("type");
                    tableColumn.setCellEditor((TableCellEditor)objectArray);
                    n2 = hashMap.get("type");
                    tableColumn.setPreferredWidth(n2 != null ? n2.intValue() : this.getPreferredColumnWidth(n));
                    objectArray.addButtonListener(this);
                    objectArray.addMouseListener(cellSelectionMouseHandler);
                    tableColumn.setCellRenderer(new VarTableCellRenderer());
                } else if (string.equals("width")) {
                    tableColumn = this.getColumnModel().getColumn(n);
                    tableColumn.setIdentifier("width");
                    tableColumn.setCellEditor(new SpinnerEditor(1, 0, 100, 1));
                    n2 = hashMap.get("width");
                    tableColumn.setPreferredWidth(n2 != null ? n2.intValue() : this.getPreferredColumnWidth(n));
                    tableColumn.setCellRenderer(new VarTableCellRenderer());
                } else if (string.equals("decimals")) {
                    tableColumn = this.getColumnModel().getColumn(n);
                    tableColumn.setIdentifier("decimals");
                    tableColumn.setCellEditor(new SpinnerEditor(1, 0, 100, 1));
                    n2 = hashMap.get("decimals");
                    tableColumn.setPreferredWidth(n2 != null ? n2.intValue() : this.getPreferredColumnWidth(n));
                    tableColumn.setCellRenderer(new VarTableCellRenderer());
                } else if (string.equals("label")) {
                    tableColumn = this.getColumnModel().getColumn(n);
                    tableColumn.setIdentifier("label");
                    tableColumn.setCellEditor(new GenericEditor());
                    n2 = hashMap.get("label");
                    tableColumn.setPreferredWidth(n2 != null ? n2.intValue() : this.getPreferredColumnWidth(n));
                    tableColumn.setCellRenderer(new VarTableCellRenderer());
                } else if (string.equals("values")) {
                    objectArray = new ButtonEditCtrl(n);
                    objectArray.getTextField().addMouseListener(new PopupMouseHandler());
                    tableColumn = this.getColumnModel().getColumn(n);
                    tableColumn.setIdentifier("values");
                    tableColumn.setCellEditor((TableCellEditor)objectArray);
                    n2 = hashMap.get("values");
                    tableColumn.setPreferredWidth(n2 != null ? n2.intValue() : this.getPreferredColumnWidth(n));
                    objectArray.addButtonListener(this);
                    objectArray.addMouseListener(cellSelectionMouseHandler);
                    tableColumn.setCellRenderer(new VarTableCellRenderer());
                } else if (string.equals("missing")) {
                    objectArray = new ButtonEditCtrl(n);
                    objectArray.getTextField().addMouseListener(new PopupMouseHandler());
                    tableColumn = this.getColumnModel().getColumn(n);
                    tableColumn.setIdentifier("missing");
                    tableColumn.setCellEditor((TableCellEditor)objectArray);
                    n2 = hashMap.get("missing");
                    tableColumn.setPreferredWidth(n2 != null ? n2.intValue() : this.getPreferredColumnWidth(n));
                    objectArray.addButtonListener(this);
                    objectArray.addMouseListener(cellSelectionMouseHandler);
                    tableColumn.setCellRenderer(new VarTableCellRenderer());
                } else if (string.equals("columns")) {
                    tableColumn = this.getColumnModel().getColumn(n);
                    tableColumn.setIdentifier("columns");
                    tableColumn.setCellEditor(new SpinnerEditor(1, 0, 100, 1));
                    n2 = hashMap.get("columns");
                    tableColumn.setPreferredWidth(n2 != null ? n2.intValue() : this.getPreferredColumnWidth(n));
                    tableColumn.setCellRenderer(new VarTableCellRenderer());
                } else if (string.equals("alignment")) {
                    tableColumn = this.getColumnModel().getColumn(n);
                    tableColumn.setIdentifier("alignment");
                    objectArray = new Object[]{DisplayAlignment.left, DisplayAlignment.right, DisplayAlignment.center};
                    tableColumn.setCellEditor(new ComboEditor(this.mAlignmentRenderer, objectArray));
                    n2 = hashMap.get("alignment");
                    tableColumn.setPreferredWidth(n2 != null ? n2.intValue() : this.getPreferredColumnWidth(n));
                    tableColumn.setCellRenderer(this.mAlignmentRenderer);
                } else if (string.equals("measure")) {
                    tableColumn = this.getColumnModel().getColumn(n);
                    tableColumn.setIdentifier("measure");
                    n2 = hashMap.get("measure");
                    tableColumn.setPreferredWidth(n2 != null ? n2.intValue() : this.getPreferredColumnWidth(n));
                    tableColumn.setCellRenderer(this.mMeasurementLevelRenderer);
                } else if (string.equals("role")) {
                    tableColumn = this.getColumnModel().getColumn(n);
                    tableColumn.setIdentifier("role");
                    objectArray = new Object[]{Role.input, Role.target, Role.both, Role.none, Role.partition, Role.split};
                    tableColumn.setCellEditor(new ComboEditor(this.mRoleRenderer, objectArray));
                    n2 = hashMap.get("role");
                    tableColumn.setPreferredWidth(n2 != null ? n2.intValue() : this.getPreferredColumnWidth(n));
                    tableColumn.setCellRenderer(this.mRoleRenderer);
                } else {
                    this.removeMouseListener(cellSelectionMouseHandler);
                    this.removeMouseMotionListener(cellSelectionMouseHandler);
                    this.removeColumn(tableColumn2);
                }
            } else {
                tableColumn2.setCellRenderer(new CustomAttributeCellRenderer());
                tableColumn2.setHeaderValue("[" + string2 + "]");
                objectArray = new CustomAttributeCellEditor(n);
                objectArray.setReadOnlyEdit(false);
                tableColumn = this.getColumnModel().getColumn(n);
                tableColumn.setCellEditor((TableCellEditor)objectArray);
                n2 = hashMap.get(string);
                tableColumn.setPreferredWidth(n2 != null ? n2.intValue() : this.getPreferredColumnWidth(n));
                objectArray.addButtonListener(this);
                objectArray.addMouseListener(cellSelectionMouseHandler);
            }
            ++n;
        }
    }

    public void stopCellEditing() {
        if (this.isEditing() && !this.getCellEditor().stopCellEditing()) {
            this.getCellEditor().cancelCellEditing();
        }
    }

    @Override
    public boolean isEntireColumnSelected(int n) {
        return this.isColumnSelected(n) && this.getSelectedRows().length == this.getRowCount();
    }

    @Override
    public boolean isEntireRowSelected(int n) {
        return this.isRowSelected(n) && this.getSelectedColumns().length == this.getColumnCount();
    }

    private FormatType getVarTypeFromRowInd(int n) {
        ISpssVariable iSpssVariable;
        VarViewTableModel varViewTableModel;
        FormatType formatType = null;
        TableModel tableModel = this.getModel();
        if (tableModel != null && tableModel instanceof VarViewTableModel && (varViewTableModel = (VarViewTableModel)tableModel).getDataSource() != null && (iSpssVariable = varViewTableModel.getDataSource().getVariable(n)) != null && iSpssVariable.getFormat() != null && iSpssVariable.getFormat().getFormatType() != null) {
            formatType = iSpssVariable.getFormat().getFormatType();
        }
        return formatType;
    }

    public boolean canSetFormat() {
        int[] nArray = this.getSelectedRows();
        VarViewTableModel varViewTableModel = this.getVarViewTableModel();
        ISpssDataSrc iSpssDataSrc = varViewTableModel.getDataSource();
        return nArray != null && nArray.length > 0 && this.isEntireRowSelected(nArray[0]) && (long)nArray[0] < iSpssDataSrc.rowCount();
    }

    @Override
    public TableCellEditor getCellEditor(int n, int n2) {
        VarViewTableModel varViewTableModel = this.getVarViewTableModel();
        ISpssDataSrc iSpssDataSrc = varViewTableModel.getDataSource();
        String string = varViewTableModel.columnIndexToColumnId(n2);
        TableCellEditor tableCellEditor = null;
        if (string.equals("measure")) {
            ISpssVariable iSpssVariable = iSpssDataSrc != null ? iSpssDataSrc.getVariable(n) : null;
            boolean bl = iSpssVariable != null && (iSpssVariable.getType() == 0 || iSpssVariable.getMeasurementLevel() == MeasurementLevel.scale);
            Object[] objectArray = new Object[]{MeasurementLevel.ordinal, MeasurementLevel.nominal};
            if (bl) {
                objectArray = new Object[]{MeasurementLevel.scale, MeasurementLevel.ordinal, MeasurementLevel.nominal};
            }
            tableCellEditor = new ComboEditor(this.mMeasurementLevelRenderer, objectArray);
        }
        return tableCellEditor != null ? tableCellEditor : super.getCellEditor(n, n2);
    }

    class CustomAttributeCellEditor
    extends ButtonEditCtrl {
        public CustomAttributeCellEditor(int n) {
            super(n);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            Component component = super.getTableCellEditorComponent(jTable, object, bl, n, n2);
            VarViewTableModel varViewTableModel = VarViewTable.this.getVarViewTableModel();
            String string = varViewTableModel.columnIndexToColumnId(n2);
            boolean bl2 = string != null && string.startsWith("@") && string.length() > 1 && string.charAt(1) == '$';
            VarViewTableModel.AttributeDisplayInfo attributeDisplayInfo = (VarViewTableModel.AttributeDisplayInfo)object;
            boolean bl3 = attributeDisplayInfo.isArray();
            this.setReadOnlyEdit(bl3 || bl2);
            if (bl2) {
                this.mTextField.setForeground(SystemColor.textInactiveText);
            } else if (bl) {
                this.mTextField.setForeground(jTable.getSelectionForeground());
            } else {
                this.mTextField.setForeground(jTable.getForeground());
            }
            if (attributeDisplayInfo.isEmpty()) {
                this.mTextField.setText("");
            } else {
                this.mTextField.setText(attributeDisplayInfo.getDisplayText());
            }
            return component;
        }
    }

    class CustomAttributeCellRenderer
    extends DefaultTableCellRenderer {
        CustomAttributeCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            boolean bl3;
            VarViewTableModel varViewTableModel;
            String string;
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            VarViewTableModel.AttributeDisplayInfo attributeDisplayInfo = (VarViewTableModel.AttributeDisplayInfo)object;
            if (attributeDisplayInfo.isEmpty() || attributeDisplayInfo.isArray()) {
                this.setFont(this.getFont().deriveFont(2));
            }
            if ((string = (varViewTableModel = VarViewTable.this.getVarViewTableModel()).columnIndexToColumnId(n2)).startsWith("@")) {
                string = string.substring(1);
            }
            boolean bl4 = bl3 = attributeDisplayInfo.isEmpty() || string.startsWith("$");
            if (bl3) {
                this.setForeground(SystemColor.textInactiveText);
            } else if (bl) {
                this.setForeground(jTable.getSelectionForeground());
            } else {
                this.setForeground(jTable.getForeground());
            }
            if (attributeDisplayInfo != null) {
                if (varViewTableModel.columnIndexToColumnId(n2).startsWith("@") && attributeDisplayInfo.getDisplayText() != null && attributeDisplayInfo.getDisplayText().length() > 0 && ComponentState.containsBidiLetter((String)attributeDisplayInfo.getDisplayText())) {
                    if (ComponentState.isBtdRtlOrLtr()) {
                        this.setText(ComponentState.prepareStringForBidiRendering((String)attributeDisplayInfo.getDisplayText()));
                    } else if (ComponentState.isBidiLetter((char)attributeDisplayInfo.getDisplayText().charAt(0))) {
                        this.setText(ComponentState.prepareStringForBidiRendering((String)attributeDisplayInfo.getDisplayText()));
                    } else {
                        this.setText(attributeDisplayInfo.getDisplayText());
                    }
                } else {
                    this.setText(attributeDisplayInfo.getDisplayText());
                }
            }
            return this;
        }
    }

    class VarTableCellRenderer
    extends DefaultTableCellRenderer {
        VarTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (ComponentState.isBtdRtlOrLtr() && this.checkCondForValueBidiRendPrep(object, n2)) {
                super.getTableCellRendererComponent(jTable, ComponentState.prepareStringForBidiRendering((String)((String)object)), bl, bl2, n, n2);
            } else {
                super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            }
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
                this.setForeground(jTable.getSelectionForeground());
            } else {
                this.setBackground(jTable.getBackground());
                this.setForeground(jTable.getForeground());
            }
            return this;
        }

        private boolean isVarViewNameCol(int n) {
            return ((VarViewTableModel)VarViewTable.this.getModel()).columnIndexToColumnId(n).equals("name");
        }

        private boolean isVarViewLabelCol(int n) {
            return ((VarViewTableModel)VarViewTable.this.getModel()).columnIndexToColumnId(n).equals("label");
        }

        private boolean checkCondForValueBidiRendPrep(Object object, int n) {
            boolean bl = false;
            if (VarViewTable.this.getModel() instanceof VarViewTableModel && object != null && object instanceof String && ((String)object).length() > 0 && (this.isVarViewNameCol(n) || this.isVarViewLabelCol(n) && !object.toString().equals("None"))) {
                bl = true;
            }
            return bl;
        }
    }

    class VarViewHeaderCellRenderer
    extends DragTableColumnRenderer {
        VarViewHeaderCellRenderer() {
            super(VarViewTable.this);
            this.updateBorders();
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JTableHeader jTableHeader;
            this.setFont(VarViewTable.this.getFont());
            if (jTable != null && (jTableHeader = jTable.getTableHeader()) != null) {
                if (VarViewTable.this.isEntireColumnSelected(n2)) {
                    this.setForeground(jTable.getSelectionForeground());
                    this.setBackground(jTable.getSelectionBackground());
                } else {
                    this.setForeground(jTableHeader.getForeground());
                    this.setBackground(jTableHeader.getBackground());
                }
                this.setFont(jTableHeader.getFont());
            }
            if (object == null || !ComponentState.containsBidiLetter((String)object.toString())) {
                this.setText(object == null ? "" : object.toString());
            } else if (ComponentState.isBtdRtlOrLtr()) {
                this.setText(ComponentState.prepareStringForBidiRendering((String)object.toString()));
            } else if (ComponentState.isBidiLetter((char)object.toString().charAt(0))) {
                this.setText(ComponentState.prepareStringForBidiRendering((String)object.toString()));
            } else {
                this.setText(object.toString());
            }
            boolean bl3 = VarViewTable.this.getColumnModel().getSelectionModel().getLeadSelectionIndex() == n2;
            Border border = sDefaultBorder;
            if (bl3) {
                border = sLeadCellBorder;
            }
            this.setBorder(border);
            return this;
        }

        @Override
        public void highlightColumn(JTableHeader jTableHeader, int n, boolean bl) {
            int n2 = n > -1 ? n : sHighlightColumn;
            sHighlightColumn = bl ? n : -1;
            Rectangle rectangle = jTableHeader.getHeaderRect(n2);
            jTableHeader.paintImmediately(rectangle);
        }

        void setCurrentCol(JTableHeader jTableHeader, int n) {
            Rectangle rectangle;
            if (sCurrentHeaderCol == n) {
                return;
            }
            if (sCurrentHeaderCol > -1) {
                rectangle = jTableHeader.getHeaderRect(sCurrentHeaderCol);
                jTableHeader.repaint(100L, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            if (n > -1) {
                rectangle = jTableHeader.getHeaderRect(n);
                jTableHeader.repaint(100L, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            sCurrentHeaderCol = n;
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.updateBorders();
        }

        private void updateBorders() {
            if (sDefaultBorder == null) {
                sDefaultBorder = UIManager.getBorder("TableHeader.cellBorder");
            }
            if (sHighlightBorder == null) {
                sHighlightBorder = new DragTableColumnRenderer.HighlightBevelBorder();
            }
            if (sLeadCellBorder == null) {
                sLeadCellBorder = BorderFactory.createEtchedBorder(1);
            }
        }
    }

    class VarViewCellRenderer
    extends DefaultTableCellRenderer {
        VarViewCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (!VarViewTable.this.getModel().isCellEditable(n, n2)) {
                super.setForeground(SystemColor.textInactiveText);
            } else if (bl) {
                super.setForeground(jTable.getSelectionForeground());
            } else {
                super.setForeground(jTable.getForeground());
            }
            this.setIcon(null);
            return component;
        }
    }

    class VarViewListSelectionListener
    implements ListSelectionListener {
        VarViewListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            JTable[] jTableArray;
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            int n = VarViewTable.this.getSelectedRow();
            int n2 = VarViewTable.this.getSelectedColumn();
            TableCellRenderer tableCellRenderer = VarViewTable.this.getTableHeader().getDefaultRenderer();
            if (tableCellRenderer instanceof VarViewHeaderCellRenderer) {
                ((VarViewHeaderCellRenderer)tableCellRenderer).setCurrentCol(VarViewTable.this.getTableHeader(), n2);
            }
            if ((jTableArray = VarViewTable.this.mDataView.getDataTables())[1] instanceof SpssRowHeaderTable) {
                ((SpssRowHeaderTable)jTableArray[1]).refreshCurrentRow(n);
            }
            VarViewTable.this.mDataView.updateToolbarEnableStatus();
            VarViewTable.this.mDataView.updateSearchDialogControls();
        }
    }

    class ComboEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private JComboBox mCombo = new JComboBox();

        ComboEditor(IconTextRenderer iconTextRenderer, Object[] objectArray) {
            for (Object object : objectArray) {
                this.mCombo.addItem(object);
            }
            this.mCombo.setEditable(false);
            this.mCombo.setRenderer(iconTextRenderer);
            AbstractAction abstractAction = new AbstractAction(VarViewTable.UP_ACTION_KEY){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (VarViewTable.this.getCellEditor() != null) {
                        if (!ComboEditor.this.mCombo.isPopupVisible()) {
                            ComboEditor.this.stopCellEditing();
                            Action action = VarViewTable.this.getActionMap().get(VarViewTable.UP_ACTION_KEY);
                            if (action != null) {
                                action.actionPerformed(new ActionEvent(VarViewTable.this, 0, VarViewTable.UP_ACTION_KEY));
                            }
                            VarViewTable.this.requestFocusInWindow();
                        } else {
                            int n = ComboEditor.this.mCombo.getSelectedIndex();
                            if (n > 0) {
                                ComboEditor.this.mCombo.setSelectedIndex(n - 1);
                            }
                        }
                    }
                }
            };
            this.mCombo.getInputMap(0).put(KeyStroke.getKeyStroke(38, 0), VarViewTable.UP_ACTION_KEY);
            this.mCombo.getActionMap().put(VarViewTable.UP_ACTION_KEY, abstractAction);
            AbstractAction abstractAction2 = new AbstractAction(VarViewTable.DOWN_ACTION_KEY){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (VarViewTable.this.getCellEditor() != null) {
                        if (!ComboEditor.this.mCombo.isPopupVisible()) {
                            ComboEditor.this.stopCellEditing();
                            Action action = VarViewTable.this.getActionMap().get(VarViewTable.DOWN_ACTION_KEY);
                            if (action != null) {
                                action.actionPerformed(new ActionEvent(VarViewTable.this, 0, VarViewTable.DOWN_ACTION_KEY));
                            }
                            VarViewTable.this.requestFocusInWindow();
                        } else {
                            int n = ComboEditor.this.mCombo.getModel().getSize();
                            int n2 = ComboEditor.this.mCombo.getSelectedIndex();
                            if (n2 < n - 1) {
                                ComboEditor.this.mCombo.setSelectedIndex(n2 + 1);
                            }
                        }
                    }
                }
            };
            this.mCombo.getInputMap(0).put(KeyStroke.getKeyStroke(40, 0), VarViewTable.DOWN_ACTION_KEY);
            this.mCombo.getActionMap().put(VarViewTable.DOWN_ACTION_KEY, abstractAction2);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (bl) {
                this.mCombo.setForeground(jTable.getSelectionForeground());
                this.mCombo.setBackground(jTable.getSelectionBackground());
            } else {
                this.mCombo.setForeground(jTable.getForeground());
                this.mCombo.setBackground(jTable.getBackground());
            }
            if ("".equals(object)) {
                object = null;
            }
            this.mCombo.setSelectedItem(object);
            return this.mCombo;
        }

        @Override
        public Object getCellEditorValue() {
            return this.mCombo.getSelectedItem();
        }
    }

    class SpinnerEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private final JSpinner mSpinner = new JSpinner(){

            @Override
            public void setFont(Font font) {
                super.setFont(font);
                ((JSpinner.DefaultEditor)this.getEditor()).getTextField().setFont(font);
            }

            @Override
            protected JComponent createEditor(SpinnerModel spinnerModel) {
                NumberFormat numberFormat = DecimalFormat.getInstance(ComponentState.getSPSSLocale());
                if (numberFormat instanceof DecimalFormat) {
                    return new JSpinner.NumberEditor((JSpinner)this, ((DecimalFormat)numberFormat).toPattern());
                }
                return new JSpinner.NumberEditor(this);
            }
        };

        public SpinnerEditor(int n, int n2, int n3, int n4) {
            this.mSpinner.setModel(new SpinnerNumberModel(n, n2, n3, n4));
            JFormattedTextField jFormattedTextField = ((JSpinner.DefaultEditor)this.mSpinner.getEditor()).getTextField();
            jFormattedTextField.addMouseListener(new PopupMouseHandler());
            JComponent jComponent = this.mSpinner.getEditor();
            if (jComponent instanceof JSpinner.DefaultEditor) {
                JSpinner.DefaultEditor defaultEditor = (JSpinner.DefaultEditor)jComponent;
                defaultEditor.getTextField().setHorizontalAlignment(10);
                if (defaultEditor instanceof JSpinner.NumberEditor) {
                    ((NumberFormatter)defaultEditor.getTextField().getFormatter()).setFormat(DecimalFormat.getInstance(ComponentState.getSPSSLocale()));
                }
                Insets insets = defaultEditor.getTextField().getMargin();
                insets.left = 0;
                defaultEditor.getTextField().setMargin(insets);
                AbstractAction abstractAction = new AbstractAction(VarViewTable.ENTER_ACTION_KEY){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (VarViewTable.this.getCellEditor() != null) {
                            SpinnerEditor.this.stopCellEditing();
                            Action action = VarViewTable.this.getActionMap().get(VarViewTable.ENTER_ACTION_KEY);
                            if (action != null) {
                                action.actionPerformed(new ActionEvent(VarViewTable.this, 0, VarViewTable.ENTER_ACTION_KEY));
                            }
                            VarViewTable.this.requestFocusInWindow();
                        }
                    }
                };
                defaultEditor.getTextField().getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), VarViewTable.ENTER_ACTION_KEY);
                defaultEditor.getTextField().getActionMap().put(VarViewTable.ENTER_ACTION_KEY, abstractAction);
                AbstractAction abstractAction2 = new AbstractAction(VarViewTable.UP_ACTION_KEY){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (VarViewTable.this.getSelectedRow() > 0 && VarViewTable.this.getCellEditor() != null) {
                            SpinnerEditor.this.stopCellEditing();
                            Action action = VarViewTable.this.getActionMap().get(VarViewTable.UP_ACTION_KEY);
                            if (action != null) {
                                action.actionPerformed(new ActionEvent(VarViewTable.this, 0, VarViewTable.UP_ACTION_KEY));
                            }
                            VarViewTable.this.requestFocusInWindow();
                        }
                    }
                };
                defaultEditor.getTextField().getInputMap(0).put(KeyStroke.getKeyStroke(38, 0), VarViewTable.UP_ACTION_KEY);
                defaultEditor.getTextField().getActionMap().put(VarViewTable.UP_ACTION_KEY, abstractAction2);
                this.mSpinner.getInputMap(0).put(KeyStroke.getKeyStroke(38, 0), VarViewTable.UP_ACTION_KEY);
                this.mSpinner.getActionMap().put(VarViewTable.UP_ACTION_KEY, abstractAction2);
                AbstractAction abstractAction3 = new AbstractAction(VarViewTable.DOWN_ACTION_KEY){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (VarViewTable.this.getCellEditor() != null) {
                            SpinnerEditor.this.stopCellEditing();
                            Action action = VarViewTable.this.getActionMap().get(VarViewTable.DOWN_ACTION_KEY);
                            if (action != null) {
                                action.actionPerformed(new ActionEvent(VarViewTable.this, 0, VarViewTable.DOWN_ACTION_KEY));
                            }
                            VarViewTable.this.requestFocusInWindow();
                        }
                    }
                };
                defaultEditor.getTextField().getInputMap(0).put(KeyStroke.getKeyStroke(40, 0), VarViewTable.DOWN_ACTION_KEY);
                defaultEditor.getTextField().getActionMap().put(VarViewTable.DOWN_ACTION_KEY, abstractAction3);
                this.mSpinner.getInputMap(0).put(KeyStroke.getKeyStroke(40, 0), VarViewTable.DOWN_ACTION_KEY);
                this.mSpinner.getActionMap().put(VarViewTable.DOWN_ACTION_KEY, abstractAction3);
            }
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            try {
                if (object instanceof String && object.toString().length() > 0) {
                    this.mSpinner.setValue(Integer.valueOf(object.toString()));
                } else {
                    this.mSpinner.setValue(0);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.mSpinner.setValue(0);
            }
            this.mSpinner.setFont(VarViewTable.this.getFont());
            SpinnerNumberModel spinnerNumberModel = (SpinnerNumberModel)this.mSpinner.getModel();
            VarViewTableModel varViewTableModel = (VarViewTableModel)jTable.getModel();
            spinnerNumberModel.setMinimum(Integer.valueOf(varViewTableModel.getMinValue(n2)));
            spinnerNumberModel.setMaximum(Integer.valueOf(varViewTableModel.getMaxValue(n, n2)));
            spinnerNumberModel.setStepSize(1);
            return this.mSpinner;
        }

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            return !(eventObject instanceof MouseEvent) || ((MouseEvent)eventObject).getClickCount() >= 1;
        }

        @Override
        public Object getCellEditorValue() {
            String string = ((JSpinner.DefaultEditor)this.mSpinner.getEditor()).getTextField().getText();
            int n = -1;
            if (string != null && string.length() > 0) {
                try {
                    Number number = DecimalFormat.getInstance(ComponentState.getSPSSLocale()).parse(string);
                    n = number != null ? number.intValue() : -1;
                    this.mSpinner.setValue(n);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            return n;
        }

        @Override
        public boolean stopCellEditing() {
            boolean bl = super.stopCellEditing();
            if (bl) {
                VarViewTable.this.requestFocusInWindow();
            }
            return bl;
        }
    }

    class GenericEditor
    extends DefaultCellEditor {
        Object mValue;
        StringTextField mEditor;

        public GenericEditor() {
            super((JTextField)((Object)new StringTextField()));
            this.mEditor = null;
            this.mEditor = (StringTextField)((Object)this.getComponent());
            this.mEditor.setName("VarLabel.editor");
            this.mEditor.setValidateOnFocusLost(false);
        }

        @Override
        public boolean stopCellEditing() {
            String string = (String)super.getCellEditorValue();
            if ("".equals(string)) {
                this.mValue = string;
                super.stopCellEditing();
            }
            try {
                if (!this.mEditor.validateContents()) {
                    VarViewTable.this.clearSelection();
                    VarViewTable.this.mDataView.doSelectVarViewCell(VarViewTable.this.getEditingColumn(), VarViewTable.this.getEditingRow());
                    return false;
                }
                this.mValue = string;
            }
            catch (Exception exception) {
                this.mEditor.setBorder(new LineBorder(Color.red));
                return false;
            }
            return super.stopCellEditing();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.mValue = null;
            this.mEditor.setBorder(new LineBorder(Color.black));
            this.mEditor.setEncoding(ComponentState.getCurrentCharset());
            return super.getTableCellEditorComponent(jTable, object, bl, n, n2);
        }

        @Override
        public Object getCellEditorValue() {
            return this.mValue;
        }
    }

    class VarTableKeyHandler
    extends KeyAdapter {
        VarTableKeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            int n;
            int n2;
            if (this.isUpDownNavKey(keyEvent)) {
                this.doUpDownMove(keyEvent);
                if (keyEvent.isConsumed()) {
                    return;
                }
            }
            if (keyEvent.isShiftDown() && keyEvent.getKeyCode() == 32 && VarViewTable.this.getDataColumnCount() != -1 && VarViewTable.this.getDataRowCount() != -1L) {
                VarViewTable.this.stopCellEditing();
                n2 = VarViewTable.this.getSelectedRow();
                VarViewTable.this.clearSelection();
                VarViewTable.this.mDataView.doSelectVarViewRows(n2, n2);
                VarViewTable.this.scrollRectToVisible(VarViewTable.this.getCellRect(n2, 0, false));
                keyEvent.consume();
            }
            if ((keyEvent.isControlDown() || keyEvent.isMetaDown()) && keyEvent.getKeyCode() == 32 && VarViewTable.this.getDataColumnCount() != -1 && VarViewTable.this.getDataRowCount() != -1L) {
                VarViewTable.this.stopCellEditing();
                n2 = 0;
                n = (int)VarViewTable.this.getDataRowCount() - 1;
                int n3 = VarViewTable.this.getSelectedColumn();
                VarViewTable.this.clearSelection();
                VarViewTable.this.getSelectionModel().setSelectionInterval(n2, n);
                VarViewTable.this.getColumnModel().getSelectionModel().setSelectionInterval(n3, n3);
                VarViewTable.this.scrollRectToVisible(VarViewTable.this.getCellRect(n2, n3, false));
                keyEvent.consume();
            }
            if ((keyEvent.isControlDown() || keyEvent.isMetaDown()) && keyEvent.getKeyCode() == 35 && VarViewTable.this.getDataRowCount() != -1L) {
                VarViewTable.this.clearSelection();
                VarViewTable.this.stopCellEditing();
                n2 = (int)VarViewTable.this.getDataRowCount() - 1;
                n = VarViewTable.this.getDataColumnCount() - 1;
                VarViewTable.this.mDataView.doSelectVarViewCell(n, n2);
                VarViewTable.this.scrollRectToVisible(VarViewTable.this.getCellRect(n2, n, false));
                keyEvent.consume();
            }
            if ((keyEvent.isControlDown() || keyEvent.isMetaDown()) && keyEvent.getKeyCode() == 36) {
                VarViewTable.this.clearSelection();
                VarViewTable.this.stopCellEditing();
                VarViewTable.this.mDataView.doSelectVarViewCell(0, 0);
                VarViewTable.this.scrollRectToVisible(VarViewTable.this.getCellRect(0, 0, false));
                keyEvent.consume();
            }
            if (keyEvent.isControlDown()) {
                VarViewTable.this.doKeyControlArrowMove(keyEvent);
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            switch (keyEvent.getKeyCode()) {
                case 9: 
                case 10: 
                case 37: 
                case 38: 
                case 39: 
                case 40: {
                    Component component;
                    String string = VarViewTable.this.getVarViewTableModel().columnIndexToColumnId(VarViewTable.this.getSelectedColumn());
                    if (string == null || string.equals("name") || string.equals("label")) break;
                    if (VarViewTable.this.getSelectedColumnCount() == 1 && VarViewTable.this.getSelectedRowCount() == 1) {
                        VarViewTable.this.editCellAt(VarViewTable.this.getSelectedRow(), VarViewTable.this.getSelectedColumn());
                    }
                    if ((component = VarViewTable.this.getEditorComponent()) == null) break;
                    component.requestFocusInWindow();
                }
            }
        }

        private boolean isUpDownNavKey(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            return !keyEvent.isAltDown() && !keyEvent.isShiftDown() && !keyEvent.isControlDown() && !keyEvent.isMetaDown() && (n == 38 || n == 40) || n == 10;
        }

        private void doUpDownMove(KeyEvent keyEvent) {
            Rectangle rectangle;
            int n = keyEvent.getKeyCode();
            int n2 = VarViewTable.this.getSelectedRow();
            boolean bl = n == 40 || n == 10;
            if ((n2 += bl ? 1 : -1) >= 0 && (rectangle = VarViewTable.this.getCellRect(n2, 0, false)).isEmpty()) {
                if (n2 == 0 && !bl) {
                    keyEvent.consume();
                } else {
                    final KeyEvent keyEvent2 = keyEvent;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            KeyEvent keyEvent = new KeyEvent(VarViewTable.this, 401, keyEvent2.getWhen(), keyEvent2.getModifiers(), keyEvent2.getKeyCode(), keyEvent2.getKeyChar());
                            VarViewTable.this.dispatchEvent(keyEvent);
                        }
                    });
                }
            }
        }
    }

    class CellSelectionMouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        int mPressedColumn = 0;
        int mPressedRow = 0;
        int mPrevPressedColumn = 0;
        int mPrevPressedRow = 0;

        CellSelectionMouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            VarViewTable.this.initPopup(mouseEvent);
            VarViewTable.this.mDataView.clearRowHeaderSelection(VarViewTable.this);
            this.mPressedColumn = VarViewTable.this.columnAtPoint(new Point(mouseEvent.getPoint().x, mouseEvent.getPoint().y));
            this.mPressedRow = VarViewTable.this.rowAtPoint(new Point(mouseEvent.getPoint().x, mouseEvent.getPoint().y));
            sPrevSelMode = DataView.SelectMode.CELL_SELECT;
            if (!VarViewTable.this.isCellSelected(this.mPressedRow, this.mPressedColumn)) {
                VarViewTable.this.mDataView.commitEdit();
            }
            if (mouseEvent.isShiftDown()) {
                VarViewTable.this.setColumnSelectionInterval(this.mPressedColumn, this.mPressedColumn);
                VarViewTable.this.setRowSelectionInterval(this.mPressedRow, this.mPressedRow);
                this.mPrevPressedColumn = this.mPressedColumn;
                this.mPrevPressedRow = this.mPressedRow;
            } else if (mouseEvent.isControlDown()) {
                VarViewTable.this.setColumnSelectionInterval(this.mPrevPressedColumn, this.mPrevPressedColumn);
                VarViewTable.this.setRowSelectionInterval(this.mPrevPressedRow, this.mPrevPressedRow);
            } else if (mouseEvent.getButton() != 3 || !VarViewTable.this.isCellSelected(this.mPressedRow, this.mPressedColumn)) {
                VarViewTable.this.setColumnSelectionInterval(this.mPressedColumn, this.mPressedColumn);
                VarViewTable.this.setRowSelectionInterval(this.mPressedRow, this.mPressedRow);
                this.mPrevPressedColumn = this.mPressedColumn;
                this.mPrevPressedRow = this.mPressedRow;
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            VarViewTable.this.initPopup(mouseEvent);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            int n;
            if (VarViewTable.this.getSelectedColumnCount() == 1 && VarViewTable.this.getSelectedRowCount() == 1) {
                VarViewTable.this.stopCellEditing();
            }
            if ((n = VarViewTable.this.rowAtPoint(new Point(mouseEvent.getPoint().x, mouseEvent.getPoint().y))) < 0 || n >= VarViewTable.this.getRowCount()) {
                return;
            }
            VarViewTable.this.setColumnSelectionInterval(this.mPressedColumn, this.mPressedColumn);
            VarViewTable.this.setRowSelectionInterval(this.mPressedRow, n);
            Point point = (Point)mouseEvent.getPoint().clone();
            Object object = mouseEvent.getSource();
            if (object instanceof JTableHeader) {
                SwingUtilities.convertPoint((JTableHeader)object, point, VarViewTable.this);
            } else if (object != VarViewTable.this) {
                return;
            }
            VarViewTable.this.autoscroll(point);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }

    class PopupMouseHandler
    implements MouseListener {
        PopupMouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 3) {
                VarViewTable.this.initPopup(mouseEvent);
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }
    }

    class TableHeaderMouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        int mPressedCachedColIdx = 0;
        int[] mPrevColsSelected = null;
        boolean mIsColumnMoving = false;
        int mDragColumn = -1;
        int mDragStartWidth = -1;

        TableHeaderMouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            VarViewTable.this.mDataView.commitEdit();
            JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
            JTable jTable = jTableHeader.getTable();
            int n = jTable.columnAtPoint(new Point(mouseEvent.getPoint().x, mouseEvent.getPoint().y));
            if (n < 0 || n >= VarViewTable.this.getColumnCount()) {
                return;
            }
            VarViewTable.this.requestFocusInWindow();
            boolean bl = mouseEvent.getButton() == 1;
            TableColumn tableColumn = jTableHeader.getResizingColumn();
            if (tableColumn == null || !bl) {
                if (!VarViewTable.this.mDataView.isDividerOn()) {
                    VarViewTable.this.scrollRectToVisible(VarViewTable.this.getCellRect(0, n, false));
                }
                if (bl && mouseEvent.getClickCount() > 1) {
                    return;
                }
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                for (int n2 : VarViewTable.this.getSelectedColumns()) {
                    arrayList.add(n2);
                }
                boolean bl2 = VarViewTable.this.isEntireColumnSelected(n);
                if (!(!bl2 || sPrevSelMode != DataView.SelectMode.COL_SELECT || mouseEvent.getButton() != 1 && mouseEvent.getButton() != 2 || mouseEvent.isControlDown() || mouseEvent.isShiftDown())) {
                    TransferHandler transferHandler = jTableHeader.getTransferHandler();
                    transferHandler.exportAsDrag(jTableHeader, mouseEvent, 2);
                    this.mIsColumnMoving = true;
                    return;
                }
                if (sPrevSelMode == DataView.SelectMode.COL_SELECT) {
                    if (mouseEvent.isControlDown()) {
                        if (bl2) {
                            arrayList.remove((Object)n);
                            VarViewTable.this.removeColumnSelectionInterval(n, n);
                            VarViewTable.this.removeRowSelectionInterval(VarViewTable.this.getRowCount() - 1, 0);
                            if (arrayList.size() > 0) {
                                int n3 = (Integer)arrayList.get(0);
                                VarViewTable.this.addRowSelectionInterval(VarViewTable.this.getRowCount() - 1, 0);
                                VarViewTable.this.addColumnSelectionInterval(n3, n3);
                            }
                        } else {
                            VarViewTable.this.addRowSelectionInterval(VarViewTable.this.getRowCount() - 1, 0);
                            VarViewTable.this.addColumnSelectionInterval(n, n);
                        }
                    } else if (mouseEvent.isShiftDown()) {
                        VarViewTable.this.clearSelection();
                        VarViewTable.this.addRowSelectionInterval(VarViewTable.this.getRowCount() - 1, 0);
                        VarViewTable.this.addColumnSelectionInterval(this.mPressedCachedColIdx, n);
                    } else if (bl || !bl2) {
                        VarViewTable.this.clearSelection();
                        VarViewTable.this.mDataView.clearRowHeaderSelection(VarViewTable.this);
                        VarViewTable.this.setRowSelectionInterval(VarViewTable.this.getRowCount() - 1, 0);
                        VarViewTable.this.setColumnSelectionInterval(n, n);
                    }
                } else {
                    VarViewTable.this.clearSelection();
                    VarViewTable.this.mDataView.clearRowHeaderSelection(VarViewTable.this);
                    VarViewTable.this.setRowSelectionInterval(VarViewTable.this.getRowCount() - 1, 0);
                    VarViewTable.this.setColumnSelectionInterval(n, n);
                }
                sPrevSelMode = DataView.SelectMode.COL_SELECT;
                if (!mouseEvent.isShiftDown()) {
                    this.mPressedCachedColIdx = n;
                }
            } else {
                this.mDragStartWidth = tableColumn.getPreferredWidth();
                this.mDragColumn = tableColumn.getModelIndex();
            }
            if (mouseEvent.isPopupTrigger()) {
                VarViewTable.this.executeHeaderPopup(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                VarViewTable.this.executeHeaderPopup(mouseEvent);
            } else if (this.mDragColumn > -1) {
                JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
                JTable jTable = jTableHeader.getTable();
                TableColumn tableColumn = jTable.getColumnModel().getColumn(this.mDragColumn);
                if (VarViewTable.this.mDataView.getDataColumnCount() > this.mDragColumn) {
                    this.doTableColumnWidth(jTable);
                } else {
                    tableColumn.setPreferredWidth(this.mDragStartWidth);
                }
                this.mDragColumn = -1;
                this.mDragStartWidth = -1;
            }
            VarViewTable.this.mDataView.updateToolbarEnableStatus();
            this.mPrevColsSelected = VarViewTable.this.getSelectedColumns();
            this.mIsColumnMoving = false;
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
            TableColumn tableColumn = jTableHeader.getResizingColumn();
            if (tableColumn == null) {
                if (this.mIsColumnMoving) {
                    return;
                }
                int n = jTableHeader.columnAtPoint(mouseEvent.getPoint());
                if (n < 0 || n >= VarViewTable.this.getColumnCount()) {
                    return;
                }
                if (sPrevSelMode == DataView.SelectMode.COL_SELECT) {
                    if (mouseEvent.isControlDown()) {
                        VarViewTable.this.setRowSelectionInterval(VarViewTable.this.getRowCount() - 1, 0);
                        VarViewTable.this.setColumnSelectionInterval(this.mPressedCachedColIdx, n);
                        if (this.mPrevColsSelected != null) {
                            for (int n2 : this.mPrevColsSelected) {
                                VarViewTable.this.addColumnSelectionInterval(n2, n2);
                            }
                        }
                    } else {
                        VarViewTable.this.clearSelection();
                        VarViewTable.this.setRowSelectionInterval(VarViewTable.this.getRowCount() - 1, 0);
                        VarViewTable.this.setColumnSelectionInterval(this.mPressedCachedColIdx, n);
                    }
                    Point point = (Point)mouseEvent.getPoint().clone();
                    Object object = mouseEvent.getSource();
                    if (object instanceof JTableHeader) {
                        SwingUtilities.convertPoint((JTableHeader)object, point, VarViewTable.this);
                    } else if (object != this) {
                        return;
                    }
                    VarViewTable.this.autoscroll(point);
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        private void doTableColumnWidth(JTable jTable) {
            int n = jTable.getColumnModel().getColumn(this.mDragColumn).getPreferredWidth();
            if (jTable.getColumnModel().getSelectionModel().isSelectedIndex(this.mDragColumn)) {
                int[] nArray;
                CompoundEdit compoundEdit = new CompoundEdit();
                VarViewTable.this.mDataView.getUndoManager().addEdit(compoundEdit);
                for (int n2 : nArray = jTable.getColumnModel().getSelectedColumns()) {
                    TableColumn tableColumn = jTable.getColumnModel().getColumn(n2);
                    int n3 = n2 == this.mDragColumn ? this.mDragStartWidth : tableColumn.getPreferredWidth();
                    new TableColumnWidthEdit(VarViewTable.this.mDataView, 1, n2, n3, n);
                }
                compoundEdit.end();
            } else {
                new TableColumnWidthEdit(VarViewTable.this.mDataView, 1, this.mDragColumn, this.mDragStartWidth, n);
            }
        }
    }
}

