/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.data;

import com.spss.java_client.core.common.FileDrop;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.documents.AppMgr;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.DatasourceAttributes;
import com.spss.java_client.core.documents.data.dictionary.ExtensionType;
import com.spss.java_client.core.documents.data.dictionary.IDatasourceAttributes;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.ui.doc_types.data.TableColMoveDropTargetHandler;
import com.spss.java_client.ui.doc_types.data.TableColMoveTransfer;
import com.spss.java_client.ui.doc_types.data.VarViewTable;
import com.spss.java_client.ui.doc_types.data.VarViewTableModel;
import com.spss.java_client.ui.undo.SpssUndoManager;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.util.Vector;
import javax.swing.table.JTableHeader;

public class VarTableColMoveDropTargetHandler
extends TableColMoveDropTargetHandler {
    public VarTableColMoveDropTargetHandler(SpssUndoManager spssUndoManager, VarViewTable varViewTable) {
        super(spssUndoManager, varViewTable);
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        boolean bl = false;
        Transferable transferable = dropTargetDropEvent.getTransferable();
        if (transferable.isDataFlavorSupported(TableColMoveTransfer.FLAVOUR)) {
            this.renderHighlight(-1);
            Component component = dropTargetDropEvent.getDropTargetContext().getComponent();
            if (component instanceof JTableHeader || component == this.mTable) {
                try {
                    VarViewTable varViewTable = (VarViewTable)this.mTable;
                    Point point = dropTargetDropEvent.getLocation();
                    int n = varViewTable.getColumnCount();
                    int n2 = this.getHitColumn(point, varViewTable);
                    dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
                    Object object = dropTargetDropEvent.getTransferable().getTransferData(TableColMoveTransfer.FLAVOUR);
                    if (object instanceof TableColMoveTransfer) {
                        TableColMoveTransfer tableColMoveTransfer = (TableColMoveTransfer)object;
                        int[] nArray = tableColMoveTransfer.getSelectedColumns();
                        Vector<Integer> vector = new Vector<Integer>();
                        for (int n3 : nArray) {
                            if (n3 <= -1 || n3 >= n) continue;
                            vector.add(n3);
                        }
                        if (vector.size() != nArray.length) {
                            nArray = new int[vector.size()];
                            for (int i = 0; i < vector.size(); ++i) {
                                nArray[i] = (Integer)vector.get(i);
                            }
                        }
                        if (nArray.length > 0) {
                            this.doColumnMoves(nArray, n2);
                        }
                        bl = true;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        } else if (dropTargetDropEvent.isDataFlavorSupported(DataFlavor.javaFileListFlavor) || FileDrop.isLinuxDropFilesEvent((DropTargetDropEvent)dropTargetDropEvent)) {
            try {
                AppMgr.processDroppedFiles((DropTargetDropEvent)dropTargetDropEvent);
                bl = true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            dropTargetDropEvent.rejectDrop();
        }
        dropTargetDropEvent.dropComplete(bl);
    }

    private void doColumnMoves(int[] nArray, int n) {
        Vector vector;
        VarViewTable varViewTable = (VarViewTable)this.mTable;
        ISpssDataSrc iSpssDataSrc = varViewTable.getDataView().getDataSrc();
        IDatasourceAttributes iDatasourceAttributes = iSpssDataSrc.getAttributes();
        boolean bl = false;
        if (iDatasourceAttributes == null) {
            iDatasourceAttributes = new DatasourceAttributes();
            bl = true;
        }
        if ((vector = iDatasourceAttributes.values("$VariableView2")) == null) {
            vector = PrefsMgr.getPrefsMgr().getDefaultVarViewDisplayColumns();
        }
        boolean bl2 = nArray[0] < n;
        Vector<String> vector2 = new Vector<String>();
        for (int i = nArray.length - 1; i >= 0; --i) {
            String string = (String)vector.remove(nArray[i]);
            vector2.insertElementAt(string, 0);
        }
        if (bl2) {
            n -= nArray.length;
        }
        vector.addAll(n, vector2);
        iDatasourceAttributes.put("$VariableView2", vector);
        if (bl) {
            iSpssDataSrc.setAttributes(iDatasourceAttributes);
        }
        iSpssDataSrc.setModified(true);
        varViewTable.updateDisplayedAttributes();
        DataMgr.getDataMgr().sendDataSrcExtensionsMsg(iSpssDataSrc.getDataSetId(), iDatasourceAttributes.toString(), ExtensionType.kDatasetAttributes, 1);
    }

    @Override
    protected void highlightColumn(DropTargetDragEvent dropTargetDragEvent, boolean bl) {
        int n = -1;
        Component component = dropTargetDragEvent.getDropTargetContext().getComponent();
        if (bl && component instanceof JTableHeader || component == this.mTable) {
            try {
                VarViewTable varViewTable = (VarViewTable)this.mTable;
                Point point = dropTargetDragEvent.getLocation();
                n = this.getHitColumn(point, varViewTable);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.renderHighlight(n);
    }

    private int getHitColumn(Point point, VarViewTable varViewTable) {
        int n;
        Rectangle rectangle;
        int n2 = this.mTable.columnAtPoint(point);
        if (n2 == -1) {
            rectangle = this.mTable.getVisibleRect();
            n2 = (double)point.x >= rectangle.getMaxX() ? ((VarViewTableModel)varViewTable.getModel()).getDisplayedAttributes().size() - 1 : 0;
        }
        if (point.x > (n = rectangle.x + (int)((rectangle = this.mTable.getTableHeader().getHeaderRect(n2)).getWidth() / 2.0))) {
            ++n2;
        }
        return n2;
    }
}

