/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.data;

import com.spss.java_client.core.common.FileDrop;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.documents.AppMgr;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.ui.doc_types.data.DataViewTable;
import com.spss.java_client.ui.doc_types.data.SpssRowHeaderTable;
import com.spss.java_client.ui.doc_types.data.SpssTable;
import com.spss.java_client.ui.doc_types.data.TableColMoveTransfer;
import com.spss.java_client.ui.doc_types.data.TableRowMoveTransferHandler;
import com.spss.java_client.ui.doc_types.data.undo.TableRowMoveEdit;
import com.spss.java_client.ui.undo.SpssUndoManager;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class TableRowMoveDropTargetHandler
extends DropTargetAdapter {
    private SpssUndoManager mUndoManager;
    private int mLastHighlightRow = -1;
    private SpssRowHeaderTable mTable = null;
    private boolean mIsDataView;
    private boolean mDataViewInitialized = false;

    public TableRowMoveDropTargetHandler(SpssUndoManager spssUndoManager, SpssRowHeaderTable spssRowHeaderTable) {
        this.mUndoManager = spssUndoManager;
        this.mTable = spssRowHeaderTable;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (!FileDrop.isDragFilesEvent((DropTargetDragEvent)dropTargetDragEvent)) {
            this.checkRowDrag(dropTargetDragEvent);
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (!FileDrop.isDragFilesEvent((DropTargetDragEvent)dropTargetDragEvent)) {
            this.autoscroll(dropTargetDragEvent);
            this.checkRowDrag(dropTargetDragEvent);
        }
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
        this.renderHighlight(-1);
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        boolean bl = false;
        Transferable transferable = dropTargetDropEvent.getTransferable();
        if (transferable.isDataFlavorSupported(TableColMoveTransfer.FLAVOUR)) {
            if (!this.mDataViewInitialized) {
                this.mIsDataView = this.mTable.getDataTable() instanceof DataViewTable;
                this.mDataViewInitialized = true;
            }
            this.renderHighlight(-1);
            Component component = dropTargetDropEvent.getDropTargetContext().getComponent();
            if (component == this.mTable || component == this.mTable.getDataTable()) {
                try {
                    SpssRowHeaderTable spssRowHeaderTable = this.mTable;
                    int n = component == this.mTable ? spssRowHeaderTable.rowAtPoint(dropTargetDropEvent.getLocation()) : this.mTable.getDataTable().rowAtPoint(dropTargetDropEvent.getLocation());
                    LocallyUniqueId locallyUniqueId = DataMgr.getDataMgr().getActiveDocumentId();
                    int n2 = this.mIsDataView ? (int)DataMgr.getDataMgr().getDataSource(locallyUniqueId).rowCount() : DataMgr.getDataMgr().getDataSource(locallyUniqueId).columnCount();
                    n = n > n2 ? n2 : n;
                    dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
                    Object object = dropTargetDropEvent.getTransferable().getTransferData(TableColMoveTransfer.FLAVOUR);
                    if (object instanceof TableRowMoveTransferHandler.TableRowMoveTransfer) {
                        TableRowMoveTransferHandler.TableRowMoveTransfer tableRowMoveTransfer = (TableRowMoveTransferHandler.TableRowMoveTransfer)object;
                        int[] nArray = tableRowMoveTransfer.getSelectedRows();
                        Vector<Integer> vector = new Vector<Integer>();
                        for (int n3 : nArray) {
                            if (n3 <= -1 || n3 >= n2) continue;
                            vector.add(n3);
                        }
                        if (vector.size() != nArray.length) {
                            nArray = new int[vector.size()];
                            for (int i = 0; i < vector.size(); ++i) {
                                nArray[i] = (Integer)vector.get(i);
                            }
                        }
                        if (nArray.length > 0) {
                            new TableRowMoveEdit(locallyUniqueId, this.mUndoManager, this.mTable, nArray, n);
                        }
                        bl = true;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        } else if (dropTargetDropEvent.isDataFlavorSupported(DataFlavor.javaFileListFlavor) || FileDrop.isLinuxDropFilesEvent((DropTargetDropEvent)dropTargetDropEvent)) {
            try {
                AppMgr.processDroppedFiles((DropTargetDropEvent)dropTargetDropEvent);
                bl = true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            dropTargetDropEvent.rejectDrop();
        }
        dropTargetDropEvent.dropComplete(bl);
    }

    protected void autoscroll(DropTargetDragEvent dropTargetDragEvent) {
        Transferable transferable = dropTargetDragEvent.getTransferable();
        if (transferable.isDataFlavorSupported(TableColMoveTransfer.FLAVOUR)) {
            Point point = dropTargetDragEvent.getLocation();
            Point point2 = (Point)point.clone();
            Component component = dropTargetDragEvent.getDropTargetContext().getComponent();
            if (component == this.mTable) {
                SwingUtilities.convertPoint(component, point2, this.mTable);
            } else if (component != this.mTable.getDataTable()) {
                return;
            }
            ((SpssTable)this.mTable.getDataTable()).autoscroll(point2);
        }
    }

    private void checkRowDrag(DropTargetDragEvent dropTargetDragEvent) {
        Transferable transferable = dropTargetDragEvent.getTransferable();
        if (transferable.isDataFlavorSupported(TableColMoveTransfer.FLAVOUR)) {
            if (!this.mDataViewInitialized) {
                this.mIsDataView = this.mTable.getDataTable() instanceof DataViewTable;
                this.mDataViewInitialized = true;
            }
            boolean bl = false;
            Component component = dropTargetDragEvent.getDropTargetContext().getComponent();
            if (component == this.mTable || component == this.mTable.getDataTable()) {
                try {
                    SpssRowHeaderTable spssRowHeaderTable = this.mTable;
                    int n = component == this.mTable ? spssRowHeaderTable.rowAtPoint(dropTargetDragEvent.getLocation()) : this.mTable.getDataTable().rowAtPoint(dropTargetDragEvent.getLocation());
                    Object object = dropTargetDragEvent.getTransferable().getTransferData(TableColMoveTransfer.FLAVOUR);
                    if (object instanceof TableRowMoveTransferHandler.TableRowMoveTransfer) {
                        TableRowMoveTransferHandler.TableRowMoveTransfer tableRowMoveTransfer = (TableRowMoveTransferHandler.TableRowMoveTransfer)object;
                        int[] nArray = tableRowMoveTransfer.getSelectedRows();
                        int n2 = Integer.MAX_VALUE;
                        int n3 = -1;
                        for (int n4 : nArray) {
                            n2 = n2 < n4 ? n2 : n4;
                            n3 = n3 > n4 ? n3 : n4;
                        }
                        if (n < n2 || n > n3) {
                            bl = true;
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (bl) {
                dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
            } else {
                dropTargetDragEvent.rejectDrag();
            }
            this.highlightRow(dropTargetDragEvent, bl);
        }
    }

    private void highlightRow(DropTargetDragEvent dropTargetDragEvent, boolean bl) {
        int n = -1;
        Component component = dropTargetDragEvent.getDropTargetContext().getComponent();
        if (bl && (component == this.mTable || component == this.mTable.getDataTable())) {
            SpssRowHeaderTable spssRowHeaderTable = this.mTable;
            n = component == this.mTable ? spssRowHeaderTable.rowAtPoint(dropTargetDragEvent.getLocation()) : this.mTable.getDataTable().rowAtPoint(dropTargetDragEvent.getLocation());
            LocallyUniqueId locallyUniqueId = DataMgr.getDataMgr().getActiveDocumentId();
            int n2 = this.mIsDataView ? (int)DataMgr.getDataMgr().getDataSource(locallyUniqueId).rowCount() : DataMgr.getDataMgr().getDataSource(locallyUniqueId).columnCount();
            n = n > n2 ? n2 : n;
        }
        this.renderHighlight(n);
    }

    private void renderHighlight(int n) {
        if (this.mTable != null && n != this.mLastHighlightRow) {
            if (n > -1) {
                this.mTable.highlightRow(n, true);
            }
            if (this.mLastHighlightRow > -1) {
                this.mTable.highlightRow(this.mLastHighlightRow, false);
            }
            this.mLastHighlightRow = n;
        }
    }
}

