/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.data;

import com.spss.charteditor.DebugOutputWindow;
import com.spss.charteditor.MyEditor;
import com.spss.charteditor.util.CETracer;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.doc_types.data.CopyTableCellPropertyManager;
import com.spss.java_client.ui.doc_types.data.FormatInfo;
import com.spss.java_client.ui.doc_types.data.TableBooleanCellPropertyManager;
import com.spss.java_client.ui.doc_types.data.TableCellPropertyManager;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TablePropertyManager {
    ArrayList<TableCellPropertyManager> mPropertyManagers = new ArrayList();
    private DocumentBuilder fBuilder;
    private Document fXMLTablePropertiesDoc;
    String DATAVIEW_TABLE_FORMAT = "DATAVIEW_TABLE_FORMAT";
    public static final String SHARED_INFO = "SHARED_INFO";
    public static final String VAR_IDS = "VAR_IDS";
    public static final String COL_START = "COL_START";
    public static final String VERSION = "VERSION";
    public static final int BK_COLOR = 0;
    public static final int FOREGROUND_COLOR = 1;
    public static final int FONT_BOLD = 2;
    public static final String BK_COLOR_TEXT = "BK_COLOR";
    public static final String FOREGROUND_COLOR_TEXT = "FOREGROUND_COLOR";
    public static final String FONT_BOLD_TEXT = "FONT_BOLD";

    public void addPropertyManager(TableCellPropertyManager tableCellPropertyManager) {
        this.mPropertyManagers.add(tableCellPropertyManager);
    }

    public ArrayList<TableCellPropertyManager> getTableCellPropertyManagers() {
        return this.mPropertyManagers;
    }

    public TableCellPropertyManager getTableCellPropertyManager(int n) {
        TableCellPropertyManager tableCellPropertyManager = null;
        for (TableCellPropertyManager tableCellPropertyManager2 : this.mPropertyManagers) {
            if (tableCellPropertyManager2.getPropertyTypeID() != n) continue;
            tableCellPropertyManager = tableCellPropertyManager2;
            break;
        }
        return tableCellPropertyManager;
    }

    public void updateVariableOrder(ArrayList<Integer> arrayList) {
        for (TableCellPropertyManager tableCellPropertyManager : this.mPropertyManagers) {
            tableCellPropertyManager.updateVariableOrder(arrayList);
        }
    }

    public TablePropertyManager savePropertyStateWholeTableBased(int n) {
        TablePropertyManager tablePropertyManager = new TablePropertyManager();
        TableCellPropertyManager tableCellPropertyManager = this.getTableCellPropertyManager(n);
        if (tableCellPropertyManager != null) {
            this.createCopyWholeTableBased(tablePropertyManager, tableCellPropertyManager);
        }
        return tablePropertyManager;
    }

    public TablePropertyManager savePropertyStateColumnBased(int n, int[] nArray) {
        TablePropertyManager tablePropertyManager = new TablePropertyManager();
        TableCellPropertyManager tableCellPropertyManager = this.getTableCellPropertyManager(n);
        if (tableCellPropertyManager != null) {
            this.createCopyColumnBased(nArray, tablePropertyManager, tableCellPropertyManager);
        }
        return tablePropertyManager;
    }

    public TablePropertyManager savePropertyStateColumnBased(int[] nArray) {
        TablePropertyManager tablePropertyManager = new TablePropertyManager();
        for (TableCellPropertyManager tableCellPropertyManager : this.mPropertyManagers) {
            this.createCopyColumnBased(nArray, tablePropertyManager, tableCellPropertyManager);
        }
        return tablePropertyManager;
    }

    public void createCopyWholeTableBased(TablePropertyManager tablePropertyManager, TableCellPropertyManager tableCellPropertyManager) {
        CopyTableCellPropertyManager copyTableCellPropertyManager = tableCellPropertyManager.savePropertyWholeTable();
        if (copyTableCellPropertyManager != null) {
            tablePropertyManager.addPropertyManager(copyTableCellPropertyManager);
        }
    }

    public void createCopyColumnBased(int[] nArray, TablePropertyManager tablePropertyManager, TableCellPropertyManager tableCellPropertyManager) {
        CopyTableCellPropertyManager copyTableCellPropertyManager = tableCellPropertyManager.savePropertySateColumnBased(nArray);
        if (copyTableCellPropertyManager != null) {
            tablePropertyManager.addPropertyManager(copyTableCellPropertyManager);
        }
    }

    public TablePropertyManager savePropertySateCellBased(int n, int[] nArray, int[] nArray2) {
        TablePropertyManager tablePropertyManager = new TablePropertyManager();
        TableCellPropertyManager tableCellPropertyManager = this.getTableCellPropertyManager(n);
        if (tableCellPropertyManager != null) {
            this.createCopyCellBased(nArray, nArray2, tablePropertyManager, tableCellPropertyManager);
        }
        return tablePropertyManager;
    }

    public TablePropertyManager savePropertySateCellBased(int[] nArray, int[] nArray2) {
        TablePropertyManager tablePropertyManager = new TablePropertyManager();
        for (TableCellPropertyManager tableCellPropertyManager : this.mPropertyManagers) {
            this.createCopyCellBased(nArray, nArray2, tablePropertyManager, tableCellPropertyManager);
        }
        return tablePropertyManager;
    }

    public void createCopyCellBased(int[] nArray, int[] nArray2, TablePropertyManager tablePropertyManager, TableCellPropertyManager tableCellPropertyManager) {
        CopyTableCellPropertyManager copyTableCellPropertyManager = tableCellPropertyManager.savePropertySateCellBased(nArray, nArray2);
        if (copyTableCellPropertyManager != null) {
            tablePropertyManager.addPropertyManager(copyTableCellPropertyManager);
        }
    }

    public TablePropertyManager savePropertySateRowBased(int n, int[] nArray) {
        TablePropertyManager tablePropertyManager = new TablePropertyManager();
        TableCellPropertyManager tableCellPropertyManager = this.getTableCellPropertyManager(n);
        if (tableCellPropertyManager != null) {
            this.createCopyRowBased(nArray, tablePropertyManager, tableCellPropertyManager);
        }
        return tablePropertyManager;
    }

    public TablePropertyManager savePropertySateRowBased(int[] nArray) {
        TablePropertyManager tablePropertyManager = new TablePropertyManager();
        for (TableCellPropertyManager tableCellPropertyManager : this.mPropertyManagers) {
            this.createCopyRowBased(nArray, tablePropertyManager, tableCellPropertyManager);
        }
        return tablePropertyManager;
    }

    public void createCopyRowBased(int[] nArray, TablePropertyManager tablePropertyManager, TableCellPropertyManager tableCellPropertyManager) {
        CopyTableCellPropertyManager copyTableCellPropertyManager = tableCellPropertyManager.savePropertySateRowBased(nArray);
        if (copyTableCellPropertyManager != null) {
            tablePropertyManager.addPropertyManager(copyTableCellPropertyManager);
        }
    }

    public void restoreSavedProperties(TablePropertyManager tablePropertyManager) {
        for (TableCellPropertyManager tableCellPropertyManager : this.mPropertyManagers) {
            TableCellPropertyManager tableCellPropertyManager2 = this.getTableCellPropertyManager(tableCellPropertyManager.getPropertyTypeID());
            TableCellPropertyManager tableCellPropertyManager3 = tablePropertyManager.getTableCellPropertyManager(tableCellPropertyManager.getPropertyTypeID());
            if (!(tableCellPropertyManager3 instanceof CopyTableCellPropertyManager)) continue;
            tableCellPropertyManager2.updateProperties((CopyTableCellPropertyManager)tableCellPropertyManager3);
        }
    }

    public void clearCellProperties(int[] nArray, int[] nArray2) {
        for (TableCellPropertyManager tableCellPropertyManager : this.mPropertyManagers) {
            if (tableCellPropertyManager == null) continue;
            tableCellPropertyManager.clearCells(nArray, nArray2);
        }
    }

    public Document createDocument(int[] nArray, int[] nArray2) {
        this.initDocBuilder();
        this.fXMLTablePropertiesDoc = this.fBuilder.newDocument();
        Element element = this.fXMLTablePropertiesDoc.createElement(this.DATAVIEW_TABLE_FORMAT);
        element.setAttribute("TMP_DESCRIPTION", "Save file for format properties in dataview table");
        element.setAttribute(VERSION, "1");
        this.fXMLTablePropertiesDoc.appendChild(element);
        this.appendSharedInfoElement(element, nArray2);
        for (TableCellPropertyManager tableCellPropertyManager : this.mPropertyManagers) {
            if (tableCellPropertyManager == null) continue;
            tableCellPropertyManager.appendXML(this.fXMLTablePropertiesDoc, nArray, nArray2);
        }
        return this.fXMLTablePropertiesDoc;
    }

    private void appendSharedInfoElement(Element element, int[] nArray) {
        if (element != null) {
            element.setAttribute(VAR_IDS, this.createVarIDsText(nArray));
        }
        if (nArray != null && nArray.length > 0) {
            element.setAttribute(COL_START, "" + nArray[0]);
        }
        element.setAttribute(VERSION, "1");
    }

    private String createVarIDsText(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<Integer> arrayList = this.mPropertyManagers.get(0).getColumnVariableIDList();
        for (int i = 0; i < arrayList.size(); ++i) {
            if (nArray != null && !TablePropertyManager.listContains(nArray, i)) continue;
            String string = this.mPropertyManagers.get(0).saveVARIDsOffsetBased() ? "" + i : "" + arrayList.get(i);
            stringBuffer.append(":" + string);
        }
        return stringBuffer.toString();
    }

    public static boolean listContains(int[] nArray, int n) {
        boolean bl = false;
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            if (n2 != n) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void doXMLRestore(String string) {
        Document document = TablePropertyManager.openXMLIntoDocument(string);
        this.doRestore(document);
    }

    public void doRestore(String string) {
        File file = new File(string);
        if (file.exists() && !file.isDirectory()) {
            Document document = TablePropertyManager.openFileIntoDocument(file);
            this.doRestore(document);
        }
    }

    public void doRestore(Document document) {
        if (document != null) {
            ArrayList<Integer> arrayList = this.getVarIDs(document);
            for (TableCellPropertyManager tableCellPropertyManager : this.mPropertyManagers) {
                if (tableCellPropertyManager == null) continue;
                tableCellPropertyManager.restore(document, arrayList);
            }
        }
    }

    private ArrayList<Integer> getVarIDs(Document document) {
        ArrayList<Object> arrayList = new ArrayList();
        NodeList nodeList = document.getElementsByTagName(this.DATAVIEW_TABLE_FORMAT);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(0);
            if (node == null) continue;
            NamedNodeMap namedNodeMap = node.getAttributes();
            Node node2 = namedNodeMap.getNamedItem(VAR_IDS);
            String string = node2.getNodeValue();
            arrayList = this.parsteVarIDText(string);
            Node node3 = namedNodeMap.getNamedItem(COL_START);
            String string2 = node3 != null ? node3.getNodeValue() : null;
            Node node4 = namedNodeMap.getNamedItem(VERSION);
            String string3 = node4 != null ? node4.getNodeValue() : null;
        }
        return arrayList != null && arrayList.size() > 0 ? arrayList : null;
    }

    private ArrayList<Integer> parsteVarIDText(String string) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (string != null) {
            String[] stringArray;
            for (String string2 : stringArray = string.trim().split(":")) {
                if (string2 == null || string2.length() <= 0) continue;
                arrayList.add(new Integer(string2));
            }
        }
        return arrayList != null && arrayList.size() > 0 ? arrayList : null;
    }

    public void copyRowProperties(int n, int[] nArray) {
        for (TableCellPropertyManager tableCellPropertyManager : this.mPropertyManagers) {
            if (tableCellPropertyManager == null) continue;
            tableCellPropertyManager.copyRowProperties(n, nArray);
        }
    }

    public void copyColummnProperties(int n, int[] nArray) {
        for (TableCellPropertyManager tableCellPropertyManager : this.mPropertyManagers) {
            if (tableCellPropertyManager == null) continue;
            tableCellPropertyManager.copyColummnProperties(n, nArray);
        }
    }

    public Document createPropertiesXML(String string) {
        return this.createPropertiesXML(string, null, null);
    }

    public Document createPropertiesXML(String string, int[] nArray, int[] nArray2) {
        Document document = this.createDocument(nArray, nArray2);
        if (string != null) {
            TablePropertyManager.writeXmlFile(document, string);
        }
        return document;
    }

    private void initDocBuilder() {
        if (this.fBuilder == null) {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            try {
                this.fBuilder = documentBuilderFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                CETracer.printStackTrace((Exception)parserConfigurationException, (DebugOutputWindow)MyEditor.debug);
            }
        }
    }

    public static void writeXmlFile(Document document, String string) {
        try {
            DOMSource dOMSource = new DOMSource(document);
            File file = new File(string);
            StreamResult streamResult = new StreamResult(file);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(dOMSource, streamResult);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
    }

    public static String writeXmlToString(Document document) {
        StringWriter stringWriter = new StringWriter();
        Transformer transformer = null;
        try {
            transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(new DOMSource(document), new StreamResult(stringWriter));
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            transformerConfigurationException.printStackTrace();
        }
        catch (TransformerException transformerException) {
            transformerException.printStackTrace();
        }
        return stringWriter.toString();
    }

    private static Document openFileIntoDocument(File file) {
        Document document = null;
        if (file.exists() && !file.isDirectory()) {
            int n = (int)file.length();
            byte[] byArray = new byte[n];
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                fileInputStream.read(byArray);
                fileInputStream.close();
                String string = new String(byArray, "UTF-8");
                StringBuffer stringBuffer = new StringBuffer(string);
                document = TablePropertyManager.openXMLIntoDocument(stringBuffer.toString());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return document;
    }

    private static Document openXMLIntoDocument(String string) {
        Document document = null;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF-8"));
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(byteArrayInputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        return document;
    }

    public void initiateDefaultPropertyManagers() {
        this.addPropertyManager(new TableCellPropertyManager(0, BK_COLOR_TEXT));
        this.addPropertyManager(new TableCellPropertyManager(1, FOREGROUND_COLOR_TEXT));
    }

    public void pasteColumnBased(ISpssDataSrc iSpssDataSrc, TablePropertyManager tablePropertyManager, HashMap<String, ArrayList<String>> hashMap) {
        if (tablePropertyManager != null && hashMap != null) {
            for (TableCellPropertyManager tableCellPropertyManager : tablePropertyManager.getTableCellPropertyManagers()) {
                this.pasteColumnBased(iSpssDataSrc, tableCellPropertyManager, hashMap);
            }
        }
    }

    private void pasteColumnBased(ISpssDataSrc iSpssDataSrc, TableCellPropertyManager tableCellPropertyManager, HashMap<String, ArrayList<String>> hashMap) {
        for (String string : hashMap.keySet()) {
            int n = new Integer(string);
            ArrayList<String> arrayList = hashMap.get(string);
            if (n == -1) continue;
            for (String string2 : arrayList) {
                ISpssVariable iSpssVariable;
                int n2 = iSpssDataSrc.findVarIndex(string2);
                if (n2 < 0 || n2 < 0 || (iSpssVariable = iSpssDataSrc.getVariable(n2)) == null) continue;
                TableCellPropertyManager tableCellPropertyManager2 = this.getTableCellPropertyManager(tableCellPropertyManager.getPropertyTypeID());
                String string3 = tableCellPropertyManager.getWholeColumnProperty(n);
                tableCellPropertyManager2.setWholeColumnToValue(n2, string3);
            }
        }
    }

    public static TablePropertyManager initFromXMLPath(String string) {
        TablePropertyManager tablePropertyManager = null;
        File file = new File(string);
        if (file.exists() && !file.isDirectory()) {
            Document document = TablePropertyManager.openFileIntoDocument(file);
            String string2 = TablePropertyManager.writeXmlToString(document);
            tablePropertyManager = TablePropertyManager.initFromXML(string2);
        }
        if (tablePropertyManager == null) {
            tablePropertyManager = new TablePropertyManager();
            tablePropertyManager.initiateDefaultPropertyManagers();
        }
        return tablePropertyManager;
    }

    public static TablePropertyManager initFromXML(String string) {
        TablePropertyManager tablePropertyManager = new TablePropertyManager();
        tablePropertyManager.initiateDefaultPropertyManagers();
        tablePropertyManager.doXMLRestore(string);
        return tablePropertyManager;
    }

    public void setSaveMethod(int n) {
        for (TableCellPropertyManager tableCellPropertyManager : this.mPropertyManagers) {
            if (tableCellPropertyManager == null) continue;
            tableCellPropertyManager.setSaveMethod(n);
        }
    }

    public void updateFromOffsetsToIDS(int[] nArray, int[] nArray2, ArrayList<Integer> arrayList, ArrayList<Integer> arrayList2) {
        for (TableCellPropertyManager tableCellPropertyManager : this.mPropertyManagers) {
            if (tableCellPropertyManager == null) continue;
            tableCellPropertyManager.updateFromOffsetsToIDS(nArray, nArray2, arrayList, arrayList2);
        }
    }

    public int getSaveMethod() {
        return this.mPropertyManagers.size() > 0 ? this.mPropertyManagers.get(0).getSaveMethod() : -1;
    }

    public FormatInfo getFormatInfo(int n, int n2) {
        Color color = this.getBKColor(n, n2);
        Color color2 = this.getForegroundColor(n, n2);
        return new FormatInfo(color, color2, null, false, false);
    }

    private Color getBKColor(int n, int n2) {
        String string = this.getBKColorManager().getPropertyAt(n, n2);
        Color color = string != null ? new Color(new Integer(string)) : null;
        return color;
    }

    private Color getForegroundColor(int n, int n2) {
        String string = this.getForegroundColorManager().getPropertyAt(n, n2);
        Color color = string != null ? new Color(new Integer(string)) : null;
        return color;
    }

    public boolean isTextBold(int n, int n2) {
        return this.getFontBoldManager().isPropertyOnAt(n, n2);
    }

    public TableBooleanCellPropertyManager getFontBoldManager() {
        return (TableBooleanCellPropertyManager)this.getTableCellPropertyManager(2);
    }

    public TableCellPropertyManager getBKColorManager() {
        return this.getTableCellPropertyManager(0);
    }

    public TableCellPropertyManager getForegroundColorManager() {
        return this.getTableCellPropertyManager(1);
    }
}

