/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.data;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.ui.doc_types.data.SpssTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;

public class TableHeaderPrintRender
extends DefaultTableCellRenderer {
    private SpssTable mTable;

    public TableHeaderPrintRender(SpssTable spssTable) {
        this.mTable = spssTable;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Object object2;
        if (jTable != null && (object2 = jTable.getTableHeader()) != null) {
            this.setForeground(((Component)object2).getForeground());
            this.setBackground(Color.white);
            this.setFont(((Component)object2).getFont());
        }
        object2 = n2 < this.mTable.getDataColumnCount() ? this.wrapHeaderText(n2, object == null ? "" : object.toString()) : (object == null ? "" : object.toString());
        this.setText((String)object2);
        this.setHorizontalAlignment(0);
        this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        return this;
    }

    @Override
    public void setText(String string) {
        if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
            super.setText(ComponentState.prepareStringForBidiRendering((String)string));
        } else {
            super.setText(string);
        }
    }

    @Override
    public void setToolTipText(String string) {
        if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
            super.setToolTipText(ComponentState.prepareStringForBidiRendering((String)string));
        } else {
            super.setToolTipText(string);
        }
    }

    protected String wrapHeaderText(int n, String string) {
        String string2 = "<html><center>";
        Rectangle rectangle = this.mTable.getTableHeader().getHeaderRect(n);
        Graphics graphics = this.mTable.getTableHeader().getGraphics();
        if (graphics == null) {
            return string;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = fontMetrics.stringWidth(string);
        string2 = n2 > rectangle.width ? string2 + this.sliceString(fontMetrics, string, rectangle.width - 2) : string2 + string;
        string2 = string2 + "</html>";
        graphics.dispose();
        return string2;
    }

    private String sliceString(FontMetrics fontMetrics, String string, int n) {
        String string2 = "";
        try {
            int n2 = 0;
            for (int i = 0; i < 3; ++i) {
                String string3 = "";
                boolean bl = false;
                do {
                    int n3;
                    if ((n3 = fontMetrics.stringWidth(string3 = string3 + string.charAt(n2++))) > n) {
                        if (string3.length() > 1) {
                            --n2;
                            string3 = string3.substring(0, string3.length() - 1);
                        }
                        bl = true;
                        continue;
                    }
                    if (n2 != string.length()) continue;
                    bl = true;
                } while (!bl);
                if (string2.length() > 0) {
                    string2 = string2 + "<br>";
                }
                string2 = string2 + string3;
                if (n2 >= string.length()) break;
            }
            if (n2 < string.length()) {
                string2 = string2.substring(0, string2.length() - 3) + "...";
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }
}

