/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.data;

import com.spss.java_client.core.common.FileDrop;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.ui.doc_types.data.SpssTable;
import com.spss.java_client.ui.doc_types.data.TableColMoveTransfer;
import com.spss.java_client.ui.undo.SpssUndoManager;
import java.awt.Component;
import java.awt.Point;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;

public abstract class TableColMoveDropTargetHandler
extends DropTargetAdapter {
    protected SpssUndoManager mUndoManager;
    protected int mLastHighlightColumn = -1;
    protected SpssTable mTable = null;

    public TableColMoveDropTargetHandler(SpssUndoManager spssUndoManager, SpssTable spssTable) {
        this.mUndoManager = spssUndoManager;
        this.mTable = spssTable;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (!FileDrop.isDragFilesEvent((DropTargetDragEvent)dropTargetDragEvent)) {
            this.checkColumnDrag(dropTargetDragEvent);
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (!FileDrop.isDragFilesEvent((DropTargetDragEvent)dropTargetDragEvent)) {
            this.autoscroll(dropTargetDragEvent);
            this.checkColumnDrag(dropTargetDragEvent);
        }
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
        this.renderHighlight(-1);
    }

    @Override
    public abstract void drop(DropTargetDropEvent var1);

    protected void renderHighlight(int n) {
        if (this.mTable != null && n != this.mLastHighlightColumn) {
            if (n > -1) {
                this.mTable.highlightColumn(n, true);
            }
            if (this.mLastHighlightColumn > -1) {
                this.mTable.highlightColumn(this.mLastHighlightColumn, false);
            }
            this.mLastHighlightColumn = n;
        }
    }

    protected void highlightColumn(DropTargetDragEvent dropTargetDragEvent, boolean bl) {
        int n = -1;
        Component component = dropTargetDragEvent.getDropTargetContext().getComponent();
        if (bl && component instanceof JTableHeader || component == this.mTable) {
            try {
                Point point = dropTargetDragEvent.getLocation();
                n = this.mTable.columnAtPoint(point);
                LocallyUniqueId locallyUniqueId = DataMgr.getDataMgr().getActiveDocumentId();
                int n2 = DataMgr.getDataMgr().getDataSource(locallyUniqueId).columnCount();
                n = n > n2 ? n2 : n;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.renderHighlight(n);
    }

    protected void autoscroll(DropTargetDragEvent dropTargetDragEvent) {
        Point point = dropTargetDragEvent.getLocation();
        Point point2 = (Point)point.clone();
        Component component = dropTargetDragEvent.getDropTargetContext().getComponent();
        if (component instanceof JTableHeader) {
            SwingUtilities.convertPoint(component, point2, this.mTable);
        } else if (component != this.mTable) {
            return;
        }
        this.mTable.autoscroll(point2);
    }

    private void checkColumnDrag(DropTargetDragEvent dropTargetDragEvent) {
        if (dropTargetDragEvent.getTransferable().isDataFlavorSupported(TableColMoveTransfer.FLAVOUR)) {
            boolean bl = false;
            Component component = dropTargetDragEvent.getDropTargetContext().getComponent();
            if (component instanceof JTableHeader || component == this.mTable) {
                try {
                    Point point = dropTargetDragEvent.getLocation();
                    SpssTable spssTable = this.mTable;
                    int n = spssTable.columnAtPoint(point);
                    Object object = dropTargetDragEvent.getTransferable().getTransferData(TableColMoveTransfer.FLAVOUR);
                    if (object instanceof TableColMoveTransfer) {
                        TableColMoveTransfer tableColMoveTransfer = (TableColMoveTransfer)object;
                        int[] nArray = tableColMoveTransfer.getSelectedColumns();
                        int n2 = 65535;
                        int n3 = -1;
                        for (int n4 : nArray) {
                            n2 = n2 < n4 ? n2 : n4;
                            n3 = n3 > n4 ? n3 : n4;
                        }
                        if (n2 <= n && n3 >= n) {
                            dropTargetDragEvent.rejectDrag();
                        } else {
                            dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
                            bl = true;
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    dropTargetDragEvent.rejectDrag();
                }
            }
            this.highlightColumn(dropTargetDragEvent, bl);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    private static File[] textURIListToFileArray(String string) {
        ArrayList<File> arrayList = new ArrayList<File>(1);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.startsWith("#")) continue;
            try {
                URI uRI = new URI(string2);
                File file = new File(uRI);
                arrayList.add(file);
            }
            catch (URISyntaxException uRISyntaxException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return (File[])arrayList.toArray();
    }
}

