/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.data;

import com.spss.java_client.ui.doc_types.data.CopyTableCellPropertyManager;
import com.spss.java_client.ui.doc_types.data.TablePropertyManager;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TableCellPropertyManager {
    public static final String PROPERTY_INFO = "PROPERTY_INFO";
    public static final String PROPERTY_ID = "PROPERTY_ID";
    public static final String ROW_INFO = "ROW_INFO";
    public static final String COL_BITS_ON = "COL_BITS_ON";
    public static final String ROW_CASE_ID = "ROW_CASE_ID";
    public static final String WHOLE_ROW = "WHOLE_ROW";
    public static final String CASE_IDS = "CASE_IDS";
    public static final String WHOLE_COL = "WHOLE_COL";
    public static final String VAR_IDS = "VAR_IDS";
    public static final String WHOLE_TABLE = "WHOLE_TABLE";
    public static final String VALUE = "VALUE";
    protected HashMap<String, HashMap<Integer, BitSet>> mPropertyIDToRowBitsetMap = new HashMap();
    protected HashMap<Integer, String> mWholeVarIDToStringMap = new HashMap();
    protected HashMap<Integer, String> mWholeCaseIDToStringMap = new HashMap();
    public String mWholeTableValue = null;
    protected ArrayList<Integer> mColumnVariableIDList;
    private int mPropertyTypeID = -1;
    private String mPropertyTypeIDString = null;
    public static final int SAVE_AS_IS = 0;
    public static final int SAVE_ONLYCASEID_OFFSETBASED = 1;
    public static final int SAVE_ALL_OFFSETBASED = 2;
    int mSaveMethod = 0;

    public TableCellPropertyManager(int n, String string) {
        this.mPropertyTypeID = n;
        this.mPropertyTypeIDString = string;
    }

    public int getPropertyTypeID() {
        return this.mPropertyTypeID;
    }

    public boolean hasWholeCaseIDS() {
        return this.mWholeCaseIDToStringMap != null ? this.mWholeCaseIDToStringMap.keySet().size() > 0 : false;
    }

    public boolean hasWholeVarIDS() {
        return this.mWholeVarIDToStringMap != null ? this.mWholeVarIDToStringMap.keySet().size() > 0 : false;
    }

    public void clearWholeColumns(int[] nArray) {
        if (nArray != null && nArray.length > 0) {
            int[] nArray2;
            for (int n : nArray2 = this.getVariableIDsFromColumnIndexs(nArray)) {
                this.mWholeVarIDToStringMap.remove(n);
            }
        }
    }

    public void clearWholeRows(int[] nArray) {
        if (nArray != null && nArray.length > 0) {
            for (int n : nArray) {
                this.mWholeCaseIDToStringMap.remove(n);
            }
        }
        this.clearRowValuesFromBitSets(nArray);
    }

    private void clearTheseColumnsCellBased(int[] nArray) {
        for (String string : this.mPropertyIDToRowBitsetMap.keySet()) {
            this.turnCellsInColumnsForPropertyOFF(nArray, string);
        }
        this.mPropertyIDToRowBitsetMap = this.removeEmptyValues(this.mPropertyIDToRowBitsetMap);
    }

    public void clearCells(int[] nArray, int[] nArray2) {
        for (String string : this.mPropertyIDToRowBitsetMap.keySet()) {
            HashMap<Integer, BitSet> hashMap = this.mPropertyIDToRowBitsetMap.get(string);
            if (hashMap == null) continue;
            this.turnCellPropertyOFF(nArray, nArray2, string);
        }
    }

    public void turnCellsInColumnsForPropertyOFF(int[] nArray, String string) {
        HashMap<Integer, BitSet> hashMap = this.mPropertyIDToRowBitsetMap.get(string);
        if (hashMap != null) {
            for (int n : nArray) {
                for (int n2 : hashMap.keySet()) {
                    BitSet bitSet = hashMap.get(n2);
                    bitSet.set(n, false);
                }
            }
        }
    }

    private HashMap<String, HashMap<Integer, BitSet>> removeEmptyValues(HashMap<String, HashMap<Integer, BitSet>> hashMap) {
        HashMap<String, HashMap<Integer, BitSet>> hashMap2 = new HashMap<String, HashMap<Integer, BitSet>>();
        for (String string : hashMap.keySet()) {
            HashMap<Integer, BitSet> hashMap3 = hashMap.get(string);
            HashMap<Integer, BitSet> hashMap4 = new HashMap<Integer, BitSet>();
            if (hashMap3.values().size() <= 0) continue;
            for (int n : hashMap3.keySet()) {
                BitSet bitSet = hashMap3.get(n);
                if (bitSet.isEmpty()) continue;
                hashMap4.put(n, bitSet);
            }
            if (hashMap4.size() <= 0) continue;
            hashMap2.put(string, hashMap4);
        }
        return hashMap2;
    }

    public void setWholeRowToValue(int n, String string) {
        this.setWholeRowsToValue(new int[]{n}, string);
    }

    public void setWholeRowsToValue(int[] nArray, String string) {
        for (int i = 0; i < nArray.length; ++i) {
            this.mWholeCaseIDToStringMap.put(nArray[i], string);
        }
        this.clearRowValuesFromBitSets(nArray);
        this.processRowColIntersections(nArray, string);
    }

    private void processRowColIntersections(int[] nArray, String string) {
        int[] nArray2 = this.getWholeVarIDKeysAsColumnIndexes();
        if (nArray != null && nArray.length > 0 && nArray2 != null && nArray2.length > 0) {
            this.turnCellPropertyON(nArray, nArray2, string);
        }
    }

    private void processColRowIntersections(int[] nArray, String string) {
        int[] nArray2 = this.getIntegerKeySetAsIntArray(this.mWholeCaseIDToStringMap.keySet());
        if (nArray2 != null && nArray2.length > 0 && nArray != null && nArray.length > 0) {
            this.turnCellPropertyON(nArray2, nArray, string);
        }
    }

    public int[] getWholeVarIDKeysAsColumnIndexes() {
        int[] nArray;
        int[] nArray2 = nArray = this.mWholeVarIDToStringMap.keySet().size() > 0 ? new int[this.mWholeVarIDToStringMap.keySet().size()] : null;
        if (nArray != null) {
            int n = 0;
            for (Integer n2 : this.mWholeVarIDToStringMap.keySet()) {
                int n3 = this.getColumnIdexFromVarID(n2);
                if (n3 < 0) continue;
                nArray[n] = n3;
                ++n;
            }
        }
        return nArray;
    }

    public int[] getIntegerKeySetAsIntArray(Set<Integer> set) {
        int[] nArray;
        int[] nArray2 = nArray = set.size() > 0 ? new int[set.size()] : null;
        if (nArray != null) {
            int n = 0;
            for (Integer n2 : set) {
                nArray[n] = n2;
                ++n;
            }
        }
        return nArray;
    }

    public ArrayList<Integer> getIntegerKeySetAsList(Set<Integer> set) {
        ArrayList<Integer> arrayList;
        ArrayList<Integer> arrayList2 = arrayList = set.size() > 0 ? new ArrayList<Integer>(set.size()) : null;
        if (arrayList != null) {
            for (Integer n : set) {
                arrayList.add(n);
            }
        }
        return arrayList;
    }

    public void setWholeTableToValue(String string, boolean bl) {
        if (bl) {
            this.clearAllPropertyInfo();
        }
        this.mWholeTableValue = string;
    }

    public void setWholeColumnToValue(int n, String string) {
        this.setWholeColumnToValue(new int[]{n}, string);
    }

    public void setWholeColumnToValue(int[] nArray, String string) {
        int[] nArray2;
        for (int n : nArray2 = this.getVariableIDsFromColumnIndexs(nArray)) {
            if (n <= 0) continue;
            this.mWholeVarIDToStringMap.put(n, string);
        }
        this.clearTheseColumnsCellBased(nArray);
        this.processColRowIntersections(nArray, string);
    }

    private int getVariableIDFromColumnIndex(int n) {
        int n2 = this.mColumnVariableIDList != null && n < this.mColumnVariableIDList.size() ? this.mColumnVariableIDList.get(n) : -1;
        return n2;
    }

    private int[] getVariableIDsFromColumnIndexs(int[] nArray) {
        int[] nArray2 = nArray != null && nArray.length > 0 ? new int[nArray.length] : null;
        for (int i = 0; i < nArray.length; ++i) {
            int n = this.getVariableIDFromColumnIndex(nArray[i]);
            if (n == -1) continue;
            nArray2[i] = n;
        }
        return nArray2;
    }

    private int[] getColumnIdexes() {
        int[] nArray;
        int[] nArray2 = nArray = this.mColumnVariableIDList != null && this.mColumnVariableIDList.size() > 0 ? new int[this.mColumnVariableIDList.size()] : null;
        if (nArray != null) {
            for (int i = 0; i < this.mColumnVariableIDList.size(); ++i) {
                nArray[i] = i;
            }
        }
        return nArray;
    }

    private int[] getColumnIdexesFromVarID(int[] nArray) {
        int[] nArray2;
        int[] nArray3 = nArray2 = nArray != null && nArray.length > 0 ? new int[nArray.length] : null;
        if (nArray2 != null) {
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                int n2 = this.getColumnIdexFromVarID(n);
                if (n2 < 0) continue;
                nArray2[i] = n2;
            }
        }
        return nArray2;
    }

    private int getColumnIdexFromVarID(int n) {
        return this.findIndex(this.mColumnVariableIDList, n);
    }

    private int findIndex(ArrayList<Integer> arrayList, int n) {
        int n2 = -1;
        for (int i = 0; i < arrayList.size(); ++i) {
            Integer n3 = arrayList.get(i);
            if (n3 != n) continue;
            n2 = i;
            break;
        }
        return n2;
    }

    protected void clearRowValuesFromBitSets(int[] nArray) {
        for (String string : this.mPropertyIDToRowBitsetMap.keySet()) {
            HashMap<Integer, BitSet> hashMap = this.mPropertyIDToRowBitsetMap.get(string);
            for (int n : nArray) {
                hashMap.remove(n);
            }
        }
    }

    public void turnCellPropertyOFF(int[] nArray, int[] nArray2, String string) {
        HashMap<Integer, BitSet> hashMap = this.mPropertyIDToRowBitsetMap.get(string);
        for (int n : nArray2 = nArray2 == null ? this.getColumnIdexes() : nArray2) {
            for (int n2 : nArray = nArray == null ? this.getRowCaseIDsIntegerArray(hashMap) : nArray) {
                BitSet bitSet = hashMap.get(n2);
                if (bitSet == null) continue;
                bitSet.set(n, false);
            }
        }
    }

    public void turnCellPropertyON(int[] nArray, int[] nArray2, String string) {
        for (int n : nArray) {
            this.turnCellPropertyON(n, nArray2, string);
        }
        this.mPropertyIDToRowBitsetMap = this.removeEmptyValues(this.mPropertyIDToRowBitsetMap);
    }

    public void turnCellPropertyON(int n, int n2, String string) {
        this.turnCellPropertyON(n, new int[]{n2}, string);
    }

    public void turnCellPropertyON(int n, int[] nArray, String string) {
        HashMap<Integer, BitSet> hashMap = this.mPropertyIDToRowBitsetMap.get(string);
        hashMap = hashMap != null ? hashMap : new HashMap<Integer, BitSet>();
        BitSet bitSet = null;
        if (hashMap != null) {
            bitSet = (BitSet)hashMap.get(n);
            if (bitSet == null) {
                bitSet = new BitSet();
            }
            for (Object object : (Object)nArray) {
                bitSet.set((int)object, true);
            }
            hashMap.put(n, bitSet);
        }
        for (String string2 : this.mPropertyIDToRowBitsetMap.keySet()) {
            HashMap<Integer, BitSet> hashMap2;
            BitSet bitSet2;
            if (string2 == null || string2.equalsIgnoreCase(string) || (bitSet2 = (hashMap2 = this.mPropertyIDToRowBitsetMap.get(string2)) != null ? hashMap2.get(n) : null) == null) continue;
            bitSet2.andNot(bitSet);
        }
        this.mPropertyIDToRowBitsetMap.put(string, hashMap);
    }

    protected void restoreCellProperties(String string, String string2, String string3) {
        int n;
        int n2 = n = string != null ? new Integer(string) : -1;
        if (n != -1 && string2 != null && string2.length() > 0) {
            String[] stringArray;
            for (String string4 : stringArray = string2.trim().split(":")) {
                if (string4 == null || string4.length() <= 0) continue;
                String[] stringArray2 = string4.trim().split("-");
                if (stringArray2.length == 1) {
                    this.turnCellPropertyON(n, new Integer(stringArray2[0]), string3);
                    continue;
                }
                if (stringArray2.length != 2) continue;
                int n3 = new Integer(stringArray2[0]);
                int n4 = new Integer(stringArray2[1]);
                n4 = n4 < this.mColumnVariableIDList.size() ? n4 : this.mColumnVariableIDList.size() - 1;
                for (int i = n3; i <= n4; ++i) {
                    this.turnCellPropertyON(n, i, string3);
                }
            }
        }
    }

    public BitSet getRowBitSet(int n, String string) {
        HashMap<Integer, BitSet> hashMap = this.mPropertyIDToRowBitsetMap.get(string);
        return hashMap != null ? hashMap.get(n) : null;
    }

    public String getWholeColumnProperty(int n) {
        return n != -1 && this.mWholeVarIDToStringMap.containsKey(n) ? this.mWholeVarIDToStringMap.get(n) : null;
    }

    public String getWholeRowProperty(int n) {
        return this.mWholeCaseIDToStringMap.containsKey(n) ? this.mWholeCaseIDToStringMap.get(n) : null;
    }

    public String getPropertyAt(int n, int n2) {
        String string = null;
        if (n != -1) {
            for (String string2 : this.mPropertyIDToRowBitsetMap.keySet()) {
                BitSet bitSet = this.getRowBitSet(n, string2);
                if (bitSet == null || !bitSet.get(n2)) continue;
                string = string2;
                break;
            }
        }
        if (string == null) {
            int n3 = this.getVariableIDFromColumnIndex(n2);
            String string3 = string = n3 != -1 && this.mWholeVarIDToStringMap.get(n3) != null ? this.mWholeVarIDToStringMap.get(n3) : null;
            if (string == null && n != -1) {
                String string4 = string = n3 != -1 && this.mWholeCaseIDToStringMap.get(n) != null ? this.mWholeCaseIDToStringMap.get(n) : null;
            }
        }
        if (string == null) {
            string = this.mWholeTableValue;
        }
        return string;
    }

    public void updateVariableOrder(ArrayList<Integer> arrayList) {
        if (this.mColumnVariableIDList == null) {
            this.mColumnVariableIDList = arrayList;
        } else {
            HashMap<String, HashMap<Integer, BitSet>> hashMap = this.reorderColumns(this.mPropertyIDToRowBitsetMap, arrayList);
            this.mPropertyIDToRowBitsetMap = hashMap;
            this.mColumnVariableIDList = arrayList;
        }
    }

    private HashMap<String, HashMap<Integer, BitSet>> reorderColumns(HashMap<String, HashMap<Integer, BitSet>> hashMap, ArrayList<Integer> arrayList) {
        HashMap<String, HashMap<Integer, BitSet>> hashMap2 = new HashMap<String, HashMap<Integer, BitSet>>();
        for (String string : hashMap.keySet()) {
            int n;
            HashMap<Integer, BitSet> hashMap3 = hashMap.get(string);
            HashMap<Integer, BitSet> hashMap4 = new HashMap<Integer, BitSet>();
            BitSet bitSet = new BitSet();
            int n2 = this.getMaxBitSetLength(hashMap3);
            for (int i = n = this.getStartIndex(hashMap3); i < n2; ++i) {
                int n3 = this.convertOldBitsetIndexToNewBitsetIndex(i, this.mColumnVariableIDList, arrayList);
                if (n3 == -1) continue;
                for (int n4 : hashMap3.keySet()) {
                    BitSet bitSet2 = hashMap3.get(n4);
                    BitSet bitSet3 = this.getRowBitSet(hashMap4, n4, true);
                    if (bitSet2 == null || !bitSet2.get(i)) continue;
                    bitSet3.set(n3, true);
                }
            }
            hashMap2.put(string, hashMap4);
        }
        return hashMap2;
    }

    private int convertOldBitsetIndexToNewBitsetIndex(Integer n, ArrayList<Integer> arrayList, ArrayList<Integer> arrayList2) {
        int n2 = n < arrayList.size() ? arrayList.get(n) : -1;
        int n3 = n2 != -1 ? this.findBitSetIndex(n2, arrayList2) : -1;
        return n3;
    }

    private int findBitSetIndex(Integer n, ArrayList<Integer> arrayList) {
        int n2 = -1;
        for (int i = 0; i < arrayList.size(); ++i) {
            Integer n3 = arrayList.get(i);
            if (n3.intValue() != n.intValue()) continue;
            n2 = i;
        }
        return n2;
    }

    private int getMaxBitSetLength(HashMap<Integer, BitSet> hashMap) {
        int n = 0;
        for (BitSet bitSet : hashMap.values()) {
            n = Math.max(n, bitSet.length());
        }
        return n;
    }

    private int getStartIndex(HashMap<Integer, BitSet> hashMap) {
        int n = Integer.MAX_VALUE;
        for (BitSet bitSet : hashMap.values()) {
            int n2 = bitSet.nextSetBit(0);
            if (n2 < 0) continue;
            n = Math.min(n, n2);
        }
        return n;
    }

    protected CopyTableCellPropertyManager savePropertyWholeTable() {
        CopyTableCellPropertyManager copyTableCellPropertyManager = new CopyTableCellPropertyManager(this.mPropertyTypeID, this.mPropertyTypeIDString);
        copyTableCellPropertyManager.setCopyInfo(3, null, null);
        copyTableCellPropertyManager.setWholeTableToValue(this.mWholeTableValue);
        return copyTableCellPropertyManager;
    }

    protected CopyTableCellPropertyManager savePropertySateColumnBased(int[] nArray) {
        HashMap<Integer, String> hashMap = this.copyWholeColumnProperties(nArray);
        int[] nArray2 = this.getColumnIdexesFromVarID(nArray);
        HashMap<String, HashMap<Integer, BitSet>> hashMap2 = this.copyCellPropertyInfo(null, nArray2);
        CopyTableCellPropertyManager copyTableCellPropertyManager = new CopyTableCellPropertyManager(this.mPropertyTypeID, this.mPropertyTypeIDString);
        copyTableCellPropertyManager.setCopyInfo(1, null, nArray2);
        copyTableCellPropertyManager.setPropertyIDToRowBitsetMap(hashMap2);
        copyTableCellPropertyManager.setWholeVarIDToStringMap(hashMap);
        copyTableCellPropertyManager.setColumnVariableIDList(this.mColumnVariableIDList);
        return copyTableCellPropertyManager;
    }

    public CopyTableCellPropertyManager savePropertySateRowBased(int[] nArray) {
        HashMap<Integer, String> hashMap = this.copyWholeRowProperties(nArray);
        HashMap<String, HashMap<Integer, BitSet>> hashMap2 = this.copyCellPropertyInfo(nArray, null);
        CopyTableCellPropertyManager copyTableCellPropertyManager = new CopyTableCellPropertyManager(this.mPropertyTypeID, this.mPropertyTypeIDString);
        copyTableCellPropertyManager.setCopyInfo(2, nArray, null);
        copyTableCellPropertyManager.setPropertyIDToRowBitsetMap(hashMap2);
        copyTableCellPropertyManager.setWholeCaseIDToStringMap(hashMap);
        copyTableCellPropertyManager.setColumnVariableIDList(this.mColumnVariableIDList);
        return copyTableCellPropertyManager;
    }

    public CopyTableCellPropertyManager savePropertySateCellBased(int[] nArray, int[] nArray2) {
        HashMap<String, HashMap<Integer, BitSet>> hashMap = this.copyCellPropertyInfo(nArray, nArray2);
        CopyTableCellPropertyManager copyTableCellPropertyManager = new CopyTableCellPropertyManager(this.mPropertyTypeID, this.mPropertyTypeIDString);
        copyTableCellPropertyManager.setCopyInfo(0, nArray, nArray2);
        copyTableCellPropertyManager.setPropertyIDToRowBitsetMap(hashMap);
        copyTableCellPropertyManager.setColumnVariableIDList(this.mColumnVariableIDList);
        return copyTableCellPropertyManager;
    }

    private HashMap<Integer, String> copyWholeColumnProperties(int[] nArray) {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        block0: for (Integer n : this.mWholeVarIDToStringMap.keySet()) {
            for (int n2 : nArray) {
                if (n2 != n) continue;
                hashMap.put(n, this.mWholeVarIDToStringMap.get(n));
                continue block0;
            }
        }
        return hashMap;
    }

    private HashMap<Integer, String> copyWholeRowProperties(int[] nArray) {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        block0: for (Integer n : this.mWholeCaseIDToStringMap.keySet()) {
            int[] nArray2 = nArray;
            int n2 = nArray2.length;
            for (int i = 0; i < n2; ++i) {
                Integer n3 = nArray2[i];
                if (n3 != n) continue;
                hashMap.put(n, this.mWholeCaseIDToStringMap.get(n));
                continue block0;
            }
        }
        return hashMap;
    }

    private HashMap<String, HashMap<Integer, BitSet>> copyCellPropertyInfo(int[] nArray, int[] nArray2) {
        HashMap<String, HashMap<Integer, BitSet>> hashMap = new HashMap<String, HashMap<Integer, BitSet>>();
        for (String string : this.mPropertyIDToRowBitsetMap.keySet()) {
            HashMap<Integer, BitSet> hashMap2 = this.mPropertyIDToRowBitsetMap.get(string);
            HashMap<Integer, BitSet> hashMap3 = new HashMap<Integer, BitSet>();
            if (hashMap2 != null) {
                for (int n : nArray2 = nArray2 == null ? this.getColumnIdexes() : nArray2) {
                    int[] nArray3 = nArray == null ? this.getRowCaseIDsIntegerArray(hashMap2) : nArray;
                    for (int i = 0; i < nArray3.length; ++i) {
                        int n2 = nArray3[i];
                        BitSet bitSet = hashMap2.get(n2);
                        if (bitSet == null || bitSet.size() <= 0 || !bitSet.get(n)) continue;
                        BitSet bitSet2 = this.getRowBitSet(hashMap3, n2, true);
                        bitSet2.set(n);
                        int n3 = this.saveCasedIDsOffsetBased() ? i : n2;
                        hashMap3.put(n3, bitSet2);
                    }
                }
            }
            hashMap.put(string, hashMap3);
        }
        return hashMap;
    }

    public void updateProperties(CopyTableCellPropertyManager copyTableCellPropertyManager) {
        this.restorePropertiesCellBased(copyTableCellPropertyManager);
        if (copyTableCellPropertyManager.getCopyType() == 3) {
            this.restorePropertiesWholeTableBased(copyTableCellPropertyManager);
        }
        if (copyTableCellPropertyManager.getCopyType() == 1) {
            this.restorePropertiesCollBased(copyTableCellPropertyManager);
        }
        if (copyTableCellPropertyManager.getCopyType() == 2) {
            this.restorePropertiesRowlBased(copyTableCellPropertyManager);
        }
    }

    private void restorePropertiesRowlBased(TableCellPropertyManager tableCellPropertyManager) {
        Object object;
        Object object2;
        if (tableCellPropertyManager instanceof CopyTableCellPropertyManager) {
            object2 = (CopyTableCellPropertyManager)tableCellPropertyManager;
            object = ((CopyTableCellPropertyManager)object2).getRowCaseIDs();
            this.clearWholeRows((int[])object);
        }
        if ((object2 = tableCellPropertyManager.getWholeCaseIDToStringMap()) != null) {
            object = ((HashMap)object2).keySet().iterator();
            while (object.hasNext()) {
                Integer n = (Integer)object.next();
                this.mWholeCaseIDToStringMap.put(n, (String)((HashMap)object2).get(n));
            }
        }
    }

    private void restorePropertiesWholeTableBased(TableCellPropertyManager tableCellPropertyManager) {
        String string;
        this.mWholeTableValue = string = tableCellPropertyManager.getWholeTableValue();
    }

    private void restorePropertiesCollBased(TableCellPropertyManager tableCellPropertyManager) {
        Object object;
        Object object2;
        HashMap<Integer, String> hashMap = tableCellPropertyManager.getWholeVarIDToStringMap();
        if (tableCellPropertyManager instanceof CopyTableCellPropertyManager) {
            object2 = (CopyTableCellPropertyManager)tableCellPropertyManager;
            object = ((CopyTableCellPropertyManager)object2).getColumns();
            this.clearWholeColumns((int[])object);
        }
        if (hashMap != null && hashMap.keySet().size() > 0) {
            object2 = hashMap.keySet().iterator();
            while (object2.hasNext()) {
                object = (Integer)object2.next();
                this.mWholeVarIDToStringMap.put((Integer)object, hashMap.get(object));
            }
        }
    }

    private void restorePropertiesCellBased(TableCellPropertyManager tableCellPropertyManager) {
        Object object;
        Object object2;
        Object object3;
        if (tableCellPropertyManager instanceof CopyTableCellPropertyManager) {
            object3 = (CopyTableCellPropertyManager)tableCellPropertyManager;
            object2 = ((CopyTableCellPropertyManager)object3).getRowCaseIDs();
            object = ((CopyTableCellPropertyManager)object3).getColumns();
            this.clearCells((int[])object2, (int[])object);
        }
        object3 = tableCellPropertyManager.getPropertyIDToRowBitsetMap();
        object2 = ((HashMap)object3).keySet().iterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            HashMap hashMap = (HashMap)((HashMap)object3).get(object);
            HashMap<Integer, BitSet> hashMap2 = this.getRowToBitSetMap((String)object, true);
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                BitSet bitSet = (BitSet)hashMap.get(n);
                if (bitSet == null || bitSet.size() <= 0) continue;
                BitSet bitSet2 = this.getRowBitSet(hashMap2, n, true);
                bitSet2.or(bitSet);
                hashMap2.put(n, bitSet2);
            }
        }
    }

    private int[] getRowCaseIDsIntegerArray(HashMap<Integer, BitSet> hashMap) {
        Integer[] integerArray = hashMap.keySet() != null ? hashMap.keySet().toArray(new Integer[hashMap.keySet().size()]) : null;
        int[] nArray = new int[integerArray.length];
        for (int i = 0; i < integerArray.length; ++i) {
            nArray[i] = integerArray[i];
        }
        return nArray;
    }

    private HashMap<Integer, BitSet> getRowToBitSetMap(String string, boolean bl) {
        HashMap<Integer, BitSet> hashMap;
        HashMap<Integer, BitSet> hashMap2 = hashMap = this.mPropertyIDToRowBitsetMap.containsKey(string) ? this.mPropertyIDToRowBitsetMap.get(string) : null;
        if (hashMap == null && bl) {
            hashMap = new HashMap();
            this.mPropertyIDToRowBitsetMap.put(string, hashMap);
        }
        return hashMap;
    }

    private BitSet getRowBitSet(HashMap<Integer, BitSet> hashMap, int n, boolean bl) {
        BitSet bitSet;
        BitSet bitSet2 = bitSet = hashMap.containsKey(n) ? hashMap.get(n) : null;
        if (bitSet == null && bl) {
            bitSet = new BitSet();
            hashMap.put(n, bitSet);
        }
        return bitSet;
    }

    public String getWholeTableValue() {
        return this.mWholeTableValue;
    }

    protected HashMap<String, HashMap<Integer, BitSet>> getPropertyIDToRowBitsetMap() {
        return this.mPropertyIDToRowBitsetMap;
    }

    protected HashMap<Integer, String> getWholeVarIDToStringMap() {
        return this.mWholeVarIDToStringMap;
    }

    protected HashMap<Integer, String> getWholeCaseIDToStringMap() {
        return this.mWholeCaseIDToStringMap;
    }

    protected ArrayList<Integer> getColumnVariableIDList() {
        return this.mColumnVariableIDList;
    }

    public void copyRowProperties(int n, int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            String string = this.getWholeRowProperty(n);
            if (string != null) {
                this.setWholeRowToValue(n2, string);
            }
            for (String string2 : this.mPropertyIDToRowBitsetMap.keySet()) {
                BitSet bitSet;
                BitSet bitSet2;
                HashMap<Integer, BitSet> hashMap = this.mPropertyIDToRowBitsetMap.get(string2);
                if (hashMap == null || (bitSet2 = (bitSet = hashMap.get(n)) != null ? (BitSet)bitSet.clone() : null) == null) continue;
                hashMap.put(n2, bitSet2);
            }
        }
    }

    public void copyColummnProperties(int n, int[] nArray) {
        for (int n2 : nArray) {
            String string = this.getWholeColumnProperty(n);
            if (string != null) {
                this.setWholeColumnToValue(n2, string);
            }
            int n3 = this.getColumnIdexFromVarID(n);
            for (String string2 : this.mPropertyIDToRowBitsetMap.keySet()) {
                HashMap<Integer, BitSet> hashMap = this.mPropertyIDToRowBitsetMap.get(string2);
                if (hashMap == null) continue;
                for (int n4 : hashMap.keySet()) {
                    BitSet bitSet = hashMap.get(n4);
                    if (bitSet == null || !bitSet.get(n3)) continue;
                    bitSet.set(n2);
                }
            }
        }
    }

    public void restore(Document document) {
        this.restore(document, null);
    }

    public void restore(Document document, ArrayList<Integer> arrayList) {
        this.clearAllPropertyInfo();
        this.mColumnVariableIDList = arrayList;
        NodeList nodeList = document.getElementsByTagName(this.mPropertyTypeIDString);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(0);
            if (node == null) continue;
            NodeList nodeList2 = node.getChildNodes();
            this.restorePropertyInfo(nodeList2);
        }
    }

    private void clearAllPropertyInfo() {
        this.mPropertyIDToRowBitsetMap = new HashMap();
        this.mWholeVarIDToStringMap = new HashMap();
        this.mWholeCaseIDToStringMap = new HashMap();
        this.mWholeTableValue = null;
    }

    private void restoreWholeRowPropertyInfo(String string) {
        ArrayList<String[]> arrayList = this.getPairs(string);
        for (String[] stringArray : arrayList) {
            this.setWholeRowToValue(new Integer(stringArray[0]), stringArray[1]);
        }
    }

    private void restoreWholeColumnPropertyInfo(String string) {
        ArrayList<String[]> arrayList = this.getPairs(string);
        for (String[] stringArray : arrayList) {
            int[] nArray = this.getColumnIdexesFromVarID(new int[]{new Integer(stringArray[0])});
            if (nArray == null || nArray[0] <= -1) continue;
            this.setWholeColumnToValue(nArray[0], stringArray[1]);
        }
    }

    private ArrayList<String[]> getPairs(String string) {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        if (string != null && string.length() > 0) {
            String[] stringArray;
            for (String string2 : stringArray = string.trim().split(":")) {
                String[] stringArray2 = string2.trim().split("=");
                if (stringArray2 == null || stringArray2.length <= 1 || stringArray2[0].trim().length() <= 0 || stringArray2[1].trim().length() <= 0) continue;
                arrayList.add(stringArray2);
            }
        }
        return arrayList;
    }

    private void restorePropertyInfo(NodeList nodeList) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node;
            NamedNodeMap namedNodeMap;
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName();
            if (string.equals(PROPERTY_INFO)) {
                namedNodeMap = node2.getAttributes();
                node = namedNodeMap.getNamedItem(PROPERTY_ID);
                NodeList nodeList2 = node2.getChildNodes();
                this.restoreRowInfo(node.getNodeValue(), nodeList2);
                continue;
            }
            if (string.equals(WHOLE_ROW)) {
                namedNodeMap = node2.getAttributes();
                node = namedNodeMap.getNamedItem(CASE_IDS);
                if (node == null) continue;
                this.restoreWholeRowPropertyInfo(node.getNodeValue());
                continue;
            }
            if (string.equals(WHOLE_COL)) {
                namedNodeMap = node2.getAttributes();
                node = namedNodeMap.getNamedItem(VAR_IDS);
                if (node == null) continue;
                this.restoreWholeColumnPropertyInfo(node.getNodeValue());
                continue;
            }
            if (!string.equals(WHOLE_TABLE) || (node = (namedNodeMap = node2.getAttributes()).getNamedItem(VALUE)) == null) continue;
            this.mWholeTableValue = node.getNodeValue().trim().length() > 0 ? node.getNodeValue() : null;
        }
    }

    private void restoreRowInfo(String string, NodeList nodeList) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            NamedNodeMap namedNodeMap;
            Node node = nodeList.item(i);
            String string2 = node.getNodeName();
            if (!string2.equals(ROW_INFO) || (namedNodeMap = node.getAttributes()) == null) continue;
            Node node2 = namedNodeMap.getNamedItem(COL_BITS_ON);
            Node node3 = namedNodeMap.getNamedItem(ROW_CASE_ID);
            if (node2 == null || node3 == null) continue;
            String string3 = node2.getNodeValue();
            String string4 = node3.getNodeValue();
            this.restoreCellProperties(string4, string3, string);
        }
    }

    public void appendXML(Document document) {
        this.appendXML(document, null, null);
    }

    public void appendXML(Document document, int[] nArray, int[] nArray2) {
        nArray2 = nArray2 != null ? nArray2 : this.getColumnIdexes();
        Element element = document.getDocumentElement();
        Element element2 = document.createElement(this.mPropertyTypeIDString);
        this.appendWholeTableXML(document, element2);
        this.appendWholeVarIDXML(document, element2, this.getVariableIDsFromColumnIndexs(nArray2));
        this.appendWholeCaseIDXML(document, nArray, element2);
        for (String string : this.mPropertyIDToRowBitsetMap.keySet()) {
            Element element3 = this.savePropertyXML(document, string, nArray, nArray2);
            element2.appendChild(element3);
        }
        element.appendChild(element2);
    }

    private Element savePropertyXML(Document document, String string, int[] nArray, int[] nArray2) {
        Element element = document.createElement(PROPERTY_INFO);
        element.setAttribute(PROPERTY_ID, "" + string);
        HashMap<Integer, BitSet> hashMap = this.mPropertyIDToRowBitsetMap.get(string);
        int[] nArray3 = nArray = nArray == null ? this.getIntegerKeySetAsIntArray(hashMap.keySet()) : nArray;
        if (nArray != null) {
            int n = -1;
            for (int n2 : nArray) {
                int n3;
                ++n;
                if (!hashMap.containsKey(n2)) continue;
                BitSet bitSet = hashMap.get(n2);
                bitSet = (BitSet)bitSet.clone();
                int n4 = nArray2 != null && nArray2.length > 0 ? this.getMaxBitSetLength(hashMap) : -1;
                for (n3 = 0; n3 < n4; ++n3) {
                    if (TablePropertyManager.listContains(nArray2, n3)) continue;
                    bitSet.set(n3, false);
                }
                n3 = nArray2 != null && nArray2.length > 0 ? nArray2[0] : -1;
                String string2 = this.createBitSetStringRepresentation(bitSet, n3);
                if (bitSet == null || bitSet.size() <= 0) continue;
                Element element2 = document.createElement(ROW_INFO);
                n2 = this.saveCasedIDsOffsetBased() ? n : n2;
                element2.setAttribute(ROW_CASE_ID, "" + n2);
                element2.setAttribute(COL_BITS_ON, string2);
                element.appendChild(element2);
            }
        }
        return element;
    }

    private void appendWholeTableXML(Document document, Element element) {
        Element element2 = document.createElement(WHOLE_TABLE);
        if (element2 != null) {
            element2.setAttribute(VALUE, this.mWholeTableValue);
        }
        if (element2 != null) {
            element.appendChild(element2);
        }
    }

    private void appendWholeCaseIDXML(Document document, int[] nArray, Element element) {
        if (this.mWholeCaseIDToStringMap.size() > 0) {
            Element element2 = document.createElement(WHOLE_ROW);
            String string = this.createIDToPropertyStringRepresentation(this.mWholeCaseIDToStringMap, nArray, this.saveCasedIDsOffsetBased());
            if (string != null) {
                element2.setAttribute(CASE_IDS, string);
            }
            if (element2 != null) {
                element.appendChild(element2);
            }
        }
    }

    private void appendWholeVarIDXML(Document document, Element element, int[] nArray) {
        if (this.mWholeVarIDToStringMap.size() > 0) {
            Element element2 = document.createElement(WHOLE_COL);
            String string = this.createIDToPropertyStringRepresentation(this.mWholeVarIDToStringMap, nArray, this.saveVARIDsOffsetBased());
            if (string != null) {
                element2.setAttribute(VAR_IDS, string);
            }
            if (string != null) {
                element.appendChild(element2);
            }
        }
    }

    private HashMap<Integer, String> createWholeVarIDToStringSubMap(int[] nArray) {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        for (Integer n : this.mWholeVarIDToStringMap.keySet()) {
            int n2 = this.getColumnIdexFromVarID(n);
            if (n2 == -1 || !TablePropertyManager.listContains(nArray, n2)) continue;
            hashMap.put(n, this.mWholeVarIDToStringMap.get(n));
        }
        return hashMap;
    }

    private String createIDToPropertyStringRepresentation(HashMap<Integer, String> hashMap, int[] nArray, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        int[] nArray2 = nArray = nArray == null ? this.getIntegerKeySetAsIntArray(hashMap.keySet()) : nArray;
        if (nArray != null) {
            int n = -1;
            for (int n2 : nArray) {
                ++n;
                String string = hashMap.get(n2);
                if (string == null) continue;
                n2 = bl ? n : n2;
                stringBuffer.append(":" + n2 + "=" + string);
            }
        }
        return stringBuffer.length() > 0 ? stringBuffer.toString() : null;
    }

    private String createIDToPropertyStringRepresentation(HashMap<Integer, String> hashMap) {
        StringBuffer stringBuffer = new StringBuffer();
        for (Integer n : hashMap.keySet()) {
            String string = hashMap.get(n);
            if (string == null) continue;
            stringBuffer.append(":" + n + "=" + string);
        }
        return stringBuffer.length() > 0 ? stringBuffer.toString() : null;
    }

    private String createBitSetStringRepresentation(BitSet bitSet, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bitSet != null && bitSet.size() > 0) {
            int n2 = -1;
            int n3 = -1;
            for (int i = 0; i < bitSet.length(); ++i) {
                if (bitSet.get(i)) {
                    if (n2 == -1) {
                        n2 = n != -1 ? i - n : i;
                        continue;
                    }
                    n3 = n != -1 ? i - n : i;
                    continue;
                }
                if (n2 != -1) {
                    if (n3 == -1) {
                        stringBuffer.append(":" + n2);
                    } else {
                        stringBuffer.append(":" + n2 + "-" + n3);
                    }
                }
                n2 = -1;
                n3 = -1;
            }
            if (n2 != -1 && n3 == -1) {
                stringBuffer.append(":" + n2);
            } else {
                stringBuffer.append(":" + n2 + "-" + n3);
            }
        }
        return stringBuffer.toString();
    }

    public void setSaveMethod(int n) {
        this.mSaveMethod = n;
    }

    public int getSaveMethod() {
        return this.mSaveMethod;
    }

    public boolean saveCasedIDsOffsetBased() {
        return this.mSaveMethod == 2 || this.mSaveMethod == 1;
    }

    public boolean saveVARIDsOffsetBased() {
        return this.mSaveMethod == 2;
    }

    public void updateFromOffsetsToIDS(int[] nArray, int[] nArray2, ArrayList<Integer> arrayList, ArrayList<Integer> arrayList2) {
        int n;
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        HashMap<Integer, String> hashMap2 = new HashMap<Integer, String>();
        if (nArray != null && nArray2 != null) {
            for (n = 0; n < nArray.length; ++n) {
                String string = this.mWholeCaseIDToStringMap.get(nArray[n]);
                if (string == null || n >= nArray2.length) continue;
                hashMap.put(nArray2[n], string);
            }
        } else {
            hashMap = new HashMap();
        }
        if (arrayList != null && arrayList2 != null) {
            if (arrayList != null) {
                for (n = 0; n < arrayList.size(); ++n) {
                    int n2 = arrayList.get(n);
                    String string = this.mWholeVarIDToStringMap.get(n2);
                    if (n2 >= arrayList2.size()) continue;
                    hashMap2.put(arrayList2.get(n2), string);
                }
            }
        } else {
            hashMap = new HashMap();
        }
        this.mWholeCaseIDToStringMap = hashMap;
        this.mWholeVarIDToStringMap = hashMap2;
        HashMap hashMap3 = new HashMap();
        if (nArray != null && nArray2 != null) {
            for (String string : this.mPropertyIDToRowBitsetMap.keySet()) {
                HashMap<Integer, BitSet> hashMap4 = this.mPropertyIDToRowBitsetMap.get(string);
                HashMap<Integer, BitSet> hashMap5 = new HashMap<Integer, BitSet>();
                for (int i = 0; i < nArray.length; ++i) {
                    int n3 = nArray[i];
                    BitSet bitSet = hashMap4.get(n3);
                    if (bitSet == null || i >= nArray2.length) continue;
                    hashMap5.put(nArray2[i], (BitSet)bitSet.clone());
                }
                if (hashMap5.size() <= 0) continue;
                hashMap3.put(string, hashMap5);
            }
        }
        this.mPropertyIDToRowBitsetMap = hashMap3;
        this.mColumnVariableIDList = arrayList2;
    }

    public ArrayList<Integer> getUniqueRowCaseIDs() {
        ArrayList<Integer> arrayList = this.getIntegerKeySetAsList(this.mWholeCaseIDToStringMap.keySet());
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        for (String string : this.mPropertyIDToRowBitsetMap.keySet()) {
            int[] nArray;
            HashMap<Integer, BitSet> hashMap = this.mPropertyIDToRowBitsetMap.get(string);
            for (int n : nArray = this.getIntegerKeySetAsIntArray(hashMap.keySet())) {
                if (arrayList.contains(n)) continue;
                arrayList.add(n);
            }
        }
        return arrayList;
    }

    public ArrayList<Integer> getUniqueVarIDs() {
        return this.getVarIDs();
    }

    public ArrayList<Integer> getVarIDs() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int[] nArray = this.getIntegerKeySetAsIntArray(this.mWholeVarIDToStringMap.keySet());
        if (nArray != null) {
            for (int n : nArray) {
                arrayList.add(n);
            }
        }
        return arrayList;
    }
}

