/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.data;

import com.spss.java_client.ui.command.ActionCatalog;
import com.spss.java_client.ui.doc_types.actions.SpssAction;
import com.spss.java_client.ui.doc_types.data.DataView;
import com.spss.java_client.ui.doc_types.data.DragTableColumnRenderer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public abstract class SpssTable
extends JTable
implements Cloneable {
    protected DataView mDataView;

    public SpssTable(TableModel tableModel, DataView dataView) {
        super(tableModel);
        this.mDataView = dataView;
        this.registerShortcuts();
        this.setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(false);
        this.setCellSelectionEnabled(true);
        String string = System.getProperty("os.name", "Windows").toLowerCase();
        boolean bl = string.startsWith("mac os x");
        if (bl) {
            this.setGridColor(this.getGridColor().darker());
        }
    }

    public void registerShortcuts() {
        SpssAction spssAction;
        SpssAction spssAction2;
        SpssAction spssAction3;
        SpssAction spssAction4;
        SpssAction spssAction5;
        SpssAction spssAction6 = ActionCatalog.getActionCatalog().getSpssAction("edit_copy");
        Object object = spssAction6.getValue("AcceleratorKey");
        if (object instanceof KeyStroke) {
            this.registerKeyboardAction(spssAction6, "Copy", (KeyStroke)object, 0);
        }
        if ((object = (spssAction5 = ActionCatalog.getActionCatalog().getSpssAction("edit_paste")).getValue("AcceleratorKey")) instanceof KeyStroke) {
            this.registerKeyboardAction(spssAction5, "Paste", (KeyStroke)object, 0);
        }
        if ((object = (spssAction4 = ActionCatalog.getActionCatalog().getSpssAction("edit_cut")).getValue("AcceleratorKey")) instanceof KeyStroke) {
            this.registerKeyboardAction(spssAction4, "Cut", (KeyStroke)object, 0);
        }
        if ((object = (spssAction3 = ActionCatalog.getActionCatalog().getSpssAction("edit_delete")).getValue("AcceleratorKey")) instanceof KeyStroke) {
            this.registerKeyboardAction(spssAction3, "Delete", (KeyStroke)object, 0);
        }
        if ((object = (spssAction2 = ActionCatalog.getActionCatalog().getSpssAction("edit_find")).getValue("AcceleratorKey")) instanceof KeyStroke) {
            this.registerKeyboardAction(spssAction2, "Find", (KeyStroke)object, 0);
        }
        if ((object = (spssAction = ActionCatalog.getActionCatalog().getSpssAction("edit_find_next")).getValue("AcceleratorKey")) instanceof KeyStroke) {
            this.registerKeyboardAction(spssAction, "FindNext", (KeyStroke)object, 0);
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        JTable jTable = new JTable();
        this.setSelectionBackground(jTable.getSelectionBackground());
    }

    public DataView getDataView() {
        return this.mDataView;
    }

    public void highlightColumn(int n, boolean bl) {
        TableCellRenderer tableCellRenderer;
        int n2 = n;
        if (n2 >= this.getColumnModel().getColumnCount()) {
            n2 = this.getColumnModel().getColumnCount() - 1;
        }
        TableCellRenderer tableCellRenderer2 = tableCellRenderer = (tableCellRenderer = this.getColumnModel().getColumn(n2).getHeaderRenderer()) == null ? this.getTableHeader().getDefaultRenderer() : tableCellRenderer;
        if (tableCellRenderer instanceof DragTableColumnRenderer) {
            if (n2 == n) {
                ((DragTableColumnRenderer)tableCellRenderer).highlightColumn(this.getTableHeader(), n, bl);
            }
            Rectangle rectangle = this.getVisibleRect();
            Rectangle rectangle2 = this.getTableHeader().getHeaderRect(n2);
            int n3 = n2 == n ? (rectangle2.x > 0 ? rectangle2.x - 1 : rectangle2.x) : (int)rectangle2.getMaxX() - 1;
            if (n3 >= rectangle.x && n3 <= rectangle.x + rectangle.width) {
                Graphics graphics = this.getGraphics();
                graphics.setColor(bl ? new Color(156, 0, 0) : this.getGridColor());
                graphics.drawLine(n3, rectangle.y, n3, rectangle.y + rectangle.height);
                graphics.dispose();
            }
        }
    }

    public JTable clone() throws CloneNotSupportedException {
        JTable jTable = new JTable(this.getModel());
        DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel();
        jTable.setColumnModel(defaultTableColumnModel);
        int n = this.getColumnCount();
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn = this.getColumnModel().getColumn(i);
            TableColumn tableColumn2 = new TableColumn();
            tableColumn2.setWidth(tableColumn.getWidth());
            tableColumn2.setPreferredWidth(tableColumn.getPreferredWidth());
            tableColumn2.setHeaderValue(tableColumn.getHeaderValue());
            tableColumn2.setModelIndex(tableColumn.getModelIndex());
            tableColumn2.setIdentifier(tableColumn.getIdentifier());
            tableColumn2.setCellRenderer(tableColumn.getCellRenderer());
            defaultTableColumnModel.addColumn(tableColumn2);
        }
        JTableHeader jTableHeader = new JTableHeader(defaultTableColumnModel);
        jTableHeader.setPreferredSize(this.getTableHeader().getPreferredSize());
        jTableHeader.setSize(this.getTableHeader().getPreferredSize());
        jTableHeader.setFont(this.getTableHeader().getFont());
        jTable.setTableHeader(jTableHeader);
        jTable.setPreferredSize(this.getPreferredSize());
        jTable.setSize(this.getPreferredSize());
        jTable.setFont(this.getFont());
        jTable.setGridColor(this.getGridColor());
        jTable.setShowHorizontalLines(this.getShowHorizontalLines());
        jTable.setShowVerticalLines(this.getShowVerticalLines());
        return jTable;
    }

    public Insets getAutoScrollInsets() {
        return new Insets(20, 20, 20, 20);
    }

    public void autoscroll(Point point) {
        Insets insets = this.getAutoScrollInsets();
        Rectangle rectangle = this.getVisibleRect();
        Rectangle rectangle2 = new Rectangle(rectangle.x + insets.left, rectangle.y + insets.top, rectangle.width - (insets.left + insets.right), rectangle.height - (insets.top + insets.bottom));
        if (!rectangle2.contains(point)) {
            Rectangle rectangle3 = new Rectangle(point.x - insets.left, point.y - insets.top, insets.left + insets.right, insets.top + insets.bottom);
            this.scrollRectToVisible(rectangle3);
        }
    }

    protected void doTabKeyMove(KeyEvent keyEvent) {
        boolean bl;
        if (keyEvent.getKeyCode() != 9) {
            return;
        }
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        ListSelectionModel listSelectionModel2 = this.getTableHeader().getColumnModel().getSelectionModel();
        int n = listSelectionModel.getMinSelectionIndex();
        int n2 = listSelectionModel.getMaxSelectionIndex();
        int n3 = listSelectionModel2.getMinSelectionIndex();
        int n4 = listSelectionModel2.getMaxSelectionIndex();
        if (n != n2 || n3 != n4) {
            return;
        }
        int n5 = listSelectionModel.getLeadSelectionIndex();
        int n6 = listSelectionModel2.getLeadSelectionIndex();
        if (n5 == -1 || n6 == -1) {
            return;
        }
        this.mDataView.clearRowHeaderSelection(this);
        int n7 = this.getDataColumnCount() - 1;
        long l = this.getRowCount() - 1;
        boolean bl2 = bl = (keyEvent.getModifiersEx() & 0x40) != 0;
        if (bl) {
            if (n6 > 0) {
                --n6;
            } else {
                n6 = n7;
                n5 = n5 > 0 ? n5 - 1 : (int)l - 1;
            }
        } else if (n6 < n7) {
            ++n6;
        } else {
            n6 = 0;
            n5 = (long)n5 < l ? ++n5 : 0;
        }
        if (this.getCellEditor() != null && !this.getCellEditor().stopCellEditing()) {
            this.getCellEditor().cancelCellEditing();
        }
        this.getTableHeader().getColumnModel().getSelectionModel().setSelectionInterval(n6, n6);
        this.getSelectionModel().setSelectionInterval(n5, n5);
        Rectangle rectangle = this.getCellRect(n5, n6, true);
        this.scrollRectToVisible(rectangle);
        keyEvent.consume();
    }

    protected void doKeyControlArrowMove(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 38: {
                this.setRowSelectionInterval(0, 0);
                break;
            }
            case 40: {
                final int n = (int)this.getDataRowCount() - 1;
                if (n < 0 || n >= this.getRowCount()) break;
                this.setRowSelectionInterval(n, n);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SpssTable.this.setRowSelectionInterval(n, n);
                    }
                });
                break;
            }
            case 37: {
                this.setColumnSelectionInterval(0, 0);
                break;
            }
            case 39: {
                final int n = this.getDataColumnCount() - 1;
                if (n < 0 || n >= this.getColumnCount()) break;
                this.setColumnSelectionInterval(n, n);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SpssTable.this.setColumnSelectionInterval(n, n);
                    }
                });
            }
        }
    }

    protected abstract long getDataRowCount();

    public abstract boolean isEntireColumnSelected(int var1);

    public abstract boolean isEntireRowSelected(int var1);

    protected abstract int getDataColumnCount();
}

