/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.data;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.actions.SpssAction;
import com.spss.java_client.ui.doc_types.data.DataEditContextMenu;
import com.spss.java_client.ui.doc_types.data.DataView;
import com.spss.java_client.ui.doc_types.data.DataViewTable;
import com.spss.java_client.ui.doc_types.data.TableRowMoveDropTargetHandler;
import com.spss.java_client.ui.doc_types.data.TableRowMoveTransferHandler;
import com.spss.java_client.ui.doc_types.data.VarViewTable;
import com.spss.java_client.ui.doc_types.doc_util.DocUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.SystemColor;
import java.awt.dnd.DropTarget;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.undo.CompoundEdit;

public class SpssRowHeaderTable
extends JTable
implements Cloneable {
    private static final String[] editContextMenuIds = new String[]{"context_data_cut", "context_data_copy", "context_data_paste", "context_data_clear", "separator", "edit_insert_cases"};
    private static final String[] varContextMenuIds = new String[]{"context_data_copy", "context_data_paste", "context_data_clear", "separator", "edit_insert_variable", "separator", "edit_paste_variables", "separator", "context_var_info", "context_data_descriptives"};
    private JTable mDataTable;
    private DataView mDataView;
    private RowHeaderTableCellRenderer mHeaderRenderer;
    private DataEditContextMenu mEditContextMenu = null;
    private DataEditContextMenu mVarContextMenu = null;
    private boolean mIsPrinting = false;

    public SpssRowHeaderTable(TableModel tableModel, DataView dataView) {
        super(tableModel);
        MouseListener[] mouseListenerArray;
        this.mDataView = dataView;
        TableColumn tableColumn = this.getColumnModel().getColumn(0);
        this.mHeaderRenderer = new RowHeaderTableCellRenderer();
        tableColumn.setCellRenderer(this.mHeaderRenderer);
        this.setFocusable(false);
        this.addKeyListener(new RowHeaderKeyHandler());
        for (MouseListener mouseListener : mouseListenerArray = this.getMouseListeners()) {
            this.removeMouseListener(mouseListener);
        }
        RowSelectionMouseHandler rowSelectionMouseHandler = new RowSelectionMouseHandler();
        this.addMouseListener(rowSelectionMouseHandler);
        this.addMouseMotionListener(rowSelectionMouseHandler);
        TableHeaderMouseHandler tableHeaderMouseHandler = new TableHeaderMouseHandler();
        this.getTableHeader().addMouseMotionListener(tableHeaderMouseHandler);
        this.getTableHeader().addMouseListener(tableHeaderMouseHandler);
    }

    public void connectDataTable(JTable jTable) {
        this.mDataTable = jTable;
        TableRowMoveTransferHandler tableRowMoveTransferHandler = new TableRowMoveTransferHandler();
        TableRowMoveDropTargetHandler tableRowMoveDropTargetHandler = new TableRowMoveDropTargetHandler(this.mDataView.getUndoManager(), this);
        this.setTransferHandler(tableRowMoveTransferHandler);
        new DropTarget(this, 2, tableRowMoveDropTargetHandler, true, null);
        new DropTarget(this.mDataTable, 2, tableRowMoveDropTargetHandler, true, null);
    }

    public void disconnect() {
        this.mDataTable = null;
        this.mDataView = null;
        this.mHeaderRenderer = null;
        this.mEditContextMenu = null;
        this.mVarContextMenu = null;
    }

    public JTable getDataTable() {
        return this.mDataTable;
    }

    public void refreshCurrentRow(long l) {
        this.mHeaderRenderer.setCurrentRow(l);
    }

    public void highlightRow(int n, boolean bl) {
        this.mHeaderRenderer.highlightRow(n, bl);
    }

    public void setPrintMode(boolean bl) {
        this.mIsPrinting = bl;
    }

    public void setHeaderPrintMode(boolean bl) {
        this.mIsPrinting = bl;
        Color color = this.mIsPrinting ? Color.white : UIManager.getColor("TableHeader.background");
        this.getTableHeader().setBackground(color);
    }

    public SpssRowHeaderTable clone() throws CloneNotSupportedException {
        return (SpssRowHeaderTable)super.clone();
    }

    @Override
    public int columnAtPoint(Point point) {
        Rectangle rectangle = this.getBounds();
        if (rectangle.x <= point.x && rectangle.x + rectangle.width >= point.x) {
            return super.columnAtPoint(point);
        }
        Point point2 = SwingUtilities.convertPoint(this, point, this.mDataTable);
        return this.mDataTable.columnAtPoint(point2);
    }

    protected void synchDataTableRows() {
        Container container = this.getParent();
        Container container2 = this.mDataTable.getParent();
        if (container instanceof JViewport && container2 instanceof JViewport) {
            JViewport jViewport = (JViewport)container;
            JViewport jViewport2 = (JViewport)container2;
            Point point = jViewport2.getViewPosition();
            if (point.y != jViewport.getViewPosition().y) {
                point.y = jViewport.getViewPosition().y;
                jViewport2.setViewPosition(point);
            }
        }
    }

    private void initPopup(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            SpssFrame spssFrame = this.mDataView.getUndoManager().getSpssFrame();
            if (this.mDataTable instanceof DataViewTable) {
                SpssAction spssAction;
                if (this.mEditContextMenu == null) {
                    this.mEditContextMenu = new DataEditContextMenu(editContextMenuIds);
                }
                if ((spssAction = DocUtil.getActionFromMenu(this.mEditContextMenu, "context_data_cut")) != null) {
                    spssAction.setEnabled(spssAction.getMenuItemEnableStatus(spssFrame));
                }
                if ((spssAction = DocUtil.getActionFromMenu(this.mEditContextMenu, "context_data_copy")) != null) {
                    spssAction.setEnabled(spssAction.getMenuItemEnableStatus(spssFrame));
                }
                if ((spssAction = DocUtil.getActionFromMenu(this.mEditContextMenu, "context_data_paste")) != null) {
                    spssAction.setEnabled(spssAction.getMenuItemEnableStatus(spssFrame));
                }
                if ((spssAction = DocUtil.getActionFromMenu(this.mEditContextMenu, "context_data_clear")) != null) {
                    spssAction.setEnabled(spssAction.getMenuItemEnableStatus(spssFrame));
                }
                if ((spssAction = DocUtil.getActionFromMenu(this.mEditContextMenu, "edit_insert_cases")) != null) {
                    spssAction.setEnabled(spssAction.getMenuItemEnableStatus(spssFrame));
                }
                this.mEditContextMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            } else if (this.mDataTable instanceof VarViewTable) {
                SpssAction spssAction;
                if (this.mVarContextMenu == null) {
                    this.mVarContextMenu = new DataEditContextMenu(varContextMenuIds);
                }
                if ((spssAction = DocUtil.getActionFromMenu(this.mVarContextMenu, "context_data_copy")) != null) {
                    spssAction.setEnabled(spssAction.getMenuItemEnableStatus(spssFrame));
                }
                if ((spssAction = DocUtil.getActionFromMenu(this.mVarContextMenu, "context_data_paste")) != null) {
                    spssAction.setEnabled(spssAction.getMenuItemEnableStatus(spssFrame));
                }
                if ((spssAction = DocUtil.getActionFromMenu(this.mVarContextMenu, "context_data_clear")) != null) {
                    spssAction.setEnabled(spssAction.getMenuItemEnableStatus(spssFrame));
                }
                if ((spssAction = DocUtil.getActionFromMenu(this.mVarContextMenu, "edit_insert_variable")) != null) {
                    spssAction.setEnabled(spssAction.getMenuItemEnableStatus(spssFrame));
                }
                if ((spssAction = DocUtil.getActionFromMenu(this.mVarContextMenu, "edit_paste_variables")) != null) {
                    spssAction.setEnabled(spssAction.getMenuItemEnableStatus(spssFrame));
                }
                if ((spssAction = DocUtil.getActionFromMenu(this.mVarContextMenu, "context_var_info")) != null) {
                    spssAction.setEnabled(spssAction.getMenuItemEnableStatus(spssFrame));
                }
                if ((spssAction = DocUtil.getActionFromMenu(this.mVarContextMenu, "context_data_descriptives")) != null) {
                    spssAction.setEnabled(spssAction.getMenuItemEnableStatus(spssFrame));
                }
                this.mVarContextMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    class TableHeaderMouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        CompoundEdit mCompEdit;
        int mOrgPointX;
        int mOrgHeaderWidth;

        TableHeaderMouseHandler() {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
            if (jTableHeader.getResizingColumn() != null) {
                int n = mouseEvent.getPoint().x;
                for (int i = 0; i < 2; ++i) {
                    Container container = SpssRowHeaderTable.this.getParent();
                    container.setPreferredSize(new Dimension(this.mOrgHeaderWidth + n - this.mOrgPointX, container.getPreferredSize().height));
                }
                SpssRowHeaderTable.this.mDataView.redrawSplitWnd();
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.mOrgPointX = mouseEvent.getPoint().x;
            JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
            JTable jTable = jTableHeader.getTable();
            this.mOrgHeaderWidth = jTable.getParent().getPreferredSize().width;
            this.mCompEdit = new CompoundEdit();
            SpssRowHeaderTable.this.mDataView.getUndoManager().addEdit(this.mCompEdit);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.mCompEdit != null) {
                this.mCompEdit.end();
            }
            this.mCompEdit = null;
            SpssRowHeaderTable.this.mDataView.updateToolbarEnableStatus();
        }
    }

    class RowSelectionMouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        int mPressedCachedRowIdx = 0;
        int[] mPrevRowsSelected = null;
        boolean mIsRowMoving = false;

        RowSelectionMouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            SpssRowHeaderTable.this.mDataView.commitEdit();
            SpssRowHeaderTable.this.initPopup(mouseEvent);
            this.mIsRowMoving = false;
            JTable jTable = (JTable)mouseEvent.getSource();
            int n = jTable.rowAtPoint(new Point(mouseEvent.getPoint().x, mouseEvent.getPoint().y));
            if ((SpssRowHeaderTable.this.mDataView.getActiveView() == 1 || SpssRowHeaderTable.this.mDataView.getActiveView() == 0) && DataMgr.getDataMgr().isDataFreeClient()) {
                return;
            }
            if (mouseEvent.getClickCount() > 1 && SpssRowHeaderTable.this.mDataView.getActiveView() == 1) {
                SpssRowHeaderTable.this.mDataView.setActiveView(0);
                SpssRowHeaderTable.this.mDataView.selectAndScrollToVariable(0, n);
                return;
            }
            SpssRowHeaderTable.this.mDataTable.requestFocusInWindow();
            if (!SpssRowHeaderTable.this.mDataView.isDividerOn()) {
                SpssRowHeaderTable.this.mDataTable.scrollRectToVisible(SpssRowHeaderTable.this.mDataTable.getCellRect(n, 0, false));
            }
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (int n2 : SpssRowHeaderTable.this.getSelectedRows()) {
                arrayList.add(n2);
            }
            boolean bl = arrayList.contains(n);
            if (!(!bl || DataView.sPrevSelMode != DataView.SelectMode.ROW_SELECT || mouseEvent.getButton() != 1 && mouseEvent.getButton() != 2 || mouseEvent.isControlDown() || mouseEvent.isShiftDown())) {
                TransferHandler transferHandler = SpssRowHeaderTable.this.getTransferHandler();
                transferHandler.exportAsDrag(SpssRowHeaderTable.this, mouseEvent, 2);
                this.mIsRowMoving = true;
                return;
            }
            if (DataView.sPrevSelMode == DataView.SelectMode.ROW_SELECT) {
                if (mouseEvent.isControlDown()) {
                    if (bl) {
                        arrayList.remove((Object)n);
                        SpssRowHeaderTable.this.mDataTable.removeColumnSelectionInterval(SpssRowHeaderTable.this.mDataTable.getColumnCount() - 1, 0);
                        SpssRowHeaderTable.this.mDataTable.removeRowSelectionInterval(n, n);
                        SpssRowHeaderTable.this.removeColumnSelectionInterval(0, 0);
                        SpssRowHeaderTable.this.removeRowSelectionInterval(n, n);
                        if (arrayList.size() > 0) {
                            int n3 = (Integer)arrayList.get(0);
                            SpssRowHeaderTable.this.mDataTable.addColumnSelectionInterval(SpssRowHeaderTable.this.mDataTable.getColumnCount() - 1, 0);
                            SpssRowHeaderTable.this.mDataTable.addRowSelectionInterval(n3, n3);
                            SpssRowHeaderTable.this.addColumnSelectionInterval(0, 0);
                            SpssRowHeaderTable.this.addRowSelectionInterval(n3, n3);
                        }
                    } else {
                        SpssRowHeaderTable.this.mDataTable.addColumnSelectionInterval(SpssRowHeaderTable.this.mDataTable.getColumnCount() - 1, 0);
                        SpssRowHeaderTable.this.mDataTable.addRowSelectionInterval(n, n);
                        this.reselectRowHeader(SpssRowHeaderTable.this.mDataTable.getSelectedRows());
                    }
                } else if (mouseEvent.isShiftDown()) {
                    SpssRowHeaderTable.this.mDataTable.addColumnSelectionInterval(SpssRowHeaderTable.this.mDataTable.getColumnCount() - 1, 0);
                    SpssRowHeaderTable.this.mDataTable.addRowSelectionInterval(this.mPressedCachedRowIdx, n);
                    SpssRowHeaderTable.this.addColumnSelectionInterval(0, 0);
                    SpssRowHeaderTable.this.addRowSelectionInterval(this.mPressedCachedRowIdx, n);
                } else if (mouseEvent.getButton() != 3 || !bl) {
                    SpssRowHeaderTable.this.mDataTable.clearSelection();
                    SpssRowHeaderTable.this.clearSelection();
                    SpssRowHeaderTable.this.mDataTable.setColumnSelectionInterval(SpssRowHeaderTable.this.mDataTable.getColumnCount() - 1, 0);
                    SpssRowHeaderTable.this.mDataTable.setRowSelectionInterval(n, n);
                    SpssRowHeaderTable.this.setColumnSelectionInterval(0, 0);
                    SpssRowHeaderTable.this.setRowSelectionInterval(n, n);
                }
            } else {
                SpssRowHeaderTable.this.clearSelection();
                SpssRowHeaderTable.this.clearSelection();
                SpssRowHeaderTable.this.mDataTable.setColumnSelectionInterval(SpssRowHeaderTable.this.mDataTable.getColumnCount() - 1, 0);
                SpssRowHeaderTable.this.mDataTable.setRowSelectionInterval(n, n);
                SpssRowHeaderTable.this.setColumnSelectionInterval(0, 0);
                SpssRowHeaderTable.this.setRowSelectionInterval(n, n);
            }
            DataView.sPrevSelMode = DataView.SelectMode.ROW_SELECT;
            if (!mouseEvent.isShiftDown()) {
                this.mPressedCachedRowIdx = n;
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.mIsRowMoving) {
                return;
            }
            JTable jTable = (JTable)mouseEvent.getSource();
            int n = jTable.rowAtPoint(new Point(mouseEvent.getPoint().x, mouseEvent.getPoint().y));
            if (n < 0 || n >= SpssRowHeaderTable.this.getRowCount()) {
                return;
            }
            if (DataView.sPrevSelMode == DataView.SelectMode.ROW_SELECT) {
                if (mouseEvent.isControlDown()) {
                    SpssRowHeaderTable.this.mDataTable.setColumnSelectionInterval(SpssRowHeaderTable.this.mDataTable.getColumnCount() - 1, 0);
                    SpssRowHeaderTable.this.mDataTable.setRowSelectionInterval(this.mPressedCachedRowIdx, n);
                    if (this.mPrevRowsSelected != null) {
                        for (int n2 : this.mPrevRowsSelected) {
                            SpssRowHeaderTable.this.mDataTable.addRowSelectionInterval(n2, n2);
                        }
                        this.reselectRowHeader(SpssRowHeaderTable.this.mDataTable.getSelectedRows());
                    }
                } else {
                    SpssRowHeaderTable.this.mDataTable.clearSelection();
                    SpssRowHeaderTable.this.mDataTable.setColumnSelectionInterval(SpssRowHeaderTable.this.mDataTable.getColumnCount() - 1, 0);
                    SpssRowHeaderTable.this.mDataTable.setRowSelectionInterval(this.mPressedCachedRowIdx, n);
                    SpssRowHeaderTable.this.clearSelection();
                    SpssRowHeaderTable.this.setColumnSelectionInterval(0, 0);
                    SpssRowHeaderTable.this.setRowSelectionInterval(this.mPressedCachedRowIdx, n);
                }
                SpssRowHeaderTable.this.synchDataTableRows();
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.mIsRowMoving = false;
            this.mPrevRowsSelected = SpssRowHeaderTable.this.mDataTable.getSelectedRows();
            SpssRowHeaderTable.this.initPopup(mouseEvent);
        }

        private void reselectRowHeader(int[] nArray) {
            SpssRowHeaderTable.this.clearSelection();
            SpssRowHeaderTable.this.setColumnSelectionInterval(0, 0);
            for (int n : nArray) {
                SpssRowHeaderTable.this.addRowSelectionInterval(n, n);
            }
        }
    }

    class RowHeaderKeyHandler
    extends KeyAdapter {
        RowHeaderKeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.isShiftDown()) {
                if (keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 40) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            int[] nArray;
                            SpssRowHeaderTable.this.mDataTable.clearSelection();
                            int n = SpssRowHeaderTable.this.mDataTable.getColumnCount();
                            SpssRowHeaderTable.this.mDataTable.setColumnSelectionInterval(0, n - 1);
                            for (int n2 : nArray = SpssRowHeaderTable.this.getSelectedRows()) {
                                SpssRowHeaderTable.this.mDataTable.addRowSelectionInterval(n2, n2);
                            }
                            SpssRowHeaderTable.this.synchDataTableRows();
                        }
                    });
                }
            } else if (!(keyEvent.isControlDown() || keyEvent.getKeyCode() != 38 && keyEvent.getKeyCode() != 40)) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int n = SpssRowHeaderTable.this.getSelectedRow();
                        SpssRowHeaderTable.this.mDataTable.setRowSelectionInterval(n, n);
                        SpssRowHeaderTable.this.synchDataTableRows();
                    }
                });
            }
        }
    }

    class HighlightBevelBorder
    extends BevelBorder {
        private Color mHighlightColor;
        private Stroke mStroke;

        HighlightBevelBorder() {
            super(0);
            this.mHighlightColor = new Color(156, 0, 0);
            this.mStroke = new BasicStroke(1.0f);
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            super.paintBorder(component, graphics, n, n2, n3, n4);
            if (graphics instanceof Graphics2D) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                Color color = graphics.getColor();
                Stroke stroke = graphics2D.getStroke();
                graphics.setColor(this.mHighlightColor);
                graphics2D.setStroke(this.mStroke);
                graphics.drawLine(n, n2 + 1, n + n3, n2 + 1);
                graphics2D.setStroke(stroke);
                graphics.setColor(color);
            }
        }
    }

    class RowHeaderTableCellRenderer
    extends DefaultTableCellRenderer {
        private int mHighlightRow = -1;
        private long mRenderRow = -1L;
        private long mCurrentRow = -1L;
        private Border mDefaultBorder;
        private Border mCurrentCellBorder;
        private Border mHighlightBorder;

        public RowHeaderTableCellRenderer() {
            this.updateBorders();
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (SpssRowHeaderTable.this.mIsPrinting) {
                this.setBackground(Color.white);
                this.setText(object == null ? "" : object.toString());
                this.setHorizontalAlignment(0);
                this.setOpaque(true);
                return this;
            }
            if (SpssRowHeaderTable.this.mDataView == null) {
                return null;
            }
            if (jTable != null && SpssRowHeaderTable.this.mDataView.getDataSrc() != null) {
                boolean bl3 = SpssRowHeaderTable.this.mDataView.getActiveView() == 0;
                int n3 = bl3 ? (int)SpssRowHeaderTable.this.mDataView.getDataSrc().rowCount() : SpssRowHeaderTable.this.mDataView.getDataSrc().columnCount();
                JTableHeader jTableHeader = jTable.getTableHeader();
                if (jTableHeader != null) {
                    if (bl) {
                        if (n < n3) {
                            this.setForeground(jTable.getSelectionForeground());
                        } else {
                            this.setForeground(SystemColor.textInactiveText);
                        }
                        this.setBackground(jTable.getSelectionBackground());
                    } else {
                        if (n < n3) {
                            this.setForeground(jTableHeader.getForeground());
                        } else {
                            this.setForeground(SystemColor.textInactiveText);
                        }
                        this.setBackground(jTableHeader.getBackground());
                    }
                }
            }
            this.mRenderRow = n;
            this.setFont(SpssRowHeaderTable.this.getFont());
            this.setText(object == null ? "" : object.toString());
            this.setBorder(n);
            this.setHorizontalAlignment(0);
            return this;
        }

        @Override
        public void setText(String string) {
            if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                super.setText(ComponentState.prepareStringForBidiRendering((String)string));
            } else {
                super.setText(string);
            }
        }

        @Override
        public void setToolTipText(String string) {
            if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                super.setToolTipText(ComponentState.prepareStringForBidiRendering((String)string));
            } else {
                super.setToolTipText(string);
            }
        }

        void setCurrentRow(long l) {
            Rectangle rectangle;
            if (this.mCurrentRow == l) {
                return;
            }
            if (this.mCurrentRow > -1L) {
                rectangle = SpssRowHeaderTable.this.getCellRect((int)this.mCurrentRow, 0, true);
                SpssRowHeaderTable.this.repaint(100L, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            if (l > -1L) {
                rectangle = SpssRowHeaderTable.this.getCellRect((int)l, 0, true);
                SpssRowHeaderTable.this.repaint(100L, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            this.mCurrentRow = l;
        }

        void highlightRow(int n, boolean bl) {
            int n2;
            int n3 = n2 = n > -1 ? n : this.mHighlightRow;
            if (n2 == -1) {
                return;
            }
            this.mHighlightRow = bl ? n : -1;
            Rectangle rectangle = SpssRowHeaderTable.this.mDataTable.getVisibleRect();
            Rectangle rectangle2 = SpssRowHeaderTable.this.mDataTable.getCellRect(n2, 0, true);
            SpssRowHeaderTable.this.paintImmediately(rectangle2);
            int n4 = rectangle2.y;
            if (n4 >= rectangle.y && n4 <= rectangle.y + rectangle.height) {
                Graphics graphics = SpssRowHeaderTable.this.mDataTable.getGraphics();
                graphics.setColor(bl ? new Color(156, 0, 0) : SpssRowHeaderTable.this.getGridColor());
                graphics.drawLine(rectangle.x, n4, rectangle.x + rectangle.width, n4);
                graphics.dispose();
            }
        }

        protected void setBorder(int n) {
            boolean bl;
            Border border = this.mDefaultBorder;
            boolean bl2 = bl = SpssRowHeaderTable.this.mDataTable.getSelectionModel().getLeadSelectionIndex() == n;
            if (this.mHighlightRow == n) {
                border = this.mHighlightBorder;
            } else if (bl) {
                border = this.mCurrentCellBorder;
                this.mCurrentRow = n;
            }
            this.setBorder(border);
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            ISpssDataSrc iSpssDataSrc = SpssRowHeaderTable.this.mDataView.getDataSrc();
            if (SpssRowHeaderTable.this.mDataView.getActiveView() == 0 && iSpssDataSrc != null && iSpssDataSrc.isCaseFiltered(this.mRenderRow)) {
                Rectangle rectangle = this.getBounds();
                Color color = graphics.getColor();
                graphics.setColor(Color.black);
                graphics.drawLine(0, rectangle.height, rectangle.width, 0);
                graphics.setColor(color);
            }
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.updateBorders();
        }

        private void updateBorders() {
            this.mDefaultBorder = UIManager.getBorder("TableHeader.cellBorder");
            this.mCurrentCellBorder = BorderFactory.createEtchedBorder(1);
            this.mHighlightBorder = new HighlightBevelBorder();
        }
    }
}

