/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.data;

import com.spss.java_client.core.documents.data.dictionary.DisplayAlignment;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.ui.doc_types.data.DataCellEdit;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.doc_types.data.DataTableCellRenderer;
import com.spss.java_client.ui.doc_types.data.DataView;
import java.util.HashMap;
import java.util.Map;
import javax.swing.table.TableCellEditor;

public class FormatCellProvider {
    private DataFrame mFrame = null;
    private HashMap<Integer, FormatHolder> mEditorRenderers = new HashMap();

    public FormatCellProvider(DataFrame dataFrame) {
        this.mFrame = dataFrame;
    }

    public DataTableCellRenderer getCellRenderer(ISpssVariable iSpssVariable) {
        SPSS_Format sPSS_Format = iSpssVariable.getFormat();
        int n = sPSS_Format.asInt();
        if (!this.mEditorRenderers.containsKey(n)) {
            FormatHolder formatHolder = this.allocateFormatHolder(iSpssVariable);
            this.mEditorRenderers.put(n, formatHolder);
        }
        return this.mEditorRenderers.get((Object)Integer.valueOf((int)n)).mCellRenderer;
    }

    public TableCellEditor getCellEditor(ISpssVariable iSpssVariable) {
        SPSS_Format sPSS_Format = iSpssVariable.getFormat();
        int n = sPSS_Format.asInt();
        if (!this.mEditorRenderers.containsKey(n)) {
            FormatHolder formatHolder = this.allocateFormatHolder(iSpssVariable);
            this.mEditorRenderers.put(n, formatHolder);
        }
        return this.mEditorRenderers.get((Object)Integer.valueOf((int)n)).mCellEditor;
    }

    public void clear() {
        for (Map.Entry<Integer, FormatHolder> entry : this.mEditorRenderers.entrySet()) {
            entry.getValue().dispose();
        }
        this.mEditorRenderers.clear();
    }

    private FormatHolder allocateFormatHolder(ISpssVariable iSpssVariable) {
        DataTableCellRenderer dataTableCellRenderer = new DataTableCellRenderer(this.mFrame, iSpssVariable);
        dataTableCellRenderer.setVerticalAlignment(1);
        DataView dataView = this.mFrame.getDataView();
        DataCellEdit dataCellEdit = new DataCellEdit(dataView.getDataSrc(), iSpssVariable.getFormat());
        dataCellEdit.setBorder(null);
        int n = 4;
        DisplayAlignment displayAlignment = iSpssVariable.getDisplayAlignment();
        if (displayAlignment.equals((Object)DisplayAlignment.left)) {
            n = 2;
        } else if (displayAlignment.equals((Object)DisplayAlignment.center)) {
            n = 0;
        }
        dataCellEdit.setHorizontalAlignment(n);
        DataView dataView2 = dataView;
        dataView2.getClass();
        DataView.DataCellEditor dataCellEditor = dataView2.new DataView.DataCellEditor(dataCellEdit, dataView.getDataTable(0));
        return new FormatHolder(dataTableCellRenderer, dataCellEditor);
    }

    class FormatHolder {
        DataTableCellRenderer mCellRenderer = null;
        TableCellEditor mCellEditor = null;

        public FormatHolder(DataTableCellRenderer dataTableCellRenderer, TableCellEditor tableCellEditor) {
            this.mCellRenderer = dataTableCellRenderer;
            this.mCellEditor = tableCellEditor;
        }

        public void dispose() {
            this.mCellRenderer = null;
            this.mCellEditor = null;
        }
    }
}

