/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.data;

import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.ORIGINATOR_ID;
import com.spss.java_client.core.documents.data.dictionary.ExtensionType;
import com.spss.java_client.core.documents.data.dictionary.IDatasetViewObserver;
import com.spss.java_client.core.server.messages.DataEditorMsg.CellValue;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.doc_types.data.DataView;
import com.spss.uitools.util.TraceSettings;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class DatasetViewObserver
implements IDatasetViewObserver {
    private DataView mDataView = null;

    public void setDataView(DataView dataView) {
        this.mDataView = dataView;
    }

    public DataView getDataView() {
        return this.mDataView;
    }

    public void notifyCloseDataSet(final LocallyUniqueId locallyUniqueId) {
        if (SwingUtilities.isEventDispatchThread()) {
            if (!this.prologue()) {
                DataFrame dataFrame;
                if (CommandLine.isExternalCaller() && (dataFrame = SpssFrameMgr.getSpssFrameMgr().getDataFrame(locallyUniqueId)) != null) {
                    dataFrame.doDocumentClose();
                }
                return;
            }
            this.mDataView.notifyCloseDataSetImpl(locallyUniqueId);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!DatasetViewObserver.this.prologue()) {
                        return;
                    }
                    DatasetViewObserver.this.mDataView.notifyCloseDataSetImpl(locallyUniqueId);
                }
            });
        }
    }

    public void notifyStartOfDictionaryMods() {
        if (SwingUtilities.isEventDispatchThread()) {
            if (!this.prologue()) {
                return;
            }
            this.mDataView.notifyStartOfDictionaryModsImpl();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!DatasetViewObserver.this.prologue()) {
                        return;
                    }
                    DatasetViewObserver.this.mDataView.notifyStartOfDictionaryModsImpl();
                }
            });
        }
    }

    public void notifyEndOfDictionaryMods() {
        if (SwingUtilities.isEventDispatchThread()) {
            if (!this.prologue()) {
                return;
            }
            this.mDataView.notifyEndOfDictionaryModsImpl();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!DatasetViewObserver.this.prologue()) {
                        return;
                    }
                    DatasetViewObserver.this.mDataView.notifyEndOfDictionaryModsImpl();
                }
            });
        }
    }

    public void notifyVariableInserted(final int n, final ORIGINATOR_ID oRIGINATOR_ID) {
        if (SwingUtilities.isEventDispatchThread()) {
            if (!this.prologue()) {
                return;
            }
            this.mDataView.notifyVariableInsertedImpl(n, oRIGINATOR_ID);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!DatasetViewObserver.this.prologue()) {
                        return;
                    }
                    DatasetViewObserver.this.mDataView.notifyVariableInsertedImpl(n, oRIGINATOR_ID);
                }
            });
        }
    }

    public void notifyVariablesInserted(Vector<Integer> vector, ORIGINATOR_ID oRIGINATOR_ID) {
        if (SwingUtilities.isEventDispatchThread()) {
            if (!this.prologue()) {
                return;
            }
            this.mDataView.notifyVariablesInsertedImpl(vector, oRIGINATOR_ID);
        } else {
            final Vector vector2 = (Vector)vector.clone();
            final ORIGINATOR_ID oRIGINATOR_ID2 = oRIGINATOR_ID;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!DatasetViewObserver.this.prologue()) {
                        return;
                    }
                    DatasetViewObserver.this.mDataView.notifyVariablesInsertedImpl(vector2, oRIGINATOR_ID2);
                }
            });
        }
    }

    public void notifyVariableModified(final ORIGINATOR_ID oRIGINATOR_ID, final int n) {
        if (SwingUtilities.isEventDispatchThread()) {
            if (!this.prologue()) {
                return;
            }
            this.mDataView.notifyVariableModifiedImpl(n, oRIGINATOR_ID);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!DatasetViewObserver.this.prologue()) {
                        return;
                    }
                    DatasetViewObserver.this.mDataView.notifyVariableModifiedImpl(n, oRIGINATOR_ID);
                }
            });
        }
    }

    public void notifyDatasetAttributesModified(final ExtensionType extensionType) {
        if (SwingUtilities.isEventDispatchThread()) {
            if (!this.prologue()) {
                return;
            }
            this.mDataView.notifyDatasetAttributesModified(extensionType);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!DatasetViewObserver.this.prologue()) {
                        return;
                    }
                    DatasetViewObserver.this.mDataView.notifyDatasetAttributesModified(extensionType);
                }
            });
        }
    }

    public void notifyVariablesDeleted(final int n, final int n2, final int n3, final ORIGINATOR_ID oRIGINATOR_ID) {
        if (SwingUtilities.isEventDispatchThread()) {
            if (!this.prologue()) {
                return;
            }
            this.mDataView.notifyVariablesDeletedImpl(n, n2, n3, oRIGINATOR_ID);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!DatasetViewObserver.this.prologue()) {
                        return;
                    }
                    DatasetViewObserver.this.mDataView.notifyVariablesDeletedImpl(n, n2, n3, oRIGINATOR_ID);
                }
            });
        }
    }

    public void notifyVariablesMoved(final int n, final int n2, final int n3) {
        if (SwingUtilities.isEventDispatchThread()) {
            if (!this.prologue()) {
                return;
            }
            this.mDataView.notifyVariablesMovedImpl(n, n2, n3);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!DatasetViewObserver.this.prologue()) {
                        return;
                    }
                    DatasetViewObserver.this.mDataView.notifyVariablesMovedImpl(n, n2, n3);
                }
            });
        }
    }

    public void notifyDataModified(final ORIGINATOR_ID oRIGINATOR_ID) {
        if (SwingUtilities.isEventDispatchThread()) {
            if (!this.prologue()) {
                return;
            }
            this.mDataView.notifyDataModifiedImpl(oRIGINATOR_ID);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!DatasetViewObserver.this.prologue()) {
                        return;
                    }
                    DatasetViewObserver.this.mDataView.notifyDataModifiedImpl(oRIGINATOR_ID);
                }
            });
        }
    }

    public void notifyNewRows(final long l, final long l2) {
        if (SwingUtilities.isEventDispatchThread()) {
            if (!this.prologue()) {
                return;
            }
            this.mDataView.notifyNewRowsImpl(l, l2);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!DatasetViewObserver.this.prologue()) {
                        return;
                    }
                    DatasetViewObserver.this.mDataView.notifyNewRowsImpl(l, l2);
                }
            });
        }
    }

    public void notifyRowCountEstablished(ORIGINATOR_ID oRIGINATOR_ID) {
        if (SwingUtilities.isEventDispatchThread()) {
            if (!this.prologue()) {
                return;
            }
            this.mDataView.notifyRowCountEstablishedImpl();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!DatasetViewObserver.this.prologue()) {
                        return;
                    }
                    DatasetViewObserver.this.mDataView.notifyRowCountEstablishedImpl();
                }
            });
        }
    }

    public void notifyResetUndo() {
        if (SwingUtilities.isEventDispatchThread()) {
            if (!this.prologue()) {
                return;
            }
            this.mDataView.notifyResetUndoImpl();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!DatasetViewObserver.this.prologue()) {
                        return;
                    }
                    DatasetViewObserver.this.mDataView.notifyResetUndoImpl();
                }
            });
        }
    }

    public void notifyFileName(final String string, final boolean bl) {
        if (SwingUtilities.isEventDispatchThread()) {
            if (!this.prologue()) {
                return;
            }
            this.mDataView.notifyFileNameImpl(string, bl);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!DatasetViewObserver.this.prologue()) {
                        return;
                    }
                    DatasetViewObserver.this.mDataView.notifyFileNameImpl(string, bl);
                }
            });
        }
    }

    public void notifyCellValueFound(final int n, final long l, final String string) {
        if (SwingUtilities.isEventDispatchThread()) {
            if (!this.prologue()) {
                return;
            }
            this.mDataView.notifyCellValueFoundImpl(n, l, string);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!DatasetViewObserver.this.prologue()) {
                        return;
                    }
                    DatasetViewObserver.this.mDataView.notifyCellValueFoundImpl(n, l, string);
                }
            });
        }
    }

    public void notifyStopFind(final boolean bl) {
        if (SwingUtilities.isEventDispatchThread()) {
            if (!this.prologue()) {
                return;
            }
            this.mDataView.notifyStopFindImpl(bl);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!DatasetViewObserver.this.prologue()) {
                        return;
                    }
                    DatasetViewObserver.this.mDataView.notifyStopFindImpl(bl);
                }
            });
        }
    }

    public void notifyReplaceResult(Vector<CellValue> vector) {
        if (SwingUtilities.isEventDispatchThread()) {
            if (!this.prologue()) {
                return;
            }
            this.mDataView.notifyReplaceResultImpl(vector);
        } else {
            final Vector vector2 = (Vector)vector.clone();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!DatasetViewObserver.this.prologue()) {
                        return;
                    }
                    DatasetViewObserver.this.mDataView.notifyReplaceResultImpl(vector2);
                }
            });
        }
    }

    public void notifyWeightVar(final int n) {
        if (SwingUtilities.isEventDispatchThread()) {
            if (!this.prologue()) {
                return;
            }
            this.mDataView.notifyWeightVarImpl(n);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!DatasetViewObserver.this.prologue()) {
                        return;
                    }
                    DatasetViewObserver.this.mDataView.notifyWeightVarImpl(n);
                }
            });
        }
    }

    public void notifyFilterVar(final int n) {
        if (SwingUtilities.isEventDispatchThread()) {
            if (!this.prologue()) {
                return;
            }
            this.mDataView.notifyFilterVarImpl(n);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!DatasetViewObserver.this.prologue()) {
                        return;
                    }
                    DatasetViewObserver.this.mDataView.notifyFilterVarImpl(n);
                }
            });
        }
    }

    public void notifyTrendsInfo() {
        if (SwingUtilities.isEventDispatchThread()) {
            if (!this.prologue()) {
                return;
            }
            this.mDataView.notifyTrendsInfoImpl();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!DatasetViewObserver.this.prologue()) {
                        return;
                    }
                    DatasetViewObserver.this.mDataView.notifyTrendsInfoImpl();
                }
            });
        }
    }

    public void notifySplitFile(final boolean bl) {
        if (SwingUtilities.isEventDispatchThread()) {
            if (!this.prologue()) {
                return;
            }
            this.mDataView.notifySplitFileImpl(bl);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!DatasetViewObserver.this.prologue()) {
                        return;
                    }
                    DatasetViewObserver.this.mDataView.notifySplitFileImpl(bl);
                }
            });
        }
    }

    public void notifyPendingTransformation(final LocallyUniqueId locallyUniqueId, final boolean bl) {
        if (SwingUtilities.isEventDispatchThread()) {
            if (!this.prologue()) {
                return;
            }
            this.mDataView.notifyPendingTransformationImpl(locallyUniqueId, bl);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!DatasetViewObserver.this.prologue()) {
                        return;
                    }
                    DatasetViewObserver.this.mDataView.notifyPendingTransformationImpl(locallyUniqueId, bl);
                }
            });
        }
    }

    public void notifyVariableSetsChange(Vector<String> vector) {
        if (SwingUtilities.isEventDispatchThread()) {
            if (!this.prologue()) {
                return;
            }
            this.mDataView.notifyVariableSetsChangeImpl();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!DatasetViewObserver.this.prologue()) {
                        return;
                    }
                    DatasetViewObserver.this.mDataView.notifyVariableSetsChangeImpl();
                }
            });
        }
    }

    public void notifyImputationInfo() {
        if (SwingUtilities.isEventDispatchThread()) {
            if (!this.prologue()) {
                return;
            }
            this.mDataView.notifyImputationInfoImpl();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!DatasetViewObserver.this.prologue()) {
                        return;
                    }
                    DatasetViewObserver.this.mDataView.notifyImputationInfoImpl();
                }
            });
        }
    }

    public void notifyImputationDisplayChange() {
        if (SwingUtilities.isEventDispatchThread()) {
            if (!this.prologue()) {
                return;
            }
            this.mDataView.notifyImputationDisplayChangeImpl();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!DatasetViewObserver.this.prologue()) {
                        return;
                    }
                    DatasetViewObserver.this.mDataView.notifyImputationDisplayChangeImpl();
                }
            });
        }
    }

    public void setDirtyFlag(final boolean bl) {
        if (SwingUtilities.isEventDispatchThread()) {
            if (!this.prologue()) {
                return;
            }
            this.mDataView.setDirtyFlagImpl(bl);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!DatasetViewObserver.this.prologue()) {
                        return;
                    }
                    DatasetViewObserver.this.mDataView.setDirtyFlagImpl(bl);
                }
            });
        }
    }

    private boolean prologue() {
        try {
            if (this.mDataView == null) {
                if (!CommandLine.isExternalCaller()) {
                    TraceSettings.trace1((String)"==> mDataView is null in DatasetViewObserver.prologue()", (int)15);
                }
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        catch (AssertionError assertionError) {
            ((Throwable)((Object)assertionError)).printStackTrace();
            return false;
        }
        return true;
    }
}

