/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.data;

import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.cache.ICacheObserver;
import com.spss.java_client.core.documents.data.dictionary.ColumnDataProvider;
import com.spss.java_client.core.documents.data.dictionary.FormatType;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.core.server.messages.DataEditorMsg.RowRange;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.doc_types.data.DataView;
import com.spss.java_client.ui.doc_types.data.DataViewTable;
import com.spss.java_client.ui.doc_types.data.undo.RowInsertEdit;
import com.spss.java_client.ui.doc_types.data.undo.TableValueUpdateEdit;
import com.spss.java_client.ui.doc_types.data.undo.VariableInsertEdit;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.java_client.ui.undo.SpssUndoManager;
import com.spss.shared.core_tools.dictionary.IDataSrc;
import com.spss.shared.core_tools.format.CellValueFormatter;
import com.spss.shared.core_tools.format.ValueFormatter;
import com.spss.uitools.util.TraceSettings;
import java.awt.Toolkit;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.undo.CompoundEdit;

public class DataViewTableModel
extends AbstractTableModel
implements ICacheObserver {
    public static final int MAX_VIEWABLE_ROWS = 80000000;
    private static final String DEFAULT_COL_TITLE = ResUtil.getString("IDS_VAR");
    private static final String SYSMIS_STRING = ResUtil.getComponentString("IDS_MISSING_OBS");
    private static final String INDETERMINATE_STRING = ResUtil.getComponentString("IDS_INDETERMINATE_OBS");
    private static final int DEF_ROWS = 40;
    private static final double DATE_MINIMUM = 86400.0;
    private ISpssDataSrc mDataSource = null;
    private boolean mReadOnly = false;
    private SpssUndoManager mUndoManager;
    private int mLargestUnknownRow = 0;

    public static int getDisplayableRowCount(int n) {
        return Math.min(n, 80000000);
    }

    public void connectData(LocallyUniqueId locallyUniqueId) {
        this.mDataSource = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        if (this.mDataSource != null) {
            if (!CommandLine.isExternalCaller()) {
                this.mDataSource.getCacheMgr().addObserver((ICacheObserver)this);
            }
        } else assert (false);
    }

    public void disconnect() {
        if (this.mDataSource != null) {
            if (!CommandLine.isExternalCaller()) {
                this.mDataSource.getCacheMgr().removeObserver((ICacheObserver)this);
            }
            this.mDataSource = null;
        }
    }

    public boolean isReadOnly() {
        return this.mReadOnly;
    }

    public void setReadOnly(boolean bl) {
        this.mReadOnly = bl;
    }

    @Override
    public int getRowCount() {
        if (DataMgr.getDataMgr().isDataFreeClient()) {
            return 1;
        }
        if (this.mDataSource == null) {
            return 40;
        }
        int n = (int)this.mDataSource.rowCount();
        if (n < 0) {
            n = this.mLargestUnknownRow;
        }
        return DataViewTableModel.getDisplayableRowCount(n + 40);
    }

    @Override
    public int getColumnCount() {
        if (DataMgr.getDataMgr().isDataFreeClient()) {
            return 1;
        }
        int n = 20;
        if (this.mDataSource == null || this.mDataSource.columnCount() + 1 < n) {
            return n;
        }
        return this.mDataSource.columnCount() + n / 2;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        OBS oBS;
        if (DataMgr.getDataMgr().isDataFreeClient()) {
            String string = ResUtil.getString("ERR_DATA_FREE_CLIENT_MSG");
            return string;
        }
        if (this.mDataSource == null || !this.mDataSource.isVariableInCurrentSet(n2)) {
            return "";
        }
        if (this.mDataSource.rowCount() > 80000000L && n + 20 > 80000000) {
            ((DataFrame)this.mUndoManager.getSpssFrame()).getDataView().notifyMaxRowLimit();
        }
        OBS oBS2 = oBS = this.mDataSource != null && !CommandLine.isExternalCaller() ? this.mDataSource.getCacheMgr().getCellValue((long)n, n2) : null;
        if (oBS == null) {
            return "";
        }
        if (this.mDataSource.rowCount() < 0L) {
            int n3 = this.mLargestUnknownRow;
            this.mLargestUnknownRow = Math.max(n, this.mLargestUnknownRow);
            if (n3 < this.mLargestUnknownRow) {
                this.fireTableRowsInserted(n3 + 40, this.mLargestUnknownRow + 40);
            }
        }
        if (oBS.isString()) {
            return oBS.getString();
        }
        if (oBS.isMissing((IDataSrc)this.mDataSource)) {
            return SYSMIS_STRING;
        }
        return oBS.getNum();
    }

    void setValueAt(DataViewTable dataViewTable, Object object, int n, int n2) {
        OBS oBS;
        if (this.mDataSource == null || CommandLine.isExternalCaller() || this.mReadOnly || n < 0 || n2 < 0) {
            return;
        }
        if (this.mDataSource.getCacheMgr().getCacheState()) {
            oBS = this.mDataSource.getCacheMgr().getCellValue((long)n, n2);
        } else {
            ColumnDataProvider columnDataProvider = new ColumnDataProvider(this.mDataSource);
            oBS = columnDataProvider.getColumnValue(n2, (long)n);
        }
        this.setValueAt(dataViewTable, object, oBS, n, n2);
    }

    void setValueAt(DataViewTable dataViewTable, Object object, OBS oBS, int n, int n2) {
        boolean bl = object == null || object.toString().length() == 0 || object instanceof Double && ((Double)object).doubleValue() == this.mDataSource.getSystemMissing();
        long l = DataViewTableModel.getDisplayableRowCount((int)this.mDataSource.rowCount());
        if (bl && l > -1L && ((long)n >= l || n2 >= this.mDataSource.columnCount())) {
            return;
        }
        if (!dataViewTable.getDataView().canChangeCellValue()) {
            return;
        }
        if (n2 >= this.mDataSource.columnCount() && !dataViewTable.getDataView().canAddNewVariable()) {
            return;
        }
        DataFrame dataFrame = (DataFrame)this.mUndoManager.getSpssFrame();
        CompoundEdit compoundEdit = null;
        if (l > -1L && (long)n >= l) {
            if (!dataFrame.checkDataLimit(true, (long)n - this.mDataSource.rowCount() + 1L)) {
                return;
            }
            if (compoundEdit == null) {
                compoundEdit = new CompoundEdit();
                this.mUndoManager.addEdit(compoundEdit);
            }
            this.addRows(DataViewTableModel.getDisplayableRowCount((int)((long)n - this.mDataSource.rowCount() + 1L)));
        }
        if (n2 >= this.mDataSource.columnCount()) {
            if (!dataFrame.checkDataLimit(false, n2 - this.mDataSource.columnCount() + 1)) {
                return;
            }
            if (compoundEdit == null) {
                compoundEdit = new CompoundEdit();
                this.mUndoManager.addEdit(compoundEdit);
            }
            this.addColumnsForValue(object, n2 - this.mDataSource.columnCount() + 1);
        }
        OBS oBS2 = null;
        boolean bl2 = true;
        boolean bl3 = this.isDoubleCol(n2);
        try {
            if (object == null || object.toString().trim().length() == 0 || bl3 && object.toString().equals(SYSMIS_STRING)) {
                oBS2 = bl3 ? new OBS(this.mDataSource.getSystemMissing()) : new OBS("");
            } else if (bl3) {
                ISpssVariable iSpssVariable = this.mDataSource.getVariable(n2);
                SPSS_Format sPSS_Format = iSpssVariable.getFormat();
                if (object instanceof Date) {
                    Date date = (Date)object;
                    FormatType formatType = sPSS_Format.getFormatType();
                    if (formatType == FormatType.WKDAY) {
                        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT-00:00"));
                        calendar.setTime(date);
                        oBS2 = new OBS((double)calendar.get(7));
                    } else if (formatType == FormatType.MONTH) {
                        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT-00:00"));
                        calendar.setTime(date);
                        oBS2 = new OBS((double)(calendar.get(2) + 1));
                    } else {
                        long l2 = date.getTime();
                        double d = ValueFormatter.convertJavaDateLongToDouble((long)l2);
                        if (!DataViewTableModel.legalDateValue(this.mDataSource, d, sPSS_Format)) {
                            bl2 = false;
                        } else {
                            oBS2 = new OBS(d);
                        }
                    }
                } else {
                    oBS2 = new OBS();
                    if (object instanceof Double || object instanceof Long) {
                        double d;
                        double d2 = d = object instanceof Long ? (double)((Long)object).longValue() : (Double)object;
                        if (this.isDateCol(n2) && !DataViewTableModel.legalDateValue(this.mDataSource, d, sPSS_Format)) {
                            bl2 = false;
                        } else {
                            oBS2.setNum(d);
                            bl2 = true;
                        }
                    } else {
                        bl2 = CellValueFormatter.stringToObs((String)object.toString(), (SPSS_Format)sPSS_Format, (OBS)oBS2);
                    }
                }
            } else {
                if (object instanceof Double && object.equals(this.mDataSource.getSystemMissing())) {
                    object = "";
                }
                oBS2 = new OBS(object.toString());
            }
        }
        catch (NumberFormatException numberFormatException) {
            oBS2 = new OBS(this.mDataSource.getSystemMissing());
        }
        if (bl2) {
            if (!oBS2.equals((Object)oBS)) {
                new TableValueUpdateEdit(dataViewTable, this.mDataSource, oBS, oBS2, n, n2);
                this.fireTableCellUpdated(n, n2);
                if (compoundEdit != null) {
                    compoundEdit.end();
                }
            } else if (compoundEdit != null) {
                compoundEdit.die();
            }
        } else {
            Toolkit.getDefaultToolkit().beep();
            if (compoundEdit != null) {
                compoundEdit.die();
            }
        }
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        try {
            TraceSettings.trace1((String)"Invalid setValueAt() method called", (int)15);
            assert (false);
        }
        catch (AssertionError assertionError) {
            ((Throwable)((Object)assertionError)).printStackTrace();
        }
    }

    public boolean isDoubleCol(int n) {
        boolean bl = true;
        ISpssVariable iSpssVariable = this.mDataSource.getVariable(n);
        if (iSpssVariable != null && iSpssVariable.getType() > 0) {
            bl = false;
        }
        return bl;
    }

    public boolean isDateCol(int n) {
        boolean bl = false;
        ISpssVariable iSpssVariable = this.mDataSource.getVariable(n);
        if (iSpssVariable != null && iSpssVariable.getType() == 0) {
            SPSS_Format sPSS_Format = iSpssVariable.getFormat();
            bl = sPSS_Format.getFormatType().isDateOrTimeFormat();
        }
        return bl;
    }

    public static String getIndterminateString() {
        return INDETERMINATE_STRING;
    }

    public static String getSysmisString() {
        return SYSMIS_STRING;
    }

    public static double getDateMinimum() {
        return 86400.0;
    }

    public static boolean legalDateValue(ISpssDataSrc iSpssDataSrc, double d, SPSS_Format sPSS_Format) {
        boolean bl = false;
        if (iSpssDataSrc != null && sPSS_Format != null) {
            if (d == iSpssDataSrc.getSystemMissing()) {
                bl = true;
            } else {
                FormatType formatType = sPSS_Format.getFormatType();
                if ((formatType == FormatType.TIME || formatType == FormatType.MTIME || formatType == FormatType.DTIME) && d < 0.0) {
                    bl = true;
                } else if (formatType == FormatType.MONTH || formatType == FormatType.WKDAY) {
                    if (formatType == FormatType.MONTH) {
                        bl = d >= 0.0 && d < 13.0 || d >= 86400.0;
                    } else if (formatType == FormatType.WKDAY) {
                        bl = d >= 0.0 && d <= 7.0 || d >= 86400.0;
                    }
                } else {
                    boolean bl2 = formatType == FormatType.TIME || formatType == FormatType.MTIME || formatType == FormatType.DTIME || formatType == FormatType.WKDAY || formatType == FormatType.MONTH;
                    double d2 = bl2 ? 0.0 : 86400.0;
                    bl = d >= d2;
                }
            }
        }
        return bl;
    }

    @Override
    public String getColumnName(int n) {
        ISpssVariable iSpssVariable;
        ISpssVariable iSpssVariable2 = iSpssVariable = this.mDataSource != null ? this.mDataSource.getVariable(n) : null;
        if (iSpssVariable == null) {
            return DEFAULT_COL_TITLE;
        }
        return iSpssVariable.getName();
    }

    public Class<String> getColumnClass(int n) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        boolean bl = true;
        ISpssVariable iSpssVariable = this.mDataSource.getVariable(n2);
        if (iSpssVariable != null && DataView.isLockedHiddenVariable(iSpssVariable.getName())) {
            bl = false;
        }
        return bl && !this.mReadOnly;
    }

    public void notifyNewRows(long l, long l2) {
        this.fireTableRowsInserted((int)l, (int)l2);
    }

    public void rowsCached(final RowRange rowRange) {
        if (this.mUndoManager.getSpssFrame().isPrinting()) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ComponentState.getTrace((int)8192)) {
                    String string = "Server row update: StartRow(" + rowRange.getStartOfRange() + "), EndRow(" + rowRange.getEndOfRange() + ")";
                    ComponentState.trace1((String)string, (int)8192);
                }
                DataViewTableModel.this.fireTableRowsUpdated((int)rowRange.getStartOfRange(), (int)rowRange.getEndOfRange());
            }
        });
    }

    public void setUndoManager(SpssUndoManager spssUndoManager) {
        this.mUndoManager = spssUndoManager;
    }

    public SpssUndoManager getUndoManager() {
        return this.mUndoManager;
    }

    public ISpssDataSrc getDataSource() {
        return this.mDataSource;
    }

    private void addColumnsForValue(Object object, int n) {
        int n2 = 0;
        String string = "";
        boolean bl = false;
        try {
            if (object != null) {
                string = object instanceof Double ? String.format(ComponentState.getSPSSLocale(), "%f", (Double)object) : object.toString();
                OBS oBS = new OBS();
                bl = !CellValueFormatter.stringToObs((String)string, (SPSS_Format)new SPSS_Format(FormatType.F, 15, 2), (OBS)oBS);
            }
        }
        catch (Exception exception) {
            bl = true;
        }
        if (bl) {
            n2 = string.length();
        }
        new VariableInsertEdit(this.mUndoManager, this.mDataSource, this.mDataSource.columnCount(), n, n2);
    }

    public void addRows(long l) {
        new RowInsertEdit((DataFrame)this.mUndoManager.getSpssFrame(), DataViewTableModel.getDisplayableRowCount((int)this.mDataSource.rowCount()), l).setIsSignificant(true);
    }
}

