/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.data;

import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.ORIGINATOR_ID;
import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ColumnDataProvider;
import com.spss.java_client.core.documents.data.dictionary.DisplayAlignment;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.core.documents.data.dictionary.value_labels.IValueLabelMap;
import com.spss.java_client.core.documents.data.dictionary.value_labels.StringBag;
import com.spss.java_client.ui.command.ActionCatalog;
import com.spss.java_client.ui.controls.SpssProgressDlg;
import com.spss.java_client.ui.dialogs.base.utilities.spell_check.DataViewSpellCheckDlg;
import com.spss.java_client.ui.dialogs.common.SwingWorker;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.actions.SpssAction;
import com.spss.java_client.ui.doc_types.data.DataCellEdit;
import com.spss.java_client.ui.doc_types.data.DataEditBar;
import com.spss.java_client.ui.doc_types.data.DataEditContextMenu;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.doc_types.data.DataTableColMoveDropTargetHandler;
import com.spss.java_client.ui.doc_types.data.DataView;
import com.spss.java_client.ui.doc_types.data.DataViewTableModel;
import com.spss.java_client.ui.doc_types.data.DragTableColumnRenderer;
import com.spss.java_client.ui.doc_types.data.FormatInfo;
import com.spss.java_client.ui.doc_types.data.SpssRowHeaderTable;
import com.spss.java_client.ui.doc_types.data.SpssTable;
import com.spss.java_client.ui.doc_types.data.TableBooleanCellPropertyManager;
import com.spss.java_client.ui.doc_types.data.TableCellPropertyManager;
import com.spss.java_client.ui.doc_types.data.TableColMoveTransferHandler;
import com.spss.java_client.ui.doc_types.data.TableHeaderPrintRender;
import com.spss.java_client.ui.doc_types.data.TablePropertyManager;
import com.spss.java_client.ui.doc_types.data.VarViewTable;
import com.spss.java_client.ui.doc_types.data.VarViewTableModel;
import com.spss.java_client.ui.doc_types.data.undo.RowInsertEdit;
import com.spss.java_client.ui.doc_types.data.undo.TableColumnWidthEdit;
import com.spss.java_client.ui.doc_types.doc_util.DocUtil;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.format.GeneralNumberFormat;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.shared.custom_gui.ui_builder.Util.OSInfo;
import com.spss.shared.syntaxeditor.OSInfo;
import com.spss.uitools.controls.TypeAheadCombo;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.accessibility.Accessible;
import javax.swing.AbstractCellEditor;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.FocusManager;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.w3c.dom.Document;

public class DataViewTable
extends SpssTable {
    private static final String[] HEADER_CONTEXT_MENU_IDS = new String[]{"context_data_cut", "context_data_copy", "context_copy_with_variable_name", "context_copy_with_variable_label", "context_data_paste", "context_data_clear", "separator", "edit_insert_variable", "separator", "context_sort_ascend", "context_sort_descend", "separator", "context_var_info", "context_data_descriptives", "separator", "utilities_spellcheck"};
    private static final String[] TABLE_CONTEXT_MENU_IDS = new String[]{"context_data_cut", "context_data_copy", "context_copy_with_variable_name", "context_copy_with_variable_label", "context_data_paste", "context_data_paste_spec", "context_data_clear", "separator", "context_var_info", "context_data_descriptives", "separator", "context_grid_font", "utilities_spellcheck"};
    private static boolean sMouseDown = false;
    private static boolean sHeaderRMouseButtonPressed = false;
    private ValueLabelComboEditor mValueLabelEditor = new ValueLabelComboEditor();
    private DataEditBar mEditBar = null;
    private TablePropertyManager mTablePropertyManager = new TablePropertyManager();
    private HashMap<Integer, Integer> mRowIndexToCaseIDMap = new HashMap();
    private int mUniqueCaseID = -1;
    private TraverseCaseProgressDlg mProgressDlg;

    public DataViewTable(TableModel tableModel, DataView dataView, Location location) {
        super(tableModel, dataView);
        MouseListener mouseListener2;
        MouseListener[] mouseListenerArray;
        this.setAutoResizeMode(0);
        this.setSelectionMode(2);
        this.setIntercellSpacing(new Dimension(3, 1));
        ToolTipHeader toolTipHeader = new ToolTipHeader(this.getColumnModel());
        this.setTableHeader(toolTipHeader);
        if (location == Location.eTopLeft || location == Location.eTopRight) {
            mouseListenerArray = new DragTableColumnRenderer(this, true);
            mouseListenerArray.setHorizontalAlignment(0);
            toolTipHeader.setDefaultRenderer((TableCellRenderer)mouseListenerArray);
        } else if (location == Location.eBottomLeft || location == Location.eBottomRight) {
            this.setTableHeader(null);
        }
        if (!DataMgr.getDataMgr().isDataFreeClient()) {
            mouseListenerArray = new DataViewListSelectionListener();
            ListSelectionModel object = this.getSelectionModel();
            object.addListSelectionListener((ListSelectionListener)mouseListenerArray);
            ListSelectionModel tableColMoveTransferHandler = this.getColumnModel().getSelectionModel();
            tableColMoveTransferHandler.addListSelectionListener((ListSelectionListener)mouseListenerArray);
        } else {
            this.setCellSelectionEnabled(false);
            this.setEnabled(false);
        }
        for (MouseListener mouseListener2 : mouseListenerArray = this.getMouseListeners()) {
            this.removeMouseListener(mouseListener2);
        }
        CellSelectionMouseHandler cellSelectionMouseHandler = new CellSelectionMouseHandler();
        this.addMouseListener(cellSelectionMouseHandler);
        TableColMoveTransferHandler tableColMoveTransferHandler = new TableColMoveTransferHandler();
        DataTableColMoveDropTargetHandler dataTableColMoveDropTargetHandler = new DataTableColMoveDropTargetHandler(this.mDataView.getUndoManager(), this);
        mouseListener2 = new TableHeaderMouseHandler();
        toolTipHeader.addMouseMotionListener((MouseMotionListener)((Object)mouseListener2));
        toolTipHeader.addMouseListener(mouseListener2);
        toolTipHeader.setTransferHandler(tableColMoveTransferHandler);
        new DropTarget(toolTipHeader, 2, dataTableColMoveDropTargetHandler, true, null);
        new DropTarget(this, 2, dataTableColMoveDropTargetHandler, true, null);
        toolTipHeader.setReorderingAllowed(false);
        toolTipHeader.setFocusable(false);
        this.addKeyListener(new EditTableKeyHandler());
        InputMap inputMap = this.getInputMap(1);
        if (inputMap != null) {
            inputMap.remove(KeyStroke.getKeyStroke(113, 0));
        }
        this.initiatePropertyManagers();
    }

    @Override
    public void repaint(Rectangle rectangle) {
        super.repaint(rectangle);
        if (this.getTableHeader() != null) {
            this.getTableHeader().repaint();
        }
    }

    @Override
    public void repaint() {
        super.repaint();
        if (this.getTableHeader() != null) {
            this.getTableHeader().repaint();
        }
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return !DataMgr.getDataMgr().isDataFreeClient() && super.isCellEditable(n, n2);
    }

    public void setDataEditBar(DataEditBar dataEditBar) {
        this.mEditBar = dataEditBar;
    }

    public void setFormatInfo(FormatInfo formatInfo, int n, int n2) {
        if (formatInfo != null && n != -1) {
            if (this.getBKColorManager() != null && formatInfo.getBkColor() != null) {
                this.getBKColorManager().turnCellPropertyON(n, n2, "" + formatInfo.getBkColor().getRGB());
            }
            if (this.getForegroundColorManager() != null && formatInfo.getForegroundColor() != null) {
                this.getForegroundColorManager().turnCellPropertyON(n, n2, "" + formatInfo.getForegroundColor().getRGB());
            }
            if (this.getFontBoldManager() != null) {
                this.getFontBoldManager().turnCellPropertyON(n, n2, "" + formatInfo.isBold());
            }
        }
    }

    public void setCaseIDAt(int n, int n2) {
        int n3 = this.mDataView.getCaseIDColIndex();
        if (n3 != -1) {
            this.mDataView.getUndoManager().addUndoLock(1);
            ((DataViewTableModel)this.getModel()).setValueAt(this, n, n2, this.convertColumnIndexToModel(n3));
            this.mDataView.getUndoManager().clearAllUndoLocks();
        }
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        this.setValueAt(object, null, n, -1, n2);
    }

    public void setValueAt(Object object, FormatInfo formatInfo, int n, int n2, int n3) {
        this.setValueAt(object, null, formatInfo, n, n2, n3);
    }

    public void setValueAt(Object object, OBS oBS, int n, int n2) {
        this.setValueAt(object, oBS, null, n, -1, n2);
    }

    public void setValueAt(Object object, OBS oBS, FormatInfo formatInfo, int n, int n2, int n3) {
        String string = this.getModel().getColumnName(n3);
        if (string == null || !DataView.isLockedHiddenVariable(string)) {
            if (oBS != null) {
                ((DataViewTableModel)this.getModel()).setValueAt(this, object, oBS, n, this.convertColumnIndexToModel(n3));
            } else {
                ((DataViewTableModel)this.getModel()).setValueAt(this, object, n, this.convertColumnIndexToModel(n3));
            }
            if (formatInfo != null) {
                this.setFormatInfo(formatInfo, n2, n3);
            }
        }
    }

    @Override
    public JTable clone() throws CloneNotSupportedException {
        JTable jTable = super.clone();
        TableHeaderPrintRender tableHeaderPrintRender = new TableHeaderPrintRender(this);
        int n = this.getColumnCount();
        for (int i = 0; i < n; ++i) {
            jTable.getColumnModel().getColumn(i).setHeaderRenderer(tableHeaderPrintRender);
        }
        return jTable;
    }

    @Override
    public void selectAll() {
        if (this.isEditing()) {
            this.removeEditor();
        }
        if (this.getDataRowCount() > 0L && this.getDataColumnCount() > 0) {
            ListSelectionModel listSelectionModel = this.selectionModel;
            listSelectionModel.setValueIsAdjusting(true);
            int n = this.getAdjustedIndex(listSelectionModel.getLeadSelectionIndex(), true);
            int n2 = this.getAdjustedIndex(listSelectionModel.getAnchorSelectionIndex(), true);
            this.setRowSelectionInterval(0, (int)(this.getDataRowCount() - 1L));
            if (n2 == -1) {
                n2 = n;
            }
            if (n == -1) {
                listSelectionModel.setAnchorSelectionIndex(-1);
                listSelectionModel.setLeadSelectionIndex(-1);
            } else {
                listSelectionModel.addSelectionInterval(n2, n);
            }
            listSelectionModel.setValueIsAdjusting(false);
            listSelectionModel = this.columnModel.getSelectionModel();
            listSelectionModel.setValueIsAdjusting(true);
            n = this.getAdjustedIndex(listSelectionModel.getLeadSelectionIndex(), false);
            n2 = this.getAdjustedIndex(listSelectionModel.getAnchorSelectionIndex(), false);
            this.setColumnSelectionInterval(0, this.getDataColumnCount() - 1);
            if (n2 == -1) {
                n2 = n;
            }
            if (n == -1) {
                listSelectionModel.setAnchorSelectionIndex(-1);
                listSelectionModel.setLeadSelectionIndex(-1);
            } else {
                listSelectionModel.addSelectionInterval(n2, n);
            }
            listSelectionModel.setValueIsAdjusting(false);
        }
    }

    public ValueLabelComboEditor getValueLabelEditor() {
        return this.mValueLabelEditor;
    }

    @Override
    public boolean editCellAt(int n, int n2, EventObject eventObject) {
        try {
            boolean bl = super.editCellAt(n, n2, eventObject);
            if (bl) {
                TableCellEditor tableCellEditor = this.getCellEditor();
                if (tableCellEditor instanceof DefaultCellEditor) {
                    Component component = ((DefaultCellEditor)tableCellEditor).getComponent();
                    if (component instanceof DataCellEdit) {
                        ((DataCellEdit)component).clearUndoStack();
                    }
                    if (component instanceof JFormattedTextField) {
                        DataViewTableModel dataViewTableModel = (DataViewTableModel)this.getModel();
                        final JFormattedTextField jFormattedTextField = (JFormattedTextField)component;
                        Object object = dataViewTableModel.getValueAt(n, n2);
                        if (object != null && !object.toString().equals(DataViewTableModel.getSysmisString()) && !object.toString().equals(DataViewTableModel.getIndterminateString())) {
                            jFormattedTextField.setValue(object);
                            if (eventObject instanceof MouseEvent) {
                                if (!this.isEditing()) {
                                    return false;
                                }
                                jFormattedTextField.requestFocusInWindow();
                                MouseEvent mouseEvent = (MouseEvent)eventObject;
                                Point point = mouseEvent.getPoint();
                                final Point point2 = SwingUtilities.convertPoint((Component)eventObject.getSource(), point, jFormattedTextField);
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        Position.Bias[] biasArray = new Position.Bias[1];
                                        int n = jFormattedTextField.getUI().viewToModel(jFormattedTextField, point2, biasArray);
                                        jFormattedTextField.setCaretPosition(n >= 0 ? n : jFormattedTextField.getDocument().getLength());
                                    }
                                });
                            } else {
                                jFormattedTextField.selectAll();
                            }
                        } else {
                            jFormattedTextField.setValue("");
                        }
                    }
                } else if (tableCellEditor instanceof ValueLabelComboEditor) {
                    ((ValueLabelComboEditor)tableCellEditor).mCombo.getEditor().selectAll();
                }
            }
            return bl;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public int[] getColumnSelections() {
        int[] nArray = null;
        int n = this.getColumnModel().getSelectionModel().getMinSelectionIndex();
        int n2 = this.getColumnModel().getSelectionModel().getMaxSelectionIndex();
        int n3 = this.getSelectionModel().getMinSelectionIndex();
        int n4 = this.getSelectionModel().getMaxSelectionIndex();
        if (n3 == 0 && n4 == this.getRowCount() - 1) {
            int n5 = 0;
            int[] nArray2 = new int[n2 - n + 1];
            for (int i = n; i <= n2; ++i) {
                if (!this.getColumnModel().getSelectionModel().isSelectedIndex(i)) continue;
                nArray2[n5++] = i;
            }
            nArray = new int[n5];
            System.arraycopy(nArray2, 0, nArray, 0, n5);
        }
        return nArray;
    }

    public void selectAndScrollToVariable(int n) {
        if (n < 0) {
            return;
        }
        this.scrollToLeft(n);
        this.setColumnSelectionInterval(n, n);
    }

    @Override
    public long getDataRowCount() {
        long l = 0L;
        DataViewTableModel dataViewTableModel = (DataViewTableModel)this.getModel();
        if (dataViewTableModel != null && dataViewTableModel.getDataSource() != null) {
            l = DataViewTableModel.getDisplayableRowCount((int)dataViewTableModel.getDataSource().rowCount());
        }
        return l;
    }

    @Override
    public int getDataColumnCount() {
        int n = 0;
        DataViewTableModel dataViewTableModel = (DataViewTableModel)this.getModel();
        if (dataViewTableModel != null && dataViewTableModel.getDataSource() != null) {
            n = dataViewTableModel.getDataSource().columnCount();
        }
        return n;
    }

    public void updateEditBar(String string) {
        this.mEditBar.setEditBarText(string);
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (!sMouseDown) {
            boolean bl;
            int[] nArray = null;
            int[] nArray2 = null;
            boolean bl2 = bl = tableModelEvent.getType() != 0 && this.getRowCount() < 1000000;
            if (bl) {
                nArray = this.getSelectedRows();
                nArray2 = this.getSelectedColumns();
            }
            super.tableChanged(tableModelEvent);
            if (bl) {
                this.reselectCells(nArray, nArray2);
            }
        }
    }

    protected int getAdjustedIndex(int n, boolean bl) {
        int n2 = bl ? (int)this.getDataRowCount() : this.getDataColumnCount();
        return n < n2 ? n : -1;
    }

    protected void reselectCells(int[] nArray, int[] nArray2) {
        this.getSelectionModel().clearSelection();
        this.getColumnModel().getSelectionModel().clearSelection();
        int n = -1;
        int n2 = -2;
        for (int n3 : nArray) {
            if (n == -1) {
                n = n3;
            } else if (n3 != n2 + 1) {
                this.getSelectionModel().addSelectionInterval(n, n2);
                n = n3;
            }
            n2 = n3;
        }
        if (n > -1) {
            this.getSelectionModel().addSelectionInterval(n, n2);
        }
        n = -1;
        n2 = -2;
        for (int n3 : nArray2) {
            if (n == -1) {
                n = n3;
            } else if (n3 != n2 + 1) {
                this.getColumnModel().getSelectionModel().addSelectionInterval(n, n2);
                n = n3;
            }
            n2 = n3;
        }
        if (n > -1) {
            this.getColumnModel().getSelectionModel().addSelectionInterval(n, n2);
        }
    }

    @Override
    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        boolean bl2;
        if (keyEvent.isConsumed()) {
            return false;
        }
        if ((keyEvent.isShiftDown() || keyEvent.isControlDown() || keyEvent.isMetaDown()) && keyEvent.getKeyChar() == ' ' && !this.isEditing()) {
            return false;
        }
        if (!this.isEditing() && keyEvent.isControlDown() && (keyEvent.getKeyCode() == 72 || keyEvent.getKeyCode() == 90 || keyEvent.getKeyCode() == 89)) {
            return false;
        }
        if ((keyStroke.getModifiers() & 8) != 0) {
            return false;
        }
        if (OSCheck.getOSType() == OSInfo.OSType.MAC && (keyStroke.getModifiers() & 4) != 0) {
            return false;
        }
        if (keyEvent.getKeyCode() == 525 || keyEvent.isShiftDown() && keyEvent.getKeyCode() == 121) {
            int n2;
            DataEditContextMenu dataEditContextMenu = new DataEditContextMenu(TABLE_CONTEXT_MENU_IDS);
            Point point = keyEvent.getComponent().getLocation();
            int n3 = (int)point.getX();
            int n4 = this.getSelectedColumn();
            for (n2 = 0; n2 < n4; ++n2) {
                n3 += this.getColumnModel().getColumn(n2).getWidth();
            }
            n2 = (int)point.getY() + this.getRowHeight() * this.getSelectedRow() + (int)(0.5 * (double)this.getRowHeight());
            dataEditContextMenu.show(this, n3 += (int)(0.5 * (double)this.getColumnModel().getColumn(n4).getWidth()), n2);
            keyEvent.consume();
            return true;
        }
        if (n == 1 && keyEvent.getKeyChar() != '\n' && keyEvent.getKeyChar() != '\t' && keyEvent.getID() == 400 && keyEvent.getModifiers() == 0) {
            keyEvent = new KeyEvent(this, 401, keyEvent.getWhen(), keyEvent.getModifiers(), keyEvent.getKeyCode(), keyEvent.getKeyChar());
        }
        boolean bl3 = keyEvent.getKeyChar() == '\u007f' && !this.isEditing();
        boolean bl4 = true;
        boolean bl5 = bl2 = (keyEvent.getModifiersEx() & 0x40) != 0;
        if (n == 1 && keyEvent.getKeyChar() == '\t' && keyEvent.getID() == 401 && (keyEvent.getModifiers() == 0 || bl2)) {
            this.doTabKeyMove(keyEvent);
        } else {
            ActionCatalog.getActionCatalog().enableActions(this.getSpssFrame(), ActionCatalog.getActionCatalog().getMneumonicActions());
            bl4 = super.processKeyBinding(keyStroke, keyEvent, n, bl);
        }
        if (bl4 || n != 1 || Character.isSpaceChar(keyEvent.getKeyChar()) || Character.isISOControl(keyEvent.getKeyChar()) || !bl || !this.isEditing() || !(this.getEditorComponent() instanceof JComboBox) || keyEvent.getSource() == this) {
            // empty if block
        }
        if (bl4 && keyEvent.getKeyCode() == 9 && n == 1 && keyEvent.getSource() != this) {
            this.requestFocusInWindow();
        }
        if (bl4 && bl3 && this.isEditing() && keyEvent.getSource() == this) {
            this.getCellEditor().cancelCellEditing();
        }
        return bl4;
    }

    private SpssFrame getSpssFrame() {
        return this.mDataView.getUndoManager().getSpssFrame();
    }

    private void routeKeyToValueLabelComboEditor(KeyEvent keyEvent) {
        String string = String.valueOf(keyEvent.getKeyChar());
        JComboBox jComboBox = (JComboBox)this.getEditorComponent();
        Object object = this.lookupComboItem(jComboBox, string);
        if (object == null) {
            jComboBox.getEditor().setItem(string);
        } else {
            Component component = jComboBox.getEditor().getEditorComponent();
            if (component instanceof JTextField) {
                if (!this.isWindows7()) {
                    JTextField jTextField = (JTextField)component;
                    jTextField.setText(string);
                    jTextField.requestFocusInWindow();
                }
            } else {
                jComboBox.setSelectedItem(object);
                jComboBox.getEditor().setItem(object);
                jComboBox.getEditor().selectAll();
            }
        }
    }

    public boolean isWindows7() {
        String string;
        boolean bl = false;
        if (OSInfo.getOSType() == OSInfo.OSType.WIN && (string = System.getProperty("os.name").toLowerCase()).contains("7")) {
            bl = true;
        }
        return bl;
    }

    @Deprecated
    protected void synchDataTableCols() {
        JTableHeader jTableHeader = this.getTableHeader();
        if (jTableHeader != null) {
            Container container = jTableHeader.getParent();
            Container container2 = this.getParent();
            if (container instanceof JViewport && container2 instanceof JViewport) {
                JViewport jViewport = (JViewport)container;
                JViewport jViewport2 = (JViewport)container2;
                Point point = jViewport2.getViewPosition();
                if (point.x != jViewport.getViewPosition().x) {
                    point.x = jViewport.getViewPosition().x;
                    jViewport2.setViewPosition(point);
                }
            }
        }
    }

    protected void scrollToLeft(int n) {
        if (!(this.getParent() instanceof JViewport)) {
            return;
        }
        JViewport jViewport = (JViewport)this.getParent();
        Rectangle rectangle = this.getCellRect(0, n, true);
        Rectangle rectangle2 = jViewport.getViewRect();
        rectangle.setLocation(rectangle.x - rectangle2.x, rectangle.y - rectangle2.y);
        int n2 = rectangle2.width - rectangle.width;
        int n3 = 0;
        if (rectangle.x < 0) {
            n2 = 0;
        }
        rectangle.translate(n2, n3);
        jViewport.scrollRectToVisible(rectangle);
    }

    private void executeCellPopup(MouseEvent mouseEvent) {
        DataEditContextMenu dataEditContextMenu = new DataEditContextMenu(TABLE_CONTEXT_MENU_IDS);
        SpssAction spssAction = DocUtil.getActionFromMenu(dataEditContextMenu, "context_data_cut");
        if (spssAction != null) {
            spssAction.setEnabled(spssAction.getMenuItemEnableStatus(this.getSpssFrame()));
        }
        if ((spssAction = DocUtil.getActionFromMenu(dataEditContextMenu, "context_data_copy")) != null) {
            spssAction.setEnabled(spssAction.getMenuItemEnableStatus(this.getSpssFrame()));
        }
        if ((spssAction = DocUtil.getActionFromMenu(dataEditContextMenu, "context_copy_with_variable_name")) != null) {
            spssAction.setEnabled(spssAction.getMenuItemEnableStatus(this.getSpssFrame()));
        }
        if ((spssAction = DocUtil.getActionFromMenu(dataEditContextMenu, "context_copy_with_variable_label")) != null) {
            spssAction.setEnabled(spssAction.getMenuItemEnableStatus(this.getSpssFrame()));
        }
        if ((spssAction = DocUtil.getActionFromMenu(dataEditContextMenu, "context_data_paste")) != null) {
            spssAction.setEnabled(spssAction.getMenuItemEnableStatus(this.getSpssFrame()));
        }
        if ((spssAction = DocUtil.getActionFromMenu(dataEditContextMenu, "context_data_paste_spec")) != null) {
            spssAction.setEnabled(spssAction.getMenuItemEnableStatus(this.getSpssFrame()));
        }
        if ((spssAction = DocUtil.getActionFromMenu(dataEditContextMenu, "context_data_clear")) != null) {
            spssAction.setEnabled(spssAction.getMenuItemEnableStatus(this.getSpssFrame()));
        }
        if ((spssAction = DocUtil.getActionFromMenu(dataEditContextMenu, "context_var_info")) != null) {
            int[] nArray = this.getSelectedColumns();
            spssAction.setEnabled(nArray != null && nArray.length == 1);
        }
        if ((spssAction = DocUtil.getActionFromMenu(dataEditContextMenu, "context_data_descriptives")) != null) {
            spssAction.setEnabled(spssAction.getMenuItemEnableStatus(this.getSpssFrame()));
        }
        if ((spssAction = DocUtil.getActionFromMenu(dataEditContextMenu, "context_grid_font")) != null) {
            spssAction.setEnabled(spssAction.getMenuItemEnableStatus(this.getSpssFrame()));
        }
        if ((spssAction = DocUtil.getActionFromMenu(dataEditContextMenu, "utilities_spellcheck")) != null) {
            spssAction.setEnabled(spssAction.getMenuItemEnableStatus(this.getSpssFrame()));
        }
        dataEditContextMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    private void executeTablePopup(MouseEvent mouseEvent) {
        DataEditContextMenu dataEditContextMenu = new DataEditContextMenu(HEADER_CONTEXT_MENU_IDS);
        SpssAction spssAction = DocUtil.getActionFromMenu(dataEditContextMenu, "context_data_cut");
        if (spssAction != null) {
            spssAction.setEnabled(spssAction.getMenuItemEnableStatus(this.getSpssFrame()));
        }
        if ((spssAction = DocUtil.getActionFromMenu(dataEditContextMenu, "context_data_copy")) != null) {
            spssAction.setEnabled(spssAction.getMenuItemEnableStatus(this.getSpssFrame()));
        }
        if ((spssAction = DocUtil.getActionFromMenu(dataEditContextMenu, "context_copy_with_variable_name")) != null) {
            spssAction.setEnabled(spssAction.getMenuItemEnableStatus(this.getSpssFrame()));
        }
        if ((spssAction = DocUtil.getActionFromMenu(dataEditContextMenu, "context_copy_with_variable_label")) != null) {
            spssAction.setEnabled(spssAction.getMenuItemEnableStatus(this.getSpssFrame()));
        }
        if ((spssAction = DocUtil.getActionFromMenu(dataEditContextMenu, "context_data_paste")) != null) {
            spssAction.setEnabled(spssAction.getMenuItemEnableStatus(this.getSpssFrame()));
        }
        if ((spssAction = DocUtil.getActionFromMenu(dataEditContextMenu, "context_data_clear")) != null) {
            spssAction.setEnabled(spssAction.getMenuItemEnableStatus(this.getSpssFrame()));
        }
        if ((spssAction = DocUtil.getActionFromMenu(dataEditContextMenu, "context_sort_ascend")) != null) {
            spssAction.setEnabled(spssAction.getMenuItemEnableStatus(this.getSpssFrame()));
        }
        if ((spssAction = DocUtil.getActionFromMenu(dataEditContextMenu, "context_sort_descend")) != null) {
            spssAction.setEnabled(spssAction.getMenuItemEnableStatus(this.getSpssFrame()));
        }
        if ((spssAction = DocUtil.getActionFromMenu(dataEditContextMenu, "context_var_info")) != null) {
            int[] nArray = this.getSelectedColumns();
            spssAction.setEnabled(nArray != null && nArray.length == 1);
        }
        if ((spssAction = DocUtil.getActionFromMenu(dataEditContextMenu, "context_data_descriptives")) != null) {
            spssAction.setEnabled(spssAction.getMenuItemEnableStatus(this.getSpssFrame()));
        }
        if ((spssAction = DocUtil.getActionFromMenu(dataEditContextMenu, "utilities_spellcheck")) != null) {
            spssAction.setEnabled(spssAction.getMenuItemEnableStatus(this.getSpssFrame()));
        }
        dataEditContextMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        mouseEvent.consume();
    }

    public boolean canSetFormat() {
        boolean bl = true;
        int[] nArray = this.getSelectedRows();
        int[] nArray2 = this.getSelectedColumns();
        if (nArray != null && nArray.length > 0 && nArray2 != null && nArray2.length > 0) {
            DataViewTableModel dataViewTableModel = (DataViewTableModel)this.getModel();
            ISpssDataSrc iSpssDataSrc = dataViewTableModel.getDataSource();
            if (iSpssDataSrc.columnCount() == this.mDataView.getNumHiddenColumns() || nArray2[0] >= iSpssDataSrc.columnCount()) {
                bl = false;
            }
            if ((long)nArray[0] >= iSpssDataSrc.rowCount()) {
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean canSpellCheck() {
        if (CommandLine.isExternalCaller()) {
            return false;
        }
        List<Integer> list = DataViewSpellCheckDlg.getTextColumns(this.mDataView);
        return list.size() > 0;
    }

    public void updateVariableOrder(ArrayList<Integer> arrayList) {
        this.mTablePropertyManager.updateVariableOrder(arrayList);
    }

    @Deprecated
    public TablePropertyManager savePropertyState() {
        TablePropertyManager tablePropertyManager = new TablePropertyManager();
        DataViewTableModel dataViewTableModel = (DataViewTableModel)this.getModel();
        ISpssDataSrc iSpssDataSrc = dataViewTableModel.getDataSource();
        int[] nArray = this.getSelectedRows();
        int[] nArray2 = this.getSelectedColumns();
        boolean bl = iSpssDataSrc.columnCount() == nArray2.length && iSpssDataSrc.rowCount() == (long)nArray.length;
        boolean bl2 = this.isEntireColumnSelected(nArray2[0]);
        boolean bl3 = this.isEntireRowSelected(nArray[0]);
        int[] nArray3 = null;
        if (this.needCaseIDs(bl, bl2, nArray2)) {
            nArray3 = this.getRowCaseIDs(nArray, true);
        }
        for (TableCellPropertyManager tableCellPropertyManager : this.mTablePropertyManager.getTableCellPropertyManagers()) {
            if (bl) {
                this.mTablePropertyManager.createCopyWholeTableBased(tablePropertyManager, tableCellPropertyManager);
                continue;
            }
            if (nArray2 != null && nArray2.length > 0 && bl2) {
                int[] nArray4 = this.getVariableIDs(nArray2);
                if (nArray4 == null) continue;
                this.mTablePropertyManager.createCopyColumnBased(nArray4, tablePropertyManager, tableCellPropertyManager);
                continue;
            }
            if (nArray3 != null && nArray3.length > 0 && bl3 && !bl2) {
                this.mTablePropertyManager.createCopyRowBased(nArray3, tablePropertyManager, tableCellPropertyManager);
                continue;
            }
            this.mTablePropertyManager.createCopyCellBased(nArray3, nArray2, tablePropertyManager, tableCellPropertyManager);
        }
        return tablePropertyManager;
    }

    private boolean needCaseIDs(boolean bl, boolean bl2, int[] nArray) {
        boolean bl3 = true;
        if (bl) {
            bl3 = false;
        } else if (nArray != null && nArray.length > 0 && bl2) {
            bl3 = false;
        }
        return bl3;
    }

    private int[] getVariableIDs(int[] nArray) {
        int[] nArray2;
        DataViewTableModel dataViewTableModel = (DataViewTableModel)this.getModel();
        ISpssDataSrc iSpssDataSrc = dataViewTableModel.getDataSource();
        int[] nArray3 = nArray2 = nArray != null && nArray.length > 0 ? new int[nArray.length] : null;
        if (nArray2 != null) {
            ISpssVariable iSpssVariable;
            for (int i = 0; i < nArray.length && (iSpssVariable = iSpssDataSrc.getVariable(nArray[i])) != null; ++i) {
                nArray2[i] = iSpssVariable.getId().asInt();
            }
        }
        return nArray2;
    }

    public TablePropertyManager savePropertyStateWholeTableInfo(int n) {
        return this.mTablePropertyManager.savePropertyStateWholeTableBased(n);
    }

    public TablePropertyManager savePropertyStateColumnBased(int n, int[] nArray) {
        return this.mTablePropertyManager.savePropertyStateColumnBased(n, nArray);
    }

    @Deprecated
    public TablePropertyManager savePropertyStateColumnBased(int[] nArray) {
        return this.mTablePropertyManager.savePropertyStateColumnBased(nArray);
    }

    public TablePropertyManager savePropertyStateRowBased(int n, int[] nArray) {
        return this.mTablePropertyManager.savePropertySateRowBased(n, nArray);
    }

    public TablePropertyManager savePropertySateRowBased(int[] nArray) {
        return this.mTablePropertyManager.savePropertySateRowBased(nArray);
    }

    @Deprecated
    public TablePropertyManager savePropertyStateCellBased(int[] nArray, int[] nArray2) {
        return this.mTablePropertyManager.savePropertySateCellBased(nArray, nArray2);
    }

    public TablePropertyManager savePropertyStateCellBased(int n, int[] nArray, int[] nArray2) {
        return this.mTablePropertyManager.savePropertySateCellBased(n, nArray, nArray2);
    }

    @Deprecated
    public void doColorText(Color color) {
        int[] nArray = this.getSelectedRows();
        int[] nArray2 = this.getSelectedColumns();
        boolean bl = this.isEntireColumnSelected(nArray2[0]);
        boolean bl2 = this.isEntireRowSelected(nArray[0]);
        int[] nArray3 = this.getRowCaseIDs(nArray, true);
        if (nArray2.length > 0 && bl) {
            this.setWholeForegroundColumnsColor(nArray2, color);
        } else if (nArray3 != null && nArray3.length > 0 && bl2 && !bl) {
            this.setWholeForegroundRowsColor(nArray3, color);
        } else {
            this.setCellsForegroundColorInfo(nArray3, nArray2, color);
        }
        this.repaint();
    }

    @Deprecated
    public void doColorCells(Color color) {
        int[] nArray = this.getSelectedRows();
        int[] nArray2 = this.getSelectedColumns();
        boolean bl = this.isEntireColumnSelected(nArray2[0]);
        boolean bl2 = this.isEntireRowSelected(nArray[0]);
        int[] nArray3 = this.getRowCaseIDs(nArray, true);
        if (nArray2.length > 0 && bl) {
            this.setWholeBKColumnsColor(nArray2, color);
        } else if (nArray3 != null && nArray3.length > 0 && bl2 && !bl) {
            this.setWholeBKRowsColor(nArray3, color);
        } else {
            this.setCellsBkColorInfo(nArray3, nArray2, color);
        }
        this.repaint();
    }

    public void restoreSavedProperties(TablePropertyManager tablePropertyManager) {
        this.mTablePropertyManager.restoreSavedProperties(tablePropertyManager);
    }

    @Deprecated
    public void doBoldCells(boolean bl) {
        int[] nArray = this.getSelectedRows();
        int[] nArray2 = this.getSelectedColumns();
        boolean bl2 = this.isEntireColumnSelected(nArray2[0]);
        boolean bl3 = this.isEntireRowSelected(nArray[0]);
        int[] nArray3 = this.getRowCaseIDs(nArray, true);
        if (nArray2.length > 0 && bl2) {
            this.setEntireColumnsFontBold(nArray2, bl);
        } else if (nArray3 != null && nArray3.length > 0 && bl3 && !bl2) {
            this.setEntireRowsFontBold(nArray3, bl);
        } else {
            this.setRowBoldInfo(nArray3, nArray2, bl);
        }
        this.repaint();
    }

    public int[] getRowCaseIDs(boolean bl) {
        int[] nArray = null;
        if (this.getRowCount() > 0) {
            nArray = new int[this.getRowCount()];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = i;
            }
        }
        return nArray != null ? this.getRowCaseIDs(nArray, bl) : null;
    }

    public int[] getRowCaseIDs(int n, int n2, boolean bl) {
        int[] nArray = new int[n2 - n + 1];
        for (int i = n; i <= n2; ++i) {
            nArray[i - n] = i;
        }
        return this.getRowCaseIDs(nArray, bl);
    }

    public int getRowCaseID(int n, boolean bl) {
        int n2 = -1;
        int[] nArray = this.getRowCaseIDs(new int[]{n}, bl);
        if (nArray != null && nArray.length > 0) {
            n2 = nArray[0];
        }
        return n2;
    }

    public int[] getRowCaseIDs(int[] nArray, boolean bl) {
        int[] nArray2 = null;
        if (nArray != null && nArray.length > 0) {
            int n = this.mDataView.getCaseIDColIndex();
            ISpssDataSrc iSpssDataSrc = this.mDataView.getDataSrc();
            ColumnDataProvider columnDataProvider = new ColumnDataProvider(iSpssDataSrc);
            nArray2 = new int[nArray.length];
            if (bl && (long)nArray[nArray.length - 1] > iSpssDataSrc.rowCount()) {
                long l = (long)nArray[nArray.length - 1] - iSpssDataSrc.rowCount() + 1L;
                new RowInsertEdit((DataFrame)this.getSpssFrame(), iSpssDataSrc.rowCount(), l);
            }
            this.mDataView.getUndoManager().addNotificationLock(2);
            OBS[] oBSArray = n != -1 ? columnDataProvider.getColumnData(n, (long)nArray[0], (long)nArray[nArray.length - 1]) : null;
            for (int i = 0; i < nArray.length; ++i) {
                int n2;
                int n3 = nArray[i];
                int n4 = nArray[i] - nArray[0];
                int n5 = n2 = oBSArray == null || i >= oBSArray.length ? -1 : (int)oBSArray[n4].getNum();
                if (bl) {
                    int n6 = nArray2[i] = n2 >= 0 ? n2 : this.getNextUniqueCaseID();
                    if (n2 >= 0) continue;
                    this.setCaseIDAt(nArray2[i], n3);
                    continue;
                }
                nArray2[i] = n2 >= 0 ? n2 : -1;
            }
            this.mDataView.getUndoManager().clearAllNotificationLocks();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DataViewTable.this.mDataView.getDataSrc().getCacheMgr().clearCache();
                    DataViewTable.this.mDataView.getDataSrc().notifyRowCountEstablished(ORIGINATOR_ID.DATAMGR_ORIGINATOR);
                    DataViewTable.this.getSpssFrame().updateToolbarEnableStatus();
                    DataViewTable.this.repaint();
                }
            });
        }
        return nArray2;
    }

    @Deprecated
    public void addRows(long l) {
        ISpssDataSrc iSpssDataSrc = this.mDataView.getDataSrc();
        new RowInsertEdit((DataFrame)this.getSpssFrame(), DataViewTableModel.getDisplayableRowCount((int)iSpssDataSrc.rowCount()), l).setIsSignificant(true);
    }

    @Deprecated
    public boolean hasCase(int n) {
        return this.mDataView.hasCase(n);
    }

    public int getNextUniqueCaseID() {
        ++this.mUniqueCaseID;
        return this.mUniqueCaseID;
    }

    @Deprecated
    public int[] convertToRowIndexCaseID2(int[] nArray) {
        if (nArray != null && nArray.length > 0) {
            int[] nArray2 = new int[nArray.length];
            this.fillRowIndexToCaseIDMap(nArray);
            for (int i = 0; i < nArray.length; ++i) {
                nArray2[i] = this.mRowIndexToCaseIDMap.get(nArray[i]);
            }
            return nArray2;
        }
        return null;
    }

    private void fillRowIndexToCaseIDMap(int[] nArray) {
        ISpssDataSrc iSpssDataSrc = this.mDataView.getDataSrc();
        int n = iSpssDataSrc.findVarIndex("CASEID_$");
        for (int n2 : nArray) {
            int n3;
            if (this.mRowIndexToCaseIDMap.get(n2) != null || (n3 = this.convertRowIndexToCaseID(n2, n)) == -1) continue;
            this.mRowIndexToCaseIDMap.put(n2, n3);
        }
    }

    private int convertRowIndexToCaseID(int n, int n2) {
        int n3 = -1;
        if (n2 >= 0) {
            Object object = this.getModel().getValueAt(n, n2);
            while (object instanceof String) {
                object = this.getModel().getValueAt(n, n2);
            }
            n3 = object instanceof Double ? ((Double)object).intValue() : -1;
        }
        return n3;
    }

    public void setEntireColumnsFontBold(int[] nArray, boolean bl) {
        this.getFontBoldManager().setEntireColumnsOn(nArray, bl);
    }

    public void setRowBoldInfo(int[] nArray, int[] nArray2, boolean bl) {
        if (bl) {
            this.getFontBoldManager().turnCellPropertyON(nArray, nArray2, "true");
        } else {
            this.getFontBoldManager().turnCellPropertyOFF(nArray, nArray2, "true");
        }
    }

    public void setWholeTableBKColor(Color color) {
        if (color == null || color.getAlpha() == 0) {
            this.getBKColorManager().setWholeTableToValue(null, true);
        } else {
            this.getBKColorManager().setWholeTableToValue("" + color.getRGB(), true);
        }
    }

    public void setWholeTableForegroundColor(Color color) {
        if (color == null || color.getAlpha() == 0) {
            this.getForegroundColorManager().setWholeTableToValue(null, true);
        } else {
            this.getForegroundColorManager().setWholeTableToValue("" + color.getRGB(), true);
        }
    }

    public void setWholeBKColumnsColor(int[] nArray, Color color) {
        if (color == null || color.getAlpha() == 0) {
            this.getBKColorManager().clearWholeColumns(nArray);
        } else {
            this.getBKColorManager().setWholeColumnToValue(nArray, "" + color.getRGB());
        }
    }

    public void setWholeForegroundColumnsColor(int[] nArray, Color color) {
        if (color == null || color.getAlpha() == 0) {
            this.getForegroundColorManager().clearWholeColumns(nArray);
        } else {
            this.getForegroundColorManager().setWholeColumnToValue(nArray, "" + color.getRGB());
        }
    }

    public void setCellsBkColorInfo(int[] nArray, int[] nArray2, Color color) {
        if (color == null || color.getAlpha() == 0) {
            this.getBKColorManager().clearCells(nArray, nArray2);
        }
        if (color != null) {
            this.getBKColorManager().turnCellPropertyON(nArray, nArray2, "" + color.getRGB());
        }
    }

    public void setCellsForegroundColorInfo(int[] nArray, int[] nArray2, Color color) {
        if (color == null || color.getAlpha() == 0) {
            this.getForegroundColorManager().clearCells(nArray, nArray2);
        }
        if (color != null) {
            this.getForegroundColorManager().turnCellPropertyON(nArray, nArray2, "" + color.getRGB());
        }
    }

    public void setWholeBKRowsColor(int[] nArray, Color color) {
        if (color == null || color.getAlpha() == 0) {
            this.getBKColorManager().clearWholeRows(nArray);
        } else {
            this.getBKColorManager().setWholeRowsToValue(nArray, "" + color.getRGB());
        }
    }

    public void setWholeForegroundRowsColor(int[] nArray, Color color) {
        if (color == null || color.getAlpha() == 0) {
            this.getForegroundColorManager().clearWholeRows(nArray);
        } else {
            this.getForegroundColorManager().setWholeRowsToValue(nArray, "" + color.getRGB());
        }
    }

    public void setEntireTableBold(boolean bl) {
        this.getFontBoldManager().setEntireTableON(bl);
    }

    public void setEntireRowsFontBold(int[] nArray, boolean bl) {
        this.getFontBoldManager().setEntireRowsOn(nArray, bl);
    }

    public FormatInfo getFormatInfo(int n, int n2) {
        return this.mTablePropertyManager.getFormatInfo(n, n2);
    }

    @Deprecated
    public FormatInfo getColFormatInfo(int n) {
        Color color = null;
        Color color2 = null;
        String string = this.getBKColorManager().getWholeColumnProperty(n);
        if (string != null) {
            color = new Color(new Integer(string));
        }
        if ((string = this.getForegroundColorManager().getWholeColumnProperty(n)) != null) {
            color2 = new Color(new Integer(string));
        }
        return new FormatInfo(color, color2, null, false, false);
    }

    @Deprecated
    public FormatInfo getRowFormatInfo(int n) {
        Color color = null;
        Color color2 = null;
        String string = this.getBKColorManager().getWholeRowProperty(n);
        if (string != null) {
            color = new Color(new Integer(string));
        }
        if ((string = this.getForegroundColorManager().getWholeRowProperty(n)) != null) {
            color2 = new Color(new Integer(string));
        }
        return new FormatInfo(color, color2, null, false, false);
    }

    public TableBooleanCellPropertyManager getFontBoldManager() {
        return this.mTablePropertyManager.getFontBoldManager();
    }

    public TableCellPropertyManager getBKColorManager() {
        return this.mTablePropertyManager.getBKColorManager();
    }

    public TableCellPropertyManager getForegroundColorManager() {
        return this.mTablePropertyManager.getForegroundColorManager();
    }

    private void initiatePropertyManagers() {
        this.mTablePropertyManager.initiateDefaultPropertyManagers();
    }

    @Deprecated
    public void clearCellProperties(int[] nArray, int[] nArray2) {
        this.mTablePropertyManager.clearCellProperties(nArray, nArray2);
        this.repaint();
    }

    public void doRestoreProperties(Document document) {
        this.mTablePropertyManager.doRestore(document);
    }

    @Deprecated
    public void restorePropertiesFromRecord7(String string) {
        this.mTablePropertyManager = TablePropertyManager.initFromXML(string);
        int[] nArray = this.getCaseIDListFromTablePropertyManagers();
        if (nArray != null) {
            Arrays.sort(nArray);
        }
        int[] nArray2 = this.getRowCaseIDs(nArray, true);
        ArrayList<Integer> arrayList = this.getVarIDListFromTablePropertyManagers();
        ArrayList<Integer> arrayList2 = this.mDataView.getVariabIeDList();
        this.mTablePropertyManager.updateFromOffsetsToIDS(nArray, nArray2, arrayList, arrayList2);
    }

    public int[] getCaseIDListFromTablePropertyManagers() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (TableCellPropertyManager tableCellPropertyManager : this.mTablePropertyManager.getTableCellPropertyManagers()) {
            ArrayList<Integer> arrayList2 = tableCellPropertyManager.getUniqueRowCaseIDs();
            if (arrayList2 == null) continue;
            for (Integer n : arrayList2) {
                if (arrayList.contains(n)) continue;
                arrayList.add(n);
            }
        }
        if (arrayList.size() > 0) {
            Object object = new int[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                object[i] = (Integer)arrayList.get(i);
            }
            return object;
        }
        return null;
    }

    public ArrayList<Integer> getVarIDListFromTablePropertyManagers() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (TableCellPropertyManager tableCellPropertyManager : this.mTablePropertyManager.getTableCellPropertyManagers()) {
            ArrayList<Integer> arrayList2 = tableCellPropertyManager.getUniqueVarIDs();
            if (arrayList2 == null) continue;
            for (Integer n : arrayList2) {
                if (arrayList.contains(n)) continue;
                arrayList.add(n);
            }
        }
        return arrayList;
    }

    public Document createPropertiesXML(String string) {
        int[] nArray = this.getRowCaseIDs(false);
        return this.createPropertiesXML(string, 2, nArray, null);
    }

    public Document createPropertiesXML(String string, int n, int[] nArray, int[] nArray2) {
        this.setSaveMethod(n);
        Document document = this.mTablePropertyManager.createPropertiesXML(string, nArray, nArray2);
        this.setSaveMethod(0);
        return document;
    }

    public TablePropertyManager getTablePropertyManager() {
        return this.mTablePropertyManager;
    }

    public void setSaveMethod(int n) {
        this.mTablePropertyManager.setSaveMethod(n);
    }

    public void stopCellEditing() {
        if (this.isEditing() && !this.getCellEditor().stopCellEditing()) {
            this.getCellEditor().cancelCellEditing();
        }
    }

    @Deprecated
    public boolean isColumnOrRowHeaderSelected(int n, boolean bl) {
        boolean bl2 = false;
        JTable[] jTableArray = this.mDataView.getDataTables();
        if (jTableArray != null && jTableArray[1] != null && jTableArray[1] instanceof SpssRowHeaderTable) {
            int[] nArray;
            for (int n2 : nArray = bl ? jTableArray[1].getSelectedRows() : jTableArray[1].getSelectedColumns()) {
                if (n != n2) continue;
                bl2 = true;
                break;
            }
        }
        return bl2;
    }

    @Override
    public boolean isEntireColumnSelected(int n) {
        int n2 = this.getSelectionModel().getMaxSelectionIndex() - this.getSelectionModel().getMinSelectionIndex() + 1;
        return this.isColumnSelected(n) && n2 == this.getRowCount();
    }

    @Override
    public boolean isEntireRowSelected(int n) {
        return this.isRowSelected(n) && this.getSelectedColumns().length == this.getColumnCount();
    }

    public Object lookupComboItem(JComboBox jComboBox, String string) {
        Object e;
        int n;
        if (string == null || string.length() == 0) {
            return null;
        }
        int n2 = jComboBox.getSelectedIndex();
        n2 = n2 < 0 || n2 == jComboBox.getItemCount() - 1 ? 0 : ++n2;
        Object var5_4 = null;
        for (n = n2; n < jComboBox.getItemCount(); ++n) {
            e = jComboBox.getModel().getElementAt(n);
            if (!this.startsWithIgnoreCase(e.toString(), string)) continue;
            var5_4 = e;
            break;
        }
        if (var5_4 == null) {
            for (n = 0; n < n2; ++n) {
                e = jComboBox.getModel().getElementAt(n);
                if (!this.startsWithIgnoreCase(e.toString(), string)) continue;
                var5_4 = e;
                break;
            }
        }
        return var5_4;
    }

    public boolean startsWithIgnoreCase(String string, String string2) {
        return string.toUpperCase().startsWith(string2.toUpperCase());
    }

    private void handleCaseFilter(final ISpssDataSrc iSpssDataSrc, final int n, final int n2, final boolean bl) {
        this.mProgressDlg = new TraverseCaseProgressDlg(null, ResUtil.getString("IDS_DATA_VIEW"));
        SwingWorker<Object> swingWorker = new SwingWorker<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Object construct() {
                try {
                    DataViewTable.this.getTopLevelAncestor().setCursor(Cursor.getPredefinedCursor(3));
                    DataViewTable.this.moveToNext(this, iSpssDataSrc, n, n2, bl);
                }
                finally {
                    DataViewTable.this.mProgressDlg.dispose();
                    DataViewTable.this.mProgressDlg = null;
                    DataViewTable.this.getTopLevelAncestor().setCursor(null);
                    DataViewTable.this.repaint();
                }
                return null;
            }
        };
        this.mProgressDlg.setSwingWorker(swingWorker);
        swingWorker.start();
        Timer timer = new Timer();
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                if (DataViewTable.this.mProgressDlg != null) {
                    DataViewTable.this.mProgressDlg.setVisible(true);
                }
            }
        };
        timer.schedule(timerTask, 2000L);
    }

    private void moveToNext(SwingWorker swingWorker, ISpssDataSrc iSpssDataSrc, int n, int n2, boolean bl) {
        block6: {
            long l;
            block5: {
                l = this.getDataRowCount();
                if (!bl) break block5;
                int n3 = n + 1;
                while ((long)n3 < l) {
                    if (swingWorker != null && swingWorker.isCancelled()) {
                        return;
                    }
                    this.updateStatus(n3);
                    if (!iSpssDataSrc.isCaseFiltered((long)n3)) {
                        this.mDataView.doSelectCells(n2, n2, n3, n3);
                        this.scrollRectToVisible(this.getCellRect(n3, n2, false));
                        return;
                    }
                    ++n3;
                }
                break block6;
            }
            if ((long)n >= l) break block6;
            for (int i = n - 1; i >= 0; --i) {
                if (swingWorker != null && swingWorker.isCancelled()) {
                    return;
                }
                this.updateStatus(i);
                if (iSpssDataSrc.isCaseFiltered((long)i)) continue;
                this.mDataView.doSelectCells(n2, n2, i, i);
                this.scrollRectToVisible(this.getCellRect(i, n2, false));
                return;
            }
        }
    }

    private void updateStatus(int n) {
        final String string = "Checking Case Id: " + n;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (DataViewTable.this.mProgressDlg != null) {
                    DataViewTable.this.mProgressDlg.updateProgress(string);
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    class TraverseCaseProgressDlg
    extends SpssProgressDlg {
        SwingWorker mSwingWorker;

        TraverseCaseProgressDlg(JFrame jFrame, String string) {
            super((Window)jFrame, string);
        }

        @Override
        public void setMessage(String string) {
            super.setMessage(string);
        }

        void setSwingWorker(SwingWorker swingWorker) {
            this.mSwingWorker = swingWorker;
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            this.cancel();
            super.windowClosing(windowEvent);
            DataViewTable.this.repaint();
        }

        @Override
        public synchronized void actionPerformed(ActionEvent actionEvent) {
            this.cancel();
            super.actionPerformed(actionEvent);
        }

        void cancel() {
            if (this.mSwingWorker != null) {
                this.mSwingWorker.cancel(true);
                super.setCancel(true);
                this.mSwingWorker = null;
            }
        }

        void updateProgress(String string) {
            if (DataViewTable.this.mProgressDlg == null) {
                return;
            }
            DataViewTable.this.mProgressDlg.setMessage(string);
        }
    }

    class ToolTipHeader
    extends JTableHeader {
        public ToolTipHeader(TableColumnModel tableColumnModel) {
            super(tableColumnModel);
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            String string;
            int n = this.columnAtPoint(mouseEvent.getPoint());
            DataViewTable dataViewTable = (DataViewTable)this.getTable();
            int n2 = dataViewTable.convertColumnIndexToModel(n);
            DataViewTableModel dataViewTableModel = (DataViewTableModel)dataViewTable.getModel();
            ISpssDataSrc iSpssDataSrc = dataViewTableModel.getDataSource();
            try {
                ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(n2);
                VarViewTable varViewTable = DataViewTable.this.mDataView.getVarViewTable();
                String string2 = ((VarViewTableModel)varViewTable.getModel()).varTypeName(iSpssVariable);
                String string3 = this.replaceReservedCharacters(iSpssVariable.getLabel());
                if (!iSpssVariable.getLabel().isEmpty()) {
                    string3 = ResUtil.getString("IDS_LABEL") + ": " + string3 + "<br>";
                }
                String string4 = this.replaceReservedCharacters(iSpssVariable.getName());
                string = "<html>" + ResUtil.getString("IDS_NAME") + ": " + string4 + "<br>" + string3 + ResUtil.getString("IDS_TYPE") + ": " + string2 + "<br>" + ResUtil.getString("IDS_MEASURE") + ": " + this.getMeasurementLevelResString(iSpssVariable.getMeasurementLevel()) + "</html>";
            }
            catch (NullPointerException nullPointerException) {
                string = "";
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                string = "";
            }
            if (string.length() < 1) {
                string = super.getToolTipText(mouseEvent);
            }
            return string;
        }

        public String replaceReservedCharacters(String string) {
            StringBuffer stringBuffer = new StringBuffer(string);
            for (int i = 0; i < stringBuffer.length(); ++i) {
                char c = stringBuffer.charAt(i);
                if (c == '<') {
                    stringBuffer.replace(i, i + 1, "&lt;");
                    continue;
                }
                if (c == '>') {
                    stringBuffer.replace(i, i + 1, "&gt;");
                    continue;
                }
                if (c == '&') {
                    stringBuffer.replace(i, i + 1, "&amp;");
                    continue;
                }
                if (c != '\"') continue;
                stringBuffer.replace(i, i + 1, "&quot;");
            }
            return stringBuffer.toString();
        }

        @Override
        public Dimension getPreferredSize() {
            if (this.isPreferredSizeSet()) {
                return super.getPreferredSize();
            }
            Dimension dimension = null;
            if (this.ui != null) {
                long l = 0L;
                JTableHeader jTableHeader = DataViewTable.this.getTableHeader();
                Enumeration<TableColumn> enumeration = jTableHeader.getColumnModel().getColumns();
                while (enumeration.hasMoreElements()) {
                    TableColumn tableColumn = enumeration.nextElement();
                    l += (long)tableColumn.getPreferredWidth();
                }
                dimension = this.createHeaderSize(l);
            }
            return dimension != null ? dimension : super.getPreferredSize();
        }

        private Dimension createHeaderSize(long l) {
            if (l > Integer.MAX_VALUE) {
                l = Integer.MAX_VALUE;
            }
            return new Dimension((int)l, this.getHeaderHeight());
        }

        private int getHeaderHeight() {
            int n = this.calculateHeaderHeight();
            boolean bl = DataViewTable.this.mDataView.isDividerOn();
            if (bl) {
                JTable[] jTableArray;
                for (JTable jTable : jTableArray = DataViewTable.this.mDataView.getColHeaderTables()) {
                    JTableHeader jTableHeader;
                    if (jTable == DataViewTable.this || !((jTableHeader = jTable.getTableHeader()) instanceof ToolTipHeader)) continue;
                    int n2 = ((ToolTipHeader)jTableHeader).calculateHeaderHeight();
                    if (n2 != n) {
                        jTableHeader.revalidate();
                    }
                    n = Math.max(n, n2);
                }
            }
            return n;
        }

        int calculateHeaderHeight() {
            int n = 22;
            TableColumnModel tableColumnModel = this.getColumnModel();
            Rectangle rectangle = this.getVisibleRect();
            int n2 = this.columnAtPoint(rectangle.getLocation());
            int n3 = this.columnAtPoint(new Point((int)rectangle.getMaxX(), (int)rectangle.getMaxY()));
            n2 -= 16;
            n2 = Math.max(n2, 0);
            n3 += 16;
            n3 = Math.min(n3, tableColumnModel.getColumnCount());
            boolean bl = this.isWindows8OrNewer(false);
            int n4 = this.calculateThreeLinesHighHeaderHeight(n2);
            for (int i = n2; i < n3; ++i) {
                String string;
                TableColumn tableColumn = tableColumnModel.getColumn(i);
                if (tableColumn.getHeaderRenderer() == null && i != 0) continue;
                TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
                if (tableCellRenderer == null) {
                    tableCellRenderer = this.getDefaultRenderer();
                }
                if (ComponentState.containsBidiLetter((String)(string = DataViewTable.this.getColumnName(i)))) {
                    this.isWindows8OrNewer(true);
                }
                if (bl && ComponentState.containsBidiLetter((String)string)) {
                    n = n4;
                    continue;
                }
                Component component = tableCellRenderer.getTableCellRendererComponent(DataViewTable.this, tableColumn.getHeaderValue(), false, false, -1, i);
                int n5 = component.getPreferredSize().height;
                n = Math.max(n, n5);
            }
            return n;
        }

        private int calculateThreeLinesHighHeaderHeight(int n) {
            Serializable serializable;
            TableCellRenderer tableCellRenderer = null;
            if (this.columnModel.getColumnCount() > 0) {
                serializable = this.columnModel.getColumn(n);
                tableCellRenderer = ((TableColumn)serializable).getHeaderRenderer();
            }
            if (tableCellRenderer == null) {
                tableCellRenderer = this.getDefaultRenderer();
            }
            serializable = ((JLabel)((Object)tableCellRenderer)).getFontMetrics(((JLabel)((Object)tableCellRenderer)).getFont());
            int n2 = ((FontMetrics)serializable).getHeight() * 3 + 12;
            return n2;
        }

        public boolean isWindows8OrNewer(boolean bl) {
            boolean bl2 = false;
            if (com.spss.shared.custom_gui.ui_builder.Util.OSInfo.getOSType() == OSInfo.OSType.WIN) {
                String string = System.getProperty("os.name").toLowerCase();
                String string2 = System.getProperty("os.version");
                if (string.contains("8") || string.contains("8.1") || string2.equalsIgnoreCase("6.2")) {
                    bl2 = true;
                }
            }
            return bl2;
        }

        public boolean isWindows8OrNewerOLD(boolean bl) {
            boolean bl2 = false;
            if (com.spss.shared.custom_gui.ui_builder.Util.OSInfo.getOSType() == OSInfo.OSType.WIN) {
                double d;
                int n;
                String string = System.getProperty("os.version", "");
                int n2 = string.lastIndexOf(".");
                if (n2 != (n = string.indexOf("."))) {
                    string = string.substring(0, n2);
                }
                if ((d = Double.valueOf(string).doubleValue()) >= 8.0) {
                    bl2 = true;
                }
            }
            return bl2;
        }

        String getMeasurementLevelResString(MeasurementLevel measurementLevel) {
            String string = "";
            string = measurementLevel == MeasurementLevel.scale ? VarViewTable.sMeasurementValues[0] : (measurementLevel == MeasurementLevel.ordinal ? VarViewTable.sMeasurementValues[1] : (measurementLevel == MeasurementLevel.nominal ? VarViewTable.sMeasurementValues[2] : VarViewTable.sMeasurementValues[3]));
            return string;
        }
    }

    class ValueLabelComboEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private TypeAheadCombo mCombo = new TypeAheadCombo(true);
        private GeneralNumberFormat mFormatter = null;

        ValueLabelComboEditor() {
            this.mCombo.putClientProperty((Object)"JComboBox.isTableCellEditor", (Object)Boolean.TRUE);
            this.mCombo.setEditable(true);
            this.mCombo.setFocusable(true);
            this.mCombo.setClosePopupOnMismatch(true);
            this.mCombo.getEditor().getEditorComponent().addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() > 1) {
                        mouseEvent.consume();
                        ValueLabelComboEditor.this.selectByOBS(ValueLabelComboEditor.this.getCellEditorValue(), false);
                    }
                }
            });
            this.mCombo.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    int n = keyEvent.getKeyCode();
                    if (n == 27) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                DataViewTable.this.requestFocusInWindow();
                            }
                        });
                    } else if (n == 10) {
                        if (DataViewTable.this.getCellEditor() != null) {
                            boolean bl = false;
                            ComboPopup comboPopup = ValueLabelComboEditor.this.getComboPopup();
                            if (comboPopup != null) {
                                bl = comboPopup.isVisible();
                            }
                            if (bl) {
                                ValueLabelComboEditor.this.mCombo.getEditor().setItem(comboPopup.getList().getSelectedValue());
                                final KeyEvent keyEvent2 = keyEvent;
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        ValueLabelComboEditor.this.stopCellEditing();
                                        DataViewTable.this.requestFocusInWindow();
                                        KeyEvent keyEvent = new KeyEvent(DataViewTable.this, 401, keyEvent2.getWhen(), keyEvent2.getModifiers(), keyEvent2.getKeyCode(), keyEvent2.getKeyChar());
                                        DataViewTable.this.dispatchEvent(keyEvent);
                                    }
                                });
                            } else {
                                ValueLabelComboEditor.this.stopCellEditing();
                                int n2 = DataViewTable.this.getSelectedRow();
                                int n3 = DataViewTable.this.getSelectedColumn();
                                if (n2 >= 0 && n3 >= 0) {
                                    DataViewTable.this.changeSelection(++n2, n3, false, false);
                                    keyEvent.consume();
                                    ValueLabelComboEditor.this.stopCellEditing();
                                }
                            }
                        }
                    } else if (n == 37 || n == 39) {
                        ValueLabelComboEditor.this.handleLeftRightArrowKeys(keyEvent);
                    }
                }
            });
        }

        private void handleLeftRightArrowKeys(KeyEvent keyEvent) {
            JComponent jComponent;
            Component component;
            boolean bl = false;
            boolean bl2 = false;
            ComboPopup comboPopup = this.getComboPopup();
            if (comboPopup != null) {
                bl2 = comboPopup.isVisible();
            }
            if (bl2) {
                bl = true;
            } else {
                component = this.mCombo.getEditor().getEditorComponent();
                if (component instanceof JTextField) {
                    jComponent = (JTextField)component;
                    int n = ((JTextComponent)jComponent).getText().length();
                    int n2 = ((JTextComponent)jComponent).getCaretPosition();
                    if (keyEvent.getKeyCode() == 37 && n2 == 0 || keyEvent.getKeyCode() == 39 && n2 == n) {
                        bl = true;
                    }
                }
            }
            if (bl) {
                this.stopCellEditing();
                component = FocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
                if (component instanceof DataFrame && (jComponent = ((DataFrame)component).getDataView().getLastActiveTable()) != null) {
                    KeyEvent keyEvent2 = new KeyEvent(jComponent, 401, keyEvent.getWhen(), keyEvent.getModifiers(), keyEvent.getKeyCode(), keyEvent.getKeyChar());
                    jComponent.dispatchEvent(keyEvent2);
                    keyEvent.consume();
                }
            }
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            ComboPopup comboPopup;
            if (bl) {
                this.mCombo.setForeground(jTable.getSelectionForeground());
                this.mCombo.setBackground(jTable.getSelectionBackground());
            } else {
                this.mCombo.setForeground(jTable.getForeground());
                this.mCombo.setBackground(jTable.getBackground());
            }
            this.mCombo.setFont(DataViewTable.this.getFont());
            this.mCombo.removeAllItems();
            ISpssDataSrc iSpssDataSrc = DataViewTable.this.mDataView.getDataSrc();
            if (n2 >= 0 && n2 < iSpssDataSrc.columnCount()) {
                comboPopup = iSpssDataSrc.getVariable(n2);
                int n3 = 4;
                DisplayAlignment displayAlignment = comboPopup.getDisplayAlignment();
                if (displayAlignment.equals((Object)DisplayAlignment.left)) {
                    n3 = 2;
                } else if (displayAlignment.equals((Object)DisplayAlignment.center)) {
                    n3 = 0;
                }
                ((JTextField)this.mCombo.getEditor().getEditorComponent()).setHorizontalAlignment(n3);
                IValueLabelMap iValueLabelMap = comboPopup.getValueLabels();
                Set set = iValueLabelMap.getValueLabelEntries();
                for (Map.Entry entry : set) {
                    StringBag stringBag = new StringBag((String)entry.getValue());
                    stringBag.setUserObject(entry.getKey());
                    this.mCombo.addItem((Object)stringBag);
                }
            }
            if ((comboPopup = this.getComboPopup()) != null) {
                JList<Object> jList = comboPopup.getList();
                jList.setBackground(new Color(255, 255, 255));
            }
            this.selectByOBS(object, true);
            return this.mCombo;
        }

        @Override
        public void cancelCellEditing() {
            super.cancelCellEditing();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DataViewTable.this.requestFocusInWindow();
                }
            });
        }

        @Override
        public Object getCellEditorValue() {
            Object object = "";
            Object object2 = this.mCombo.getEditor().getItem();
            if (object2 != null) {
                object = CharacterUtil.rightTrim((String)object2.toString());
                for (int i = 0; i < this.mCombo.getItemCount(); ++i) {
                    object2 = this.mCombo.getItemAt(i);
                    OBS oBS = (OBS)((StringBag)object2).getUserObject();
                    if (object2.toString().equals(object)) {
                        oBS = (OBS)((StringBag)object2).getUserObject();
                        object = oBS.isString() ? oBS.getString() : Double.valueOf(oBS.getNum());
                        break;
                    }
                    if (!oBS.isString() || !oBS.getString().equals(object)) continue;
                    object = oBS.isString() ? oBS.getString() : Double.valueOf(oBS.getNum());
                    break;
                }
            }
            return object;
        }

        public void reset() {
            this.mFormatter = null;
        }

        private void selectByOBS(Object object, boolean bl) {
            Object object2;
            String string = null;
            if (object != null && object.toString().length() > 0) {
                if (!DataViewTableModel.getSysmisString().equals(object)) {
                    for (int i = 0; i < this.mCombo.getItemCount(); ++i) {
                        object2 = this.mCombo.getItemAt(i);
                        OBS oBS = (OBS)((StringBag)object2).getUserObject();
                        if ((!oBS.isString() || !oBS.getString().equals(object.toString())) && (oBS.isString() || !(object instanceof Double) || oBS.getNum() != ((Double)object).doubleValue())) continue;
                        this.mCombo.setSelectedIndex(i);
                        string = ((StringBag)object2).getString();
                        break;
                    }
                } else {
                    object = null;
                }
            }
            ComboBoxEditor comboBoxEditor = this.mCombo.getEditor();
            if (bl && string != null) {
                comboBoxEditor.setItem(string);
            } else if (object != null && object instanceof Double) {
                if (this.mFormatter == null) {
                    this.mFormatter = new GeneralNumberFormat(ComponentState.getSPSSLocale());
                    this.mFormatter.setGroupingUsed(false);
                }
                try {
                    object2 = this.mFormatter.format(object);
                    comboBoxEditor.setItem(object2);
                }
                catch (Exception exception) {
                    comboBoxEditor.setItem("");
                }
            } else {
                comboBoxEditor.setItem(object != null ? object.toString() : "");
            }
        }

        private ComboPopup getComboPopup() {
            Accessible accessible = this.mCombo.getUI().getAccessibleChild((JComponent)this.mCombo, 0);
            if (accessible instanceof ComboPopup) {
                return (ComboPopup)((Object)accessible);
            }
            return null;
        }
    }

    class EditTableKeyHandler
    extends KeyAdapter {
        EditTableKeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            int n;
            int n2;
            if (keyEvent.isControlDown()) {
                if (keyEvent.getKeyCode() == 85) {
                    keyEvent.setKeyCode(38);
                } else if (keyEvent.getKeyCode() == 68) {
                    keyEvent.setKeyCode(40);
                }
            }
            if (this.isLeftRightNavKey(keyEvent)) {
                this.doLeftRightMove(keyEvent);
                if (keyEvent.isConsumed()) {
                    return;
                }
            }
            if (keyEvent.getKeyCode() == 9) {
                DataViewTable.this.doTabKeyMove(keyEvent);
            } else if (this.isCtrlArrowKey(keyEvent)) {
                DataViewTable.this.doKeyControlArrowMove(keyEvent);
            }
            if (this.isNavKey(keyEvent)) {
                DataViewTable.this.mDataView.clearRowHeaderSelection(DataViewTable.this);
                n2 = DataViewTable.this.getSelectedRow();
                n = DataViewTable.this.getSelectedColumn();
                ISpssDataSrc iSpssDataSrc = DataViewTable.this.mDataView.getDataSrc();
                if (((DataFrame)DataViewTable.this.getSpssFrame()).getViewValueLabels() && keyEvent.isAltDown() && !keyEvent.isControlDown() && !keyEvent.isMetaDown() && !keyEvent.isShiftDown() && keyEvent.getKeyCode() == 40) {
                    TableCellEditor tableCellEditor;
                    keyEvent.consume();
                    if (DataViewTable.this.editCellAt(n2, n, keyEvent) && (tableCellEditor = DataViewTable.this.getCellEditor(n2, n)) instanceof ValueLabelComboEditor) {
                        ComboPopup comboPopup = ((ValueLabelComboEditor)tableCellEditor).getComboPopup();
                        comboPopup.show();
                        ((ValueLabelComboEditor)tableCellEditor).mCombo.getEditor().setItem(comboPopup.getList().getSelectedValue());
                    }
                } else {
                    if (keyEvent.isAltDown() && (keyEvent.getKeyCode() == 40 || keyEvent.getKeyCode() == 38) && iSpssDataSrc != null && iSpssDataSrc.getCaseFilter() != null) {
                        keyEvent.consume();
                        DataViewTable.this.handleCaseFilter(iSpssDataSrc, n2, n, keyEvent.getKeyCode() == 40);
                        return;
                    }
                    if ((keyEvent.isControlDown() || keyEvent.isMetaDown()) && keyEvent.isShiftDown() && !DataViewTable.this.isEditing()) {
                        this.handleCtrlShiftNavKey(keyEvent);
                        return;
                    }
                }
            }
            if (keyEvent.getKeyCode() == 35 && DataViewTable.this.getDataColumnCount() != -1 && DataViewTable.this.getDataRowCount() != -1L) {
                if (!(keyEvent.isControlDown() || keyEvent.isMetaDown() || keyEvent.isShiftDown())) {
                    keyEvent.consume();
                    DataViewTable.this.stopCellEditing();
                    n2 = DataViewTable.this.getSelectedRow();
                    n = DataViewTable.this.getDataColumnCount() - 1;
                    DataViewTable.this.clearSelection();
                    DataViewTable.this.mDataView.doSelectCells(n, n, n2, n2);
                    DataViewTable.this.scrollRectToVisible(DataViewTable.this.getCellRect(n2, n, false));
                } else if ((keyEvent.isControlDown() || keyEvent.isMetaDown()) && !keyEvent.isShiftDown()) {
                    keyEvent.consume();
                    DataViewTable.this.clearSelection();
                    DataViewTable.this.stopCellEditing();
                    n2 = (int)DataViewTable.this.getDataRowCount() - 1;
                    n = DataViewTable.this.getDataColumnCount() - 1;
                    DataViewTable.this.mDataView.doSelectCells(n, n, n2, n2);
                    DataViewTable.this.scrollRectToVisible(DataViewTable.this.getCellRect(n2, n, false));
                } else if (!keyEvent.isControlDown() && !keyEvent.isMetaDown() && keyEvent.isShiftDown()) {
                    keyEvent.consume();
                    DataViewTable.this.stopCellEditing();
                    n2 = DataViewTable.this.getSelectedRow();
                    n = DataViewTable.this.getSelectedColumn();
                    int n3 = DataViewTable.this.getDataColumnCount() - 1;
                    DataViewTable.this.clearSelection();
                    DataViewTable.this.mDataView.doSelectCells(n3 >= n ? n : n3, n3, n2, n2);
                    DataViewTable.this.scrollRectToVisible(DataViewTable.this.getCellRect(n2, n3, false));
                }
            } else if (!DataViewTable.this.isEditing() && keyEvent.isShiftDown() && keyEvent.getKeyCode() == 32 && DataViewTable.this.getDataColumnCount() != -1 && DataViewTable.this.getDataRowCount() != -1L) {
                keyEvent.consume();
                n2 = DataViewTable.this.getSelectedRow();
                n = DataViewTable.this.getSelectedColumn();
                DataViewTable.this.clearSelection();
                DataViewTable.this.mDataView.doSelectRows(n2, n2);
                DataViewTable.this.getSelectionModel().addSelectionInterval(n2, n2);
                DataViewTable.this.getColumnModel().getSelectionModel().addSelectionInterval(n, n);
            } else if (!DataViewTable.this.isEditing() && (keyEvent.isControlDown() || keyEvent.isMetaDown()) && keyEvent.getKeyCode() == 32 && DataViewTable.this.getDataColumnCount() != -1 && DataViewTable.this.getDataRowCount() != -1L) {
                keyEvent.consume();
                n2 = DataViewTable.this.getSelectedRow();
                n = DataViewTable.this.getSelectedColumn();
                DataViewTable.this.clearSelection();
                DataViewTable.this.mDataView.doSelectColumns(n, n);
                DataViewTable.this.getSelectionModel().addSelectionInterval(n2, n2);
                DataViewTable.this.getColumnModel().getSelectionModel().addSelectionInterval(n, n);
            } else if ((keyEvent.isControlDown() || keyEvent.isMetaDown()) && !keyEvent.isShiftDown() && keyEvent.getKeyCode() == 36) {
                keyEvent.consume();
                DataViewTable.this.clearSelection();
                DataViewTable.this.stopCellEditing();
                DataViewTable.this.mDataView.doSelectCells(0, 0, 0, 0);
                DataViewTable.this.scrollRectToVisible(DataViewTable.this.getCellRect(0, 0, false));
            }
        }

        private boolean isCtrlArrowKey(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            return keyEvent.isControlDown() && !keyEvent.isShiftDown() && n >= 37 && n <= 40;
        }

        private boolean isNavKey(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            return n >= 33 && n <= 40;
        }

        private boolean isLeftRightNavKey(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            return !keyEvent.isAltDown() && !keyEvent.isShiftDown() && !keyEvent.isControlDown() && !keyEvent.isMetaDown() && (n == 37 || n == 39) || n == 9;
        }

        private void doLeftRightMove(KeyEvent keyEvent) {
            TableColumn tableColumn;
            int n = keyEvent.getKeyCode();
            boolean bl = (keyEvent.getModifiersEx() & 0x40) != 0;
            int n2 = DataViewTable.this.getSelectedColumn();
            boolean bl2 = n == 39 || n == 9 && !bl;
            if ((n2 += bl2 ? 1 : -1) >= 0 && n2 < DataViewTable.this.getColumnCount() && (tableColumn = DataViewTable.this.getColumnModel().getColumn(n2)) != null && tableColumn.getPreferredWidth() == 0 && !tableColumn.getResizable()) {
                if (n2 == 0 && !bl2) {
                    keyEvent.consume();
                } else {
                    int n3 = DataViewTable.this.getSelectedRow();
                    if (n3 >= 0) {
                        DataViewTable.this.changeSelection(n3, n2, false, false);
                        keyEvent.consume();
                        DataViewTable.this.stopCellEditing();
                    }
                }
            }
        }

        private void handleCtrlShiftNavKey(KeyEvent keyEvent) {
            if (!keyEvent.isControlDown() && !keyEvent.isMetaDown() || !keyEvent.isShiftDown()) {
                return;
            }
            int n = DataViewTable.this.getSelectedRow();
            int n2 = DataViewTable.this.getSelectedColumn();
            int n3 = (int)DataViewTable.this.getDataRowCount() - 1;
            int n4 = DataViewTable.this.getDataColumnCount() - 1;
            n = n3 >= n ? n : n3;
            int n5 = n2 = n4 >= n2 ? n2 : n4;
            if (DataViewTable.this.getDataRowCount() != -1L) {
                if (keyEvent.getKeyCode() == 35) {
                    keyEvent.consume();
                    DataViewTable.this.clearSelection();
                    DataViewTable.this.mDataView.doSelectCells(n2, n4, n, n3);
                    DataViewTable.this.scrollRectToVisible(DataViewTable.this.getCellRect(n3, n4, false));
                } else if (keyEvent.getKeyCode() == 40) {
                    keyEvent.consume();
                    DataViewTable.this.clearSelection();
                    DataViewTable.this.mDataView.doSelectCells(n2, n2, n, n3);
                    DataViewTable.this.scrollRectToVisible(DataViewTable.this.getCellRect(n3, n2, false));
                }
            }
            if (keyEvent.getKeyCode() == 36) {
                keyEvent.consume();
                DataViewTable.this.clearSelection();
                DataViewTable.this.mDataView.doSelectCells(0, n2, 0, n);
                DataViewTable.this.scrollRectToVisible(DataViewTable.this.getCellRect(n, n2, false));
            } else if (keyEvent.getKeyCode() == 38) {
                keyEvent.consume();
                DataViewTable.this.clearSelection();
                n = Math.max(DataViewTable.this.getSelectionModel().getLeadSelectionIndex(), DataViewTable.this.getSelectionModel().getAnchorSelectionIndex());
                DataViewTable.this.mDataView.doSelectCells(n2, n2, 0, n);
                DataViewTable.this.scrollRectToVisible(DataViewTable.this.getCellRect(0, n2, false));
            } else if (keyEvent.getKeyCode() == 37) {
                keyEvent.consume();
                DataViewTable.this.clearSelection();
                n2 = Math.max(DataViewTable.this.getColumnModel().getSelectionModel().getLeadSelectionIndex(), DataViewTable.this.getColumnModel().getSelectionModel().getAnchorSelectionIndex());
                DataViewTable.this.mDataView.doSelectCells(0, n2, n, n);
                DataViewTable.this.scrollRectToVisible(DataViewTable.this.getCellRect(n, 0, false));
            } else if (keyEvent.getKeyCode() == 39) {
                keyEvent.consume();
                DataViewTable.this.clearSelection();
                DataViewTable.this.mDataView.doSelectCells(n2, n4, n, n);
                DataViewTable.this.scrollRectToVisible(DataViewTable.this.getCellRect(n, n4, false));
            }
        }
    }

    class TableHeaderMouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        int mPressedCachedColIdx = 0;
        int[] mPrevColsSelected = null;
        boolean mIsColumnMoving = false;
        int mDragColumn = -1;
        int mDragStartWidth = -1;

        TableHeaderMouseHandler() {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
            TableColumn tableColumn = jTableHeader.getResizingColumn();
            if (tableColumn == null && !sHeaderRMouseButtonPressed) {
                if (this.mIsColumnMoving) {
                    return;
                }
                int n = jTableHeader.columnAtPoint(mouseEvent.getPoint());
                if (n < 0 || n >= DataViewTable.this.getColumnCount()) {
                    return;
                }
                if (DataView.sPrevSelMode == DataView.SelectMode.COL_SELECT) {
                    if (this.mPressedCachedColIdx == -1) {
                        this.mPressedCachedColIdx = DataViewTable.this.getSelectedColumn();
                    }
                    if (mouseEvent.isControlDown()) {
                        DataViewTable.this.setRowSelectionInterval(DataViewTable.this.getRowCount() - 1, 0);
                        DataViewTable.this.setColumnSelectionInterval(this.mPressedCachedColIdx, n);
                        if (this.mPrevColsSelected != null) {
                            for (int n2 : this.mPrevColsSelected) {
                                DataViewTable.this.addColumnSelectionInterval(n2, n2);
                            }
                        }
                    } else {
                        DataViewTable.this.clearSelection();
                        DataViewTable.this.setRowSelectionInterval(DataViewTable.this.getRowCount() - 1, 0);
                        DataViewTable.this.setColumnSelectionInterval(this.mPressedCachedColIdx, n);
                    }
                    Point point = (Point)mouseEvent.getPoint().clone();
                    Object object = mouseEvent.getSource();
                    if (object instanceof JTableHeader) {
                        SwingUtilities.convertPoint((JTableHeader)object, point, DataViewTable.this);
                    } else if (object != this) {
                        return;
                    }
                    DataViewTable.this.autoscroll(point);
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            sHeaderRMouseButtonPressed = mouseEvent.getButton() == 2 || mouseEvent.getButton() == 3;
            DataViewTable.this.mDataView.commitEdit();
            JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
            JTable jTable = jTableHeader.getTable();
            int n = jTable.columnAtPoint(new Point(mouseEvent.getPoint().x, mouseEvent.getPoint().y));
            if (n < 0 || n >= DataViewTable.this.getColumnCount()) {
                return;
            }
            DataViewTable.this.requestFocusInWindow();
            boolean bl = mouseEvent.getButton() == 1;
            TableColumn tableColumn = jTableHeader.getResizingColumn();
            if (tableColumn == null || !bl) {
                int n2;
                if (!DataViewTable.this.mDataView.isDividerOn()) {
                    DataViewTable.this.scrollRectToVisible(DataViewTable.this.getCellRect(0, n, false));
                }
                if (bl && mouseEvent.getClickCount() > 1) {
                    DataViewTable.this.mDataView.setActiveView(1);
                    DataViewTable.this.mDataView.selectAndScrollToVariable(1, n);
                    return;
                }
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    n2 = (Integer)iterator.next();
                    arrayList.add(n2);
                }
                boolean bl2 = DataViewTable.this.isEntireColumnSelected(n);
                if (!(!bl2 || DataView.sPrevSelMode != DataView.SelectMode.COL_SELECT || mouseEvent.getButton() != 1 && mouseEvent.getButton() != 2 || mouseEvent.isControlDown() || mouseEvent.isShiftDown())) {
                    TransferHandler transferHandler = jTableHeader.getTransferHandler();
                    transferHandler.exportAsDrag(jTableHeader, mouseEvent, 2);
                    this.mIsColumnMoving = true;
                    this.mPressedCachedColIdx = -1;
                    return;
                }
                if (DataView.sPrevSelMode == DataView.SelectMode.COL_SELECT) {
                    if (mouseEvent.isControlDown()) {
                        if (bl2) {
                            arrayList.remove((Object)n);
                            DataViewTable.this.removeColumnSelectionInterval(n, n);
                            DataViewTable.this.removeRowSelectionInterval(DataViewTable.this.getRowCount() - 1, 0);
                            if (arrayList.size() > 0) {
                                n2 = (Integer)arrayList.get(0);
                                DataViewTable.this.addRowSelectionInterval(DataViewTable.this.getRowCount() - 1, 0);
                                DataViewTable.this.addColumnSelectionInterval(n2, n2);
                            }
                        } else {
                            DataViewTable.this.addRowSelectionInterval(DataViewTable.this.getRowCount() - 1, 0);
                            DataViewTable.this.addColumnSelectionInterval(n, n);
                        }
                    } else if (mouseEvent.isShiftDown()) {
                        DataViewTable.this.setRowSelectionInterval(DataViewTable.this.getRowCount() - 1, 0);
                        if (this.mPressedCachedColIdx == -1) {
                            this.mPressedCachedColIdx = arrayList.size() > 0 ? (Integer)arrayList.get(0) : 0;
                        }
                        DataViewTable.this.setColumnSelectionInterval(this.mPressedCachedColIdx, n);
                    } else if (bl || !bl2) {
                        DataViewTable.this.mDataView.clearRowHeaderSelection(DataViewTable.this);
                        DataViewTable.this.setRowSelectionInterval(DataViewTable.this.getRowCount() - 1, 0);
                        DataViewTable.this.setColumnSelectionInterval(n, n);
                    }
                } else {
                    DataViewTable.this.mDataView.clearRowHeaderSelection(DataViewTable.this);
                    DataViewTable.this.setRowSelectionInterval(DataViewTable.this.getRowCount() - 1, 0);
                    DataViewTable.this.setColumnSelectionInterval(n, n);
                }
                DataView.sPrevSelMode = DataView.SelectMode.COL_SELECT;
                if (!mouseEvent.isShiftDown()) {
                    this.mPressedCachedColIdx = n;
                }
            } else {
                this.mDragStartWidth = tableColumn.getPreferredWidth();
                this.mDragColumn = tableColumn.getModelIndex();
            }
            if (mouseEvent.isPopupTrigger()) {
                DataViewTable.this.executeTablePopup(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            sHeaderRMouseButtonPressed = false;
            if (mouseEvent.isPopupTrigger()) {
                DataViewTable.this.executeTablePopup(mouseEvent);
            } else if (this.mDragColumn > -1) {
                JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
                JTable jTable = jTableHeader.getTable();
                TableColumn tableColumn = jTable.getColumnModel().getColumn(this.mDragColumn);
                if (DataViewTable.this.mDataView.getDataColumnCount() > this.mDragColumn) {
                    this.doTableColumnWidth(jTable);
                } else {
                    tableColumn.setPreferredWidth(this.mDragStartWidth);
                }
                this.mDragColumn = -1;
                this.mDragStartWidth = -1;
            }
            DataViewTable.this.mDataView.updateToolbarEnableStatus();
            this.mPrevColsSelected = DataViewTable.this.getSelectedColumns();
            this.mIsColumnMoving = false;
        }

        private void doTableColumnWidth(JTable jTable) {
            int n = jTable.getColumnModel().getColumn(this.mDragColumn).getPreferredWidth();
            if (DataViewTable.this.isEntireColumnSelected(this.mDragColumn)) {
                int[] nArray = jTable.getColumnModel().getSelectedColumns();
                new TableColumnWidthEdit(DataViewTable.this.mDataView, 0, nArray, this.mDragColumn, this.mDragStartWidth, n);
            } else {
                new TableColumnWidthEdit(DataViewTable.this.mDataView, 0, this.mDragColumn, this.mDragStartWidth, n);
            }
        }
    }

    class CellSelectionMouseHandler
    extends MouseAdapter {
        CellSelectionMouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            int n = DataViewTable.this.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
            int n2 = DataViewTable.this.getSelectionModel().getAnchorSelectionIndex();
            sMouseDown = true;
            int n3 = DataViewTable.this.columnAtPoint(mouseEvent.getPoint());
            int n4 = DataViewTable.this.rowAtPoint(mouseEvent.getPoint());
            if (mouseEvent.isPopupTrigger()) {
                this.doPopup(mouseEvent);
            } else {
                int n5;
                if (mouseEvent.getButton() != 1) {
                    return;
                }
                boolean bl = DataViewTable.this.isEditing();
                if (bl) {
                    DataViewTable.this.stopCellEditing();
                }
                DataViewTable.this.mDataView.clearRowHeaderSelection(DataViewTable.this);
                boolean bl2 = DataViewTable.this.isCellSelected(n4, n3);
                DataView.sPrevSelMode = DataView.SelectMode.CELL_SELECT;
                if (mouseEvent.isShiftDown()) {
                    DataViewTable.this.setColumnSelectionInterval(n, n3);
                    DataViewTable.this.setRowSelectionInterval(n2, n4);
                } else if (mouseEvent.getButton() != 3 && mouseEvent.isControlDown()) {
                    DataViewTable.this.setColumnSelectionInterval(n, n);
                    DataViewTable.this.setRowSelectionInterval(n2, n2);
                } else if (mouseEvent.getButton() != 3 || !DataViewTable.this.isCellSelected(n4, n3)) {
                    DataViewTable.this.setColumnSelectionInterval(n3, n3);
                    DataViewTable.this.setRowSelectionInterval(n4, n4);
                }
                mouseEvent.consume();
                TableCellEditor tableCellEditor = DataViewTable.this.getCellEditor(n4, n3);
                int n6 = n5 = tableCellEditor instanceof ValueLabelComboEditor && bl2 ? 1 : 2;
                if (tableCellEditor != null && tableCellEditor.isCellEditable(mouseEvent) && mouseEvent.getClickCount() >= n5) {
                    DataViewTable.this.editCellAt(n4, n3, mouseEvent);
                    final Component component = DataViewTable.this.getEditorComponent();
                    if (bl && component != null) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                component.requestFocusInWindow();
                                if (component instanceof JTextField) {
                                    ((JTextField)component).selectAll();
                                } else if (component instanceof JComboBox) {
                                    ((JComboBox)component).getEditor().selectAll();
                                }
                            }
                        });
                    }
                } else {
                    DataViewTable.this.requestFocusInWindow();
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            sMouseDown = false;
            DataViewTable.this.repaint();
            if (mouseEvent.isPopupTrigger()) {
                this.doPopup(mouseEvent);
            }
        }

        private void doPopup(MouseEvent mouseEvent) {
            int n = DataViewTable.this.columnAtPoint(mouseEvent.getPoint());
            int n2 = DataViewTable.this.rowAtPoint(mouseEvent.getPoint());
            if (!DataViewTable.this.isCellSelected(n2, n)) {
                DataViewTable.this.mDataView.clearRowHeaderSelection(DataViewTable.this);
                DataViewTable.this.setColumnSelectionInterval(n, n);
                DataViewTable.this.setRowSelectionInterval(n2, n2);
            }
            DataViewTable.this.executeCellPopup(mouseEvent);
        }
    }

    class DataViewListSelectionListener
    implements ListSelectionListener {
        DataViewListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            int n = DataViewTable.this.getSelectedRow();
            int n2 = DataViewTable.this.getSelectedColumn();
            if (n < 0 || n2 < 0) {
                DataViewTable.this.mEditBar.currentCellChanged(-1L, -1);
            } else {
                DataViewTable.this.mEditBar.currentCellChanged(n, DataViewTable.this.convertColumnIndexToModel(n2));
            }
            DataViewTable.this.mDataView.refreshDataRowCol(n, n2);
            DataViewTable.this.mDataView.updateSearchDialogControls();
        }
    }

    public static enum Location {
        eTopLeft,
        eTopRight,
        eBottomLeft,
        eBottomRight;

    }
}

