/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.data;

import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.ILocaleListener;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.ORIGINATOR_ID;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.prefs.PrefDefaults;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.documents.AppMgr;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.core.documents.data.cache.CacheColumnInfo;
import com.spss.java_client.core.documents.data.case_filter.VarCaseFilter;
import com.spss.java_client.core.documents.data.dictionary.ColumnDataProvider;
import com.spss.java_client.core.documents.data.dictionary.DisplayAlignment;
import com.spss.java_client.core.documents.data.dictionary.ExtensionType;
import com.spss.java_client.core.documents.data.dictionary.FormatType;
import com.spss.java_client.core.documents.data.dictionary.IDatasetViewObserver;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.IVariableSet;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.core.documents.data.dictionary.SpssVariable;
import com.spss.java_client.core.documents.data.dictionary.value_labels.IValueLabelMap;
import com.spss.java_client.core.documents.syntax.SyntaxMgr;
import com.spss.java_client.core.script.ScriptingUtil;
import com.spss.java_client.core.server.messages.DataEditorMsg.CellValue;
import com.spss.java_client.core.server.messages.DataEditorMsg.FindValueMsg;
import com.spss.java_client.core.server.messages.DataEditorMsg.RowRange;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.dialogs.base.edit.find.DataFindDlg;
import com.spss.java_client.ui.dialogs.base.edit.find.DataSearchOptions;
import com.spss.java_client.ui.dialogs.base.edit.find.ISearchProxy;
import com.spss.java_client.ui.dialogs.base.edit.find.SearchOptions;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SPSSFontChooser;
import com.spss.java_client.ui.dialogs.common.SelectTextColorDlg;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.doc_types.data.CompositeSplitPane;
import com.spss.java_client.ui.doc_types.data.DataCellEdit;
import com.spss.java_client.ui.doc_types.data.DataEditBar;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.doc_types.data.DataTableRowHeaderModel;
import com.spss.java_client.ui.doc_types.data.DataViewTable;
import com.spss.java_client.ui.doc_types.data.DataViewTableModel;
import com.spss.java_client.ui.doc_types.data.DatasetViewObserver;
import com.spss.java_client.ui.doc_types.data.DragTableColumnRenderer;
import com.spss.java_client.ui.doc_types.data.FormatCellProvider;
import com.spss.java_client.ui.doc_types.data.FormatInfo;
import com.spss.java_client.ui.doc_types.data.SpssRowHeaderTable;
import com.spss.java_client.ui.doc_types.data.SpssTable;
import com.spss.java_client.ui.doc_types.data.VarViewTable;
import com.spss.java_client.ui.doc_types.data.VarViewTableModel;
import com.spss.java_client.ui.doc_types.data.serialize.DataSerializer;
import com.spss.java_client.ui.doc_types.data.undo.ClearCellsEdit;
import com.spss.java_client.ui.doc_types.data.undo.ColorCellsEdit;
import com.spss.java_client.ui.doc_types.data.undo.DeleteDataRowsEdit;
import com.spss.java_client.ui.doc_types.data.undo.DeleteVariablesEdit;
import com.spss.java_client.ui.doc_types.data.undo.RowInsertEdit;
import com.spss.java_client.ui.doc_types.data.undo.TableColumnValuesEdit;
import com.spss.java_client.ui.doc_types.data.undo.VariableInsertEdit;
import com.spss.java_client.ui.laf.GradientTabbedPane;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.java_client.ui.undo.SpssUndoManager;
import com.spss.shared.core_tools.dictionary.IDataSrc;
import com.spss.shared.core_tools.format.CellValueFormatter;
import com.spss.shared.core_tools.format.ValueFormatter;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.shared.core_tools.utils.FontUtil;
import com.spss.uitools.clipboard.AppClipboard;
import com.spss.uitools.clipboard.StringWrapper;
import com.spss.uitools.util.EncodingValidator;
import com.spss.uitools.util.ISpssAlertHandler;
import com.spss.uitools.util.TraceSettings;
import com.spss.uitools.util.UIAlertRegistrar;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.CoderResult;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.Vector;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.accessibility.AccessibleContext;
import javax.swing.DefaultCellEditor;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.BorderUIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.Caret;
import javax.swing.undo.CompoundEdit;
import org.w3c.dom.Document;

public class DataView
extends JPanel
implements ComponentListener,
ChangeListener,
ISearchProxy,
ILocaleListener,
TableModelListener {
    public static final int DATA_VIEW = 0;
    public static final int VARIABLE_VIEW = 1;
    private CopyType mCopyType = CopyType.COPY_WITH_NONE;
    private static final String SYSMIS_STRING = ResUtil.getComponentString("IDS_MISSING_OBS");
    private static final int NUM_GRID_PANES = 4;
    private static final int TABLE_ROW_HEIGHT_EXTRA_SPACE = 4;
    private static final int MAC_MIN_TABLE_ROW_HEIGHT = 23;
    protected static SelectMode sPrevSelMode = SelectMode.CELL_SELECT;
    private static final String DATA_VIEW_STR = "IDS_DATA_VIEW";
    private static final String VAR_VIEW_STR = "IDS_VARIABLE_VIEW";
    private static String sStrDViewActive = null;
    private static String sStrDViewInactive = null;
    private static String sStrVViewActive = null;
    private static String sStrVViewInactive = null;
    private Locale mCurrentSPSSLocale = (Locale)ComponentState.getSPSSLocale().clone();
    private DataFrame mParentFrame = null;
    private DataViewTableModel mDataTableModel = new DataViewTableModel();
    private DataViewTable[] mDataTables = new DataViewTable[4];
    private DataTableRowHeaderModel mDataRowHeaderModel;
    private DataTableRowHeaderModel mVarRowHeaderModel;
    private SpssRowHeaderTable[] mDataHeaderTables = new SpssRowHeaderTable[2];
    private VarViewTableModel mVarTableModel = new VarViewTableModel();
    private SpssRowHeaderTable mVarHeaderTable;
    private VarViewTable mVarTable;
    private GradientTabbedPane mTabbedPane = new GradientTabbedPane(3);
    private DataEditBar mEditBar;
    private boolean[] mGridsOn = new boolean[2];
    private CompositeSplitPane mSplitPane;
    private DragTableColumnRenderer mColumnRenderer = null;
    private FormatCellProvider mCellProvider = null;
    private boolean mAllVariablesVisible = true;
    private boolean mIsDictModEndPending = false;
    private EncodingValidator mEncodingValidator;
    private boolean mbCanCellEditCheck = true;
    private DatasetViewObserver mObserver = null;
    private boolean mMaxRowCountMsgDisplayed = false;
    private boolean mGroupDigits;
    private boolean mLeadZero;
    private boolean mSelectNewVarRow = false;
    public static final String CASE_ID_VAR_NAME = "CASEID_$";
    public static ArrayList<String> mLockedHiddenVariables = new ArrayList();

    public DataView(DataFrame dataFrame) {
        super(new GridBagLayout(), false);
        this.mParentFrame = dataFrame;
        this.mDataTableModel.setUndoManager(this.getUndoManager());
        this.mVarTableModel.setUndoManager(this.getUndoManager());
        this.mDataRowHeaderModel = new DataTableRowHeaderModel(dataFrame, true);
        this.mVarRowHeaderModel = new DataTableRowHeaderModel(dataFrame, false);
        Arrays.fill(this.mGridsOn, true);
        UIManager.put("Table.focusCellHighlightBorder", new BorderUIResource.LineBorderUIResource(Color.BLUE, 1));
        if (sStrDViewActive == null || sStrDViewActive.length() == 0) {
            this.loadTabStrings();
        }
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node("options").node("general");
        String string = preferences2.get("digit_grouping", "No");
        this.mGroupDigits = string.equals("Yes");
        String string2 = preferences2.get("lead_zero", "No");
        this.mLeadZero = string2.equals("Yes");
        this.addComponentListener(this);
        this.createDataView();
        this.createVariableView();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(0, 0, 1, 0);
        this.add((Component)this.mTabbedPane, gridBagConstraints);
        this.mTabbedPane.addChangeListener(this);
        this.mDataTableModel.addTableModelListener(this);
        this.mEncodingValidator = new EncodingValidator(ComponentState.getCurrentCharset());
        this.loadPrefsSettings();
    }

    public void connectData(LocallyUniqueId locallyUniqueId, DatasetViewObserver datasetViewObserver) {
        if (CommandLine.isExternalCaller()) {
            return;
        }
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        if (iSpssDataSrc == null) {
            assert (false);
            return;
        }
        this.mObserver = datasetViewObserver;
        this.mObserver.setDataView(this);
        ComponentState.addLocaleListener((ILocaleListener)this);
        if (!DataMgr.getDataMgr().isDataFreeClient()) {
            this.mDataTableModel.connectData(locallyUniqueId);
            this.mDataRowHeaderModel.connectData(locallyUniqueId);
        }
        this.mVarTableModel.connectData(locallyUniqueId);
        this.mVarRowHeaderModel.connectData(locallyUniqueId);
        this.mEditBar.setDataset(locallyUniqueId);
        this.updateUI();
        this.mVarTable.updateDisplayedAttributes();
        this.updateDatasetState(true);
        this.mParentFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowDeactivated(WindowEvent windowEvent) {
                DataView.this.commitEdit();
            }
        });
    }

    public ArrayList<Integer> getVariabIeDList() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < this.mDataTables[0].getColumnCount(); ++i) {
            ISpssVariable iSpssVariable = this.getDataSrc().getVariable(i);
            if (iSpssVariable == null) continue;
            arrayList.add(iSpssVariable.getId().asInt());
        }
        return arrayList;
    }

    public void notifyMaxRowLimit() {
        if (!this.mMaxRowCountMsgDisplayed) {
            this.mMaxRowCountMsgDisplayed = true;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String string = String.format(ResUtil.getString("IDS_MAX_DE_ROWS_EXCEEDED"), 80000000);
                    SpssAlertOptionPane.showInformationMessageDialog(DataView.this.mParentFrame, string, VersionInfo.getAppVersionString());
                }
            });
        }
    }

    public ISpssDataSrc getDataSrc() {
        if (this.mParentFrame == null) {
            return null;
        }
        return DataMgr.getDataMgr().getDataSource(this.mParentFrame.getDatasetId());
    }

    public int getActiveView() {
        return this.mTabbedPane.getSelectedIndex();
    }

    public void setActiveView(int n) {
        if (n < 0 || n > 1 || n == this.mTabbedPane.getSelectedIndex()) {
            return;
        }
        this.mTabbedPane.setSelectedIndex(n);
        this.mParentFrame.activeViewChanged(n);
    }

    public void setCopyType(CopyType copyType) {
        this.mCopyType = copyType;
    }

    public CopyType getCopyType() {
        return this.mCopyType;
    }

    public boolean getShowImputation(int n) {
        if (n < 0 || n > 1) {
            assert (false);
            return false;
        }
        return this.getDataSrc() != null && this.getDataSrc().isMultipleImputation();
    }

    public void setShowImputation(int n, boolean bl) {
        if (n < 0 || n > 1) {
            assert (false);
            return;
        }
        if (this.mEditBar != null) {
            this.mEditBar.setShowImputation(bl);
            this.mParentFrame.setShowImputation(bl);
        }
    }

    public boolean getViewGridlines(int n) {
        if (n < 0 || n > 1) {
            assert (false);
            return false;
        }
        return this.mGridsOn[n];
    }

    public void setViewGridlines(int n, boolean bl) {
        if (n < 0 || n > 1) {
            assert (false);
            return;
        }
        if (this.mGridsOn[n] == bl) {
            return;
        }
        this.mGridsOn[n] = bl;
        if (n == 0) {
            for (DataViewTable dataViewTable : this.mDataTables) {
                dataViewTable.setShowHorizontalLines(bl);
                dataViewTable.setShowVerticalLines(bl);
            }
        } else {
            this.mVarTable.setShowHorizontalLines(bl);
            this.mVarTable.setShowVerticalLines(bl);
        }
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node("doc_types/dataeditor");
        String string = n == 0 ? "dv_grids" : "vv_grids";
        preferences2.putBoolean(string, this.mGridsOn[n]);
    }

    public GradientTabbedPane getTabbedPane() {
        return this.mTabbedPane;
    }

    public void selectAndScrollToVariable(int n, int n2) {
        if (n < 0 || n > 1 || n2 < 0) {
            return;
        }
        if (n == 0) {
            this.mDataTables[0].selectAndScrollToVariable(n2);
        } else {
            this.mVarTable.selectAndScrollToVariable(n2);
        }
    }

    public void dataPreferenceChange(String string, String string2) {
        boolean bl;
        if ("digit_grouping".equalsIgnoreCase(string)) {
            boolean bl2 = "Yes".equalsIgnoreCase(string2);
            if (bl2 != this.mGroupDigits) {
                this.mGroupDigits = bl2;
                if (this.mCellProvider != null) {
                    this.mCellProvider.clear();
                }
                CellValueFormatter.clearFormatCache();
                this.createColumnRenderers(true);
            }
        } else if ("lead_zero".equalsIgnoreCase(string) && (bl = "Yes".equalsIgnoreCase(string2)) != this.mLeadZero) {
            this.mLeadZero = bl;
            CellValueFormatter.setLeadZero((boolean)this.mLeadZero);
            this.repaint();
        }
    }

    public void setDataColumnWidth(int n, short s) {
        if (n > -1 && n < this.mDataTableModel.getColumnCount()) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int n2 = fontMetrics.charWidth('A');
            int n3 = this.mDataTables[0].getColumnModel().getColumnMargin();
            int n4 = n2 * s + n3 * 2 + 4;
            if (DataMgr.getDataMgr().isDataFreeClient()) {
                n4 = this.getSize().width;
            }
            for (int i = 0; i < 4; ++i) {
                if (n >= this.mDataTables[i].getColumnModel().getColumnCount()) continue;
                TableColumn tableColumn = this.mDataTables[i].getColumnModel().getColumn(n);
                tableColumn.setResizable(true);
                tableColumn.setPreferredWidth(n4);
                if (!DataView.isLockedHiddenVariable(this.mDataTableModel.getColumnName(n))) continue;
                tableColumn.setResizable(false);
                tableColumn.setPreferredWidth(0);
                tableColumn.setWidth(0);
                tableColumn.setMaxWidth(0);
                tableColumn.setMinWidth(0);
            }
        }
    }

    public SpssUndoManager getUndoManager() {
        return this.mParentFrame.getUndoManager();
    }

    public boolean canAddNewVariable() {
        boolean bl = true;
        ISpssDataSrc iSpssDataSrc = this.getDataSrc();
        Vector vector = iSpssDataSrc.getVariableSetsInUse();
        if (!vector.contains(ISpssDataSrc.NEWVARIABLES)) {
            String string = ResUtil.getString("ERR_CANT_ADD_NEW_VAR");
            ISpssAlertHandler iSpssAlertHandler = UIAlertRegistrar.getUIAlertRegistrar().getAlertHandler();
            bl = iSpssAlertHandler.showAlert((Window)this.mParentFrame, string, ISpssAlertHandler.CoreAlertIconType.eQuestion, true, ISpssAlertHandler.CoreAlertOptionType.OK_CANCEL_OPTION);
            if (bl) {
                vector.add(ISpssDataSrc.NEWVARIABLES);
                iSpssDataSrc.setSelectedVariableSets(vector);
            }
        }
        return bl;
    }

    public void queryVarSetsNewVariableName(String string) {
        IVariableSet iVariableSet2;
        ISpssDataSrc iSpssDataSrc = this.getDataSrc();
        if (iSpssDataSrc.findVarIndex(string) == -1) {
            return;
        }
        Vector vector = iSpssDataSrc.getVariableSetsInUse();
        if (vector.contains(ISpssDataSrc.ALLVARIABLES)) {
            return;
        }
        Vector vector2 = iSpssDataSrc.getVariableSets(ISpssDataSrc.VarSetsType.kVariableSet);
        for (IVariableSet iVariableSet2 : vector2) {
            if (!iVariableSet2.isVariableInSet(string)) continue;
            return;
        }
        String string2 = ResUtil.getString("QUERY_ADD_TO_SETS_IN_USE");
        iVariableSet2 = UIAlertRegistrar.getUIAlertRegistrar().getAlertHandler();
        boolean bl = iVariableSet2.showAlert((Window)this.mParentFrame, string2, ISpssAlertHandler.CoreAlertIconType.eQuestion, true, ISpssAlertHandler.CoreAlertOptionType.YES_NO_OPTION);
        if (bl) {
            for (IVariableSet iVariableSet3 : vector2) {
                iVariableSet3.addVariableName(string);
            }
            iSpssDataSrc.saveVariableSets(vector2);
        }
        iSpssDataSrc.setSelectedVariableSets(vector);
    }

    public boolean canChangeCellValue() {
        boolean bl = false;
        if (this.mbCanCellEditCheck) {
            this.mbCanCellEditCheck = false;
            if (this.mParentFrame != null && this.mParentFrame.hasPendingTransforms()) {
                String string = ResUtil.getString("ERR_PENDING_TRANSFORMATIONS");
                ISpssAlertHandler iSpssAlertHandler = UIAlertRegistrar.getUIAlertRegistrar().getAlertHandler();
                bl = iSpssAlertHandler.showAlert((Window)this.mParentFrame, string, ISpssAlertHandler.CoreAlertIconType.eQuestion, true, ISpssAlertHandler.CoreAlertOptionType.OK_CANCEL_OPTION);
                if (bl) {
                    SyntaxMgr.getSyntaxMgr().executeSyntax("EXECUTE.");
                }
            } else {
                bl = true;
            }
            this.mbCanCellEditCheck = true;
        }
        return bl;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        int n = this.mTabbedPane.getTabCount();
        final boolean bl = this.mTabbedPane.getSelectedIndex() == 0;
        AccessibleContext accessibleContext = this.mTabbedPane.getAccessibleContext();
        if (n > 0) {
            accessibleContext.getAccessibleChild(0).getAccessibleContext().setAccessibleName(ResUtil.getString(DATA_VIEW_STR));
            accessibleContext.getAccessibleChild(0).getAccessibleContext().setAccessibleDescription(ResUtil.getTooltip(DATA_VIEW_STR));
            this.mTabbedPane.setTitleAt(0, bl ? sStrDViewActive : sStrDViewInactive);
        }
        if (n > 1) {
            accessibleContext.getAccessibleChild(1).getAccessibleContext().setAccessibleName(ResUtil.getString(VAR_VIEW_STR));
            accessibleContext.getAccessibleChild(1).getAccessibleContext().setAccessibleDescription(ResUtil.getTooltip(VAR_VIEW_STR));
            this.mTabbedPane.setTitleAt(1, bl ? sStrVViewInactive : sStrVViewActive);
        }
        this.commitEdit();
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node("doc_types/dataeditor");
        int n2 = this.mTabbedPane.getSelectedIndex();
        if (DataMgr.getDataMgr().isDataFreeClient()) {
            n2 = 1;
        }
        preferences2.putInt("de_view", n2);
        this.mParentFrame.updateToolbarEnableStatus();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (bl) {
                    if (DataView.this.mDataTables != null && DataView.this.mDataTables[0] != null) {
                        DataView.this.mDataTables[0].requestFocusInWindow();
                    }
                } else if (DataView.this.mVarTable != null) {
                    DataView.this.mVarTable.requestFocusInWindow();
                }
            }
        });
    }

    @Override
    public String getDocumentName() {
        return this.getDataSrc().getDatasetName();
    }

    @Override
    public boolean findNext(String string, SearchOptions searchOptions) {
        if (!(searchOptions instanceof DataSearchOptions)) {
            return false;
        }
        this.commitEdit();
        DataSearchOptions dataSearchOptions = (DataSearchOptions)searchOptions;
        boolean bl = this.getActiveView() == 0 ? this.doFindNext(string, dataSearchOptions) : this.mVarTable.findNext(string, dataSearchOptions);
        return bl;
    }

    @Override
    public boolean replaceNext(String string, String string2, SearchOptions searchOptions) {
        boolean bl;
        if (!(searchOptions instanceof DataSearchOptions)) {
            return false;
        }
        this.commitEdit();
        DataSearchOptions dataSearchOptions = (DataSearchOptions)searchOptions;
        if (this.getActiveView() == 0) {
            boolean bl2 = dataSearchOptions.isFirstSearch();
            bl = this.doReplace(string, string2, dataSearchOptions);
            if (bl || bl2) {
                bl = this.doFindNext(string, dataSearchOptions);
            }
        } else {
            bl = this.mVarTable.replaceNext(string, string2, dataSearchOptions);
        }
        return bl;
    }

    @Override
    public int replaceAll(String string, String string2, SearchOptions searchOptions) {
        if (!(searchOptions instanceof DataSearchOptions)) {
            return 0;
        }
        int n = 0;
        this.commitEdit();
        DataSearchOptions dataSearchOptions = (DataSearchOptions)searchOptions;
        if (this.getActiveView() == 0) {
            this.doReplaceAll(string, string2, dataSearchOptions);
        } else {
            n = this.mVarTable.replaceAll(string, string2, dataSearchOptions);
        }
        return n;
    }

    @Override
    public void stopSearch() {
        if (this.getActiveView() == 0) {
            ISpssDataSrc iSpssDataSrc = this.getDataSrc();
            if (iSpssDataSrc == null) {
                return;
            }
            DataMgr.getDataMgr().sendStopFindMsg(iSpssDataSrc.getDataSetId(), false);
        }
    }

    public void updateSearchDialogControls() {
        if (this.mParentFrame != null) {
            this.mParentFrame.updateSearchDialogControls();
        }
    }

    public void updateTitleBar() {
        if (this.mParentFrame != null) {
            this.mParentFrame.updateTitleBar();
        }
    }

    public boolean doFindNext(String string, DataSearchOptions dataSearchOptions) {
        Object object;
        long l;
        long l2;
        ISpssDataSrc iSpssDataSrc = this.getDataSrc();
        if (iSpssDataSrc == null) {
            return false;
        }
        int n = this.mDataTables[0].getSelectedRow();
        int n2 = this.mDataTables[0].getSelectedColumn();
        if (n2 < 0 || n2 >= iSpssDataSrc.columnCount() || n < 0) {
            JOptionPane.showMessageDialog(this.mParentFrame, ResUtil.getString("ERR_NOT_SEARCHABLE_ERROR"), VersionInfo.getAppVersionString(), 1);
            return false;
        }
        if (!dataSearchOptions.isFirstSearch()) {
            long l3;
            boolean bl = dataSearchOptions.getWrapped();
            if (dataSearchOptions.getSearchArea() == SearchOptions.SearchArea.selected) {
                int[] nArray = dataSearchOptions.getSelectedRows();
                l3 = bl ? (long)dataSearchOptions.getFocusedRow() : (long)nArray[nArray.length - 1];
            } else {
                long l4 = l3 = bl ? (long)dataSearchOptions.getFocusedRow() : (long)DataViewTableModel.getDisplayableRowCount((int)iSpssDataSrc.rowCount());
            }
            if ((long)(n + 1) <= l3) {
                ++n;
            } else {
                return false;
            }
        }
        DataFindDlg dataFindDlg = this.mParentFrame.getSearchDialog();
        dataFindDlg.setInBackendSearch(true);
        DataSearchOptions.SearchType searchType = dataSearchOptions.getSearchType();
        FindValueMsg.SearchType searchType2 = searchType == DataSearchOptions.SearchType.endsWith ? FindValueMsg.SearchType.endsWith : (searchType == DataSearchOptions.SearchType.exact ? FindValueMsg.SearchType.exact : (searchType == DataSearchOptions.SearchType.startsWith ? FindValueMsg.SearchType.startsWith : FindValueMsg.SearchType.contains));
        if (dataSearchOptions.getSearchArea() == SearchOptions.SearchArea.all) {
            l2 = n;
            l = dataSearchOptions.isFirstSearch() ? (long)n : (long)dataSearchOptions.getFocusedRow();
        } else {
            l2 = n;
            object = dataSearchOptions.getSelectedRows();
            long l5 = object[((int[])object).length - 1];
            l = l5 + 1L;
        }
        object = iSpssDataSrc.getVariable(n2).getId();
        RowRange rowRange = new RowRange(l2, l);
        boolean bl = dataSearchOptions.getMatchCase();
        DataMgr.getDataMgr().sendFindValueMsg(iSpssDataSrc.getDataSetId(), (LocallyUniqueId)object, string, rowRange, bl, this.mParentFrame.getViewValueLabels(), searchType2);
        return true;
    }

    private boolean doReplace(String string, String string2, DataSearchOptions dataSearchOptions) {
        OBS oBS;
        ISpssDataSrc iSpssDataSrc = this.getDataSrc();
        if (iSpssDataSrc == null) {
            return false;
        }
        int n = this.mDataTables[0].getSelectedRow();
        int n2 = this.mDataTables[0].getSelectedColumn();
        if (n2 < 0 || n2 >= iSpssDataSrc.columnCount() || n < 0) {
            SpssAlertOptionPane.showWarningMessageDialog(this.mParentFrame, ResUtil.getString("ERR_NOT_SEARCHABLE_ERROR"), VersionInfo.getAppVersionString());
            return false;
        }
        if (n < 0 || n >= DataViewTableModel.getDisplayableRowCount((int)iSpssDataSrc.rowCount())) {
            return false;
        }
        ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(n2);
        Object object = this.mDataTables[0].getValueAt(n, n2);
        if (iSpssVariable.getType() > 0) {
            oBS = new OBS(object.toString());
        } else if (object instanceof Double) {
            oBS = new OBS(((Double)object).doubleValue());
        } else {
            return false;
        }
        String string3 = CellValueFormatter.obsToString((OBS)oBS, (SPSS_Format)iSpssVariable.getFormat());
        Pattern pattern = this.makeSearchPattern(dataSearchOptions, string);
        Matcher matcher = pattern.matcher(string3.trim());
        if (matcher.find()) {
            String string4 = matcher.replaceAll(Matcher.quoteReplacement(string2));
            oBS.setEmpty(true);
            if (!CellValueFormatter.stringToObs((String)string4, (SPSS_Format)iSpssVariable.getFormat(), (OBS)oBS)) {
                SpssAlertOptionPane.showWarningMessageDialog(this.mParentFrame, ResUtil.getComponentString("ERR_INVALID_SEARCH_VALUE"), VersionInfo.getAppVersionString());
            } else {
                this.mDataTables[0].setValueAt(string4, n, n2);
                this.mParentFrame.updateToolbarEnableStatus();
            }
            return true;
        }
        return false;
    }

    private void doReplaceAll(String string, String string2, DataSearchOptions dataSearchOptions) {
        Object object;
        long l;
        long l2;
        ISpssDataSrc iSpssDataSrc = this.getDataSrc();
        if (iSpssDataSrc == null) {
            return;
        }
        int n = this.mDataTables[0].getSelectedRow();
        int n2 = this.mDataTables[0].getSelectedColumn();
        if (n2 < 0 || n2 >= iSpssDataSrc.columnCount() || n < 0) {
            JOptionPane.showMessageDialog(this.mParentFrame, ResUtil.getString("IDS_NOT_SEARCHABLE_ERROR"), VersionInfo.getAppVersionString(), 1);
            return;
        }
        DataFindDlg dataFindDlg = this.mParentFrame.getSearchDialog();
        dataFindDlg.setInBackendSearch(true);
        DataSearchOptions.SearchType searchType = dataSearchOptions.getSearchType();
        FindValueMsg.SearchType searchType2 = searchType == DataSearchOptions.SearchType.endsWith ? FindValueMsg.SearchType.endsWith : (searchType == DataSearchOptions.SearchType.exact ? FindValueMsg.SearchType.exact : (searchType == DataSearchOptions.SearchType.startsWith ? FindValueMsg.SearchType.startsWith : FindValueMsg.SearchType.contains));
        if (dataSearchOptions.getSearchArea() == SearchOptions.SearchArea.all) {
            l2 = n;
            l = n;
        } else {
            l2 = n;
            object = dataSearchOptions.getSelectedRows();
            long l3 = object[((int[])object).length - 1];
            l3 = Math.min(l3, (long)DataViewTableModel.getDisplayableRowCount((int)iSpssDataSrc.rowCount() - 1));
            l = l3 + 1L;
        }
        object = iSpssDataSrc.getVariable(n2).getId();
        RowRange rowRange = new RowRange(l2, l);
        boolean bl = dataSearchOptions.getMatchCase();
        DataMgr.getDataMgr().sendReplaceValuesMsg(iSpssDataSrc.getDataSetId(), (LocallyUniqueId)object, string, string2, rowRange, bl, true, searchType2);
    }

    private Pattern makeSearchPattern(DataSearchOptions dataSearchOptions, String string) {
        String string2 = "";
        String string3 = "";
        DataSearchOptions.SearchType searchType = dataSearchOptions.getSearchType();
        if (searchType == DataSearchOptions.SearchType.startsWith || searchType == DataSearchOptions.SearchType.exact) {
            string2 = "^";
        }
        if (searchType == DataSearchOptions.SearchType.endsWith || searchType == DataSearchOptions.SearchType.exact) {
            string3 = "$";
        }
        string = string.replace("\\", "\\\\");
        string = string.replace(".", "\\x2E");
        string = string.replace("*", "\\x2A");
        string = string.replace("^", "\\x5E");
        string = string.replace("(", "\\x28");
        string = string.replace(")", "\\x29");
        string = Matcher.quoteReplacement(string);
        String string4 = !dataSearchOptions.getMatchCase() ? "(?i)(?u)" + string2 + string + string3 : string2 + string + string3;
        return Pattern.compile(string4);
    }

    public void notifyCharsetChange(final String string) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.notifyCharsetChangeImpl(string);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DataView.this.notifyCharsetChangeImpl(string);
                }
            });
        }
    }

    private void notifyCharsetChangeImpl(String string) {
        this.mEncodingValidator.setEncoding(Charset.forName(string));
    }

    public void notifyILangChange(final Locale locale) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.notifyILangChangeImpl(locale);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DataView.this.notifyILangChangeImpl(locale);
                }
            });
        }
    }

    private void notifyILangChangeImpl(Locale locale) {
        this.loadTabStrings();
        this.stateChanged(null);
        this.mVarTable.reloadStrings();
        VarViewTableModel.reloadColumnNames();
        this.mVarTable.updateDisplayedAttributes();
        this.updateVarsInUse(false);
        this.mDataTables[0].registerShortcuts();
        this.mVarTable.registerShortcuts();
    }

    public void notifySpssLocaleChange(final Locale locale) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.notifyLocaleChangeImpl(locale);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DataView.this.notifyLocaleChangeImpl(locale);
                }
            });
        }
    }

    private void notifyLocaleChangeImpl(Locale locale) {
        if (!this.mCurrentSPSSLocale.equals(locale)) {
            this.mCurrentSPSSLocale = (Locale)locale.clone();
            if (this.mCellProvider != null) {
                this.mCellProvider.clear();
            }
            this.mDataTables[0].getValueLabelEditor().reset();
            this.createColumnRenderers(false);
            this.mVarTable.addSpinners();
        }
    }

    public int getTopRow(DataViewTable dataViewTable) {
        int n = -1;
        if (dataViewTable.getParent() instanceof JViewport) {
            JViewport jViewport = (JViewport)dataViewTable.getParent();
            Rectangle rectangle = jViewport.getViewRect();
            n = dataViewTable.rowAtPoint(rectangle.getLocation());
        }
        return n;
    }

    public int getLeftColumn(DataViewTable dataViewTable) {
        int n = -1;
        if (dataViewTable.getParent() instanceof JViewport) {
            JViewport jViewport = (JViewport)dataViewTable.getParent();
            Rectangle rectangle = jViewport.getViewRect();
            n = dataViewTable.columnAtPoint(rectangle.getLocation());
        }
        return n;
    }

    public void updateMultipleImputationUI() {
        if (this.mEditBar != null) {
            this.mEditBar.updateImputationControls();
            this.mParentFrame.setShowImputation(this.getDataSrc().isMultipleImputation());
        }
        if (this.getDataSrc().isMultipleImputation()) {
            this.scrollToImputationDataset();
        } else {
            this.updateUI();
        }
    }

    private void scrollToImputationDataset() {
        int n;
        int n2 = this.getDataSrc().getImputationInfo().getCurrentImputedDataset();
        long l = this.getDataSrc().getImputationInfo().getImputationStartingRowNumber(n2);
        DataViewTable dataViewTable = this.isDividerOn() ? this.mDataTables[2] : this.mDataTables[0];
        long l2 = 0L;
        int n3 = this.getTopRow(dataViewTable);
        int n4 = this.getLeftColumn(dataViewTable);
        if (n4 == -1) {
            n4 = 0;
        }
        if (n3 != -1 && (n = this.getDataSrc().getImputationInfo().getImputationNumberFromRow((long)n3)) != -1 && n2 != n) {
            long l3 = this.getDataSrc().getImputationInfo().getImputationStartingRowNumber(n);
            l2 = (long)n3 - l3;
        }
        this.doSelectCells(n4, n4, (int)(l += l2), (int)l);
        Rectangle rectangle = dataViewTable.getCellRect((int)l, n4, true);
        dataViewTable.scrollRectToVisible(dataViewTable.getCellRect(dataViewTable.getRowCount() - 1, dataViewTable.getColumnCount() - 1, true));
        dataViewTable.scrollRectToVisible(rectangle);
    }

    public void updateVarsInUse(boolean bl) {
        ISpssDataSrc iSpssDataSrc = this.getDataSrc();
        if (iSpssDataSrc == null) {
            return;
        }
        if (bl) {
            this.mVarTable.setRowHeight(this.mVarTable.getRowHeight());
            this.mVarHeaderTable.setRowHeight(this.mVarTable.getRowHeight());
        }
        int n = 0;
        int n2 = iSpssDataSrc.columnCount();
        for (int i = 0; i < n2; ++i) {
            boolean bl2 = iSpssDataSrc.isVariableInCurrentSet(i);
            if (bl2) {
                ++n;
            }
            if (!bl) continue;
            if (!bl2) {
                this.adjustVarTableWidth(i);
                continue;
            }
            this.setDataColumnWidth(i, iSpssDataSrc.getVariable(i).getDisplayWidth());
        }
        this.mAllVariablesVisible = n == n2;
        this.mEditBar.updateVarsInUse(n);
    }

    private void adjustVarTableWidth(int n) {
        ISpssDataSrc iSpssDataSrc = this.getDataSrc();
        if (iSpssDataSrc == null || DataMgr.getDataMgr().isDataFreeClient()) {
            return;
        }
        ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(n);
        boolean bl = iSpssDataSrc.isVariableInCurrentSet(n);
        for (DataViewTable dataViewTable : this.mDataTables) {
            if (bl) {
                this.setDataColumnWidth(n, iSpssVariable.getDisplayWidth());
                continue;
            }
            TableColumn tableColumn = dataViewTable.getColumnModel().getColumn(n);
            if (tableColumn.getMinWidth() > 0) {
                tableColumn.setMinWidth(0);
            }
            tableColumn.setPreferredWidth(0);
            tableColumn.setResizable(false);
        }
        this.mVarHeaderTable.setRowHeight(n, bl ? this.mVarHeaderTable.getRowHeight() : 1);
        this.mVarTable.setRowHeight(n, bl ? this.mVarTable.getRowHeight() : 1);
    }

    public boolean getAllVariablesVisible() {
        return this.mAllVariablesVisible;
    }

    public void showDivider(boolean bl) {
        this.mSplitPane.showDivider(bl);
    }

    public boolean isDividerOn() {
        return this.mSplitPane.isDividerOn();
    }

    public JViewport getLastActiveViewport() {
        return this.mSplitPane.getLastActiveViewPort();
    }

    public JTable getLastActiveTable() {
        return this.mSplitPane.getLastActiveTable();
    }

    public JTable[] getDataTables() {
        int n = this.mTabbedPane.getSelectedIndex();
        if (n == 0) {
            return new JTable[]{this.mDataTables[0], this.mDataHeaderTables[0]};
        }
        return new JTable[]{this.mVarTable, this.mVarHeaderTable};
    }

    public JTable getDataTable(int n) {
        if (n == 0) {
            return this.mDataTables[0];
        }
        if (n == 1) {
            return this.mVarTable;
        }
        return null;
    }

    public DataViewTable getDataViewTable() {
        return (DataViewTable)this.getDataTable(0);
    }

    public VarViewTable getVarViewTable() {
        return (VarViewTable)this.getDataTable(1);
    }

    public JTable[] getColHeaderTables() {
        return new JTable[]{this.mDataTables[0], this.mDataTables[1]};
    }

    public void refreshDataRowCol(int n, int n2) {
        this.mDataHeaderTables[0].refreshCurrentRow(n);
        this.mDataHeaderTables[1].refreshCurrentRow(n);
        for (int i = 0; i < 2; ++i) {
            TableCellRenderer tableCellRenderer = this.mDataTables[i].getTableHeader().getDefaultRenderer();
            ISpssDataSrc iSpssDataSrc = this.getDataSrc();
            if (n2 > -1 && iSpssDataSrc != null && n2 < iSpssDataSrc.columnCount()) {
                tableCellRenderer = this.mDataTables[i].getTableHeader().getColumnModel().getColumn(n2).getHeaderRenderer();
            }
            if (!(tableCellRenderer instanceof DragTableColumnRenderer)) continue;
            ((DragTableColumnRenderer)tableCellRenderer).setCurrentCol(this.mDataTables[i].getTableHeader(), n2, i == 1);
        }
    }

    public void doSelectRows(int n, int n2) {
        this.mDataTables[0].getSelectionModel().setSelectionInterval(n, n2);
        this.mDataTables[0].getColumnModel().getSelectionModel().setSelectionInterval(this.mDataTables[0].getColumnCount() - 1, 0);
        this.mDataHeaderTables[0].getSelectionModel().setSelectionInterval(n, n2);
        this.mDataHeaderTables[1].getSelectionModel().setSelectionInterval(n, n2);
    }

    public void doSelectColumns(int n, int n2) {
        this.mDataTables[0].getSelectionModel().setSelectionInterval(this.mDataTables[0].getRowCount() - 1, 0);
        this.mDataTables[0].getColumnModel().getSelectionModel().setSelectionInterval(n, n2);
    }

    public void doSelectCells(int n, int n2, int n3, int n4) {
        if (!DataMgr.getDataMgr().isDataFreeClient()) {
            this.mDataTables[0].getSelectionModel().setSelectionInterval(n3, n4);
            this.mDataTables[0].getColumnModel().getSelectionModel().setSelectionInterval(n, n2);
        }
    }

    public void doSelectVarViewCell(int n, int n2) {
        this.mVarTable.getSelectionModel().setSelectionInterval(n2, n2);
        this.mVarTable.getColumnModel().getSelectionModel().setSelectionInterval(n, n);
    }

    public void doSelectVarViewRows(int n, int n2) {
        this.mVarTable.getSelectionModel().setSelectionInterval(n, n2);
        this.mVarTable.getColumnModel().getSelectionModel().setSelectionInterval(this.mVarTable.getColumnCount() - 1, 0);
    }

    public Vector<Object> getSelectedVariables() {
        boolean bl = false;
        long l = 0L;
        long l2 = 0L;
        Vector<Object> vector = new Vector<Object>();
        int[] nArray = this.mDataTables[0].getColumnSelections();
        if (nArray != null && nArray.length != 0) {
            bl = true;
            l = nArray[0];
            l2 = nArray[nArray.length - 1];
        }
        vector.add(l);
        vector.add(l2);
        vector.add(bl);
        return vector;
    }

    public void doCopy() {
        int n = this.mTabbedPane.getSelectedIndex();
        AppClipboard appClipboard = AppClipboard.getAppClipboard();
        this.mParentFrame.setCursor(Cursor.getPredefinedCursor(3));
        DataSerializer dataSerializer = new DataSerializer();
        if (n == 0) {
            DataSerializer.DEData dEData = dataSerializer.serializeDataViewSelection(this.mDataTables[0]);
            if (dEData != null) {
                appClipboard.addClipboardData(dEData.getDataFlavor(), (Object)dEData, false);
            }
        } else {
            DataSerializer.DEData dEData = dataSerializer.serializeVariableViewSelection(this.mVarTable);
            if (dEData != null) {
                appClipboard.addClipboardData(dEData.getDataFlavor(), (Object)dEData, false);
            }
        }
        this.copyStringData(n, appClipboard);
        this.mParentFrame.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void copyStringData(int n, AppClipboard appClipboard) {
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        if (n == 0) {
            this.mCopyType = this.getCopyType();
            string2 = this.getSelectedDataAsString(this.mDataTables[0], true);
            if (this.mCopyType == CopyType.COPY_WITH_VARIABLE) {
                string3 = this.getSelectedVariabeAsString(this.mDataTables[0]);
                string = string3 + string2;
            } else if (this.mCopyType == CopyType.COPY_WITH_LABEL) {
                string4 = this.getSelectedLabelAsString(this.mDataTables[0]);
                string = string4 + string2;
            } else {
                string = string2;
            }
            if (!ComponentState.getSystemLocale().equals(ComponentState.getSPSSLocale())) {
                DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(ComponentState.getSystemLocale());
                DecimalFormatSymbols decimalFormatSymbols2 = new DecimalFormatSymbols(ComponentState.getSPSSLocale());
                if (decimalFormatSymbols.getDecimalSeparator() != decimalFormatSymbols2.getDecimalSeparator()) {
                    string2 = this.getSelectedDataAsString(this.mDataTables[0], false);
                    string = this.mCopyType == CopyType.COPY_WITH_VARIABLE ? string3 + string2 : (this.mCopyType == CopyType.COPY_WITH_LABEL ? string4 + string2 : string2);
                    if (string == null) {
                        string = "";
                    }
                    appClipboard.addClipboardData(AppClipboard.DATAVIEW_STRING_FLAVOR, (Object)new StringWrapper(string), false);
                }
            }
        } else {
            string = this.getSelectedDataAsString(this.mVarTable, true);
        }
        if (string == null) {
            string = "";
        }
        appClipboard.addClipboardData(AppClipboard.STRING_FLAVOR, (Object)string, true);
    }

    private String getSelectedVariabeAsString(DataViewTable dataViewTable) {
        StringBuffer stringBuffer = new StringBuffer();
        int[] nArray = dataViewTable.getSelectedColumns();
        ISpssDataSrc iSpssDataSrc = this.getDataSrc();
        if (iSpssDataSrc == null) {
            return null;
        }
        for (int i = 0; i < nArray.length; ++i) {
            ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(nArray[i]);
            String string = iSpssVariable.getName();
            if (i == 0) {
                stringBuffer.append(string);
                continue;
            }
            stringBuffer.append("\t").append(string);
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    private String getSelectedLabelAsString(DataViewTable dataViewTable) {
        StringBuffer stringBuffer = new StringBuffer();
        int[] nArray = dataViewTable.getSelectedColumns();
        ISpssDataSrc iSpssDataSrc = this.getDataSrc();
        if (iSpssDataSrc == null) {
            return null;
        }
        for (int i = 0; i < nArray.length; ++i) {
            ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(nArray[i]);
            String string = iSpssVariable.getLabel();
            if (i == 0) {
                stringBuffer.append(string);
                continue;
            }
            stringBuffer.append("\t").append(string);
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public void doCut() {
        this.doCopy();
        this.doDelete();
    }

    public void doPaste() {
        this.doPaste(false);
    }

    public void doPaste(boolean bl) {
        int n = this.mTabbedPane.getSelectedIndex();
        if (DataSerializer.canPaste(n == 0 ? this.mDataTables[0] : this.mVarTable)) {
            Object object;
            boolean bl2 = false;
            this.cancelEdit();
            AppClipboard appClipboard = AppClipboard.getAppClipboard();
            this.mParentFrame.setCursor(Cursor.getPredefinedCursor(3));
            DataSerializer dataSerializer = new DataSerializer();
            if (n == 0) {
                object = null;
                if (appClipboard.isFlavorAvailable(DataSerializer.DATA_CELL_FLAVOR)) {
                    object = appClipboard.getClipboardData(DataSerializer.DATA_CELL_FLAVOR);
                } else if (appClipboard.isFlavorAvailable(DataSerializer.DATA_COL_FLAVOR)) {
                    object = appClipboard.getClipboardData(DataSerializer.DATA_COL_FLAVOR);
                } else if (appClipboard.isFlavorAvailable(DataSerializer.DATA_ROW_FLAVOR)) {
                    object = appClipboard.getClipboardData(DataSerializer.DATA_ROW_FLAVOR);
                }
                if (object instanceof DataSerializer.DEData) {
                    bl2 = dataSerializer.deserializeDataViewSelection(this.mDataTables[0], (DataSerializer.DEData)object);
                }
                if (bl2) {
                    ISpssDataSrc iSpssDataSrc = this.mParentFrame.getDataSource();
                    iSpssDataSrc.getCacheMgr().clearCache();
                }
            } else if (n == 1) {
                object = null;
                if (appClipboard.isFlavorAvailable(DataSerializer.VAR_CELL_FLAVOR)) {
                    object = appClipboard.getClipboardData(DataSerializer.VAR_CELL_FLAVOR);
                } else if (appClipboard.isFlavorAvailable(DataSerializer.VAR_ROW_FLAVOR)) {
                    object = appClipboard.getClipboardData(DataSerializer.VAR_ROW_FLAVOR);
                } else if (appClipboard.isFlavorAvailable(DataSerializer.DATA_COL_FLAVOR)) {
                    object = appClipboard.getClipboardData(DataSerializer.DATA_COL_FLAVOR);
                }
                bl2 = object instanceof DataSerializer.DEData ? dataSerializer.deserializeVariableViewSelection(this.mVarTable, (DataSerializer.DEData)object) : DataSerializer.dataRowsAvailable();
            }
            if (!bl2 && appClipboard.isFlavorAvailable(AppClipboard.STRING_FLAVOR)) {
                try {
                    if (n == 0) {
                        this.pasteStringToDataTable(this.mDataTables[0], bl);
                    } else {
                        this.pasteStringToVarTable(this.mVarTable);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.mParentFrame.setCursor(Cursor.getPredefinedCursor(0));
            this.mParentFrame.updateToolbarEnableStatus();
        }
    }

    public void doDelete() {
        this.commitEdit();
        int n = this.mTabbedPane.getSelectedIndex();
        if (n == 0) {
            int[] nArray = this.mDataTables[0].getColumnSelections();
            int[] nArray2 = this.getValidRowHeaderSelns();
            int n2 = 0;
            int n3 = 0;
            if (nArray2.length > 0) {
                n2 = this.mDataHeaderTables[0].getSelectedRow();
                new DeleteDataRowsEdit(this.getUndoManager(), this.mDataTables[0], this.mDataTableModel.getDataSource(), nArray2);
            } else if (nArray != null) {
                n3 = this.mDataTables[0].getSelectedColumn();
                this.mDataTables[0].clearSelection();
                new DeleteVariablesEdit(this.getUndoManager(), this.mVarTableModel, this.mDataTableModel.getDataSource(), nArray, this);
            } else {
                n2 = this.mDataTables[0].getSelectedRow();
                n3 = this.mDataTables[0].getSelectedColumn();
                this.clearSelectedCellData(this.mDataTables[0]);
            }
            this.mDataTables[0].clearSelection();
            this.mDataHeaderTables[0].clearSelection();
            this.doSelectCells(n3, n3, n2, n2);
        } else {
            boolean bl = false;
            int[] nArray = this.mVarHeaderTable.getSelectedRows();
            if (nArray.length > 0) {
                new DeleteVariablesEdit(this.getUndoManager(), this.mVarTableModel, this.mDataTableModel.getDataSource(), nArray, this);
                bl = true;
            } else {
                this.clearSelectedCellData(this.mVarTable);
            }
            if (bl) {
                int n4 = this.mVarHeaderTable.getSelectedRow();
                this.mVarTable.clearSelection();
                this.mVarHeaderTable.clearSelection();
                this.doSelectVarViewCell(0, n4);
            }
        }
        if (this.mDataTables[0] != null) {
            this.mDataTables[0].repaint();
        }
    }

    public void doGridFont() {
        int n;
        int n2;
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node("doc_types/dataeditor");
        String string = preferences2.get("font_family", PrefDefaults.DEF_DE_FONT_FAMILY);
        SPSSFontChooser sPSSFontChooser = new SPSSFontChooser(this.mParentFrame, true, string, n2 = preferences2.getInt("font_style", 0), n = preferences2.getInt("font_size", PrefDefaults.DEF_DE_FONT_SIZE));
        if (sPSSFontChooser.getReturnValue() == 0) {
            Font font = sPSSFontChooser.getSelectedFont();
            this.setFontForTables(font, false);
            int n3 = (int)FontUtil.physicalToLogicalSize((float)font.getSize2D());
            preferences2.put("font_family", font.getFamily(ResUtil.getLocale()));
            preferences2.putInt("font_style", font.getStyle());
            preferences2.putInt("font_size", n3);
        }
    }

    public void commitEdit() {
        for (DataViewTable dataViewTable : this.mDataTables) {
            if (!dataViewTable.isEditing()) continue;
            if (dataViewTable.getCellEditor().stopCellEditing()) break;
            dataViewTable.getCellEditor().cancelCellEditing();
            break;
        }
        if (this.mVarTable.isEditing() && !this.mVarTable.getCellEditor().stopCellEditing()) {
            this.mVarTable.getCellEditor().cancelCellEditing();
        }
    }

    public void cancelEdit() {
        for (DataViewTable dataViewTable : this.mDataTables) {
            if (!dataViewTable.isEditing()) continue;
            dataViewTable.getCellEditor().cancelCellEditing();
        }
        if (this.mVarTable.isEditing()) {
            this.mVarTable.getCellEditor().cancelCellEditing();
        }
    }

    public long getDataRowCount() {
        if (this.mParentFrame == null) {
            return 0L;
        }
        ISpssDataSrc iSpssDataSrc = this.getDataSrc();
        if (iSpssDataSrc == null) {
            return -1L;
        }
        int n = this.mTabbedPane.getSelectedIndex();
        if (n == 0) {
            return DataViewTableModel.getDisplayableRowCount((int)iSpssDataSrc.rowCount());
        }
        return iSpssDataSrc.columnCount();
    }

    public int getDataColumnCount() {
        int n = this.mTabbedPane.getSelectedIndex();
        if (n == 0) {
            ISpssDataSrc iSpssDataSrc = this.getDataSrc();
            if (iSpssDataSrc != null) {
                return iSpssDataSrc.columnCount();
            }
            return -1;
        }
        return this.mVarTableModel.getColumnCount();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (SwingUtilities.isEventDispatchThread()) {
            this.createColumnRenderers(true);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DataView.this.createColumnRenderers(true);
                }
            });
        }
    }

    public static String[][] parseString2Array(String string, boolean bl) {
        int n;
        String string2 = "\n";
        if (OSInfo.getOSType() == OSInfo.OSType.MAC && string.contains("\r")) {
            string2 = "\r";
        }
        String[] stringArray = string.split(string2);
        String[][] stringArray2 = new String[stringArray.length][];
        int n2 = 0;
        for (n = 0; n < stringArray.length; ++n) {
            stringArray2[n] = stringArray[n].split("\t", -2);
            n2 = stringArray2[n].length > n2 ? stringArray2[n].length : n2;
        }
        for (n = 0; n < n2; ++n) {
            int n3 = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    n3 = stringArray2[i][n].length() > n3 ? stringArray2[i][n].length() : n3;
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!bl) continue;
            try {
                stringArray2[0][n] = DataView.rightPadWithBlanks(stringArray2[0][n], n3);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return stringArray2;
    }

    public static String rightPadWithBlanks(String string, int n) {
        StringBuilder stringBuilder = new StringBuilder(string);
        while (stringBuilder.length() < n) {
            stringBuilder.append(' ');
        }
        return stringBuilder.toString();
    }

    public String getSelectedDataAsString(JTable jTable, boolean bl) {
        int n;
        DecimalFormatSymbols decimalFormatSymbols;
        CellValueFormatter cellValueFormatter;
        Object object;
        long l;
        ISpssDataSrc iSpssDataSrc = this.getDataSrc();
        if (iSpssDataSrc == null) {
            return null;
        }
        boolean bl2 = jTable instanceof DataViewTable;
        StringBuilder stringBuilder = new StringBuilder();
        Object object2 = jTable.getSelectedRows();
        Object object3 = jTable.getSelectedColumns();
        long l2 = ((int[])object3).length;
        if (bl2) {
            l = (long)((int[])object2).length > iSpssDataSrc.rowCount() ? iSpssDataSrc.rowCount() : (long)((int[])object2).length;
            l2 = ((int[])object3).length > iSpssDataSrc.columnCount() ? (long)iSpssDataSrc.columnCount() : (long)((int[])object3).length;
        } else {
            long l3 = l = ((int[])object2).length > iSpssDataSrc.columnCount() ? (long)iSpssDataSrc.columnCount() : (long)((int[])object2).length;
        }
        if (l > 0L && l <= (long)((int[])object2).length) {
            object = new int[(int)l];
            System.arraycopy(object2, 0, object, 0, (int)l);
            object2 = object;
        }
        if (l2 > 0L && l2 <= (long)((int[])object3).length) {
            object = new int[(int)l2];
            System.arraycopy(object3, 0, object, 0, (int)l2);
            object3 = object;
        }
        object = null;
        Format[] formatArray = null;
        IValueLabelMap[] iValueLabelMapArray = null;
        if (bl2) {
            ColumnDataProvider columnDataProvider = new ColumnDataProvider(iSpssDataSrc);
            object = new OBS[((int[])object3).length][((int[])object2).length];
            for (int i = 0; i < ((int[])object3).length; ++i) {
                object[i] = columnDataProvider.getColumnData(object3[i], (long)object2[0], (long)object2[((int[])object2).length - 1]);
            }
            cellValueFormatter = new CellValueFormatter(PrefsMgr.getLeadZeroPreferenceValue());
            formatArray = new Format[((int[])object3).length];
            boolean bl3 = this.mParentFrame.getViewValueLabels();
            if (bl3) {
                iValueLabelMapArray = new IValueLabelMap[((int[])object3).length];
            }
            for (int i = 0; i < ((int[])object3).length && object3[i] < iSpssDataSrc.columnCount(); ++i) {
                IValueLabelMap iValueLabelMap;
                decimalFormatSymbols = iSpssDataSrc.getVariable(object3[i]);
                formatArray[i] = cellValueFormatter.buildFormatter(decimalFormatSymbols.getFormat());
                if (!bl3 || (n = (iValueLabelMap = decimalFormatSymbols.getValueLabels()).size()) <= 0) continue;
                iValueLabelMapArray[i] = iValueLabelMap;
            }
        }
        if (((int[])object2).length > 0 && ((int[])object3).length > 0) {
            DecimalFormatSymbols decimalFormatSymbols2 = null;
            decimalFormatSymbols = null;
            if (bl) {
                decimalFormatSymbols2 = new DecimalFormatSymbols(ComponentState.getSystemLocale());
                decimalFormatSymbols = new DecimalFormatSymbols(ComponentState.getSPSSLocale());
            }
            for (int i = 0; !(i >= ((int[])object2).length || bl2 && (long)object2[i] >= iSpssDataSrc.rowCount() || !bl2 && object2[i] >= iSpssDataSrc.columnCount()); ++i) {
                if (i > 0) {
                    stringBuilder.append("\n");
                }
                for (n = 0; !(n >= ((int[])object3).length || bl2 && object3[n] >= iSpssDataSrc.columnCount()); ++n) {
                    String string = null;
                    if (bl2) {
                        if (object != null) {
                            int n2 = object2[i] - object2[0];
                            cellValueFormatter = object[n][n2];
                        } else {
                            cellValueFormatter = iSpssDataSrc.getCacheMgr().getCellValue((long)object2[i], object3[n]);
                        }
                        string = null;
                        if (cellValueFormatter != null && iValueLabelMapArray != null && iValueLabelMapArray[n] != null) {
                            if (cellValueFormatter.isString()) {
                                cellValueFormatter.setString(cellValueFormatter.getString().trim());
                            }
                            string = iValueLabelMapArray[n].get((OBS)cellValueFormatter);
                        }
                        if (string == null) {
                            SPSS_Format sPSS_Format = iSpssDataSrc.getVariable(object3[n]).getFormat();
                            if (cellValueFormatter == null || cellValueFormatter.isMissing((IDataSrc)iSpssDataSrc) || sPSS_Format.getFormatType().isNumericFormat() && new Double(cellValueFormatter.getNum()).isNaN()) {
                                string = "";
                            } else {
                                string = !sPSS_Format.getFormatType().isDateOrTimeFormat() ? formatArray[n].format(cellValueFormatter.isString() ? cellValueFormatter.getString().trim().replace('\n', ' ') : Double.valueOf(cellValueFormatter.getNum())) : CellValueFormatter.obsToString((OBS)cellValueFormatter, (SPSS_Format)sPSS_Format);
                                if (bl && sPSS_Format.getFormatType().isNumericFormat() && !sPSS_Format.getFormatType().isCurrencyFormat() && !sPSS_Format.getFormatType().isDateOrTimeFormat() && !sPSS_Format.getFormatType().isDotFormat() && !sPSS_Format.getFormatType().isCommaFormat() && decimalFormatSymbols2.getDecimalSeparator() != decimalFormatSymbols.getDecimalSeparator()) {
                                    string = string.replace(decimalFormatSymbols.getDecimalSeparator(), decimalFormatSymbols2.getDecimalSeparator());
                                }
                            }
                        }
                    } else if (jTable instanceof VarViewTable) {
                        VarViewTable varViewTable = (VarViewTable)jTable;
                        VarViewTableModel varViewTableModel = (VarViewTableModel)varViewTable.getModel();
                        string = varViewTableModel.getValueAsString(object2[i], object3[n]);
                    }
                    if (string == null) {
                        string = "";
                    }
                    if (n == 0) {
                        stringBuilder.append(string);
                        continue;
                    }
                    stringBuilder.append("\t").append(string);
                }
            }
        }
        return stringBuilder.toString();
    }

    void createColumnRenderers(boolean bl) {
        if (this.mParentFrame == null || this.mParentFrame.getDatasetId() == null) {
            return;
        }
        ISpssDataSrc iSpssDataSrc = this.getDataSrc();
        try {
            for (int i = 0; i < iSpssDataSrc.columnCount(); ++i) {
                this.createColumnRenderer(i);
                if (!bl) continue;
                this.setDataColumnWidth(i, iSpssDataSrc.getVariable(i).getDisplayWidth());
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    void notifyCloseDataSetImpl(LocallyUniqueId locallyUniqueId) {
        if (this.mParentFrame == null) {
            return;
        }
        if (!locallyUniqueId.equals((Object)this.mParentFrame.getDatasetId())) {
            assert (false);
            return;
        }
        this.mSplitPane.disconnect();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        if (iSpssDataSrc != null && this.mObserver != null) {
            iSpssDataSrc.removeObserver((IDatasetViewObserver)this.mObserver);
        }
        this.removeComponentListener(this);
        this.mTabbedPane.removeChangeListener(this);
        ComponentState.removeLocaleListener((ILocaleListener)this);
        SpssFrameMgr.getSpssFrameMgr().clearChartDataLinks();
        Object object = this.mDataHeaderTables;
        int n = ((SpssRowHeaderTable[])object).length;
        for (int i = 0; i < n; ++i) {
            SpssRowHeaderTable spssRowHeaderTable = object[i];
            spssRowHeaderTable.disconnect();
        }
        if (this.mCellProvider != null) {
            this.mCellProvider.clear();
        }
        this.mEditBar.destroy();
        for (n = 0; n < this.mDataTables[0].getColumnModel().getColumnCount(); ++n) {
            object = this.mDataTables[0].getColumnModel().getColumn(n);
            ((TableColumn)object).setCellEditor(null);
            ((TableColumn)object).setCellRenderer(null);
            ((TableColumn)object).setHeaderRenderer(null);
        }
        this.mDataTableModel.disconnect();
        this.mDataRowHeaderModel.disconnect();
        this.mVarTableModel.disconnect();
        this.mVarRowHeaderModel.disconnect();
        this.mParentFrame.setVisible(false);
        this.mParentFrame.doDocumentClose();
        this.mParentFrame.dispose();
        this.mParentFrame = null;
        this.mCurrentSPSSLocale = null;
        this.mDataTableModel = null;
        this.mDataTables = null;
        this.mDataRowHeaderModel = null;
        this.mVarRowHeaderModel = null;
        this.mDataHeaderTables = null;
        this.mVarTableModel = null;
        this.mVarHeaderTable = null;
        this.mVarTable = null;
        this.mTabbedPane = null;
        this.mEditBar = null;
        this.mSplitPane = null;
        this.mColumnRenderer = null;
        this.mCellProvider = null;
        this.mEncodingValidator = null;
        this.mGridsOn = null;
        this.mObserver = null;
    }

    void notifyDataModifiedImpl(ORIGINATOR_ID oRIGINATOR_ID) {
        if (oRIGINATOR_ID == ORIGINATOR_ID.SERVER_ORIGINATOR) {
            this.mParentFrame.updateTitleBar();
        }
        SpssFrameMgr.getSpssFrameMgr().clearChartDataLinks();
    }

    void notifyStartOfDictionaryModsImpl() {
        this.mDataTableModel.setReadOnly(true);
        this.mVarTableModel.setReadOnly(true);
    }

    void notifyEndOfDictionaryModsImpl() {
        this.mDataTableModel.setReadOnly(false);
        this.mVarTableModel.setReadOnly(false);
        if (AppMgr.getAppMgr().isSessionClosing()) {
            return;
        }
        this.updateDatasetState(true);
    }

    void notifyFileNameImpl(String string, boolean bl) {
        if (this.mParentFrame != null) {
            this.mParentFrame.updateTitleBar();
        }
        assert (this.mParentFrame != null);
    }

    void notifyFilterVarImpl(int n) {
        ISpssVariable iSpssVariable;
        ISpssDataSrc iSpssDataSrc = this.getDataSrc();
        if (iSpssDataSrc == null) {
            return;
        }
        VarCaseFilter varCaseFilter = null;
        if (n != -1 && (iSpssVariable = iSpssDataSrc.getVariable(n)) != null) {
            varCaseFilter = new VarCaseFilter(iSpssDataSrc, iSpssVariable.getId(), 0.0);
        }
        iSpssDataSrc.setCaseFilter(varCaseFilter);
        if (varCaseFilter != null) {
            this.mParentFrame.updateFilterStatus(true);
        } else {
            this.mParentFrame.updateFilterStatus(false);
        }
    }

    void notifyNewRowsImpl(long l, long l2) {
        this.mDataTableModel.notifyNewRows(l, l2);
    }

    void notifyResetUndoImpl() {
        if (this.mParentFrame != null) {
            this.mParentFrame.getUndoManager().discardAllEdits();
        }
    }

    void notifyRowCountEstablishedImpl() {
        ISpssDataSrc iSpssDataSrc = this.getDataSrc();
        if (iSpssDataSrc != null) {
            int[] nArray = this.mDataTables[0].getSelectedRows();
            int[] nArray2 = this.mDataTables[0].getSelectedColumns();
            this.mDataTableModel.fireTableStructureChanged();
            this.mVarTableModel.fireTableStructureChanged();
            this.mVarRowHeaderModel.fireTableDataChanged();
            if (nArray != null && nArray.length > 0 && nArray[0] < this.mDataTableModel.getRowCount()) {
                int n = Math.min(nArray[nArray.length - 1], this.mDataTableModel.getRowCount());
                this.mDataTables[0].getSelectionModel().setSelectionInterval(nArray[0], n);
            }
            if (nArray2 != null && nArray2.length > 0) {
                this.mDataTables[0].getColumnModel().getSelectionModel().addSelectionInterval(nArray2[0], nArray2[nArray2.length - 1]);
            }
        }
    }

    void notifySplitFileImpl(boolean bl) {
        if (this.mParentFrame != null) {
            this.mParentFrame.updateSplitFileStatus(bl);
        }
    }

    public Rectangle getCellRect(int n, int n2) {
        JTable jTable = this.getLastActiveTable();
        return jTable.getCellRect(n2, n, true);
    }

    public void scrollCellToVisible(int n, int n2) {
        JTable jTable = this.getLastActiveTable();
        JViewport jViewport = this.getLastActiveViewport();
        if (jTable == null || jViewport == null) {
            return;
        }
        Rectangle rectangle = jTable.getCellRect(n2, n, true);
        Point point = jViewport.getViewPosition();
        rectangle.setLocation(rectangle.x - point.x, rectangle.y - point.y);
        jViewport.scrollRectToVisible(rectangle);
    }

    public void selectCell(int n, int n2) {
        JTable jTable = this.getLastActiveTable();
        jTable = jTable != null ? jTable : this.mDataTables[0];
        jTable.changeSelection(n2, n, false, false);
    }

    public void selectCells(int n, int n2, int n3, int n4) {
        if (!DataMgr.getDataMgr().isDataFreeClient()) {
            JTable jTable = this.getLastActiveTable();
            jTable.getSelectionModel().setSelectionInterval(n3, n4);
            jTable.getColumnModel().getSelectionModel().setSelectionInterval(n, n2);
        }
    }

    private void repositionFindDlg(DataFindDlg dataFindDlg, int n, int n2) {
        JTable jTable = this.getLastActiveTable();
        Rectangle rectangle = jTable.getCellRect(n2, n, true);
        Point point = new Point(rectangle.x, rectangle.y);
        SwingUtilities.convertPointToScreen(point, jTable);
        rectangle = new Rectangle(point.x, point.y, rectangle.width, rectangle.height);
        dataFindDlg.adjustPosition(rectangle);
    }

    void notifyCellValueFoundImpl(int n, long l, String string) {
        DataFindDlg dataFindDlg = this.mParentFrame.getSearchDialog();
        if (dataFindDlg != null) {
            DataSearchOptions dataSearchOptions = dataFindDlg.getSearchOptions();
            boolean bl = dataSearchOptions.getReplaceAll();
            if (!bl) {
                dataFindDlg.setInBackendSearch(false);
            } else if (!dataFindDlg.isShowing()) {
                return;
            }
            if (this.getActiveView() != 0) {
                this.setActiveView(0);
            }
            if (l > -1L) {
                if (l < (long)dataSearchOptions.getFocusedRow()) {
                    dataSearchOptions.setWrapped(true);
                }
                if (!bl) {
                    this.scrollCellToVisible(n, (int)l);
                    if (dataFindDlg.isVisible()) {
                        this.repositionFindDlg(dataFindDlg, n, (int)l);
                    }
                }
                this.selectCells(n, n, (int)l, (int)l);
                this.repaint();
            } else {
                dataFindDlg.setInBackendSearch(false);
                if (!bl) {
                    dataSearchOptions.restoreSelections(this.mDataTables[0]);
                    dataSearchOptions.setFirstSearch(true);
                    dataFindDlg.showNotFoundMsg(string);
                } else {
                    dataFindDlg.replaceAllResponse(dataSearchOptions.getItemsSearched());
                }
            }
        }
    }

    void notifyStopFindImpl(boolean bl) {
        DataFindDlg dataFindDlg = this.mParentFrame.getSearchDialog();
        DataSearchOptions dataSearchOptions = dataFindDlg.getSearchOptions();
        dataSearchOptions.restoreSelections(this.mDataTables[0]);
        dataSearchOptions.setFirstSearch(true);
        dataFindDlg.setInBackendSearch(false);
        dataFindDlg.setCursor(null);
        if (!bl) {
            JOptionPane.showMessageDialog(this.mParentFrame, ResUtil.getString("ERR_NOSTOP_SEARCH_ERROR"), VersionInfo.getAppVersionString(), 1);
        }
    }

    void notifyReplaceResultImpl(Vector<CellValue> vector) {
        if (!this.mParentFrame.getSearchDialog().isShowing()) {
            return;
        }
        DataFindDlg dataFindDlg = this.mParentFrame.getSearchDialog();
        DataSearchOptions dataSearchOptions = dataFindDlg.getSearchOptions();
        dataFindDlg.setInBackendSearch(false);
        dataSearchOptions.setItemsSearched(vector.size());
        new TableColumnValuesEdit(this.mDataTables[0], vector);
        this.mParentFrame.updateToolbarEnableStatus();
        dataFindDlg.replaceAllResponse(vector.size());
    }

    void notifyTrendsInfoImpl() {
        if (this.mParentFrame != null) {
            this.mParentFrame.updateUseStatus();
        }
    }

    void notifyVariableInsertedImpl(int n, ORIGINATOR_ID oRIGINATOR_ID) {
        int n2;
        if (this.mParentFrame == null) {
            return;
        }
        ISpssDataSrc iSpssDataSrc = this.getDataSrc();
        if (iSpssDataSrc == null) {
            return;
        }
        for (n2 = n; n2 < iSpssDataSrc.columnCount(); ++n2) {
            this.createColumnRenderer(n2);
            if (!oRIGINATOR_ID.equals((Object)ORIGINATOR_ID.DATAMGR_ORIGINATOR)) continue;
            this.adjustVarTableWidth(n2);
        }
        if (oRIGINATOR_ID.equals((Object)ORIGINATOR_ID.DATAMGR_ORIGINATOR)) {
            n2 = iSpssDataSrc.columnCount();
            this.mVarRowHeaderModel.fireTableRowsInserted(0, n2 - 1);
            int n3 = this.mVarTableModel.getRowCount() - n2;
            ArrayList<Integer> arrayList = this.getVariabIeDList();
            this.mDataTables[0].updateVariableOrder(arrayList);
            this.mVarTableModel.fireTableRowsInserted(n + n3, n + n3);
            if (this.getActiveView() == 1 && this.mSelectNewVarRow) {
                this.selectRow(n);
                this.mSelectNewVarRow = false;
            }
        }
    }

    public void selectRow(final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DataView.this.mVarHeaderTable.clearSelection();
                DataView.this.mVarTable.clearSelection();
                DataView.this.mVarHeaderTable.setColumnSelectionInterval(0, 0);
                DataView.this.mVarHeaderTable.setRowSelectionInterval(n, n);
                DataView.this.mVarTable.setColumnSelectionInterval(0, DataView.this.mVarTableModel.getColumnCount() - 1);
                DataView.this.mVarTable.setRowSelectionInterval(n, n);
            }
        });
    }

    public void selectNewVarRow(boolean bl) {
        this.mSelectNewVarRow = bl;
    }

    void notifyVariablesInsertedImpl(Vector<Integer> vector, ORIGINATOR_ID oRIGINATOR_ID) {
        if (this.mParentFrame == null || vector.size() == 0) {
            return;
        }
        int n = Integer.MAX_VALUE;
        ISpssDataSrc iSpssDataSrc = vector.iterator();
        while (iSpssDataSrc.hasNext()) {
            int n2 = iSpssDataSrc.next();
            n = Math.min(n2, n);
        }
        iSpssDataSrc = this.getDataSrc();
        if (iSpssDataSrc == null) {
            return;
        }
        for (int i = n; i < iSpssDataSrc.columnCount(); ++i) {
            ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(i);
            if (iSpssVariable == null) continue;
            this.createColumnRenderer(i);
            this.adjustVarTableWidth(i);
        }
        ArrayList<Integer> arrayList = this.getVariabIeDList();
        this.mDataTables[0].updateVariableOrder(arrayList);
        if (oRIGINATOR_ID.equals((Object)ORIGINATOR_ID.DATAMGR_ORIGINATOR) && this.getActiveView() == 1) {
            this.mVarTable.repaint(100L);
            this.mVarHeaderTable.repaint(100L);
        }
    }

    void notifyVariableModifiedImpl(int n, ORIGINATOR_ID oRIGINATOR_ID) {
        if (this.mParentFrame == null) {
            return;
        }
        try {
            this.createColumnRenderer(n);
            ISpssDataSrc iSpssDataSrc = this.getDataSrc();
            this.setDataColumnWidth(n, iSpssDataSrc.getVariable(n).getDisplayWidth());
            if (oRIGINATOR_ID.equals((Object)ORIGINATOR_ID.DATAMGR_ORIGINATOR)) {
                this.mDataTableModel.fireTableDataChanged();
                this.mVarTableModel.fireTableVariableChanged(n);
            } else {
                this.mVarTable.checkDisplayAttributes();
            }
            ArrayList<Integer> arrayList = this.getVariabIeDList();
            this.mDataTables[0].updateVariableOrder(arrayList);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void notifyDatasetAttributesModified(ExtensionType extensionType) {
        if (extensionType.equals((Object)ExtensionType.kDatasetAttributes)) {
            this.mVarTable.updateDisplayedAttributes();
        }
    }

    void notifyVariablesDeletedImpl(int n, int n2, int n3, ORIGINATOR_ID oRIGINATOR_ID) {
        TableColumn tableColumn;
        int n4;
        int n5;
        if (this.mParentFrame == null) {
            return;
        }
        if (n == -1 || n2 == -1) {
            return;
        }
        ISpssDataSrc iSpssDataSrc = this.getDataSrc();
        if (iSpssDataSrc == null) {
            return;
        }
        int n6 = iSpssDataSrc.columnCount();
        for (n5 = n; n5 < n6; ++n5) {
            this.createColumnRenderer(n5);
        }
        for (n5 = 0; n5 < 2; ++n5) {
            for (n4 = n6; n4 < this.mDataTables[n5].getColumnModel().getColumnCount(); ++n4) {
                tableColumn = this.mDataTables[n5].getColumnModel().getColumn(n4);
                tableColumn.setCellRenderer(null);
                tableColumn.setCellEditor(null);
                tableColumn.setHeaderValue(this.mDataTables[n5].getColumnName(n4));
                tableColumn.setPreferredWidth(75);
            }
        }
        if (oRIGINATOR_ID.equals((Object)ORIGINATOR_ID.DATAMGR_ORIGINATOR)) {
            this.mVarTableModel.fireTableVariablesDeleted(n, n2);
        }
        if ((n5 = this.mDataTables[0].getColumnModel().getColumnCount()) > n3 + n2 - n + 1) {
            n5 = n3 + n2 - n + 1;
        }
        for (n4 = n; n4 < n5; ++n4) {
            tableColumn = this.mDataTables[0].getColumnModel().getColumn(n4);
            tableColumn.setHeaderValue(this.mDataTables[0].getColumnName(n4));
            if (n4 < n6 && iSpssDataSrc.getVariable(n4) != null) {
                this.setDataColumnWidth(n4, iSpssDataSrc.getVariable(n4).getDisplayWidth());
                continue;
            }
            this.setDataColumnWidth(n4, (short)8);
        }
        ArrayList<Integer> arrayList = this.getVariabIeDList();
        this.mDataTables[0].updateVariableOrder(arrayList);
        if (oRIGINATOR_ID.equals((Object)ORIGINATOR_ID.DATAMGR_ORIGINATOR)) {
            this.mDataTableModel.fireTableDataChanged();
        }
    }

    void notifyVariablesMovedImpl(int n, int n2, int n3) {
        if (this.mParentFrame == null) {
            return;
        }
        int n4 = n < n2 ? n : n2;
        int n5 = n > n2 ? n : n2;
        n4 = n4 < n3 ? n4 : n3;
        n5 = n3 > n5 ? n3 : n5;
        ISpssDataSrc iSpssDataSrc = this.getDataSrc();
        if (iSpssDataSrc == null) {
            return;
        }
        for (int i = n4; i < n5 + 1; ++i) {
            if (iSpssDataSrc.getVariable(i) == null) continue;
            this.createColumnRenderer(i);
            this.setDataColumnWidth(i, iSpssDataSrc.getVariable(i).getDisplayWidth());
            this.mVarTableModel.fireTableVariableChanged(i);
        }
        ArrayList<Integer> arrayList = this.getVariabIeDList();
        this.mDataTables[0].updateVariableOrder(arrayList);
        this.mDataTableModel.fireTableDataChanged();
    }

    void notifyWeightVarImpl(int n) {
        if (n >= 0) {
            this.mParentFrame.updateWeightStatus(true);
        } else {
            this.mParentFrame.updateWeightStatus(false);
        }
    }

    void notifyPendingTransformationImpl(LocallyUniqueId locallyUniqueId, boolean bl) {
        if (locallyUniqueId.equals((Object)this.mParentFrame.getDatasetId())) {
            this.mParentFrame.activateDataFrame();
        } else {
            SpssFrameMgr.getSpssFrameMgr().updatePendingTransformation(locallyUniqueId, bl);
        }
    }

    void notifyVariableSetsChangeImpl() {
        ISpssDataSrc iSpssDataSrc = this.getDataSrc();
        if (iSpssDataSrc == null) {
            return;
        }
        Vector vector = iSpssDataSrc.getVariableSetsInUse();
        String string = ISpssDataSrc.ALLVARIABLES;
        String string2 = ISpssDataSrc.NEWVARIABLES;
        boolean bl = false;
        boolean bl2 = false;
        for (String string3 : vector) {
            if (string3.equals(string)) {
                bl = true;
            } else if (string3.equals(string2)) {
                bl2 = true;
            }
            if (!bl || !bl2) continue;
            break;
        }
        boolean bl3 = !bl || !bl2;
        this.mParentFrame.setToolbarToggleButtonState("utilities_use_variable_sets", bl3);
        this.updateVarsInUse(true);
    }

    void notifyImputationInfoImpl() {
        this.updateMultipleImputationUI();
    }

    void notifyImputationDisplayChangeImpl() {
        this.updateUI();
    }

    void setDirtyFlagImpl(boolean bl) {
        if (this.mParentFrame != null) {
            this.mParentFrame.updateTitleBar();
            this.mParentFrame.updateToolbarEnableStatus();
        }
        SpssFrameMgr.getSpssFrameMgr().clearChartDataLinks();
    }

    private void loadTabStrings() {
        sStrDViewActive = DataView.formatHTMLString(ResUtil.getString(DATA_VIEW_STR), true, false, false);
        sStrDViewInactive = DataView.formatHTMLString(ResUtil.getString(DATA_VIEW_STR), false, false, false);
        sStrVViewActive = DataView.formatHTMLString(ResUtil.getString(VAR_VIEW_STR), true, false, false);
        sStrVViewInactive = DataView.formatHTMLString(ResUtil.getString(VAR_VIEW_STR), false, false, false);
    }

    private void updateDatasetState(boolean bl) {
        if (!this.mIsDictModEndPending) {
            this.mIsDictModEndPending = true;
            try {
                this.mVarTableModel.fireTableStructureChanged();
                this.mVarRowHeaderModel.fireTableDataChanged();
                this.updateVarsInUse(bl);
                for (int i = 0; i < 4; ++i) {
                    this.mDataTables[i].revalidate();
                    this.mDataTables[i].repaint();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.mIsDictModEndPending = false;
        }
    }

    private void createDataView() {
        Serializable serializable;
        int n;
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        DataViewTable.Location[] locationArray = new DataViewTable.Location[]{DataViewTable.Location.eTopLeft, DataViewTable.Location.eTopRight, DataViewTable.Location.eBottomLeft, DataViewTable.Location.eBottomRight};
        for (n = 0; n < 4; ++n) {
            this.mDataTables[n] = new DataViewTable((TableModel)this.mDataTableModel, this, locationArray[n]);
            this.mDataTables[n].setAutoCreateColumnsFromModel(false);
            this.mDataTables[n].setAutoResizeMode(0);
            if (DataMgr.getDataMgr().isDataFreeClient() && (serializable = this.mDataTables[n].getTableHeader()) != null) {
                serializable.setMaximumSize(new Dimension(0, 0));
                serializable.setPreferredSize(new Dimension(0, 0));
            }
            this.mDataTables[n].getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    DataView.this.mParentFrame.updateToolbarEnableStatus();
                }
            });
            this.mDataTables[n].getColumnModel().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    DataView.this.mParentFrame.updateToolbarEnableStatus();
                }
            });
        }
        for (n = 1; n < 4; ++n) {
            this.mDataTables[n].setColumnModel(this.mDataTables[0].getColumnModel());
            this.mDataTables[n].setSelectionModel(this.mDataTables[0].getSelectionModel());
        }
        this.mEditBar = new DataEditBar(this.mDataTables[0]);
        if (!DataMgr.getDataMgr().isDataFreeClient()) {
            for (n = 0; n < 4; ++n) {
                this.mDataTables[n].setDataEditBar(this.mEditBar);
            }
        }
        this.mTabbedPane.addTab(sStrDViewActive, null, jPanel, null);
        this.mTabbedPane.getAccessibleContext().getAccessibleChild(0).getAccessibleContext().setAccessibleName(ResUtil.getString(DATA_VIEW_STR));
        this.mTabbedPane.setFocusable(false);
        for (n = 0; n < 2; ++n) {
            this.mDataHeaderTables[n] = new SpssRowHeaderTable((TableModel)this.mDataRowHeaderModel, this);
            this.mDataHeaderTables[n].getTableHeader().setReorderingAllowed(false);
        }
        this.mDataHeaderTables[1].setSelectionModel(this.mDataHeaderTables[0].getSelectionModel());
        if (!DataMgr.getDataMgr().isDataFreeClient()) {
            this.mDataHeaderTables[0].connectDataTable(this.mDataTables[0]);
            this.mDataHeaderTables[1].connectDataTable(this.mDataTables[2]);
        }
        JScrollPane jScrollPane = this.getScrollPaneWithRowHeader(this.mDataTables[0], this.mDataHeaderTables[0], true);
        this.mSplitPane = new CompositeSplitPane(jScrollPane, new JScrollPane(this.mDataTables[1], 22, 32), this.getScrollPaneWithRowHeader(this.mDataTables[2], this.mDataHeaderTables[1], true), new JScrollPane(this.mDataTables[3], 22, 32), this.mDataTables[0], this.mDataHeaderTables[0]);
        serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).gridx = 0;
        ((GridBagConstraints)serializable).gridy = 0;
        ((GridBagConstraints)serializable).gridwidth = 1;
        ((GridBagConstraints)serializable).gridheight = 1;
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).weighty = 0.0;
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).anchor = 23;
        ((GridBagConstraints)serializable).insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)this.mEditBar, serializable);
        ((GridBagConstraints)serializable).gridy = 1;
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).weighty = 1.0;
        ((GridBagConstraints)serializable).fill = 1;
        jPanel.add((Component)this.mSplitPane, serializable);
    }

    private void createVariableView() {
        this.mVarTable = new VarViewTable(this.mVarTableModel, this);
        this.mVarTable.setAutoCreateColumnsFromModel(false);
        this.mVarTable.setAutoResizeMode(0);
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        String string = ResUtil.getString(VAR_VIEW_STR);
        this.mTabbedPane.addTab(string, null, jPanel, null);
        this.mTabbedPane.getAccessibleContext().getAccessibleChild(1).getAccessibleContext().setAccessibleName(string);
        TableCellRenderer tableCellRenderer = this.mVarTable.getTableHeader().getDefaultRenderer();
        if (tableCellRenderer instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)tableCellRenderer).setHorizontalAlignment(0);
        }
        this.mVarHeaderTable = new SpssRowHeaderTable((TableModel)this.mVarRowHeaderModel, this);
        JScrollPane jScrollPane = this.getScrollPaneWithRowHeader(this.mVarTable, this.mVarHeaderTable, false);
        jScrollPane.setHorizontalScrollBarPolicy(32);
        this.mVarHeaderTable.connectDataTable(this.mVarTable);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jScrollPane, gridBagConstraints);
    }

    private void createColumnRenderer(int n) {
        if (this.mParentFrame == null) {
            return;
        }
        if (DataMgr.getDataMgr().isDataFreeClient()) {
            return;
        }
        try {
            ISpssVariable iSpssVariable;
            ISpssDataSrc iSpssDataSrc = this.getDataSrc();
            if (iSpssDataSrc != null && (iSpssVariable = iSpssDataSrc.getVariable(n)) != null) {
                IValueLabelMap iValueLabelMap;
                int n2;
                TableColumnModel tableColumnModel = this.mDataTables[0].getColumnModel();
                while (tableColumnModel.getColumnCount() < this.mDataTables[0].getModel().getColumnCount()) {
                    this.mDataTables[0].addColumn(new TableColumn(tableColumnModel.getColumnCount()));
                }
                TableColumn tableColumn = this.mDataTables[0].getColumnModel().getColumn(n);
                if (this.mColumnRenderer == null) {
                    this.mColumnRenderer = new DragTableColumnRenderer(this.mDataTables[0], true);
                    this.mColumnRenderer.setHorizontalAlignment(0);
                }
                tableColumn.setHeaderRenderer(this.mColumnRenderer);
                if (this.mCellProvider == null) {
                    this.mCellProvider = new FormatCellProvider(this.mParentFrame);
                }
                tableColumn.setCellRenderer(this.mCellProvider.getCellRenderer(iSpssVariable));
                TableCellEditor tableCellEditor = null;
                if (this.mParentFrame.getViewValueLabels() && (n2 = (iValueLabelMap = iSpssVariable.getValueLabels()).size()) > 0) {
                    tableCellEditor = this.mDataTables[0].getValueLabelEditor();
                }
                if (tableCellEditor == null) {
                    tableCellEditor = this.mCellProvider.getCellEditor(iSpssVariable);
                }
                tableColumn.setCellEditor(tableCellEditor);
                tableColumn.setHeaderValue(this.mDataTables[0].getModel().getColumnName(n));
                if (!this.mDataTableModel.isReadOnly()) {
                    this.mDataTables[0].getTableHeader().resizeAndRepaint();
                    if (this.isDividerOn()) {
                        this.mDataTables[1].getTableHeader().resizeAndRepaint();
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        catch (AssertionError assertionError) {
            ((Throwable)((Object)assertionError)).printStackTrace();
        }
    }

    private void loadPrefsSettings() {
        boolean bl;
        this.loadFontFromPrefs();
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node("doc_types/dataeditor");
        boolean bl2 = bl = preferences2.getInt("de_view", 0) == 0;
        if (!bl || DataMgr.getDataMgr().isDataFreeClient()) {
            this.setActiveView(1);
        }
        boolean bl3 = preferences2.getBoolean("dv_grids", true);
        boolean bl4 = preferences2.getBoolean("vv_grids", true);
        if (!bl3) {
            for (DataViewTable dataViewTable : this.mDataTables) {
                dataViewTable.setShowHorizontalLines(false);
                dataViewTable.setShowVerticalLines(false);
            }
        }
        if (!bl4) {
            this.mVarTable.setShowHorizontalLines(false);
            this.mVarTable.setShowVerticalLines(false);
        }
        this.mGridsOn[0] = bl3;
        this.mGridsOn[1] = bl4;
    }

    private static String formatHTMLString(String string, boolean bl, boolean bl2, boolean bl3) {
        String string2 = "<html>";
        if (bl) {
            string2 = string2 + "<B>";
        }
        if (bl2) {
            string2 = string2 + "<I>";
        }
        if (bl3) {
            string2 = string2 + "<U>";
        }
        string2 = string2 + string;
        if (bl) {
            string2 = string2 + "</B>";
        }
        if (bl2) {
            string2 = string2 + "</I>";
        }
        if (bl3) {
            string2 = string2 + "</U>";
        }
        string2 = string2 + "</html>";
        return string2;
    }

    private JScrollPane getScrollPaneWithRowHeader(JTable jTable, JTable jTable2, boolean bl) {
        JScrollPane jScrollPane = new JScrollPane(jTable, 22, 32);
        JViewport jViewport = new JViewport();
        jViewport.setView(jTable2);
        int n = DataMgr.getDataMgr().isDataFreeClient() && bl ? 0 : 80;
        jViewport.setPreferredSize(new Dimension(n, jTable2.getPreferredSize().height));
        jScrollPane.setRowHeader(jViewport);
        jScrollPane.setCorner("UPPER_LEFT_CORNER", jTable2.getTableHeader());
        return jScrollPane;
    }

    private void pasteStringToDataTable(DataViewTable dataViewTable, boolean bl) {
        String[][] stringArray;
        String string;
        Object object = AppClipboard.getAppClipboard().getClipboardData(AppClipboard.STRING_FLAVOR);
        if (object instanceof String && this.validateString(string = (String)object) && (stringArray = DataView.parseString2Array(string, true)) != null && stringArray.length > 0) {
            ISpssDataSrc iSpssDataSrc;
            if (bl) {
                iSpssDataSrc = stringArray[0];
                String[][] stringArray2 = new String[stringArray.length - 1][stringArray[0].length];
                for (int i = 0; i < stringArray2.length; ++i) {
                    stringArray2[i] = stringArray[i + 1];
                }
                this.pasteDataStringCells(dataViewTable, stringArray2, (String[])iSpssDataSrc);
            } else {
                this.pasteDataStringCells(dataViewTable, stringArray);
            }
            ScriptingUtil.waitForBackend();
            iSpssDataSrc = this.mParentFrame.getDataSource();
            iSpssDataSrc.getCacheMgr().clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pasteDataStringCells(DataViewTable dataViewTable, String[][] stringArray, String[] stringArray2) {
        ISpssDataSrc iSpssDataSrc = ((DataViewTableModel)dataViewTable.getModel()).getDataSource();
        int[] nArray = dataViewTable.getSelectedRows();
        int[] nArray2 = dataViewTable.getSelectedColumns();
        int n = stringArray.length;
        int n2 = n > 0 ? stringArray[0].length : 0;
        boolean bl = !(n2 != 1 && n != 1 || nArray.length <= 1 && nArray2.length <= 1);
        int n3 = nArray2[0];
        int n4 = nArray[0];
        int n5 = nArray2[nArray2.length - 1];
        int n6 = nArray[nArray.length - 1];
        if (n3 == n5) {
            n5 = n3 + n2 - 1;
        }
        if (n4 == n6) {
            n6 = n4 + n - 1;
        }
        if (iSpssDataSrc.columnCount() < n5 && !dataViewTable.getDataView().canAddNewVariable()) {
            return;
        }
        SpssUndoManager spssUndoManager = ((DataViewTableModel)dataViewTable.getModel()).getUndoManager();
        CompoundEdit compoundEdit = new CompoundEdit();
        spssUndoManager.addEdit(compoundEdit);
        try {
            if ((long)n6 >= iSpssDataSrc.rowCount()) {
                int n7 = bl ? nArray.length : n;
                int n8 = n4 + n7;
                DataFrame dataFrame = (DataFrame)spssUndoManager.getSpssFrame();
                if (!dataFrame.checkDataLimit(true, (long)n8 - iSpssDataSrc.rowCount())) {
                    compoundEdit.end();
                    return;
                }
                new RowInsertEdit(dataFrame, iSpssDataSrc.rowCount(), (long)n8 - iSpssDataSrc.rowCount());
            }
            Object[][] objectArray = null;
            if (bl) {
                objectArray = new Object[n2][n];
            }
            int n9 = n2;
            if (n5 < n3 + n2) {
                n9 = n5 - n3 + 1;
            }
            n9 = Math.min(n9, n2);
            Vector<CellValue> vector = new Vector<CellValue>();
            OBS oBS = new OBS();
            for (int i = 0; i < n9; ++i) {
                if (n3 + i >= iSpssDataSrc.columnCount()) {
                    if (stringArray2 != null && stringArray2.length > 0) {
                        Vector<ISpssVariable> vector2 = new Vector<ISpssVariable>();
                        SpssVariable spssVariable = new SpssVariable();
                        short s = (short)this.determineTypeForStringValue(stringArray[0][i]);
                        spssVariable.setType(s);
                        spssVariable.setName(VarNameValidator.generateSPSSName((ISpssDataSrc)iSpssDataSrc, (String)stringArray2[i], (int)0));
                        spssVariable.setLabel(stringArray2[i]);
                        if (s == 0) {
                            Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
                            Preferences preferences2 = preferences.node("options");
                            Preferences preferences3 = preferences2.node("data");
                            String string = preferences3.get("display_format_width", "8");
                            String string2 = preferences3.get("display_format_decimal", "2");
                            short s2 = Short.valueOf(string);
                            byte by = Byte.valueOf(string2);
                            spssVariable.setFormat(new SPSS_Format(FormatType.F, s2, by));
                            spssVariable.setWriteFormat(new SPSS_Format(FormatType.F, s2, by));
                            spssVariable.setDisplayAlignment(DisplayAlignment.right);
                            spssVariable.setDisplayWidth(s2);
                        } else {
                            spssVariable.setFormat(new SPSS_Format(FormatType.A, s, 0));
                            spssVariable.setWriteFormat(new SPSS_Format(FormatType.A, s, 0));
                            spssVariable.setDisplayAlignment(DisplayAlignment.left);
                            spssVariable.setDisplayWidth(s);
                        }
                        spssVariable.setMeasurementLevel(s == 0 ? MeasurementLevel.unknown : MeasurementLevel.nominal);
                        vector2.add((ISpssVariable)spssVariable);
                        new VariableInsertEdit(this.getUndoManager(), iSpssDataSrc, n3 + i, vector2);
                    } else if (i == 0) {
                        new VariableInsertEdit(this.getUndoManager(), iSpssDataSrc, n3 + i, n3 - iSpssDataSrc.columnCount() + 1, this.determineTypeForStringValue(stringArray[0][i]));
                    } else {
                        new VariableInsertEdit(this.getUndoManager(), iSpssDataSrc, n3 + i, 1, this.determineTypeForStringValue(stringArray[0][i]));
                    }
                }
                ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(n3 + i);
                for (int j = 0; j < n; ++j) {
                    boolean bl2;
                    if (i >= stringArray[j].length) continue;
                    String string = stringArray[j][i];
                    if (bl) {
                        objectArray[i][j] = string;
                        continue;
                    }
                    if (n3 + i > n5 || n4 + j > n6 || !(bl2 = CellValueFormatter.stringToObs((String)string.toString(), (SPSS_Format)iSpssVariable.getFormat(), (OBS)oBS))) continue;
                    oBS = this.convertToSysmysIfNeeded(string, oBS, n3 + i);
                    vector.add(new CellValue((long)(n4 + j), iSpssVariable.getId(), iSpssVariable.getType() == 0 ? CacheColumnInfo.Type.Double : CacheColumnInfo.Type.String, oBS));
                }
            }
            if (bl) {
                this.replicateIntoSelections(dataViewTable, nArray, nArray2, objectArray);
            } else {
                new TableColumnValuesEdit(dataViewTable, vector);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            compoundEdit.end();
        }
    }

    private void pasteDataStringCells(DataViewTable dataViewTable, String[][] stringArray) {
        this.pasteDataStringCells(dataViewTable, stringArray, null);
    }

    private OBS convertToSysmysIfNeeded(Object object, OBS oBS, int n) {
        boolean bl = this.isDoubleCol(n);
        if (object == null || object.toString().trim().length() == 0 || bl && object.toString().equals(SYSMIS_STRING)) {
            oBS = bl ? new OBS(this.getDataSrc().getSystemMissing()) : new OBS("");
        }
        return oBS;
    }

    private boolean isDoubleCol(int n) {
        boolean bl = true;
        ISpssVariable iSpssVariable = this.getDataSrc().getVariable(n);
        if (iSpssVariable != null && iSpssVariable.getType() > 0) {
            bl = false;
        }
        return bl;
    }

    private int determineTypeForStringValue(String string) {
        boolean bl = false;
        try {
            if (string != null) {
                OBS oBS = new OBS();
                bl = !CellValueFormatter.stringToObs((String)string, (SPSS_Format)new SPSS_Format(FormatType.F, 15, 2), (OBS)oBS);
            }
        }
        catch (Exception exception) {
            bl = true;
        }
        if (string != null && bl) {
            return string.length() > 0 ? string.length() : 8;
        }
        return 0;
    }

    private void replicateIntoSelections(DataViewTable dataViewTable, int[] nArray, int[] nArray2, Object[][] objectArray) {
        int n = 0;
        int n2 = objectArray.length;
        int n3 = objectArray[0].length;
        boolean bl = n2 == 1 && n3 > 1;
        ISpssDataSrc iSpssDataSrc = ((DataViewTableModel)dataViewTable.getModel()).getDataSource();
        ColumnDataProvider columnDataProvider = new ColumnDataProvider(iSpssDataSrc);
        for (int n4 : nArray2) {
            OBS[] oBSArray = columnDataProvider.getColumnData(n4, (long)nArray[0], (long)nArray[nArray.length - 1]);
            int n5 = 0;
            for (int i = 0; i < nArray.length; ++i) {
                int n6 = nArray[i];
                if (!bl || n5 < n3) {
                    dataViewTable.setValueAt(objectArray[n % n2][n5 % n3], oBSArray[i], n6, n4);
                }
                ++n5;
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pasteStringToVarTable(JTable jTable) {
        String[][] stringArray;
        String string;
        int n = jTable.getSelectedRow();
        int n2 = jTable.getSelectedColumn();
        Object object = AppClipboard.getAppClipboard().getClipboardData(AppClipboard.STRING_FLAVOR);
        if (object instanceof String && this.validateString(string = (String)object) && (stringArray = DataView.parseString2Array(string, false)) != null && stringArray.length > 0) {
            Object object2;
            int n3 = stringArray.length;
            int n4 = stringArray[0].length;
            CompoundEdit compoundEdit = new CompoundEdit();
            this.getUndoManager().addEdit(compoundEdit);
            int n5 = 0;
            try {
                for (int i = 0; i < n3; ++i) {
                    if (stringArray[i] == null || stringArray[i].length <= n5) continue;
                    boolean bl = false;
                    object2 = this.mVarTableModel.columnIndexToColumnId(n2 + n5);
                    if (object2 != null) {
                        if (((String)object2).equals("name") || ((String)object2).equals("label")) {
                            if (((String)object2).equals("name")) {
                                boolean bl2;
                                String string2 = stringArray[i][n5];
                                Object object3 = this.mVarTableModel.getValueAt(n + i, n2 + n5);
                                boolean bl3 = bl2 = object3 != null && object3.toString().equalsIgnoreCase(string2);
                                if (!bl2 && !DialogUtil.checkNewVarName(this.mParentFrame, this.getDataSrc(), string2)) {
                                    break;
                                }
                                bl = true;
                            } else if (((String)object2).equals("label")) {
                                bl = true;
                            }
                        } else {
                            bl = true;
                        }
                    }
                    if (!bl) continue;
                    jTable.setValueAt(stringArray[i][n5], n + i, n2 + n5);
                }
            }
            catch (Exception exception) {
                TraceSettings.trace1((String)exception.getMessage(), (int)15);
                return;
            }
            finally {
                compoundEdit.end();
            }
            Rectangle rectangle = jTable.getCellRect(n, n2, true);
            Rectangle rectangle2 = jTable.getCellRect(n + n3, n2 + n4, true);
            object2 = rectangle.union(rectangle2);
            jTable.repaint((Rectangle)object2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearSelectedCellData(JTable jTable) {
        int n = this.mTabbedPane.getSelectedIndex();
        boolean bl = n == 0;
        int[] nArray = jTable.getSelectedRows();
        int[] nArray2 = jTable.getSelectedColumns();
        if (nArray != null && nArray.length > 0 && nArray2 != null && nArray2.length > 0) {
            CompoundEdit compoundEdit = null;
            try {
                if (jTable instanceof DataViewTable && this.contiguousRowSelections(nArray, nArray2)) {
                    new DeleteDataRowsEdit(this.getUndoManager(), this.mDataTables[0], this.mDataTableModel.getDataSource(), nArray);
                } else if (bl) {
                    new ClearCellsEdit(this.mDataTables[0], this.getUndoManager(), nArray2, nArray);
                } else {
                    compoundEdit = new CompoundEdit();
                    this.getUndoManager().addEdit(compoundEdit);
                    for (int n2 : nArray) {
                        for (int n3 : nArray2) {
                            jTable.setValueAt("", n2, n3);
                        }
                    }
                }
            }
            finally {
                if (compoundEdit != null) {
                    compoundEdit.end();
                }
            }
            this.mParentFrame.updateToolbarEnableStatus();
        }
    }

    private boolean contiguousRowSelections(int[] nArray, int[] nArray2) {
        ISpssDataSrc iSpssDataSrc = this.getDataSrc();
        if (iSpssDataSrc == null || nArray == null || nArray.length == 0 || nArray2 == null || nArray2.length == 0) {
            return false;
        }
        int n = iSpssDataSrc.columnCount();
        if (nArray2.length < n || nArray2[0] != 0) {
            return false;
        }
        int n2 = nArray[0];
        for (int n3 : nArray) {
            if (n3 != n2) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected void redrawSplitWnd() {
        this.mSplitPane.forceRedraw();
    }

    protected void updateToolbarEnableStatus() {
        if (this.mParentFrame != null) {
            this.mParentFrame.updateToolbarEnableStatus();
        }
    }

    protected void clearRowHeaderSelection(JTable jTable) {
        if (jTable instanceof DataViewTable) {
            this.mDataHeaderTables[0].clearSelection();
        } else if (jTable == this.mVarTable) {
            this.mVarHeaderTable.clearSelection();
        }
    }

    private int[] getValidRowHeaderSelns() {
        int[] nArray = this.mDataHeaderTables[0].getSelectedRows();
        Vector<Integer> vector = new Vector<Integer>();
        ISpssDataSrc iSpssDataSrc = this.getDataSrc();
        if (iSpssDataSrc == null) {
            return new int[0];
        }
        int n = DataViewTableModel.getDisplayableRowCount((int)iSpssDataSrc.rowCount());
        for (int n2 : nArray) {
            if (n2 >= n) continue;
            vector.add(n2);
        }
        nArray = new int[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            nArray[i] = (Integer)vector.get(i);
        }
        return nArray;
    }

    private void loadFontFromPrefs() {
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node("doc_types/dataeditor");
        String string = preferences2.get("font_family", PrefDefaults.DEF_DE_FONT_FAMILY);
        int n = preferences2.getInt("font_style", 0);
        int n2 = preferences2.getInt("font_size", PrefDefaults.DEF_DE_FONT_SIZE);
        Font font = FontUtil.makeFont((String)string, (int)n, (float)n2);
        this.setFontForTables(font);
    }

    private void setFontForTables(Font font) {
        this.setFontForTables(font, true);
    }

    private void setFontForTables(Font font, boolean bl) {
        int n;
        this.commitEdit();
        this.setFont(font);
        FontMetrics fontMetrics = this.mDataTables[0].getFontMetrics(font);
        int n2 = fontMetrics.getHeight() + 4;
        if (OSInfo.getOSType() == OSInfo.OSType.MAC && n2 < 23) {
            n2 = 23;
        }
        for (n = 0; n < 4; ++n) {
            this.mDataTables[n].setFont(font);
            this.mDataTables[n].setRowHeight(n2);
            if (n >= 2) continue;
            this.mDataTables[n].getTableHeader().setFont(font);
        }
        this.mVarTable.setFont(font);
        this.mVarTable.setRowHeight(n2);
        this.mVarTable.getTableHeader().setFont(font);
        if (bl) {
            this.mVarTable.setColumnWidths();
        }
        this.mVarHeaderTable.setFont(font);
        this.mVarHeaderTable.setRowHeight(n2);
        this.mVarHeaderTable.getTableHeader().setFont(font);
        for (n = 0; n < 2; ++n) {
            this.mDataHeaderTables[n].setFont(font);
            this.mDataHeaderTables[n].setRowHeight(n2);
            this.mDataTables[n].getTableHeader().setFont(font);
        }
        this.createColumnRenderers(true);
    }

    public boolean validateString(String string) {
        boolean bl = true;
        String string2 = null;
        try {
            boolean bl2 = this.mEncodingValidator.validateString(string);
            if (!bl2) {
                string2 = this.mEncodingValidator.getResult().equals(CoderResult.OVERFLOW) ? "ERR_CLIPBOARD_STRING_OVERFLOW_MSG" : "ERR_CLIPBOARD_STRING_UNMAPPABLE_MSG";
            }
        }
        catch (Exception exception) {
            string2 = "ERR_CLIPBOARD_STRING_OVERFLOW_MSG";
        }
        if (string2 != null) {
            JOptionPane.showMessageDialog(this.mParentFrame, ResUtil.getString(string2), VersionInfo.getAppVersionString(), 0);
            bl = false;
        }
        return bl;
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        if (DataMgr.getDataMgr().isDataFreeClient()) {
            Dimension dimension = this.getSize();
            for (int i = 0; i < 4; ++i) {
                TableColumn tableColumn = this.mDataTables[i].getColumnModel().getColumn(0);
                tableColumn.setResizable(false);
                tableColumn.setPreferredWidth(dimension.width - 20);
                this.mDataTables[i].setRowHeight((int)((double)dimension.height * 0.9));
            }
        }
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.updateEditBar();
    }

    public void updateEditBar() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (DataView.this.mDataTables != null && DataView.this.mDataTables[0] != null) {
                    int n = DataView.this.mDataTables[0].getSelectedRow();
                    int n2 = DataView.this.mDataTables[0].getSelectedColumn();
                    DataView.this.mEditBar.currentCellChanged(n, n2);
                }
            }
        });
    }

    public int getCaseIDColIndex() {
        ISpssDataSrc iSpssDataSrc = this.getDataSrc();
        return iSpssDataSrc.findVarIndex(CASE_ID_VAR_NAME);
    }

    public Document createPropertiesXML() {
        return this.mDataTables[0].createPropertiesXML(null);
    }

    public void launchColorDlg() {
        int n = this.mTabbedPane.getSelectedIndex();
        SpssTable spssTable = n == 0 ? this.getDataViewTable() : this.getVarViewTable();
        int n2 = spssTable.getSelectedRow();
        int n3 = spssTable.getSelectedColumn();
        Color color = null;
        Color color2 = null;
        if (n2 != -1 && n3 != -1 && n == 0) {
            int n4 = this.getDataViewTable().getRowCaseID(n2, false);
            FormatInfo formatInfo = this.getDataViewTable().getFormatInfo(n4, n3);
            color = formatInfo != null && formatInfo.getBkColor() != null ? formatInfo.getBkColor() : this.getDataViewTable().getBackground();
            color2 = formatInfo != null && formatInfo.getForegroundColor() != null ? formatInfo.getForegroundColor() : this.getDataViewTable().getForeground();
        }
        SelectTextColorDlg selectTextColorDlg = new SelectTextColorDlg(this.mParentFrame, color, color2);
        selectTextColorDlg.setVisible(true);
        color = selectTextColorDlg.getSelectedBKColor();
        color2 = selectTextColorDlg.getSelectedTextColor();
        if (selectTextColorDlg.isOKSelected()) {
            this.doColorCells(color);
            this.doColorText(color2);
        }
    }

    public void doColorCells(Color color) {
        int n = this.mTabbedPane.getSelectedIndex();
        SpssTable spssTable = n == 0 ? this.getDataViewTable() : this.getVarViewTable();
        new ColorCellsEdit(this.getUndoManager(), spssTable, this.getDataViewTable(), this.mDataTableModel.getDataSource(), color, true);
    }

    public void doColorText(Color color) {
        int n = this.mTabbedPane.getSelectedIndex();
        SpssTable spssTable = n == 0 ? this.getDataViewTable() : this.getVarViewTable();
        new ColorCellsEdit(this.getUndoManager(), spssTable, this.getDataViewTable(), this.mDataTableModel.getDataSource(), color, false);
    }

    public boolean hasCase(int n) {
        ISpssDataSrc iSpssDataSrc = this.getDataSrc();
        return (long)n < iSpssDataSrc.rowCount();
    }

    public int getNumHiddenColumns() {
        return mLockedHiddenVariables.size();
    }

    public static boolean isLockedHiddenVariable(String string) {
        boolean bl = false;
        for (String string2 : mLockedHiddenVariables) {
            if (string == null || !string.equalsIgnoreCase(string2)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static enum CopyType {
        COPY_WITH_NONE,
        COPY_WITH_VARIABLE,
        COPY_WITH_LABEL;

    }

    static enum SelectMode {
        ROW_SELECT,
        COL_SELECT,
        CELL_SELECT;

    }

    class DataCellEditor
    extends DefaultCellEditor {
        JTable mTable;

        public DataCellEditor(JTextField jTextField, JTable jTable) {
            super(jTextField);
            this.mTable = jTable;
            this.delegate = new MyEditorDelegate(jTextField);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            Component component = super.getTableCellEditorComponent(jTable, object, bl, n, n2);
            ((MyEditorDelegate)this.delegate).mTextField.setFont(DataView.this.mDataTables[0].getFont());
            return component;
        }

        protected class MyEditorDelegate
        extends DefaultCellEditor.EditorDelegate {
            private JTextField mTextField;
            private String mOrgValue;

            MyEditorDelegate(JTextField jTextField) {
                super(DataCellEditor.this);
                this.mTextField = jTextField;
            }

            @Override
            public void setValue(Object object) {
                this.value = object;
                if (this.mTextField instanceof DataCellEdit) {
                    DataCellEdit dataCellEdit = (DataCellEdit)this.mTextField;
                    try {
                        boolean bl;
                        int n = DataCellEditor.this.mTable.getSelectedRow();
                        int n2 = DataCellEditor.this.mTable.getSelectedColumn();
                        boolean bl2 = bl = object == null || DataView.this.mDataTableModel.getDataSource().columnCount() <= n2 || DataViewTableModel.getDisplayableRowCount(n) < n;
                        if (!bl && DataView.this.mDataTableModel.isDoubleCol(n2) && object.equals(DataViewTableModel.getSysmisString())) {
                            bl = true;
                            object = null;
                        } else if (object instanceof Double && DataView.this.mDataTableModel.isDateCol(n2)) {
                            SPSS_Format sPSS_Format;
                            double d = (Double)object;
                            ISpssDataSrc iSpssDataSrc = DataView.this.mDataTableModel.getDataSource();
                            if (!DataViewTableModel.legalDateValue(iSpssDataSrc, d, sPSS_Format = iSpssDataSrc.getVariable(n2).getFormat())) {
                                bl = true;
                                object = null;
                            } else {
                                FormatType formatType = sPSS_Format.getFormatType();
                                object = d < 8.0 && formatType == FormatType.WKDAY ? CellValueFormatter.valueToWeekday((Integer)((int)d)) : (d < 13.0 && formatType == FormatType.MONTH ? CellValueFormatter.valueToMonth((Integer)((int)d)) : new Date(ValueFormatter.convertDateDoubleToLong((double)d)));
                            }
                        }
                        if (!bl) {
                            dataCellEdit.setValue(object);
                        } else {
                            dataCellEdit.setText(object != null ? object.toString() : "");
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    Caret caret = dataCellEdit.getCaret();
                    caret.setVisible(true);
                    dataCellEdit.repaint();
                } else {
                    this.mTextField.setText(object != null ? object.toString() : "");
                }
                this.mOrgValue = this.mTextField.getText();
            }

            @Override
            public boolean stopCellEditing() {
                boolean bl = true;
                if (DataCellEditor.this.editorComponent instanceof DataCellEdit) {
                    int n = DataCellEditor.this.mTable.getSelectedRow();
                    int n2 = DataCellEditor.this.mTable.getSelectedColumn();
                    DataCellEdit dataCellEdit = (DataCellEdit)DataCellEditor.this.editorComponent;
                    String string = dataCellEdit.getText();
                    if (DataView.this.mDataTableModel.isDoubleCol(n2)) {
                        String string2 = string = string != null ? string.trim() : null;
                    }
                    if (!this.mOrgValue.equals(string)) {
                        Object object;
                        block13: {
                            object = null;
                            if (string != null && string.length() > 0) {
                                try {
                                    if (!ComponentState.isBtdRtlOrLtr()) {
                                        object = dataCellEdit.getFormatter().stringToValue(string);
                                        break block13;
                                    }
                                    if (dataCellEdit.getFormatterFactory() instanceof DataCellEdit.CellFormatterFactory) {
                                        object = dataCellEdit.getFormatter().stringToValue(string);
                                        break block13;
                                    }
                                    object = string;
                                }
                                catch (ParseException parseException) {}
                            } else {
                                object = dataCellEdit.getMaxStringWidth() > -1 ? "" : Double.valueOf(DataView.this.getDataSrc().getSystemMissing());
                            }
                        }
                        if (object == null) {
                            Toolkit.getDefaultToolkit().beep();
                            this.cancelCellEditing();
                            return true;
                        }
                        DataCellEditor.this.delegate.setValue(object);
                    }
                    bl = super.stopCellEditing();
                    if (!this.mOrgValue.equals(string)) {
                        if (n < 0 || n2 < 0) {
                            DataView.this.mEditBar.currentCellChanged(-1L, -1);
                        } else {
                            DataView.this.mEditBar.currentCellChanged(n, DataCellEditor.this.mTable.convertColumnIndexToModel(n2));
                        }
                    }
                }
                return bl;
            }
        }
    }
}

