/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.data;

import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.cache.ICacheObserver;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.server.messages.DataEditorMsg.RowRange;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.doc_types.data.DataViewTableModel;
import java.lang.ref.WeakReference;
import javax.swing.table.AbstractTableModel;

public class DataTableRowHeaderModel
extends AbstractTableModel
implements ICacheObserver {
    private static final int DEF_ROWS = 40;
    private ISpssDataSrc mDataSource = null;
    private boolean mDataViewHeader;
    private int mLargestUnknownRow = 0;
    private WeakReference<DataFrame> mDataFrameRef = null;

    public DataTableRowHeaderModel(DataFrame dataFrame, boolean bl) {
        this.mDataFrameRef = new WeakReference<DataFrame>(dataFrame);
        this.mDataViewHeader = bl;
    }

    @Override
    public int getRowCount() {
        if (this.mDataViewHeader && DataMgr.getDataMgr().isDataFreeClient()) {
            return 1;
        }
        if (this.mDataSource == null) {
            return 40;
        }
        int n = (int)(this.mDataViewHeader ? this.mDataSource.rowCount() : (long)this.mDataSource.columnCount());
        if (n < 0) {
            n = this.mLargestUnknownRow;
        }
        return DataViewTableModel.getDisplayableRowCount(n + 40);
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (this.mDataSource != null && this.mDataSource.rowCount() < 0L) {
            int n3 = this.mLargestUnknownRow;
            this.mLargestUnknownRow = Math.max(n, this.mLargestUnknownRow);
            if (n3 < this.mLargestUnknownRow) {
                this.fireTableRowsInserted(n3 + 40, this.mLargestUnknownRow + 40);
            }
        }
        return Integer.toString(n + 1) + " ";
    }

    public void connectData(LocallyUniqueId locallyUniqueId) {
        this.mDataSource = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        if (this.mDataSource != null) {
            if (this.mDataViewHeader) {
                this.mDataSource.getCacheMgr().addObserver((ICacheObserver)this);
            }
        } else assert (false);
    }

    public void disconnect() {
        if (this.mDataSource != null) {
            if (!CommandLine.isExternalCaller()) {
                this.mDataSource.getCacheMgr().removeObserver((ICacheObserver)this);
            }
            this.mDataSource = null;
        }
    }

    public void rowsCached(RowRange rowRange) {
        if (((DataFrame)this.mDataFrameRef.get()).isPrinting()) {
            return;
        }
        if (this.mDataViewHeader) {
            this.fireTableRowsUpdated((int)rowRange.getStartOfRange(), (int)rowRange.getEndOfRange());
        }
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public String getColumnName(int n) {
        return " ";
    }
}

