/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.data;

import com.spss.java_client.core.common.FileDrop;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.documents.AppMgr;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.ui.doc_types.data.DataViewTable;
import com.spss.java_client.ui.doc_types.data.SpssTable;
import com.spss.java_client.ui.doc_types.data.TableColMoveDropTargetHandler;
import com.spss.java_client.ui.doc_types.data.TableColMoveTransfer;
import com.spss.java_client.ui.doc_types.data.undo.TableColumnMoveEdit;
import com.spss.java_client.ui.undo.SpssUndoManager;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDropEvent;
import java.util.Vector;
import javax.swing.table.JTableHeader;

public class DataTableColMoveDropTargetHandler
extends TableColMoveDropTargetHandler {
    public DataTableColMoveDropTargetHandler(SpssUndoManager spssUndoManager, DataViewTable dataViewTable) {
        super(spssUndoManager, dataViewTable);
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        boolean bl = false;
        Transferable transferable = dropTargetDropEvent.getTransferable();
        if (transferable.isDataFlavorSupported(TableColMoveTransfer.FLAVOUR)) {
            this.renderHighlight(-1);
            Component component = dropTargetDropEvent.getDropTargetContext().getComponent();
            if (component instanceof JTableHeader || component == this.mTable) {
                try {
                    Point point = dropTargetDropEvent.getLocation();
                    SpssTable spssTable = this.mTable;
                    int n = spssTable.columnAtPoint(point);
                    LocallyUniqueId locallyUniqueId = DataMgr.getDataMgr().getActiveDocumentId();
                    int n2 = DataMgr.getDataMgr().getDataSource(locallyUniqueId).columnCount();
                    n = n > n2 ? n2 : n;
                    dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
                    Object object = dropTargetDropEvent.getTransferable().getTransferData(TableColMoveTransfer.FLAVOUR);
                    if (object instanceof TableColMoveTransfer) {
                        TableColMoveTransfer tableColMoveTransfer = (TableColMoveTransfer)object;
                        int[] nArray = tableColMoveTransfer.getSelectedColumns();
                        Vector<Integer> vector = new Vector<Integer>();
                        for (int n3 : nArray) {
                            if (n3 <= -1 || n3 >= n2) continue;
                            vector.add(n3);
                        }
                        if (vector.size() != nArray.length) {
                            nArray = new int[vector.size()];
                            for (int i = 0; i < vector.size(); ++i) {
                                nArray[i] = (Integer)vector.get(i);
                            }
                        }
                        if (nArray.length > 0) {
                            new TableColumnMoveEdit(locallyUniqueId, this.mUndoManager, this.mTable, nArray, n);
                        }
                        bl = true;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        } else if (dropTargetDropEvent.isDataFlavorSupported(DataFlavor.javaFileListFlavor) || FileDrop.isLinuxDropFilesEvent((DropTargetDropEvent)dropTargetDropEvent)) {
            try {
                AppMgr.processDroppedFiles((DropTargetDropEvent)dropTargetDropEvent);
                bl = true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            dropTargetDropEvent.rejectDrop();
        }
        dropTargetDropEvent.dropComplete(bl);
    }
}

