/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.data;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.documents.data.dictionary.DisplayAlignment;
import com.spss.java_client.core.documents.data.dictionary.FormatType;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.core.documents.data.dictionary.value_labels.IValueLabelMap;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.doc_types.data.DataViewTableModel;
import com.spss.shared.core_tools.format.CellValueFormatter;
import com.spss.shared.core_tools.format.ExtendedSimpleDateFormat;
import com.spss.shared.core_tools.format.GeneralNumberFormat;
import com.spss.shared.core_tools.format.NumberReformatter;
import com.spss.shared.core_tools.format.ValueFormatter;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.font.FontRenderContext;
import java.io.Serializable;
import java.text.Format;
import java.text.ParseException;
import java.util.Date;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;

public class DataTableCellRenderer
extends DefaultTableCellRenderer {
    protected DataFrame mFrame = null;
    protected ISpssVariable mVariable = null;
    protected SPSS_Format mCellFormat = null;
    protected Format mFormatObject = null;
    protected CellValueFormatter mFormatter = new CellValueFormatter(PrefsMgr.getLeadZeroPreferenceValue());
    protected boolean mIsNumeric = false;
    protected boolean mIsDateTime = false;
    protected boolean mIsString = false;
    protected int mCurrentColumnWidth;
    protected NumberReformatter mReformatter;
    protected FontRenderContext mFrc;

    public DataTableCellRenderer() {
        this(null, null);
    }

    public DataTableCellRenderer(DataFrame dataFrame, ISpssVariable iSpssVariable) {
        this.mFrame = dataFrame;
        this.mVariable = iSpssVariable;
        this.setCellFormat(iSpssVariable);
    }

    public ISpssVariable getSpssVariable() {
        return this.mVariable;
    }

    public void setCellFormat(ISpssVariable iSpssVariable) {
        DisplayAlignment displayAlignment;
        if (iSpssVariable == null) {
            return;
        }
        SPSS_Format sPSS_Format = iSpssVariable.getFormat();
        if (this.mCellFormat == null || !this.mCellFormat.equals((Object)sPSS_Format)) {
            this.mCellFormat = sPSS_Format;
            this.buildFormatter();
        }
        if ((displayAlignment = iSpssVariable.getDisplayAlignment()).equals((Object)DisplayAlignment.left)) {
            this.setHorizontalAlignment(2);
        } else if (displayAlignment.equals((Object)DisplayAlignment.center)) {
            this.setHorizontalAlignment(0);
        } else {
            this.setHorizontalAlignment(4);
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        ISpssDataSrc iSpssDataSrc;
        Component component = null;
        this.mCurrentColumnWidth = jTable.getColumnModel().getColumn(n2).getWidth();
        if (this.mFrame != null && this.mFrame.getDataView() != null && this.mFrame.getDataView().getDataSrc() != null && (iSpssDataSrc = this.mFrame.getDataView().getDataSrc()) != null) {
            OBS oBS;
            ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(n2);
            if (iSpssVariable != null) {
                this.mVariable = iSpssVariable;
                this.setCellAlignment();
            }
            this.setBackground(jTable.getBackground());
            this.setForeground(jTable.getForeground());
            component = ComponentState.isBtdRtlOrLtr() && this.isValDTString(object) ? super.getTableCellRendererComponent(jTable, ComponentState.prepareStringForBidiRendering((String)((String)object)), bl, bl2, n, n2) : super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (iSpssDataSrc.isMultipleImputation() && (oBS = iSpssDataSrc.getCacheMgr().getCellValue((long)n, n2)) != null && oBS.isImputed() && !bl) {
                component = ComponentState.isBtdRtlOrLtr() && this.isValDTString(object) ? super.getTableCellRendererComponent(jTable, ComponentState.prepareStringForBidiRendering((String)((String)object)), false, bl2, n, n2) : super.getTableCellRendererComponent(jTable, object, false, bl2, n, n2);
                this.setFont(new Font(iSpssDataSrc.getImputationInfo().getFontName(), iSpssDataSrc.getImputationInfo().getFontStyle(), this.getFont().getSize()));
                this.setBackground(iSpssDataSrc.getImputationInfo().getBackground());
            }
        }
        if (component == null) {
            component = ComponentState.isBtdRtlOrLtr() && this.isValDTString(object) ? super.getTableCellRendererComponent(jTable, ComponentState.prepareStringForBidiRendering((String)((String)object)), bl, bl2, n, n2) : super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
        return component;
    }

    private boolean isValDTString(Object object) {
        return this.mIsString && object != null && object instanceof String && ((String)object).length() > 0;
    }

    private void setCellAlignment() {
        DisplayAlignment displayAlignment = this.mVariable.getDisplayAlignment();
        if (displayAlignment.equals((Object)DisplayAlignment.left)) {
            this.setHorizontalAlignment(2);
        } else if (displayAlignment.equals((Object)DisplayAlignment.center)) {
            this.setHorizontalAlignment(0);
        } else {
            this.setHorizontalAlignment(4);
        }
    }

    @Override
    protected void setValue(Object object) {
        boolean bl;
        boolean bl2 = object instanceof Double;
        boolean bl3 = bl = this.mFrame != null && this.mFrame.getViewValueLabels();
        if (bl2 && this.mIsNumeric) {
            SPSS_Format sPSS_Format;
            Double d = (Double)object;
            if (bl) {
                object = this.formatForValueLabel(new OBS(d.doubleValue()));
            } else if (this.mVariable != null && (sPSS_Format = this.mVariable.getFormat()) != null) {
                Serializable serializable;
                if (this.mCellFormat == null || this.mFormatObject == null || !this.mCellFormat.equals((Object)sPSS_Format)) {
                    this.mCellFormat = sPSS_Format;
                    this.mFormatObject = this.mFormatter.buildFormatter(this.mCellFormat);
                } else if (this.mCellFormat.getFormatType().isCurrencyFormat() && !this.mFormatObject.equals(serializable = this.mFormatter.buildFormatter(this.mCellFormat))) {
                    this.mCellFormat = sPSS_Format;
                    this.mFormatObject = serializable;
                }
                if (this.mFormatObject instanceof GeneralNumberFormat) {
                    ((GeneralNumberFormat)this.mFormatObject).setLeadZero(CellValueFormatter.getLeadZero());
                }
                object = this.mFormatObject.format(d);
                serializable = this.getFontMetrics(this.getFont());
                if (this.mCurrentColumnWidth < 10 + SwingUtilities.computeStringWidth((FontMetrics)serializable, object.toString())) {
                    if (this.isHexFormat(this.mCellFormat.getFormatType())) {
                        object = this.trimHex((FontMetrics)serializable, (String)object);
                    } else {
                        if (this.mReformatter == null) {
                            this.mReformatter = new NumberReformatter();
                            this.mFrc = new FontRenderContext(null, true, false);
                        }
                        object = this.mReformatter.reformat(this.mCellFormat, ComponentState.getSPSSLocale(), d.doubleValue(), this.mCurrentColumnWidth - 4, this.getFont(), this.mFrc);
                    }
                }
            }
        } else if (this.mIsString) {
            if (object instanceof String) {
                object = this.isHexFormat(this.mCellFormat.getFormatType()) ? this.mFormatObject.format(object) : CharacterUtil.rightTrim((String)((String)object));
                if (bl) {
                    object = this.formatForValueLabel(new OBS((String)object));
                }
            } else {
                ComponentState.trace1((String)"Can't set non-string value into String column!", (int)15);
                object = "";
            }
        } else if (bl2 && this.mIsDateTime) {
            Double d = (Double)object;
            if (bl) {
                object = this.formatForValueLabel(new OBS(d.doubleValue()));
            } else if (d.intValue() >= 0 && d.intValue() < 13 && this.mCellFormat.getFormatType() == FormatType.MONTH || d.intValue() >= 0 && d.intValue() <= 7 && this.mCellFormat.getFormatType() == FormatType.WKDAY) {
                try {
                    Date date = ((ExtendedSimpleDateFormat)this.mFormatObject).parse("" + d.intValue());
                    object = this.mFormatObject.format(date);
                }
                catch (ParseException parseException) {
                    object = "";
                }
            } else {
                ISpssDataSrc iSpssDataSrc = this.mFrame.getDataView().getDataSrc();
                if (!DataViewTableModel.legalDateValue(iSpssDataSrc, d, this.mCellFormat)) {
                    object = DataViewTableModel.getSysmisString();
                } else {
                    Date date = new Date(ValueFormatter.convertDateDoubleToLong((double)d));
                    object = this.mFormatObject.format(date);
                }
            }
        }
        super.setValue(object);
    }

    private Object trimHex(FontMetrics fontMetrics, String string) {
        String string2 = string;
        while (string2.length() >= 1 && string2.charAt(0) == '0' && this.mCurrentColumnWidth < SwingUtilities.computeStringWidth(fontMetrics, string2 = string2.substring(1)) + 10) {
        }
        return string2;
    }

    private boolean isHexFormat(FormatType formatType) {
        return formatType == FormatType.AHEX || formatType == FormatType.PIBHEX || formatType == FormatType.RBHEX;
    }

    private String formatForValueLabel(OBS oBS) {
        String string = "";
        if (this.mVariable != null) {
            IValueLabelMap iValueLabelMap = this.mVariable.getValueLabels();
            string = iValueLabelMap.get(oBS);
        }
        if (string == null || string.length() == 0) {
            string = this.formatValueNoVL(oBS.isString() ? oBS.getString() : Double.valueOf(oBS.getNum()));
        }
        return string;
    }

    private String formatValueNoVL(Object object) {
        String string = CharacterUtil.rightTrim((String)object.toString());
        boolean bl = object instanceof Double;
        if (bl && this.mIsNumeric) {
            Double d = (Double)object;
            string = this.mFormatObject.format(d);
        } else if (this.mIsString) {
            if (object instanceof String) {
                if (this.mCellFormat.getFormatType().equals((Object)FormatType.AHEX)) {
                    string = object.toString();
                }
            } else assert (false);
        } else if (bl && this.mIsDateTime) {
            Double d = (Double)object;
            if (d.intValue() >= 0 && d.intValue() < 13 && (this.mCellFormat.getFormatType() == FormatType.WKDAY || this.mCellFormat.getFormatType() == FormatType.MONTH)) {
                try {
                    Date date = ((ExtendedSimpleDateFormat)this.mFormatObject).parse("" + d.intValue());
                    string = this.mFormatObject.format(date);
                }
                catch (ParseException parseException) {
                    string = "";
                }
            } else {
                ISpssDataSrc iSpssDataSrc = this.mFrame.getDataView().getDataSrc();
                if (!DataViewTableModel.legalDateValue(iSpssDataSrc, d, this.mCellFormat)) {
                    string = DataViewTableModel.getSysmisString();
                } else {
                    Date date = new Date(ValueFormatter.convertDateDoubleToLong((double)d));
                    string = this.mFormatObject.format(date);
                }
            }
        }
        return string;
    }

    private void buildFormatter() {
        this.mIsString = false;
        this.mIsDateTime = false;
        this.mIsNumeric = false;
        if (this.mCellFormat.getFormatType().isNumericFormat()) {
            this.mIsNumeric = true;
        } else if (this.mCellFormat.getFormatType().isStringFormat()) {
            this.mIsString = true;
        } else if (this.mCellFormat.getFormatType().isDateOrTimeFormat()) {
            this.mIsDateTime = true;
        }
        this.mFormatObject = this.mFormatter.buildFormatter(this.mCellFormat);
    }

    void dispose() {
        this.mFrame = null;
        this.mVariable = null;
        this.mCellFormat = null;
        this.mFormatObject = null;
        this.mFormatter = null;
    }
}

