/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.data;

import com.spss.java_client.ui.doc_types.StatusBar;
import com.spss.java_client.ui.doc_types.doc_util.ThinBeveledBorder;
import com.spss.java_client.ui.resources.ResUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.MouseListener;
import javax.swing.JLabel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class DataFrameStatusBar
extends StatusBar
implements MouseListener {
    private JLabel mFilterPane = new JLabel(" ");
    private JLabel mWeightPane = new JLabel(" ");
    private JLabel mSplitFilePane = new JLabel(" ");
    private JLabel mEncodingPane = null;

    public DataFrameStatusBar() {
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        ThinBeveledBorder thinBeveledBorder = new ThinBeveledBorder(uIDefaults.getColor("ToolBar.highlight"), uIDefaults.getColor("ToolBar.shadow"), 1);
        this.mFilterPane.setBorder(thinBeveledBorder);
        this.mWeightPane.setBorder(thinBeveledBorder);
        this.mSplitFilePane.setBorder(thinBeveledBorder);
        this.setBorder(new ThinBeveledBorder(uIDefaults.getColor("ToolBar.highlight"), uIDefaults.getColor("ToolBar.shadow"), 0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = this.mNextXpos;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.01;
        gridBagConstraints.weighty = 0.99;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(1, 0, 1, 0);
        this.mFilterPane.setToolTipText(ResUtil.getString("IDS_DEFAULT_FILTER_PANE_MESSAGE"));
        this.mFilterPane.addMouseListener(this);
        this.add((Component)this.mFilterPane, gridBagConstraints);
        gridBagConstraints.gridx = this.mNextXpos + 1;
        this.mWeightPane.setToolTipText(ResUtil.getString("IDS_DEFAULT_WEIGHT_PANE_MESSAGE"));
        this.mWeightPane.addMouseListener(this);
        this.add((Component)this.mWeightPane, gridBagConstraints);
        gridBagConstraints.gridx = this.mNextXpos + 2;
        this.mSplitFilePane.setToolTipText(ResUtil.getString("IDS_DEFAULT_SPLIT_FILE_PANE_MESSAGE"));
        this.mSplitFilePane.addMouseListener(this);
        this.add((Component)this.mSplitFilePane, gridBagConstraints);
        this.setStatusBarFont();
    }

    @Override
    public JLabel getPane(StatusBar.StatusPane statusPane) {
        JLabel jLabel = super.getPane(statusPane);
        if (jLabel == null) {
            if (statusPane == StatusBar.StatusPane.filterPane) {
                jLabel = this.mFilterPane;
            } else if (statusPane == StatusBar.StatusPane.weightPane) {
                jLabel = this.mWeightPane;
            } else if (statusPane == StatusBar.StatusPane.splitFilePane) {
                jLabel = this.mSplitFilePane;
            }
        }
        assert (jLabel != null);
        return jLabel;
    }
}

