/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.data;

import com.ibm.json.java.JSONObject;
import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.SpssWindowStates;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.documents.AppMgr;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.ICoreDocument;
import com.spss.java_client.core.documents.ICoreDocumentUIAgent;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.GlobalParameterErrorChecking;
import com.spss.java_client.core.documents.data.IDataDocListener;
import com.spss.java_client.core.documents.data.IDataDocument;
import com.spss.java_client.core.documents.data.IDataDocumentUIAgent;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.syntax.SyntaxMgr;
import com.spss.java_client.core.error_handler.ErrorDispatcher;
import com.spss.java_client.core.error_handler.ErrorEventMsg;
import com.spss.java_client.core.resources.CoreResUtil;
import com.spss.java_client.core.script.engine.ScriptEngine;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.SpssMgr;
import com.spss.java_client.ui.controlbar.BaseToolbar;
import com.spss.java_client.ui.dialogs.base.edit.find.DataFindDlg;
import com.spss.java_client.ui.dialogs.base.edit.find.ISearchProxy;
import com.spss.java_client.ui.dialogs.base.utilities.spell_check.DataViewSpellCheckDlg;
import com.spss.java_client.ui.dialogs.base.utilities.spell_check.SpellCheck;
import com.spss.java_client.ui.dialogs.base.utilities.spell_check.VarViewSpellCheckDlg;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.documents.data.GoToDataDlg;
import com.spss.java_client.ui.dialogs.documents.data.LastDocExitWarning;
import com.spss.java_client.ui.doc_types.ITopWindow;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.StatusBar;
import com.spss.java_client.ui.doc_types.actions.NewDataAction;
import com.spss.java_client.ui.doc_types.actions.OpenDataAction;
import com.spss.java_client.ui.doc_types.data.DataFrameStatusBar;
import com.spss.java_client.ui.doc_types.data.DataView;
import com.spss.java_client.ui.doc_types.data.DatasetViewObserver;
import com.spss.java_client.ui.doc_types.data.VarViewTable;
import com.spss.java_client.ui.doc_types.doc_util.DocUtil;
import com.spss.java_client.ui.doc_types.doc_util.MenuCache;
import com.spss.java_client.ui.doc_types.doc_util.MenuItemCache;
import com.spss.java_client.ui.doc_types.doc_util.MenuMgr;
import com.spss.java_client.ui.doc_types.output.IViewerWindow;
import com.spss.java_client.ui.doc_types.output.ViewerDocument;
import com.spss.java_client.ui.doc_types.output.ViewerTreePane;
import com.spss.java_client.ui.print.DataEditViewPrintable;
import com.spss.java_client.ui.print.SpssPrintable;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.util.TraceSettings;
import com.spss.uitools.util.WindowUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.File;
import java.util.Vector;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class DataFrame
extends SpssFrame
implements ITopWindow,
IDataDocListener,
IDataDocumentUIAgent {
    private static DataFindDlg sSearchDialog = null;
    private static BaseDialog sSpellCheckDialog = null;
    private static MenuCache sMenuTreeCache = new MenuCache(null);
    private static Vector<String> sDeletedAddOnItems = new Vector();
    protected IDataDocument mDocument = null;
    protected DataView mView = null;
    protected boolean mViewValueLabels = false;
    private GoToDataDlg mGoToDataDlg = null;
    private boolean mInDataWarning = false;
    private boolean mHasWeightVar = false;
    public static final int MAX_SPLIT_VAR_NAMES_LENGTH = 30;

    public static DataFrame createDataFrame(boolean bl) {
        DataFrame dataFrame = null;
        try {
            dataFrame = new DataFrame();
            SpssFrameMgr.getSpssFrameMgr().positionNewFrame(dataFrame);
            if (bl) {
                dataFrame.setVisible(true);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return dataFrame;
    }

    @Override
    public ICoreDocument getCoreDocument() {
        return this.mDocument;
    }

    public void attach(LocallyUniqueId locallyUniqueId, String string, DatasetViewObserver datasetViewObserver) {
        this.mDocument = DataMgr.getDataMgr().findDataDocument(locallyUniqueId);
        if (this.mDocument == null) {
            return;
        }
        this.mDocument.addDocListener((IDataDocListener)this);
        this.mDocument.setUIAgent((ICoreDocumentUIAgent)this);
        this.mView.connectData(locallyUniqueId, datasetViewObserver);
        this.updateTitleBar();
        this.updateToolbarEnableStatus();
    }

    @Override
    public DocType docType() {
        return DocType.DE_DOC;
    }

    public final LocallyUniqueId getDatasetId() {
        return this.mDocument != null ? this.mDocument.getDatasetId() : null;
    }

    public String getDatasetName() {
        return this.mDocument != null ? this.mDocument.getDatasetName() : null;
    }

    public boolean getViewValueLabels() {
        return this.mViewValueLabels;
    }

    public void setViewValueLabels(boolean bl) {
        if (this.mViewValueLabels == bl) {
            return;
        }
        this.mViewValueLabels = bl;
        this.setToolbarToggleButtonState("view_value_labels", bl);
        this.mView.createColumnRenderers(false);
        if (sSearchDialog != null && sSearchDialog.isVisible()) {
            sSearchDialog.updateDialogControls();
        }
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node("doc_types/dataeditor");
        preferences2.putBoolean("vl_view", bl);
    }

    public void setToolbarToggleButtonState(String string, boolean bl) {
        Component[] componentArray = this.mTBPanelNorth.getComponents();
        for (Component component : componentArray) {
            if (!(component instanceof BaseToolbar)) continue;
            ((BaseToolbar)component).checkButton(string, bl);
        }
        for (BaseToolbar baseToolbar : this.mFloatingToolbars) {
            baseToolbar.checkButton(string, bl);
        }
    }

    public void setShowImputation(boolean bl) {
        this.setToolbarToggleButtonState("view_imputation", bl);
        this.updateToolbarEnableStatus();
    }

    @Override
    public void performClose() {
        boolean bl = SpssFrameMgr.getSpssFrameMgr().isDesignated(this);
        int n = SpssFrameMgr.getSpssFrameMgr().openDocumentCount(DocType.DE_DOC);
        this.saveFrameSize();
        this.setIconImage(null);
        this.getRootPane().putClientProperty("Window.documentFile", null);
        if (this.mDocument != null) {
            SyntaxMgr syntaxMgr;
            this.mView.commitEdit();
            boolean bl2 = this.mDocument.getModifiedFlag();
            if (!this.saveModified()) {
                return;
            }
            this.mDocument.setModifiedFlag(false);
            if (bl || n == 1) {
                if (n > 1) {
                    syntaxMgr = SpssFrameMgr.getSpssFrameMgr().getOpenDocuments();
                    for (Object object : syntaxMgr) {
                        String string;
                        if (object == this || !(object instanceof DataFrame) || (string = ((DataFrame)object).getDatasetName()) == null || string.length() == 0) continue;
                        SpssFrameMgr.getSpssFrameMgr().designateWindow((SpssFrame)object);
                        String string2 = "DATASET ACTIVATE " + string + ".\n";
                        SyntaxMgr.getSyntaxMgr().executeSyntax(string2, false);
                        break;
                    }
                } else if (!AppMgr.getAppMgr().closeSessionData(false)) {
                    if (bl2) {
                        this.mDocument.setModifiedFlag(true);
                    }
                    return;
                }
            }
            this.mDocument.removeDocListener((IDataDocListener)this);
            syntaxMgr = SyntaxMgr.getSyntaxMgr();
            String string = this.mDocument.getDatasetName();
            if (string != null && string.length() > 0 && syntaxMgr.isConnected() && !string.equals(CoreResUtil.getSingleDataSetName())) {
                syntaxMgr.executeSyntax("DATASET CLOSE " + (String)string + ".\n", false);
            }
            this.mView.notifyCloseDataSetImpl(this.mDocument.getDatasetId());
        }
        super.performClose();
        this.setVisible(false);
        this.dispose();
        this.mDocument = null;
        this.mView = null;
        this.mGoToDataDlg = null;
        if (sSearchDialog != null) {
            sSearchDialog.dispose();
            sSearchDialog = null;
        }
        if (sSpellCheckDialog != null) {
            sSpellCheckDialog.dispose();
            sSpellCheckDialog = null;
        }
    }

    @Override
    public void pack() {
        super.pack();
        if (sSearchDialog != null) {
            sSearchDialog.dispose();
            sSearchDialog = null;
        }
        if (sSpellCheckDialog != null) {
            sSpellCheckDialog.dispose();
            sSpellCheckDialog = null;
        }
    }

    @Override
    public void setVisible(boolean bl) {
        if (CommandLine.isExternalCaller()) {
            super.setVisible(false);
        } else {
            super.setVisible(bl);
        }
    }

    @Override
    public boolean saveModified() {
        if (this.mDocument != null && this.mDocument.getModifiedFlag() && this.mDocument.getPromptToSaveFlag()) {
            if (this.getExtendedState() == 1) {
                this.setExtendedState(0);
            }
            Toolkit.getDefaultToolkit().beep();
            String string = this.mDocument.getFileSpec() == null ? this.mDocument.getDocName() : this.mDocument.getFileSpec().getPath();
            String string2 = this.mDocument.getDatasetName();
            String string3 = String.format(ResUtil.getString("ERR_DATA_SAVE_QUERY"), string2, string);
            String string4 = VersionInfo.getAppVersionString();
            int n = SpssAlertOptionPane.showConfirmDialog(this, string3, string4, SpssAlertOptionPane.OptionType.YES_NO_CANCEL_OPTION);
            if (n == 3 || n == -1) {
                return false;
            }
            if (n == 1) {
                boolean bl;
                if (AppMgr.getAppMgr().isSessionClosing()) {
                    ErrorDispatcher.getErrorDispatcher().setInterceptErrors(true);
                    bl = DocUtil.saveCoreDocument(this);
                    if (ErrorDispatcher.getErrorDispatcher().hasInterceptedErrors()) {
                        Vector vector = ErrorDispatcher.getErrorDispatcher().getInterceptedErrors();
                        TraceSettings.trace1((String)("Errors found in save: " + vector.size()), (int)3840);
                        ErrorEventMsg errorEventMsg = (ErrorEventMsg)vector.remove(0);
                        SpssMgr.getSpssMgr().handleError(errorEventMsg);
                    }
                    ErrorDispatcher.getErrorDispatcher().setInterceptErrors(false);
                } else {
                    bl = DocUtil.saveCoreDocument(this);
                }
                if (!bl) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void saveFrameSize() {
        SpssFrame[] spssFrameArray;
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node("doc_types").node("dataeditor");
        if (this.getExtendedState() == 6) {
            preferences2.putInt("data_editor_height", -1);
            preferences2.putInt("data_editor_width", -1);
        } else {
            spssFrameArray = this.getSize();
            preferences2.putInt("data_editor_height", (int)spssFrameArray.getHeight());
            preferences2.putInt("data_editor_width", (int)spssFrameArray.getWidth());
        }
        if (SpssFrameMgr.getSpssFrameMgr().openDocumentCount(DocType.DE_DOC) == 0) {
            for (SpssFrame spssFrame : spssFrameArray = SpssFrameMgr.getSpssFrameMgr().getOpenDocuments()) {
                spssFrame.saveFrameSize();
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        if (locallyUniqueId != null && this.getDatasetId() != null && locallyUniqueId.equals((Object)this.getDatasetId())) {
            ProcedureDlgMgr.getMgr().closeAllProcedureDialogs();
        }
        ProcedureDlgMgr.getMgr().removeDataset(this.getDatasetId());
    }

    public DataView getDataView() {
        return this.mView;
    }

    public SpellCheck getSpellCheckDlg() {
        DataView dataView = this.getDataView();
        JTable jTable = dataView.getDataTable(dataView.getActiveView());
        if (jTable instanceof VarViewTable) {
            sSpellCheckDialog = new VarViewSpellCheckDlg(this);
        } else {
            sSpellCheckDialog = new DataViewSpellCheckDlg(this);
            if (this.getViewValueLabels()) {
                sSpellCheckDialog = null;
                String string = ResUtil.getString("ERR_LABELS_ARE_ON");
                SpssAlertOptionPane.showWarningMessageDialog(this, string, VersionInfo.getAppVersionString());
            }
        }
        return (SpellCheck)sSpellCheckDialog;
    }

    public DataFindDlg getSearchDialog() {
        if (sSearchDialog == null) {
            sSearchDialog = new DataFindDlg(this, (ISearchProxy)this.mView);
        } else if (sSearchDialog.getParent() != this) {
            sSearchDialog.dispose();
            sSearchDialog = new DataFindDlg(this, (ISearchProxy)this.mView);
        }
        return sSearchDialog;
    }

    @Override
    public void resetSearchDialog() {
        if (sSearchDialog != null) {
            sSearchDialog.dispose();
            sSearchDialog = null;
        }
    }

    public void updateSearchDialogControls() {
        if (sSearchDialog != null && sSearchDialog.isShowing()) {
            sSearchDialog.updateDialogControls();
        }
    }

    public void showGoToDataDlg(int n) {
        if ((this.getExtendedState() & 1) != 0) {
            this.setExtendedState(0);
        }
        this.toFront();
        if (this.mGoToDataDlg != null && this.mGoToDataDlg.isShowing()) {
            this.mGoToDataDlg.setActiveTab(n);
            this.mGoToDataDlg.toFront();
        } else {
            this.mGoToDataDlg = new GoToDataDlg(this, n);
            this.mGoToDataDlg.setVisible(true);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DataFrame.this.mGoToDataDlg.requestFocusInWindow();
            }
        });
    }

    public void clearGoToDialog() {
        this.mGoToDataDlg = null;
    }

    @Override
    public SpssPrintable getPrintable() {
        this.mPrintOptions.setPrintMode(SpssPrintable.PrintMode.NORMAL);
        return new DataEditViewPrintable(this, this.mPrintOptions, this.mDocument.getDocName());
    }

    public void doColorDlg() {
        this.getDataView().launchColorDlg();
    }

    public void doColorText(Color color) {
        this.getDataView().doColorText(color);
    }

    public void doColorCells(Color color) {
        this.getDataView().doColorCells(color);
    }

    @Override
    public void doCopy() {
        this.getDataView().doCopy();
    }

    @Override
    public void doPaste() {
        this.getDataView().doPaste();
    }

    @Override
    public void doPasteSpecial() {
        this.getDataView().doPaste(true);
    }

    @Override
    public void doCut() {
        this.getDataView().doCut();
    }

    @Override
    public void doDelete() {
        this.getDataView().doDelete();
    }

    @Override
    public void doGridFont() {
        this.getDataView().doGridFont();
    }

    public void commitEdit() {
        this.mView.commitEdit();
    }

    public boolean canSearch(boolean bl) {
        if (this.mView.getActiveView() == 0) {
            boolean bl2;
            JTable jTable = this.mView.getDataTable(0);
            int n = jTable.getColumnModel().getSelectionModel().getLeadSelectionIndex();
            if (n < 0 || this.mView.getDataSrc() == null || n >= this.mView.getDataSrc().columnCount()) {
                return false;
            }
            boolean bl3 = bl2 = !bl;
            if (bl) {
                boolean bl4 = bl2 = jTable.getSelectedColumnCount() == 1;
                if (bl2 && this.getViewValueLabels()) {
                    ISpssVariable iSpssVariable = this.mView.getDataSrc().getVariable(n);
                    bl2 = iSpssVariable != null && iSpssVariable.getValueLabels().size() == 0;
                }
            }
            return bl2;
        }
        VarViewTable varViewTable = (VarViewTable)this.mView.getDataTable(1);
        return varViewTable.isSearchableColumnSelected(bl);
    }

    public boolean checkDataLimit(boolean bl, long l) {
        long l2;
        ISpssDataSrc iSpssDataSrc = this.mDocument.getDataSrc();
        long l3 = bl ? iSpssDataSrc.rowCount() : (long)iSpssDataSrc.columnCount();
        long l4 = l2 = bl ? VersionInfo.getCaseLimit() : VersionInfo.getVariableLimit();
        if (l2 > -1L && l3 + l > l2) {
            if (!this.mInDataWarning) {
                this.mInDataWarning = true;
                String string = bl ? ResUtil.getString("IDS_STUDENT_TOO_MANY_CASES") : ResUtil.getString("IDS_STUDENT_TOO_MANY_VARS");
                SpssAlertOptionPane.showWarningMessageDialog(this, string, VersionInfo.getAppVersionString());
                this.mInDataWarning = false;
            }
            return false;
        }
        return true;
    }

    public void notifySaveDocument(String string) {
        this.updateTitleBar();
        this.updateToolbarEnableStatus();
    }

    public void notifyCloseDocument() {
    }

    public void notifyDatasetNameChange(String string) {
        this.updateTitleBar();
        SpssFrameMgr.getSpssFrameMgr().updateSyntaxWindows();
    }

    public void notifyWindowStateChange(SpssWindowStates spssWindowStates) {
        int n = this.getExtendedState();
        switch (spssWindowStates) {
            case SpssMinimized: {
                this.setExtendedState(n |= 1);
                break;
            }
            case SpssMaximized: {
                this.setExtendedState(n |= 6);
                break;
            }
            case SpssNormal: {
                this.setExtendedState(n |= 0);
            }
        }
    }

    public void updateFilterStatus(boolean bl) {
        if (bl) {
            this.mStatusBarPanel.putPaneMessage(StatusBar.StatusPane.filterPane, ResUtil.getString("IDS_FILTERTEXT"));
        } else {
            this.mStatusBarPanel.putPaneMessage(StatusBar.StatusPane.filterPane, "      ");
        }
    }

    public void updateWeightStatus(boolean bl) {
        if (bl) {
            this.mStatusBarPanel.putPaneMessage(StatusBar.StatusPane.weightPane, ResUtil.getString("IDS_WEIGHTTEXT"));
        } else {
            this.mStatusBarPanel.putPaneMessage(StatusBar.StatusPane.weightPane, "      ");
        }
        this.mHasWeightVar = bl;
    }

    public boolean hasWeightVar() {
        return this.mHasWeightVar;
    }

    public void updateSplitFileStatus(boolean bl) {
        if (bl) {
            String string = DataFrame.getSplitVariableNames(this.mDocument.getDataSrc());
            String string2 = string.length() <= 30 ? string : string.substring(0, 29) + "...";
            this.mStatusBarPanel.putPaneMessage(StatusBar.StatusPane.splitFilePane, string2);
            if (this.mStatusBarPanel.getPane(StatusBar.StatusPane.splitFilePane) != null) {
                this.mStatusBarPanel.getPane(StatusBar.StatusPane.splitFilePane).setToolTipText(string);
            }
        } else {
            this.mStatusBarPanel.putPaneMessage(StatusBar.StatusPane.splitFilePane, "      ");
            if (this.mStatusBarPanel.getPane(StatusBar.StatusPane.splitFilePane) != null) {
                this.mStatusBarPanel.getPane(StatusBar.StatusPane.splitFilePane).setToolTipText(ResUtil.getString("IDS_DEFAULT_SPLIT_FILE_PANE_MESSAGE"));
            }
        }
    }

    public static String getSplitVariableNames(ISpssDataSrc iSpssDataSrc) {
        StringBuilder stringBuilder = new StringBuilder(ResUtil.getString("IDS_SPLITTEXT"));
        if (iSpssDataSrc != null && iSpssDataSrc.getNSplitVars() > 0) {
            for (int i = 0; i < iSpssDataSrc.getNSplitVars(); ++i) {
                ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(iSpssDataSrc.getSplitVarIndex(i));
                stringBuilder.append(" ");
                stringBuilder.append(iSpssVariable.getName());
            }
        }
        return stringBuilder.toString();
    }

    public void updateUseStatus() {
        boolean bl = GlobalParameterErrorChecking.isUSEUsed((LocallyUniqueId)this.getDatasetId());
        if (bl) {
            this.mStatusBarPanel.putPaneMessage(StatusBar.StatusPane.filterPane, ResUtil.getString("IDS_USETEXT"));
        } else {
            this.mStatusBarPanel.putPaneMessage(StatusBar.StatusPane.filterPane, "      ");
        }
    }

    public void setGridLines(boolean bl) {
        this.mView.setViewGridlines(0, bl);
        this.mView.setViewGridlines(1, bl);
    }

    public void setValueLabels(boolean bl) {
        if (bl != this.getViewValueLabels()) {
            this.setViewValueLabels(bl);
            this.repaint();
        }
    }

    public boolean getGridLines() {
        return this.mView.getViewGridlines(0);
    }

    public boolean getValueLabels() {
        return this.getViewValueLabels();
    }

    public void selectRows(int n, int n2) {
        this.getDataView().doSelectRows(n, n2);
    }

    public void selectColumns(int n, int n2) {
        this.getDataView().doSelectColumns(n, n2);
    }

    public void selectCells(int n, int n2, int n3, int n4) {
        this.getDataView().doSelectCells(n, n2, n3, n4);
    }

    public void copy() {
        this.getDataView().doCopy();
    }

    public void cut() {
        this.getDataView().doCut();
    }

    public void clear() {
        this.getDataView().doDelete();
    }

    public void paste() {
        this.getDataView().doPaste();
    }

    public Vector<Object> getSelectedVariables() {
        return this.getDataView().getSelectedVariables();
    }

    public void activateDataFrame() {
        SpssFrameMgr.getSpssFrameMgr().setActivatedFrame(this);
        this.doActivate();
    }

    public void runWindowCloseSequence() {
        if (this.canClose()) {
            this.performClose();
        }
    }

    @Override
    protected void updateTitleBar() {
        Object object;
        String string = String.format(ComponentState.getSPSSLocale(), ResUtil.getString("IDS_SPSS_DATA_EDITOR"), VersionInfo.getProductNickName());
        String string2 = "";
        String string3 = "";
        String string4 = "";
        if (this.mDocument != null) {
            string3 = this.mDocument.getDocName();
            string4 = this.mDocument.getDatasetName();
            object = this.getDataSource();
            if (object != null && object.isModified()) {
                if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
                    string2 = "*";
                } else {
                    String string5 = UIManager.getLookAndFeel().getClass().getName();
                    if (string5.contains("SpssPlasticXPLookAndFeel")) {
                        string2 = "*";
                    }
                }
                this.getRootPane().putClientProperty("Window.documentModified", Boolean.TRUE);
            } else {
                this.getRootPane().putClientProperty("Window.documentModified", Boolean.FALSE);
            }
        }
        String string6 = string2 + string3 + " [" + string4 + "] - " + string;
        this.setTitle(string6);
        object = this.mDocument.getDataSrc().getFileSpec();
        if (((String)object).length() > 0) {
            this.getRootPane().putClientProperty("Window.documentFile", new File((String)object));
        } else {
            this.getRootPane().putClientProperty("Window.documentFile", null);
        }
    }

    public ISpssDataSrc getDataSource() {
        return DataMgr.getDataMgr().getDataSource(this.getDatasetId());
    }

    protected DataFrame() throws HeadlessException {
        super(String.format(ComponentState.getSPSSLocale(), ResUtil.getString("IDS_SPSS_DATA_EDITOR"), VersionInfo.getProductNickName()), "dataeditor");
        WindowUtil.setMacWindowCanFullScreen((Window)this, (boolean)true);
        this.setDefaultCloseOperation(0);
        this.mView = new DataView(this);
        this.getContentPane().add((Component)this.mView, "Center");
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node("doc_types/dataeditor");
        boolean bl = preferences2.getBoolean("vl_view", false);
        if (bl) {
            this.mViewValueLabels = true;
            this.setToolbarToggleButtonState("view_value_labels", true);
        }
        InputMap inputMap = this.rootPane.getInputMap(2);
        ActionMap actionMap = this.rootPane.getActionMap();
        KeyStroke keyStroke = ResUtil.getShortcut("IDK_NEW_WINDOW");
        NewDataAction newDataAction = new NewDataAction("file_new_data");
        inputMap.put(keyStroke, newDataAction.getValue("Name"));
        actionMap.put(newDataAction.getValue("Name"), newDataAction);
        KeyStroke keyStroke2 = ResUtil.getShortcut("IDK_OPEN_WINDOW");
        OpenDataAction openDataAction = new OpenDataAction("file_open_data");
        inputMap.put(keyStroke2, openDataAction.getValue("Name"));
        actionMap.put(openDataAction.getValue("Name"), openDataAction);
        this.pack();
    }

    @Override
    protected boolean doActivate() {
        ISpssDataSrc iSpssDataSrc;
        LocallyUniqueId locallyUniqueId = this.getDatasetId();
        LocallyUniqueId locallyUniqueId2 = DataMgr.getDataMgr().getActiveDocumentId();
        if (locallyUniqueId2 != null && locallyUniqueId != null && !locallyUniqueId2.equals((Object)locallyUniqueId) && (ProcedureDlgMgr.getMgr().anyProcedureDialogsRunning(true) || SpssFrameMgr.getSpssFrameMgr().anyModalDialogsRunning())) {
            Toolkit.getDefaultToolkit().beep();
            SpssFrameMgr.getSpssFrameMgr().reactivateCurrentFrame();
            return false;
        }
        if (!super.doActivate()) {
            return false;
        }
        if (locallyUniqueId != null && (iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId)) != null) {
            boolean bl = iSpssDataSrc.hasPendingTransformation();
            this.updatePendingTransformation(bl);
            SpssFrameMgr.getSpssFrameMgr().updatePendingTransformation(locallyUniqueId, bl);
        }
        if (!CommandLine.isExternalCaller() && !CommandLine.isAutomated() && ComponentState.getProcessorAvailable() && !ScriptEngine.getScriptEngine().isAnyEditorsOpen()) {
            SpssFrameMgr.getSpssFrameMgr().removedDisconnectedDataFrames();
        }
        return true;
    }

    @Override
    protected void saveMenuBarDefaultPreferences() throws BackingStoreException {
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = PrefsMgr.getPrefsMgr().getUISystemPrefs();
        Preferences preferences3 = null;
        if (preferences2 != null && preferences2.nodeExists(this.mRootMenuPrefPath)) {
            preferences3 = preferences2.node(this.mRootMenuPrefPath);
        }
        Preferences preferences4 = preferences.node(this.mRootMenuPrefPath);
        preferences4.removeNode();
        preferences4 = preferences.node(this.mRootMenuPrefPath);
        Preferences preferences5 = preferences4.node("0;File");
        MenuMgr.saveDataFileMenuDefaultPreferences(preferences5);
        Preferences preferences6 = preferences4.node("1;Edit");
        MenuMgr.saveEditDefaultPreferences(preferences6);
        Preferences preferences7 = preferences4.node("2;View");
        MenuMgr.saveViewDefaultPreferences(preferences7);
        Preferences preferences8 = preferences4.node("3;Data");
        MenuMgr.saveDataDefaultPreferences(preferences8);
        Preferences preferences9 = preferences4.node("4;Transform");
        MenuMgr.saveTransformDefaultPreferences(preferences9);
        Preferences preferences10 = preferences4.node("5;Analyze");
        this.copyMenuItemFromInstaller(preferences3, preferences10, "5;Analyze");
        MenuMgr.saveAnalyzeDefaultPreferences(preferences10);
        Preferences preferences11 = preferences4.node("7;Graphs");
        MenuMgr.saveGraphsDefaultPreferences(preferences11);
        Preferences preferences12 = preferences4.node("8;Utilities");
        MenuMgr.saveUtilitiesDefaultPreferences(preferences12);
        Preferences preferences13 = preferences4.node("10;Extensions");
        MenuMgr.saveExtensionPreferences(preferences13);
        Preferences preferences14 = preferences4.node("11;Window");
        MenuMgr.saveDataWindowDefaultPreferences(preferences14);
        Preferences preferences15 = preferences4.node("12;Help");
        this.copyMenuItemFromInstaller(preferences3, preferences15, "12;Help");
        MenuMgr.saveHelpDefaultPreferences(preferences15);
    }

    @Override
    protected void setupStatusBar() {
        this.mStatusBarPanel = new DataFrameStatusBar();
    }

    @Override
    protected boolean canClose() {
        return SpssFrameMgr.getSpssFrameMgr().openDocumentCount(DocType.DE_DOC) != 1 || LastDocExitWarning.runDialog(this);
    }

    public void activeViewChanged(int n) {
        if (sSpellCheckDialog != null) {
            sSpellCheckDialog.setVisible(false);
        }
    }

    @Override
    public MenuItemCache getMenuTreeCache() {
        return sMenuTreeCache;
    }

    @Override
    public void setMenuTreeCache(MenuCache menuCache) {
        sMenuTreeCache = menuCache;
        try {
            this.saveMenuBarPreferences();
        }
        catch (BackingStoreException backingStoreException) {
            backingStoreException.printStackTrace();
        }
        this.refreshMenuBar();
    }

    @Override
    public ViewerTreePane getViewerTreePane() {
        return null;
    }

    @Override
    public ViewerDocument getViewerDocument() {
        return null;
    }

    @Override
    public IViewerWindow getIViewerWindow() {
        return null;
    }

    public boolean canExecuteASL() {
        return false;
    }

    public boolean executeASL(JSONObject jSONObject, Vector<JSONObject> vector) {
        return false;
    }

    @Override
    protected void addDeletedAddOnItem(String string) {
        sDeletedAddOnItems.add(string);
    }

    @Override
    protected Vector<String> getDeletedAddOnItem() {
        return sDeletedAddOnItems;
    }

    @Override
    public void clearDeletedAddOnItems() {
        sDeletedAddOnItems.removeAllElements();
    }
}

