/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.data;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.ORIGINATOR_ID;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.cache.CachePage;
import com.spss.java_client.core.documents.data.dictionary.FormatType;
import com.spss.java_client.core.documents.data.dictionary.IImputationInfo;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.core.documents.syntax.SyntaxMgr;
import com.spss.java_client.core.server.messages.DataEditorMsg.ImputationInfoMsg;
import com.spss.java_client.core.server.messages.DataMsgWrapper;
import com.spss.java_client.core.server.messages.IDataMsg;
import com.spss.java_client.core.server.packages.IPackage;
import com.spss.java_client.core.server.packages.PackageMgr;
import com.spss.java_client.ui.command.ActionCatalog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.doc_types.actions.SpssAction;
import com.spss.java_client.ui.doc_types.data.DataCellEdit;
import com.spss.java_client.ui.doc_types.data.DataEditContextMenu;
import com.spss.java_client.ui.doc_types.data.DataViewTableModel;
import com.spss.java_client.ui.doc_types.doc_util.ThinBeveledBorder;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.format.CellValueFormatter;
import com.spss.shared.core_tools.format.ValueFormatter;
import com.spss.uitools.clipboard.AppClipboard;
import com.spss.uitools.controls.TypeAheadCombo;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DataEditBar
extends JPanel
implements FocusListener,
DocumentListener,
ActionListener {
    private static final String[] EDITBAR_CONTEXT_MENU_IDS = new String[]{"context_data_cut", "context_data_copy", "context_data_paste", "context_data_clear"};
    private DataEditContextMenu mEditBarContextMenu = new DataEditContextMenu(EDITBAR_CONTEXT_MENU_IDS);
    private JMenuItem mCutItem;
    private JMenuItem mPasteItem;
    private JMenuItem mCopyItem;
    private JMenuItem mClearItem;
    protected ISpssDataSrc mDataSource = null;
    protected JTable mTable = null;
    protected JLabel mCellAddressPane = new JLabel(" ", 10);
    protected DataCellEdit mEditPane = new DataCellEdit(true);
    protected JLabel mVarSetsPane = new JLabel(" ", 10);
    protected MultipleImputationToolBar mMultipleImputationToolBar;
    protected JToggleButton mMultipleImputationToggle = null;
    protected long mCurrentRow = -1L;
    protected int mCurrentColumn = -1;
    protected boolean mInReselect = false;
    protected boolean mIsModified = false;

    public DataEditBar(JTable jTable) {
        super(new GridBagLayout(), true);
        this.mTable = jTable;
        this.initialize();
        this.mEditPane.getDocument().addDocumentListener(this);
        this.mEditPane.addFocusListener(this);
        this.setModified(false);
        this.mEditPane.setEditBarCellFlag(true);
    }

    public void setDataset(LocallyUniqueId locallyUniqueId) {
        if (locallyUniqueId != null && !locallyUniqueId.isNull()) {
            this.mDataSource = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        }
        this.displayImputationControls();
    }

    public void destroy() {
        this.mEditBarContextMenu = null;
        this.mCutItem = null;
        this.mPasteItem = null;
        this.mCopyItem = null;
        this.mClearItem = null;
        this.mDataSource = null;
        this.mTable = null;
        this.mCellAddressPane = null;
        this.mEditPane = null;
        this.mVarSetsPane = null;
        this.mMultipleImputationToolBar = null;
        this.mMultipleImputationToggle = null;
    }

    public void updateImputationControls() {
        this.displayImputationControls();
    }

    public void updateVarsInUse(int n) {
        this.displayImputationControls();
        if (this.mDataSource == null) {
            return;
        }
        String string = ResUtil.getString("IDS_VARS_IN_USE");
        String string2 = DataMgr.getDataMgr().isDataFreeClient() ? String.format(string, 0, 0) : String.format(string, n, this.mDataSource.columnCount());
        this.mVarSetsPane.setText(string2);
        Graphics graphics = this.mVarSetsPane.getGraphics();
        if (graphics != null) {
            int n2 = SwingUtilities.computeStringWidth(graphics.getFontMetrics(), string2);
            graphics.dispose();
            Dimension dimension = this.mVarSetsPane.getPreferredSize();
            dimension.width = n2 + 6;
            this.mVarSetsPane.setPreferredSize(dimension);
        }
    }

    public void currentCellChanged(long l, int n) {
        String string;
        if (l > -1L && n > -1) {
            this.setValueIfChanged();
        }
        Object object = "";
        this.mCurrentRow = l;
        this.mCurrentColumn = n;
        if (l > -1L && n > -1 && this.mDataSource != null) {
            Object object2;
            SPSS_Format sPSS_Format;
            ISpssVariable iSpssVariable = null;
            if (n > -1 && this.mDataSource.columnCount() >= n) {
                iSpssVariable = this.mDataSource.getVariable(n);
            }
            string = String.format("%d : %s", l + 1L, iSpssVariable != null ? iSpssVariable.getName() : "");
            OBS oBS = iSpssVariable != null && this.mDataSource.getCacheMgr().isCellCached(l, n) ? this.mDataSource.getCacheMgr().getCellValue(l, n) : null;
            SPSS_Format sPSS_Format2 = sPSS_Format = iSpssVariable != null ? iSpssVariable.getFormat() : null;
            if (ComponentState.isBtdRtlOrLtr()) {
                if (ComponentState.getBTD() == 1) {
                    if (sPSS_Format != null) {
                        if (!sPSS_Format.getFormatType().isStringFormat() || FormatType.AHEX.equals((Object)sPSS_Format.getFormatType())) {
                            if (this.mEditPane.getDocument().getProperty(TextAttribute.RUN_DIRECTION) != TextAttribute.RUN_DIRECTION_LTR) {
                                this.mEditPane.getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_LTR);
                            }
                        } else if (this.mEditPane.getDocument().getProperty(TextAttribute.RUN_DIRECTION) != TextAttribute.RUN_DIRECTION_RTL) {
                            this.mEditPane.getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_RTL);
                        }
                    }
                } else if (sPSS_Format != null && this.mEditPane.getDocument().getProperty(TextAttribute.RUN_DIRECTION) != TextAttribute.RUN_DIRECTION_LTR) {
                    this.mEditPane.getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_LTR);
                }
            }
            if (oBS != null && sPSS_Format != null) {
                if (sPSS_Format.getFormatType().isNumericFormat() || sPSS_Format.getFormatType().isDateOrTimeFormat()) {
                    object = oBS.getNum();
                } else if (sPSS_Format.getFormatType().isStringFormat()) {
                    object2 = oBS.getString();
                    object = sPSS_Format.getFormatType() != FormatType.AHEX ? CharacterUtil.rightTrim((String)object2) : object2;
                }
            }
            if (sPSS_Format != null) {
                object2 = sPSS_Format.getFormatType();
                if (object instanceof Double && (Double)object >= 0.0 && (Double)object < 13.0 && (object2 == FormatType.WKDAY || object2 == FormatType.MONTH)) {
                    object = object2 == FormatType.WKDAY ? CellValueFormatter.valueToWeekday((Integer)((Double)object).intValue()) : CellValueFormatter.valueToMonth((Integer)((Double)object).intValue());
                }
            }
            this.mEditPane.setFormat(this.mDataSource, sPSS_Format);
        } else {
            string = "";
            this.mEditPane.setFormat(this.mDataSource, null);
        }
        this.mCellAddressPane.setText(string);
        this.mEditPane.setValue(object);
        this.setModified(false);
    }

    private void setModified(boolean bl) {
        this.mIsModified = bl;
    }

    public void setEditBarText(String string) {
        this.mEditPane.setText(string);
        this.setModified(false);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (!this.mEditPane.isHandlingProcessFocusEvent()) {
            this.setModified(true);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (!this.mEditPane.isHandlingProcessFocusEvent()) {
            this.setModified(true);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        if (!this.mEditPane.isHandlingProcessFocusEvent()) {
            this.setModified(true);
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (this.mTable.isEditing()) {
            this.mTable.getCellEditor().stopCellEditing();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (DataEditBar.this.mEditPane != null && DataEditBar.this.mEditPane.getText() != null) {
                    int n = DataEditBar.this.mEditPane.getText().length();
                    DataEditBar.this.mEditPane.select(n, n);
                }
            }
        });
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setValueIfChanged() {
        void var7_19;
        SPSS_Format sPSS_Format;
        if (!this.mIsModified || this.mCurrentRow < 0L || this.mCurrentColumn < 0 || this.mInReselect) {
            return;
        }
        String string = CachePage.getIndeterminateObs().getString();
        int n = (int)this.mCurrentRow;
        int n2 = this.mCurrentColumn;
        Object object = this.mTable.getModel().getValueAt(n, n2);
        boolean bl = object instanceof String;
        String string2 = "";
        if (bl && (sPSS_Format = this.mEditPane.getFormat()) != null && sPSS_Format.getFormatType() != FormatType.AHEX) {
            string2 = CharacterUtil.rightTrim((String)object.toString());
        }
        if (string.equals(object.toString())) {
            return;
        }
        Object var7_8 = null;
        String string3 = this.mEditPane.getText(true);
        if (DataViewTableModel.getSysmisString().equals(object) && "".equals(string3)) {
            return;
        }
        boolean bl2 = string2.length() > 0 && string2.equals(string3);
        try {
            ISpssVariable iSpssVariable;
            if (string3 != null && string3.length() > 0) {
                void var7_12;
                if (!ComponentState.isBtdRtlOrLtr()) {
                    Object object2 = this.mEditPane.getFormatter().stringToValue(string3);
                } else if (this.mEditPane.getFormat() != null && !this.mEditPane.getFormat().getFormatType().isStringFormat() && this.mEditPane.getFormatter() != null) {
                    Object object3 = this.mEditPane.getFormatter().stringToValue(string3);
                } else {
                    String string4 = string3;
                }
                if (var7_12 instanceof Date) {
                    Date date = (Date)var7_12;
                    SPSS_Format sPSS_Format2 = this.mEditPane.getFormat();
                    FormatType formatType = sPSS_Format2.getFormatType();
                    if (formatType == FormatType.WKDAY) {
                        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT-00:00"));
                        calendar.setTime(date);
                        Double d = calendar.get(7);
                    } else if (formatType == FormatType.MONTH) {
                        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT-00:00"));
                        calendar.setTime(date);
                        Double d = (double)calendar.get(2) + 1.0;
                    } else {
                        long l = ((Date)var7_12).getTime();
                        double d = ValueFormatter.convertJavaDateLongToDouble((long)l);
                        if (!DataViewTableModel.legalDateValue(this.mDataSource, d, sPSS_Format2)) return;
                        Double d2 = d;
                    }
                } else if (var7_12 instanceof Long) {
                    Double d = (double)((Long)var7_12);
                } else {
                    String string5 = string3;
                }
            } else if (string3 != null && (iSpssVariable = this.mDataSource.getVariable(this.mCurrentColumn)) != null && iSpssVariable.getFormat().getFormatType().isDateOrTimeFormat()) {
                return;
            }
        }
        catch (ParseException parseException) {
            return;
        }
        if (!(string3 == null || bl2 || var7_19 != null && object.equals(var7_19))) {
            this.mTable.setValueAt(var7_19, n, n2);
            this.setModified(false);
            return;
        } else {
            if (string3 != null) return;
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private void initialize() {
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        ThinBeveledBorder thinBeveledBorder = new ThinBeveledBorder(uIDefaults.getColor("ToolBar.highlight"), uIDefaults.getColor("ToolBar.shadow"), 1);
        this.setBorder(new EmptyBorder(0, 2, 0, 2));
        this.mCellAddressPane.setBorder(thinBeveledBorder);
        this.mEditPane.setBorder(thinBeveledBorder);
        this.mVarSetsPane.setBorder(thinBeveledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(2, 0, 2, 1);
        this.add((Component)this.mCellAddressPane, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 1, 2, 1);
        this.add((Component)this.mEditPane, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 1, 2, 1);
        this.add((Component)this.mVarSetsPane, gridBagConstraints);
        if (VersionInfo.allowMultipleImputation()) {
            this.mMultipleImputationToolBar = new MultipleImputationToolBar();
            gridBagConstraints.gridx = 4;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(2, 1, 2, 1);
            this.add((Component)this.mMultipleImputationToolBar, gridBagConstraints);
            this.mMultipleImputationToolBar.setVisible(false);
            this.mMultipleImputationToggle = new JToggleButton();
            this.mMultipleImputationToggle.setIcon(new ImageIcon(ResUtil.getImageResource(ResUtil.getString("IDS_MULTIPLE_IMPUTATION_ON_IMAGE"))));
            this.mMultipleImputationToggle.setMargin(new Insets(0, 0, 0, 0));
            gridBagConstraints.gridx = 5;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(2, 1, 2, 1);
            this.add((Component)this.mMultipleImputationToggle, gridBagConstraints);
            this.mMultipleImputationToggle.setVisible(false);
            this.mMultipleImputationToggle.setEnabled(true);
            this.mMultipleImputationToggle.setSelected(false);
            this.mMultipleImputationToggle.setFocusPainted(false);
            this.mMultipleImputationToggle.addActionListener(this);
        }
        Dimension dimension = this.mCellAddressPane.getPreferredSize();
        dimension.width = 140;
        dimension.height += 4;
        this.mCellAddressPane.setPreferredSize(dimension);
        this.mCellAddressPane.setMinimumSize(dimension);
        this.mCellAddressPane.setFont(this.mTable.getFont());
        this.mEditPane.setFont(this.mTable.getFont());
        this.mVarSetsPane.setPreferredSize(dimension);
        this.mVarSetsPane.setFont(this.mTable.getFont());
        int n = this.mEditBarContextMenu.getComponentCount();
        for (int i = 0; i < n; ++i) {
            if (!(this.mEditBarContextMenu.getComponent(i) instanceof JMenuItem)) continue;
            JMenuItem jMenuItem = (JMenuItem)this.mEditBarContextMenu.getComponent(i);
            if (jMenuItem.getText().equals(ResUtil.getString("context_data_cut"))) {
                this.mCutItem = jMenuItem;
            }
            if (jMenuItem.getText().equals(ResUtil.getString("context_data_paste"))) {
                this.mPasteItem = jMenuItem;
            }
            if (jMenuItem.getText().equals(ResUtil.getString("context_data_copy"))) {
                this.mCopyItem = jMenuItem;
            }
            if (!jMenuItem.getText().equals(ResUtil.getString("context_data_clear"))) continue;
            this.mClearItem = jMenuItem;
        }
        this.mEditPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                super.mouseReleased(mouseEvent);
                if (mouseEvent.isPopupTrigger()) {
                    DataEditBar.this.showPopup(mouseEvent);
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                super.mousePressed(mouseEvent);
                if (mouseEvent.isPopupTrigger()) {
                    DataEditBar.this.showPopup(mouseEvent);
                }
            }
        });
        this.mEditPane.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                super.focusLost(focusEvent);
                DataEditBar.this.setValueIfChanged();
            }
        });
        if (!DataMgr.getDataMgr().isDataFreeClient()) {
            this.mEditPane.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    super.keyPressed(keyEvent);
                    if (keyEvent.getKeyCode() == 10) {
                        DataEditBar.this.setValueIfChanged();
                        DataEditBar.this.mInReselect = true;
                        int n = DataEditBar.this.mTable.getSelectedRow();
                        int n2 = DataEditBar.this.mTable.getSelectedColumn();
                        DataEditBar.this.mTable.setRowSelectionInterval(n + 1, n + 1);
                        if (!ComponentState.isBtdRtlOrLtr()) {
                            DataEditBar.this.mTable.setColumnSelectionInterval(n2, n2);
                        } else if (n2 > -1) {
                            DataEditBar.this.mTable.setColumnSelectionInterval(n2, n2);
                        }
                        DataEditBar.this.mTable.requestFocusInWindow();
                        DataEditBar.this.mInReselect = false;
                    }
                }
            });
        }
    }

    private void showPopup(MouseEvent mouseEvent) {
        AppClipboard appClipboard = AppClipboard.getAppClipboard();
        String string = this.mEditPane.getSelectedText();
        boolean bl = this.mEditPane.getRawText() != null && this.mEditPane.getRawText().length() > 0 && (string == null || string.equals(this.mEditPane.getRawText()));
        this.mCutItem.setEnabled(bl);
        this.mCopyItem.setEnabled(bl);
        this.mClearItem.setEnabled(bl);
        this.mPasteItem.setEnabled(appClipboard.isFlavorAvailable(AppClipboard.STRING_FLAVOR));
        this.mEditBarContextMenu.show(this.mEditPane, mouseEvent.getX(), mouseEvent.getY());
    }

    public ISpssDataSrc getDataSource() {
        return this.mDataSource;
    }

    private void displayImputationControls() {
        if (this.mMultipleImputationToggle != null) {
            this.mMultipleImputationToggle.removeActionListener(this);
            if (this.mDataSource == null || this.mDataSource.findVarIndex("Imputation_") == -1) {
                this.mMultipleImputationToggle.setVisible(false);
                this.mMultipleImputationToggle.setSelected(false);
                this.mMultipleImputationToolBar.setVisible(false);
                if (this.mDataSource != null && this.mDataSource.getImputationInfo() != null) {
                    this.mDataSource.getImputationInfo().setEnabled(false);
                    this.mDataSource.notifyImputationDisplayChange();
                }
            } else if (this.mDataSource.isMultipleImputation()) {
                this.mMultipleImputationToggle.setVisible(true);
                this.mMultipleImputationToggle.setSelected(true);
                this.mMultipleImputationToolBar.loadMultipleImputationDatasetsCombo();
                this.mMultipleImputationToolBar.setVisible(true);
                this.mDataSource.notifyImputationDisplayChange();
            } else {
                this.mMultipleImputationToggle.setVisible(true);
                this.mMultipleImputationToggle.setSelected(false);
                this.mMultipleImputationToolBar.setVisible(false);
            }
            this.mMultipleImputationToggle.addActionListener(this);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        SpssAction spssAction;
        Object object = actionEvent.getSource();
        if (object == this.mMultipleImputationToggle && (spssAction = ActionCatalog.getActionCatalog().getSpssAction("view_imputation")) != null) {
            spssAction.actionPerformed(new ActionEvent(object, 1001, "view_imputation"));
        }
    }

    public void setShowImputation(boolean bl) {
        if (this.mDataSource != null) {
            if (bl) {
                this.getParent().setCursor(Cursor.getPredefinedCursor(3));
                this.mDataSource.setImputationInfo(null);
                ImputationInfoMsg imputationInfoMsg = new ImputationInfoMsg();
                imputationInfoMsg.setDataSetId(this.mDataSource.getDataSetId());
                imputationInfoMsg.setOriginator(ORIGINATOR_ID.DATAMGR_ORIGINATOR);
                IPackage iPackage = PackageMgr.getPkgMgr().getPackage(null, "DataEditorPkg");
                DataMsgWrapper dataMsgWrapper = iPackage.sendSynchronousMessage((IDataMsg)imputationInfoMsg, "DEMessages::ImputationInfoMsg");
                this.getParent().setCursor(Cursor.getPredefinedCursor(0));
                if (dataMsgWrapper != null && dataMsgWrapper.getNetResult() == 0) {
                    ImputationInfoMsg imputationInfoMsg2 = (ImputationInfoMsg)dataMsgWrapper.getDataMsg();
                    IImputationInfo iImputationInfo = imputationInfoMsg2.getImputationInfo();
                    if (iImputationInfo.getErrorCode() == 0) {
                        this.mDataSource.setImputationInfo(iImputationInfo);
                        this.enableSplitFileForImputation();
                    } else {
                        this.mDataSource.setImputationInfo(null);
                        if (this.handleMultipleImputationErrors(iImputationInfo)) {
                            this.setShowImputation(bl);
                        }
                    }
                } else assert (false);
                if (this.mDataSource.getImputationInfo() != null) {
                    this.mDataSource.getImputationInfo().setEnabled(true);
                    this.mDataSource.notifyImputationInfo();
                } else {
                    this.mMultipleImputationToggle.setSelected(false);
                }
            } else {
                if (this.mDataSource.getImputationInfo() != null) {
                    this.mDataSource.getImputationInfo().setEnabled(false);
                }
                this.mDataSource.notifyImputationInfo();
            }
            this.mDataSource.getCacheMgr().clearCache();
        }
    }

    private void enableSplitFileForImputation() {
        int n;
        if (this.mDataSource != null && (n = this.mDataSource.findVarIndex("Imputation_")) != -1) {
            boolean bl = true;
            for (int i = 0; i < this.mDataSource.getNSplitVars(); ++i) {
                int n2 = this.mDataSource.getSplitVarIndex(i);
                if (n2 != n) continue;
                bl = false;
                break;
            }
            if (bl) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(SyntaxUtil.getCommand("SPLIT FILE"));
                stringBuffer.append(" LAYERED BY ");
                stringBuffer.append("Imputation_");
                stringBuffer.append(SyntaxUtil.terminateSyntax());
                SyntaxMgr.getSyntaxMgr().executeSyntax(stringBuffer.toString());
            }
        }
    }

    private boolean handleMultipleImputationErrors(IImputationInfo iImputationInfo) {
        int n;
        boolean bl;
        boolean bl2 = false;
        int n2 = iImputationInfo.getErrorCode();
        boolean bl3 = bl = (n2 & 4) == 4;
        if ((n2 &= 0xFFFFFFFB) != 0) {
            JOptionPane.showMessageDialog(this, iImputationInfo.getErrorMessage(n2), VersionInfo.getAppVersionString(), 0);
        }
        if (bl && n2 == 0 && (n = JOptionPane.showConfirmDialog(null, iImputationInfo.getErrorMessage(4), VersionInfo.getAppVersionString(), 0)) == 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(SyntaxUtil.getCommand("SORT CASES"));
            stringBuffer.append(" BY ");
            stringBuffer.append("Imputation_");
            stringBuffer.append("(A)");
            stringBuffer.append(SyntaxUtil.terminateSyntax());
            SyntaxMgr.getSyntaxMgr().executeSyntax(stringBuffer.toString());
            bl2 = true;
        }
        return bl2;
    }

    class MultipleImputationToolBar
    extends JPanel
    implements ActionListener {
        private TypeAheadCombo mMultipleImputationDatasets;

        public MultipleImputationToolBar() {
            super(new GridBagLayout(), true);
            this.init();
            this.loadMultipleImputationDatasetsCombo();
        }

        private void init() {
            this.mMultipleImputationDatasets = new TypeAheadCombo();
            this.mMultipleImputationDatasets.setEditable(false);
            this.mMultipleImputationDatasets.setMaximumRowCount(10);
            this.mMultipleImputationDatasets.addActionListener((ActionListener)this);
            Dimension dimension = this.mMultipleImputationDatasets.getPreferredSize();
            dimension.width = 150;
            this.mMultipleImputationDatasets.setPreferredSize(dimension);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            Insets insets = new Insets(0, 2, 0, 2);
            int n = 23;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            DialogUtil.addUsingGBL(this, (JComponent)this.mMultipleImputationDatasets, gridBagConstraints, 0, 1, 1, 1, n, insets);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.handleMultipleImputationDatasetsAction(actionEvent);
        }

        public void loadMultipleImputationDatasetsCombo() {
            this.mMultipleImputationDatasets.removeActionListener((ActionListener)this);
            this.mMultipleImputationDatasets.removeAllItems();
            ISpssDataSrc iSpssDataSrc = DataEditBar.this.getDataSource();
            if (iSpssDataSrc != null && iSpssDataSrc.isMultipleImputation()) {
                this.mMultipleImputationDatasets.removeAllItems();
                for (String string : iSpssDataSrc.getImputationInfo().getImputedDatasetNames(iSpssDataSrc)) {
                    this.mMultipleImputationDatasets.addItem((Object)string);
                }
                int n = iSpssDataSrc.getImputationInfo().getCurrentImputedDataset();
                if (n == -1) {
                    n = 0;
                }
                this.mMultipleImputationDatasets.setSelectedItem(iSpssDataSrc.getImputationInfo().getImputedDatasetNames(iSpssDataSrc).get(n));
            }
            this.mMultipleImputationDatasets.addActionListener((ActionListener)this);
        }

        private void handleMultipleImputationDatasetsAction(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.mMultipleImputationDatasets && DataEditBar.this.mDataSource != null && DataEditBar.this.mDataSource.isMultipleImputation()) {
                String string = (String)this.mMultipleImputationDatasets.getSelectedItem();
                DataEditBar.this.mDataSource.getImputationInfo().setCurrentImputedDataset(DataEditBar.this.mDataSource.getImputationInfo().getImputationNumberFromName(DataEditBar.this.mDataSource, string));
                DataEditBar.this.mDataSource.notifyImputationInfo();
            }
        }
    }
}

