/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.data;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.documents.data.dictionary.FormatType;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.ui.doc_types.data.DataViewTable;
import com.spss.java_client.ui.doc_types.data.DataViewTableModel;
import com.spss.shared.core_tools.format.CellValueFormatter;
import com.spss.shared.core_tools.format.DTimeFormat;
import com.spss.shared.core_tools.format.ValueFormatter;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.font.TextAttribute;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.JFormattedTextField;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.Document;
import javax.swing.text.InternationalFormatter;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class DataCellEdit
extends JFormattedTextField
implements DocumentListener {
    protected ISpssDataSrc mDataSource = null;
    protected SPSS_Format mSpssFormat = null;
    protected InternationalFormatter mFormatter = new InternationalFormatter();
    protected CellValueFormatter mCellFormat = new CellValueFormatter(PrefsMgr.getLeadZeroPreferenceValue());
    protected int mMaxStringWidth = -1;
    protected Object mOldValue = null;
    protected UndoManager undoManager;
    protected boolean handlingProcessFocusEvent = false;
    private boolean mIsEditBarCell = false;
    private Caret mDefaultCaret;
    private Caret mOvertypeCaret;
    private boolean mIsOvertypeMode = false;

    public DataCellEdit() {
        this(null, null);
    }

    public DataCellEdit(boolean bl) {
        this(null, null, bl);
    }

    public DataCellEdit(ISpssDataSrc iSpssDataSrc, SPSS_Format sPSS_Format) {
        String string;
        if (ComponentState.isBtdRtlOrLtr()) {
            if (this.mIsEditBarCell || sPSS_Format != null && sPSS_Format.getFormatType().isStringFormat()) {
                DataCellEdit.setJTxtFldRunDirProp(this);
            }
            if (this.mIsEditBarCell || sPSS_Format != null && sPSS_Format.getFormatType().isStringFormat() && (this.mSpssFormat == null || !FormatType.AHEX.equals((Object)this.mSpssFormat.getFormatType()))) {
                this.setFormatterFactory(new DefaultFormatterFactory());
            } else {
                this.setFormatterFactory(new CellFormatterFactory());
            }
        } else {
            this.setFormatterFactory(new CellFormatterFactory());
        }
        this.setFormat(iSpssDataSrc, sPSS_Format);
        this.getDocument().addDocumentListener(this);
        this.setupUndo();
        if (OSInfo.getOSType() == OSInfo.OSType.MAC && ((string = System.getProperty("java.version")).equals("1.5.0_24") || string.equals("1.6.0_20"))) {
            this.getInputMap().put(KeyStroke.getKeyStroke(8, 0), "none");
        }
        this.mDefaultCaret = this.getCaret();
        this.mOvertypeCaret = new OvertypeCaret();
        this.setOverwriteMode(false);
    }

    public DataCellEdit(ISpssDataSrc iSpssDataSrc, SPSS_Format sPSS_Format, boolean bl) {
        String string;
        this.mIsEditBarCell = bl;
        if (ComponentState.isBtdRtlOrLtr()) {
            if (bl || sPSS_Format != null && sPSS_Format.getFormatType().isStringFormat()) {
                DataCellEdit.setJTxtFldRunDirProp(this);
            }
            if (bl || sPSS_Format != null && sPSS_Format.getFormatType().isStringFormat() && (this.mSpssFormat == null || !FormatType.AHEX.equals((Object)this.mSpssFormat.getFormatType()))) {
                this.setFormatterFactory(new DefaultFormatterFactory());
            } else {
                this.setFormatterFactory(new CellFormatterFactory());
            }
        } else {
            this.setFormatterFactory(new CellFormatterFactory());
        }
        this.setFormat(iSpssDataSrc, sPSS_Format);
        this.getDocument().addDocumentListener(this);
        this.setupUndo();
        if (OSInfo.getOSType() == OSInfo.OSType.MAC && ((string = System.getProperty("java.version")).equals("1.5.0_24") || string.equals("1.6.0_20"))) {
            this.getInputMap().put(KeyStroke.getKeyStroke(8, 0), "none");
        }
        this.mDefaultCaret = this.getCaret();
        this.mOvertypeCaret = new OvertypeCaret();
        this.setOverwriteMode(false);
    }

    @Override
    protected void processFocusEvent(FocusEvent focusEvent) {
        this.handlingProcessFocusEvent = true;
        super.processFocusEvent(focusEvent);
        this.handlingProcessFocusEvent = false;
    }

    protected void setupUndo() {
        this.undoManager = new UndoManager();
        Document document = this.getDocument();
        document.addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
                DataCellEdit.this.undoManager.addEdit(undoableEditEvent.getEdit());
            }
        });
        this.getActionMap().put("Undo", new AbstractAction("Undo"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (DataCellEdit.this.undoManager.canUndo()) {
                        DataCellEdit.this.undoManager.undo();
                    }
                }
                catch (CannotUndoException cannotUndoException) {
                    // empty catch block
                }
            }
        });
        this.getInputMap(0).put(KeyStroke.getKeyStroke("control Z"), "Undo");
        this.getActionMap().put("Redo", new AbstractAction("Redo"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (DataCellEdit.this.undoManager.canRedo()) {
                        DataCellEdit.this.undoManager.redo();
                    }
                }
                catch (CannotRedoException cannotRedoException) {
                    // empty catch block
                }
            }
        });
        this.getInputMap(0).put(KeyStroke.getKeyStroke("control Y"), "Redo");
    }

    public void clearUndoStack() {
        if (this.undoManager != null) {
            this.undoManager.discardAllEdits();
        }
    }

    public SPSS_Format getFormat() {
        return this.mSpssFormat;
    }

    public void setFormat(ISpssDataSrc iSpssDataSrc, SPSS_Format sPSS_Format) {
        this.mDataSource = iSpssDataSrc;
        int n = this.mMaxStringWidth = sPSS_Format != null && sPSS_Format.getFormatType().isStringFormat() ? (int)sPSS_Format.getWidth() : -1;
        if (sPSS_Format != null && !sPSS_Format.getFormatType().isDateOrTimeFormat() && !sPSS_Format.getFormatType().isRestrictedNumericFormat() && sPSS_Format.getFormatType() != FormatType.AHEX) {
            boolean bl;
            NumberFormat numberFormat = null;
            boolean bl2 = bl = !sPSS_Format.getFormatType().isStringFormat() && !sPSS_Format.getFormatType().isGeneralFormat();
            if (bl) {
                numberFormat = (NumberFormat)this.mCellFormat.buildFormatter(new SPSS_Format(FormatType.F, 30, 14), CellValueFormatter.getLocaleForFormat((SPSS_Format)sPSS_Format));
                numberFormat.setMinimumFractionDigits(sPSS_Format.getDecimals());
                numberFormat.setGroupingUsed(false);
            }
            this.mSpssFormat = sPSS_Format;
            this.mFormatter.setFormat(numberFormat);
        } else if (this.mSpssFormat == null || sPSS_Format == null || !this.mSpssFormat.equals((Object)sPSS_Format) || this.hasGroupingChange()) {
            this.mSpssFormat = sPSS_Format;
            this.buildFormatter();
        }
    }

    @Override
    public void setValue(Object object) {
        try {
            Double d = this.mDataSource != null ? this.mDataSource.getSystemMissing() : -1.7976931348623157E308;
            if (this.mSpssFormat != null && object instanceof Double) {
                if (!this.mSpssFormat.getFormatType().isStringFormat() && object.equals(d)) {
                    object = null;
                } else if (this.mSpssFormat.getFormatType().isDateOrTimeFormat()) {
                    double d2 = (Double)object;
                    FormatType formatType = this.mSpssFormat.getFormatType();
                    object = d2 < 8.0 && formatType == FormatType.WKDAY ? CellValueFormatter.valueToWeekday((Integer)((int)d2)) : (d2 < 13.0 && formatType == FormatType.MONTH ? CellValueFormatter.valueToMonth((Integer)((int)d2)) : (DataViewTableModel.legalDateValue(this.mDataSource, d2, this.mSpssFormat) ? new Date(ValueFormatter.convertDateDoubleToLong((double)d2)) : null));
                }
            } else if (this.mSpssFormat != null && object instanceof String) {
                if (this.mSpssFormat.getFormatType() != FormatType.AHEX) {
                    object = CharacterUtil.rightTrim((String)((String)object));
                }
                if (object.equals(DataViewTableModel.getSysmisString())) {
                    object = null;
                }
            }
            if ("".equals(object) || d.equals(object)) {
                object = null;
            }
            try {
                if (!ComponentState.isBtdRtlOrLtr()) {
                    super.setValue(object);
                } else if (object != null && this.mSpssFormat != null && (!this.mSpssFormat.getFormatType().isStringFormat() || FormatType.AHEX.equals((Object)this.mSpssFormat.getFormatType()))) {
                    if (!(object instanceof String)) {
                        if (!this.mIsEditBarCell) {
                            super.setValue(object);
                        } else {
                            this.setText(this.mFormatter.valueToString(object));
                        }
                    } else {
                        this.setText((String)object);
                    }
                } else if (object == null) {
                    this.setText("");
                } else {
                    this.setText((String)object);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.mOldValue = object;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getRawText() {
        return super.getText();
    }

    public String getText(boolean bl) {
        if (this.getDocument().getLength() == 0) {
            return "";
        }
        String string = super.getText();
        String string2 = this.getText();
        if (bl && string2.length() == 0 && string != null && string.length() > 0) {
            string2 = null;
        }
        return string2;
    }

    @Override
    public String getText() {
        String string;
        block17: {
            string = super.getText();
            if (this.mSpssFormat != null && this.mSpssFormat.getFormatType() == FormatType.AHEX) {
                return string;
            }
            try {
                boolean bl;
                boolean bl2 = bl = this.mSpssFormat != null && this.mSpssFormat.getFormatType().isNumericFormat();
                if (bl && this.mSpssFormat.getFormatType().isDollarFormat()) {
                    string = string.replace("$", "");
                }
                if (bl) {
                    string = string.replace("e", "E");
                }
                Object object = string != null && string.length() > 0 ? (!ComponentState.isBtdRtlOrLtr() ? this.mFormatter.stringToValue(string) : (this.getFormatterFactory() instanceof CellFormatterFactory ? this.mFormatter.stringToValue(string) : string)) : (this.mSpssFormat != null && this.mSpssFormat.getFormatType().isNumericFormat() ? Double.valueOf(this.mDataSource != null ? this.mDataSource.getSystemMissing() : -1.7976931348623157E308) : "");
                if (object != null && object.equals("")) {
                    string = "";
                } else if (object instanceof Double && ((Double)object).doubleValue() == this.mDataSource.getSystemMissing()) {
                    string = "";
                } else if (object != null && this.mFormatter != null) {
                    string = !ComponentState.isBtdRtlOrLtr() ? this.mFormatter.valueToString(object) : (this.getFormatterFactory() instanceof CellFormatterFactory ? this.mFormatter.valueToString(object) : (String)object);
                }
            }
            catch (Exception exception) {
                boolean bl = true;
                if (this.mSpssFormat != null && this.mSpssFormat.getFormatType().isDateOrTimeFormat()) {
                    try {
                        Object object = CellValueFormatter.parseDate((SPSS_Format)this.mSpssFormat, (String)string);
                        if (object != null && object.equals("")) {
                            string = "";
                        } else if (object != null && this.mFormatter != null) {
                            string = !ComponentState.isBtdRtlOrLtr() ? this.mFormatter.valueToString(object) : (this.getFormatterFactory() instanceof CellFormatterFactory ? this.mFormatter.valueToString(object) : (String)object);
                        }
                        bl = false;
                    }
                    catch (ParseException parseException) {
                        parseException.printStackTrace();
                    }
                } else {
                    string = "";
                }
                if (!bl) break block17;
                ComponentState.trace1((String)("DataCellEdit: Parse failed - " + super.getText()), (int)15);
            }
        }
        return string;
    }

    public int getMaxStringWidth() {
        return this.mMaxStringWidth;
    }

    public static void setJTxtFldRunDirProp(JTextField jTextField) {
        if (ComponentState.getBTD() == 1) {
            jTextField.getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_RTL);
        } else if (ComponentState.getBTD() == 2) {
            jTextField.getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_LTR);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.checkStringLength();
        this.updateEditBar();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.checkStringLength();
        this.updateEditBar();
    }

    public void setEditBarCellFlag(boolean bl) {
        this.mIsEditBarCell = bl;
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.checkStringLength();
        this.updateEditBar();
    }

    private void checkStringLength() {
        if (this.mMaxStringWidth > -1) {
            String string = this.getText();
            if (string.length() > this.mMaxStringWidth) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Toolkit.getDefaultToolkit().beep();
                        DataCellEdit.this.setValue(DataCellEdit.this.mOldValue);
                        int n = DataCellEdit.this.mOldValue.toString().length();
                        DataCellEdit.this.select(n, n);
                    }
                });
            } else {
                this.mOldValue = string;
            }
        }
    }

    private boolean hasGroupingChange() {
        if (this.mFormatter == null || this.mFormatter.getFormat() == null) {
            return true;
        }
        boolean bl = false;
        Format format = this.mFormatter.getFormat();
        if (format instanceof DTimeFormat || format instanceof NumberFormat) {
            Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
            Preferences preferences2 = preferences.node("options").node("general");
            String string = preferences2.get("digit_grouping", "No");
            boolean bl2 = string.equalsIgnoreCase("Yes");
            bl = format instanceof DTimeFormat ? bl2 != ((DTimeFormat)format).isGroupingUsed() : bl2 != ((NumberFormat)format).isGroupingUsed();
        }
        return bl;
    }

    private void updateEditBar() {
        if (this.getParent() instanceof DataViewTable) {
            ((DataViewTable)this.getParent()).updateEditBar(this.getText());
        }
    }

    private void buildFormatter() {
        this.mFormatter.setFormat(this.mCellFormat.buildFormatter(this.mSpssFormat));
    }

    @Override
    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        if (keyEvent.getID() == 402 && keyEvent.getKeyCode() == 155) {
            this.setOverwriteMode(!this.mIsOvertypeMode);
        }
    }

    public void setOverwriteMode(boolean bl) {
        this.mIsOvertypeMode = bl;
        int n = this.getCaretPosition();
        if (this.isOvertypeMode()) {
            this.setCaret(this.mOvertypeCaret);
        } else {
            this.setCaret(this.mDefaultCaret);
        }
        this.setCaretPosition(n);
        DefaultFormatter defaultFormatter = (DefaultFormatter)this.getFormatter();
        if (defaultFormatter != null) {
            defaultFormatter.setOverwriteMode(bl);
        }
    }

    public boolean isOvertypeMode() {
        return this.mIsOvertypeMode;
    }

    public boolean isHandlingProcessFocusEvent() {
        return this.handlingProcessFocusEvent;
    }

    class OvertypeCaret
    extends DefaultCaret {
        OvertypeCaret() {
        }

        @Override
        public void paint(Graphics graphics) {
            if (this.isVisible()) {
                try {
                    JTextComponent jTextComponent = this.getComponent();
                    TextUI textUI = jTextComponent.getUI();
                    Rectangle rectangle = textUI.modelToView(jTextComponent, this.getDot());
                    graphics.setColor(jTextComponent.getCaretColor());
                    int n = graphics.getFontMetrics().charWidth('w');
                    int n2 = rectangle.y + rectangle.height - 2;
                    graphics.drawLine(rectangle.x, n2, rectangle.x + n - 2, n2);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }

        @Override
        protected synchronized void damage(Rectangle rectangle) {
            if (rectangle != null) {
                JTextComponent jTextComponent = this.getComponent();
                this.x = rectangle.x;
                this.y = rectangle.y;
                this.width = jTextComponent.getFontMetrics(jTextComponent.getFont()).charWidth('w');
                this.height = rectangle.height;
                this.repaint();
            }
        }
    }

    public class CellFormatterFactory
    extends DefaultFormatterFactory {
        @Override
        public JFormattedTextField.AbstractFormatter getFormatter(JFormattedTextField jFormattedTextField) {
            if (DataCellEdit.this.mFormatter != null) {
                if (!DataCellEdit.this.mIsEditBarCell || DataCellEdit.this.mSpssFormat != null && (!DataCellEdit.this.mSpssFormat.getFormatType().isStringFormat() || FormatType.AHEX.equals((Object)DataCellEdit.this.mSpssFormat.getFormatType()))) {
                    DataCellEdit.this.mFormatter.setOverwriteMode(DataCellEdit.this.mIsOvertypeMode);
                    return DataCellEdit.this.mFormatter;
                }
                DefaultFormatter defaultFormatter = new DefaultFormatter();
                defaultFormatter.setOverwriteMode(DataCellEdit.this.mIsOvertypeMode);
                return defaultFormatter;
            }
            return super.getFormatter(jFormattedTextField);
        }
    }
}

