/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.data;

import com.sun.java.swing.plaf.motif.MotifSplitPaneDivider;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class CompositeSplitPane
extends JSplitPane
implements PropertyChangeListener,
AdjustmentListener {
    private JSplitPane mTopSplitPane;
    private JSplitPane mBottomSplitPane;
    private JScrollPane mPane11;
    private JScrollPane mPane12;
    private JScrollPane mPane21;
    private JScrollPane mPane22;
    private JScrollPane[] mScrollPanes;
    private JViewport mLastViewport;
    private FocusChangeListener mFocusListener = null;
    private JScrollBar mBarHorz1;
    private JScrollBar mBarHorz2;
    private JScrollBar mBarVert1;
    private JScrollBar mBarVert2;
    private JTable mTable;
    private JTable mRowHeaderTable;
    private BasicStroke mDragStroke = new BasicStroke(4.0f);
    private int mLastPos = 19999;
    private int mDelta = 0;
    private Color mDividerDraggingColor = UIManager.getColor("SplitPaneDivider.draggingColor");
    private int mHorzThumbOffset = 30;
    protected int mHorzThumbWidth = 12;
    protected int mHorzThumbHeight = 18;
    protected int mVertThumbWidth = 18;
    protected int mVertThumbHeight = 12;
    private boolean mIsInThumb;
    static int X = 0;

    public CompositeSplitPane(JScrollPane jScrollPane, JScrollPane jScrollPane2, JScrollPane jScrollPane3, JScrollPane jScrollPane4, JTable jTable, JTable jTable2) {
        super(0);
        this.mPane11 = jScrollPane;
        this.mPane12 = jScrollPane2;
        this.mPane21 = jScrollPane3;
        this.mPane22 = jScrollPane4;
        this.mTable = jTable;
        this.mRowHeaderTable = jTable2;
        this.init();
        this.mScrollPanes = new JScrollPane[]{this.mPane11, this.mPane12, this.mPane21, this.mPane22};
        this.mFocusListener = new FocusChangeListener();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener(this.mFocusListener);
    }

    protected void init() {
        this.mPane11.setMinimumSize(new Dimension(0, 0));
        this.mPane12.setMinimumSize(new Dimension(0, 0));
        this.mPane21.setMinimumSize(new Dimension(0, 0));
        this.mPane22.setMinimumSize(new Dimension(0, 0));
        this.mBarHorz1 = this.mPane11.getHorizontalScrollBar();
        this.mBarHorz2 = this.mPane12.getHorizontalScrollBar();
        this.mBarVert1 = this.mPane11.getVerticalScrollBar();
        this.mBarVert2 = this.mPane12.getVerticalScrollBar();
        this.mPane21.setHorizontalScrollBar(this.mBarHorz1);
        this.mPane11.setHorizontalScrollBar(this.mBarHorz1);
        this.mPane22.setHorizontalScrollBar(this.mBarHorz2);
        this.mPane12.setHorizontalScrollBar(this.mBarHorz2);
        this.mPane12.setVerticalScrollBar(this.mBarVert1);
        this.mPane11.setVerticalScrollBar(this.mBarVert1);
        this.mPane22.setVerticalScrollBar(this.mBarVert2);
        this.mPane21.setVerticalScrollBar(this.mBarVert2);
        this.mTopSplitPane = new JSplitPane(1, this.mPane11, this.mPane12);
        this.mBottomSplitPane = new JSplitPane(1, this.mPane21, this.mPane22);
        this.mTopSplitPane.setDividerLocation(9999);
        this.mBottomSplitPane.setDividerLocation(9999);
        this.mTopSplitPane.setResizeWeight(1.0);
        this.mBottomSplitPane.setResizeWeight(1.0);
        this.setTopComponent(this.mTopSplitPane);
        this.setBottomComponent(this.mBottomSplitPane);
        this.setDividerLocation(9999);
        this.setResizeWeight(1.0);
        this.mBarHorz1.addAdjustmentListener(this);
        this.mBarHorz2.addAdjustmentListener(this);
        this.mBarVert1.addAdjustmentListener(this);
        this.mBarVert2.addAdjustmentListener(this);
        this.mTopSplitPane.addPropertyChangeListener(this);
        this.mBottomSplitPane.addPropertyChangeListener(this);
        this.addPropertyChangeListener(this);
        this.addDividerListener();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CompositeSplitPane.this.addDividerListener();
            }
        });
    }

    public void disconnect() {
        if (this.mTopSplitPane == null) {
            return;
        }
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener(this.mFocusListener);
        this.mBarHorz1.removeAdjustmentListener(this);
        this.mBarHorz2.removeAdjustmentListener(this);
        this.mBarVert1.removeAdjustmentListener(this);
        this.mBarVert2.removeAdjustmentListener(this);
        this.mTopSplitPane.removePropertyChangeListener(this);
        this.mBottomSplitPane.removePropertyChangeListener(this);
        this.removePropertyChangeListener(this);
        this.mFocusListener = null;
        this.mLastViewport = null;
        this.mDragStroke = null;
        this.mTopSplitPane = null;
        this.mBottomSplitPane = null;
        this.mPane11 = null;
        this.mPane12 = null;
        this.mPane21 = null;
        this.mPane22 = null;
        this.mScrollPanes = null;
        this.mBarHorz1 = null;
        this.mBarHorz2 = null;
        this.mBarVert1 = null;
        this.mBarVert2 = null;
        this.mTable = null;
        this.mDividerDraggingColor = null;
    }

    private void addDividerListener() {
        BasicSplitPaneUI basicSplitPaneUI;
        VerticalDividerMouseHandler verticalDividerMouseHandler = new VerticalDividerMouseHandler();
        if (this.mTopSplitPane != null && (basicSplitPaneUI = (BasicSplitPaneUI)this.mTopSplitPane.getUI()) != null) {
            basicSplitPaneUI.getDivider().addMouseListener(verticalDividerMouseHandler);
            basicSplitPaneUI.getDivider().addMouseMotionListener(verticalDividerMouseHandler);
        }
        if (this.mBottomSplitPane != null && (basicSplitPaneUI = (BasicSplitPaneUI)this.mBottomSplitPane.getUI()) != null) {
            basicSplitPaneUI.getDivider().addMouseListener(verticalDividerMouseHandler);
            basicSplitPaneUI.getDivider().addMouseMotionListener(verticalDividerMouseHandler);
        }
        if ((basicSplitPaneUI = (BasicSplitPaneUI)this.getUI()) != null) {
            HorizontalDividerMouseHandler horizontalDividerMouseHandler = new HorizontalDividerMouseHandler();
            basicSplitPaneUI.getDivider().addMouseListener(horizontalDividerMouseHandler);
            basicSplitPaneUI.getDivider().addMouseMotionListener(horizontalDividerMouseHandler);
        }
        this.mDragStroke = new BasicStroke(this.getDividerSize() - 1);
    }

    public void showDivider(boolean bl) {
        if (bl) {
            this.mTopSplitPane.setDividerLocation(this.getSize().width / 2);
            this.setDividerLocation(this.getSize().height / 2);
        } else {
            this.mTopSplitPane.setDividerLocation(9999);
            this.setDividerLocation(9999);
        }
    }

    public boolean isDividerOn() {
        return this.mTopSplitPane.getResizeWeight() < 1.0 || this.getResizeWeight() < 1.0;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("dividerLocation")) {
            JSplitPane jSplitPane = (JSplitPane)propertyChangeEvent.getSource();
            if (jSplitPane == this.mTopSplitPane || jSplitPane == this.mBottomSplitPane) {
                int n = jSplitPane.getDividerLocation();
                if (jSplitPane.getResizeWeight() == 1.0 && n < 9999) {
                    n = this.normalizeCol(n);
                    this.mBarHorz2.setValue(n - this.mTable.getColumnModel().getColumn(0).getPreferredWidth());
                }
                if (n + 50 > this.mTopSplitPane.getSize().width) {
                    if (jSplitPane.getResizeWeight() < 1.0) {
                        this.mPane11.setVerticalScrollBar(this.mBarVert1);
                        this.mPane21.setVerticalScrollBar(this.mBarVert2);
                        this.mTopSplitPane.setResizeWeight(1.0);
                        this.mBottomSplitPane.setResizeWeight(1.0);
                        if (this.mTopSplitPane.getDividerLocation() < 9999) {
                            this.mTopSplitPane.setDividerLocation(9999);
                        }
                        if (this.mBottomSplitPane.getDividerLocation() < 9999) {
                            this.mBottomSplitPane.setDividerLocation(9999);
                        }
                    } else {
                        if (jSplitPane.getDividerLocation() < 9999) {
                            jSplitPane.setDividerLocation(9999);
                        }
                        if (jSplitPane == this.mBottomSplitPane) {
                            this.mTopSplitPane.repaint();
                        } else if (jSplitPane == this.mTopSplitPane) {
                            this.mBottomSplitPane.repaint();
                        }
                    }
                } else {
                    this.mPane12.setVerticalScrollBar(this.mBarVert1);
                    this.mPane22.setVerticalScrollBar(this.mBarVert2);
                    this.mTopSplitPane.setResizeWeight(0.0);
                    this.mBottomSplitPane.setResizeWeight(0.0);
                    if (n != this.mBottomSplitPane.getDividerLocation()) {
                        this.mBottomSplitPane.setDividerLocation(n);
                    }
                    if (n != this.mTopSplitPane.getDividerLocation()) {
                        this.mTopSplitPane.setDividerLocation(n);
                    }
                }
            } else if (jSplitPane == this) {
                int n = jSplitPane.getDividerLocation();
                if (jSplitPane.getResizeWeight() == 1.0 && n < 9999) {
                    n = this.normalizeRow(n);
                    this.mBarVert2.setValue(n - this.mTable.getTableHeader().getHeight());
                }
                if (n + 50 > this.getSize().height) {
                    if (jSplitPane.getResizeWeight() < 1.0) {
                        this.mPane11.setHorizontalScrollBar(this.mBarHorz1);
                        this.mPane12.setHorizontalScrollBar(this.mBarHorz2);
                        this.setResizeWeight(1.0);
                    }
                    if (this.getDividerLocation() < 9999) {
                        this.setDividerLocation(9999);
                    }
                } else {
                    this.mPane21.setHorizontalScrollBar(this.mBarHorz1);
                    this.mPane22.setHorizontalScrollBar(this.mBarHorz2);
                    this.setResizeWeight(0.0);
                    if (n != this.getDividerLocation()) {
                        this.setDividerLocation(n);
                    }
                }
            }
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        Point point;
        JViewport jViewport;
        JScrollBar jScrollBar = (JScrollBar)adjustmentEvent.getSource();
        if (jScrollBar == this.mBarVert1) {
            jViewport = this.mPane11.getViewport();
            point = jViewport.getViewPosition();
            jViewport.setViewPosition(new Point(point.x, this.mPane12.getViewport().getViewPosition().y));
        } else if (jScrollBar == this.mBarVert2) {
            jViewport = this.mPane21.getViewport();
            point = jViewport.getViewPosition();
            jViewport.setViewPosition(new Point(point.x, this.mPane22.getViewport().getViewPosition().y));
        }
        if (jScrollBar == this.mBarHorz1) {
            jViewport = this.mPane11.getViewport();
            point = jViewport.getViewPosition();
            jViewport.setViewPosition(new Point(this.mPane21.getViewport().getViewPosition().x, point.y));
        } else if (jScrollBar == this.mBarHorz2) {
            jViewport = this.mPane12.getViewport();
            point = jViewport.getViewPosition();
            jViewport.setViewPosition(new Point(this.mPane22.getViewport().getViewPosition().x, point.y));
        }
    }

    private int normalizeRow(int n) {
        int n2 = n;
        int n3 = this.mTable.getRowCount();
        int n4 = this.mTable.getTableHeader().getHeight();
        for (int i = 0; i < n3; ++i) {
            if ((n4 += this.mTable.getRowHeight(i)) < n) continue;
            n2 = n4;
            break;
        }
        return n2;
    }

    private int normalizeCol(int n) {
        int n2 = n;
        int n3 = this.mTable.getColumnCount();
        int n4 = 7 + (int)this.mRowHeaderTable.getPreferredSize().getWidth();
        for (int i = 0; i < n3; ++i) {
            if ((n4 += this.mTable.getColumnModel().getColumn(i).getPreferredWidth()) < n) continue;
            n2 = n4;
            break;
        }
        return n2;
    }

    public void forceRedraw() {
        int n = this.getDividerLocation();
        this.setDividerLocation(n + 1);
        this.setDividerLocation(n);
    }

    private void hideBothDivider(BasicSplitPaneDivider basicSplitPaneDivider, int n) {
        JSplitPane jSplitPane = basicSplitPaneDivider.getBasicSplitPaneUI().getSplitPane();
        if (jSplitPane != null) {
            jSplitPane.setDividerLocation(9999);
            if (jSplitPane == this && n >= this.mTopSplitPane.getDividerLocation() && n <= this.mTopSplitPane.getDividerLocation() + this.mTopSplitPane.getDividerSize()) {
                this.mTopSplitPane.setDividerLocation(9999);
            }
        }
    }

    private boolean isCrossedPoint(int n) {
        return n >= this.mTopSplitPane.getDividerLocation() && n <= this.mTopSplitPane.getDividerLocation() + this.mTopSplitPane.getDividerSize();
    }

    private boolean isInThumb(int n, int n2, MotifSplitPaneDivider motifSplitPaneDivider) {
        Dimension dimension = motifSplitPaneDivider.getSize();
        int n3 = dimension.width / 2;
        int n4 = n3 - this.mHorzThumbWidth / 2;
        int n5 = this.mHorzThumbOffset;
        int n6 = this.mHorzThumbWidth;
        int n7 = this.mHorzThumbHeight;
        return n >= n4 && n < n4 + n6 && n2 >= n5 && n2 < n5 + n7;
    }

    public JViewport getLastActiveViewPort() {
        return this.mLastViewport;
    }

    public JTable getLastActiveTable() {
        if (this.mLastViewport != null && this.mLastViewport.getComponent(0) instanceof JTable) {
            return (JTable)this.mLastViewport.getComponent(0);
        }
        return null;
    }

    class FocusChangeListener
    implements PropertyChangeListener {
        FocusChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getNewValue() instanceof Component) {
                Component component = (Component)propertyChangeEvent.getNewValue();
                if ("focusOwner".equals(propertyChangeEvent.getPropertyName()) && propertyChangeEvent.getOldValue() == null) {
                    for (JScrollPane jScrollPane : CompositeSplitPane.this.mScrollPanes) {
                        if (!jScrollPane.isAncestorOf(component)) continue;
                        Component[] componentArray = jScrollPane.getComponents();
                        if (componentArray == null || componentArray.length <= 0 || !(componentArray[0] instanceof JViewport)) break;
                        CompositeSplitPane.this.mLastViewport = (JViewport)componentArray[0];
                        break;
                    }
                }
            }
        }
    }

    class HorizontalDividerMouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        HorizontalDividerMouseHandler() {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            BasicSplitPaneDivider basicSplitPaneDivider = (BasicSplitPaneDivider)mouseEvent.getSource();
            if (basicSplitPaneDivider.getCursor() == Cursor.getPredefinedCursor(13)) {
                final int n = mouseEvent.getPoint().x - (CompositeSplitPane.this.getDividerSize() - 1) / 2;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CompositeSplitPane.this.mTopSplitPane.setDividerLocation(n);
                        CompositeSplitPane.this.repaint(0, 0, CompositeSplitPane.this.getWidth(), CompositeSplitPane.this.getHeight());
                    }
                });
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            BasicSplitPaneDivider basicSplitPaneDivider = (BasicSplitPaneDivider)mouseEvent.getSource();
            if (basicSplitPaneDivider.getCursor() == Cursor.getPredefinedCursor(13)) {
                final int n = mouseEvent.getPoint().x + (CompositeSplitPane.this.getDividerSize() - 1) / 2;
                CompositeSplitPane.this.repaint(0, 0, CompositeSplitPane.this.getWidth(), CompositeSplitPane.this.getHeight());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Graphics graphics = CompositeSplitPane.this.getGraphics();
                        Graphics2D graphics2D = (Graphics2D)graphics;
                        graphics2D.setColor(CompositeSplitPane.this.mDividerDraggingColor);
                        graphics2D.setStroke(CompositeSplitPane.this.mDragStroke);
                        graphics2D.drawLine(n, 0, n, CompositeSplitPane.this.getHeight());
                        graphics.dispose();
                    }
                });
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            BasicSplitPaneDivider basicSplitPaneDivider = (BasicSplitPaneDivider)mouseEvent.getSource();
            if (basicSplitPaneDivider instanceof MotifSplitPaneDivider) {
                return;
            }
            if (CompositeSplitPane.this.isCrossedPoint(mouseEvent.getPoint().x)) {
                basicSplitPaneDivider.setCursor(Cursor.getPredefinedCursor(13));
            } else {
                basicSplitPaneDivider.setCursor(Cursor.getPredefinedCursor(8));
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (mouseEvent.getClickCount() == 2 && object instanceof BasicSplitPaneDivider) {
                CompositeSplitPane.this.hideBothDivider((BasicSplitPaneDivider)object, mouseEvent.getX());
            }
        }
    }

    class VerticalDividerMouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        VerticalDividerMouseHandler() {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            JSplitPane jSplitPane;
            Point point = mouseEvent.getPoint();
            BasicSplitPaneDivider basicSplitPaneDivider = (BasicSplitPaneDivider)mouseEvent.getSource();
            JSplitPane jSplitPane2 = basicSplitPaneDivider.getBasicSplitPaneUI().getSplitPane();
            if (jSplitPane2 == CompositeSplitPane.this.mTopSplitPane) {
                jSplitPane = CompositeSplitPane.this.mBottomSplitPane;
            } else if (jSplitPane2 == CompositeSplitPane.this.mBottomSplitPane) {
                jSplitPane = CompositeSplitPane.this.mTopSplitPane;
            } else {
                return;
            }
            if (basicSplitPaneDivider instanceof MotifSplitPaneDivider) {
                if (CompositeSplitPane.this.mIsInThumb) {
                    int n = basicSplitPaneDivider.getBasicSplitPaneUI().getSplitPane().getDividerLocation();
                    if (jSplitPane2.getResizeWeight() == 1.0) {
                        n = ((CompositeSplitPane)CompositeSplitPane.this).mBottomSplitPane.getSize().width - (CompositeSplitPane.this.getDividerSize() + 1);
                    }
                    final int n2 = n + point.x - CompositeSplitPane.this.mDelta + (CompositeSplitPane.this.getDividerSize() - 1) / 2;
                    jSplitPane.repaint(0, 0, jSplitPane.getWidth(), jSplitPane.getHeight());
                    final JSplitPane jSplitPane3 = jSplitPane;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Graphics graphics = jSplitPane3.getGraphics();
                            Graphics2D graphics2D = (Graphics2D)graphics;
                            graphics2D.setColor(CompositeSplitPane.this.mDividerDraggingColor);
                            graphics2D.setStroke(CompositeSplitPane.this.mDragStroke);
                            graphics2D.drawLine(n2, 0, n2, jSplitPane3.getHeight());
                            graphics2D.dispose();
                        }
                    });
                }
            } else {
                Graphics graphics = jSplitPane.getGraphics();
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setColor(Color.white);
                graphics2D.setXORMode(Color.black);
                graphics2D.setStroke(CompositeSplitPane.this.mDragStroke);
                int n = basicSplitPaneDivider.getBasicSplitPaneUI().getSplitPane().getDividerLocation();
                if (jSplitPane2.getResizeWeight() == 1.0) {
                    n = ((CompositeSplitPane)CompositeSplitPane.this).mBottomSplitPane.getSize().width - (CompositeSplitPane.this.getDividerSize() + 1);
                }
                int n3 = n + point.x - CompositeSplitPane.this.mDelta + (CompositeSplitPane.this.getDividerSize() - 1) / 2;
                if (CompositeSplitPane.this.mLastPos != 19999) {
                    graphics.drawLine(CompositeSplitPane.this.mLastPos, 0, CompositeSplitPane.this.mLastPos, jSplitPane.getSize().height);
                }
                graphics.drawLine(n3, 0, n3, jSplitPane.getSize().height);
                graphics.dispose();
                CompositeSplitPane.this.mLastPos = n3;
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (mouseEvent.getClickCount() == 2 && object instanceof BasicSplitPaneDivider) {
                CompositeSplitPane.this.hideBothDivider((BasicSplitPaneDivider)object, mouseEvent.getX());
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            CompositeSplitPane.this.mLastPos = 19999;
            CompositeSplitPane.this.mDelta = mouseEvent.getPoint().x;
            Point point = mouseEvent.getPoint();
            BasicSplitPaneDivider basicSplitPaneDivider = (BasicSplitPaneDivider)mouseEvent.getSource();
            if (basicSplitPaneDivider instanceof MotifSplitPaneDivider) {
                MotifSplitPaneDivider motifSplitPaneDivider = (MotifSplitPaneDivider)basicSplitPaneDivider;
                CompositeSplitPane.this.mIsInThumb = CompositeSplitPane.this.isInThumb(point.x, point.y, motifSplitPaneDivider);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            CompositeSplitPane.this.mIsInThumb = false;
            BasicSplitPaneDivider basicSplitPaneDivider = (BasicSplitPaneDivider)mouseEvent.getSource();
            final JSplitPane jSplitPane = basicSplitPaneDivider.getBasicSplitPaneUI().getSplitPane();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JSplitPane jSplitPane2 = jSplitPane == CompositeSplitPane.this.mTopSplitPane ? CompositeSplitPane.this.mBottomSplitPane : CompositeSplitPane.this.mTopSplitPane;
                    jSplitPane2.repaint(0, 0, jSplitPane2.getWidth(), jSplitPane2.getHeight());
                }
            });
        }
    }
}

