/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.actions.syntax;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.syntax.SyntaxMgr;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.doc_types.ITopWindow;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.actions.SpssAction;
import com.spss.java_client.ui.doc_types.actions.syntax.RunContinue;
import com.spss.java_client.ui.doc_types.output.ViewerFrame;
import com.spss.java_client.ui.doc_types.syntax.SyntaxFrame;
import com.spss.java_client.ui.doc_types.syntax.SyntaxView;
import com.spss.java_client.ui.resources.ResUtil;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.nio.charset.CoderResult;
import java.util.prefs.Preferences;

public class RunAction
extends SpssAction {
    private SyntaxFrame.SyntaxSegment mSyntaxSegment;

    public RunAction(String string, SyntaxFrame.SyntaxSegment syntaxSegment) {
        super(string);
        this.configureAction(true);
        this.mSyntaxSegment = syntaxSegment;
    }

    @Override
    public boolean getMenuItemEnableStatus(ITopWindow iTopWindow) {
        SyntaxView syntaxView;
        boolean bl = false;
        if (iTopWindow != null && iTopWindow instanceof SyntaxFrame && (syntaxView = ((SyntaxFrame)iTopWindow).getSyntaxView()) != null) {
            bl = !syntaxView.isEditorEmpty();
        }
        return bl;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        SpssFrame spssFrame = this.getFrame(((Container)actionEvent.getSource()).getParent());
        if (spssFrame instanceof SyntaxFrame) {
            if (!(this instanceof RunContinue)) {
                ((SyntaxFrame)spssFrame).clearErrorPane();
            }
            RunAction.doRunForSegment((SyntaxFrame)spssFrame, this.mSyntaxSegment);
        }
    }

    public static void doRunForSegmentToGetExtensionHelp(SyntaxFrame syntaxFrame, SyntaxFrame.SyntaxSegment syntaxSegment) {
        if (syntaxFrame instanceof SyntaxFrame) {
            ViewerFrame viewerFrame;
            SyntaxFrame syntaxFrame2 = syntaxFrame;
            String string = syntaxFrame2.processRunSyntaxToGetExtensionHelp(syntaxSegment);
            if (string == null || string.trim().length() == 0) {
                return;
            }
            CoderResult coderResult = syntaxFrame2.getSyntaxView().validateCharacterEncoding(string, false);
            syntaxFrame2.getSyntaxView();
            if (!SyntaxView.isValidCoderResult(coderResult)) {
                return;
            }
            if (!string.trim().endsWith(".")) {
                if (SpssAlertOptionPane.showConfirmDialog(syntaxFrame, ResUtil.getString("ERR_MISSINGSYNTAXTERMINATOR"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION) != 0) {
                    return;
                }
                string = string + ".";
            }
            SyntaxMgr.getSyntaxMgr().executeSyntax(string);
            Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs().node("options").node("general");
            if (preferences.getBoolean("raise_viewer_window", true) && SpssFrameMgr.getSpssFrameMgr().openDocumentCount(DocType.OUTPUT_DOC) > 0 && (viewerFrame = (ViewerFrame)SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.OUTPUT_DOC)) != null) {
                if (viewerFrame.getExtendedState() != 6 && viewerFrame.getExtendedState() != 1) {
                    viewerFrame.setExtendedState(0);
                }
                viewerFrame.toFront();
            }
        }
    }

    public static void doRunForSegment(SyntaxFrame syntaxFrame, SyntaxFrame.SyntaxSegment syntaxSegment) {
        if (syntaxFrame instanceof SyntaxFrame) {
            ViewerFrame viewerFrame;
            SyntaxFrame syntaxFrame2 = syntaxFrame;
            String string = syntaxFrame2.processRunSyntax(syntaxSegment);
            if (string == null || string.trim().length() == 0) {
                return;
            }
            CoderResult coderResult = syntaxFrame2.getSyntaxView().validateCharacterEncoding(string, false);
            syntaxFrame2.getSyntaxView();
            if (!SyntaxView.isValidCoderResult(coderResult)) {
                return;
            }
            if (!string.trim().endsWith(".")) {
                if (SpssAlertOptionPane.showConfirmDialog(syntaxFrame, ResUtil.getString("ERR_MISSINGSYNTAXTERMINATOR"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION) != 0) {
                    return;
                }
                string = string + ".";
            }
            SyntaxMgr.getSyntaxMgr().executeSyntax(string);
            Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs().node("options").node("general");
            if (preferences.getBoolean("raise_viewer_window", true) && SpssFrameMgr.getSpssFrameMgr().openDocumentCount(DocType.OUTPUT_DOC) > 0 && (viewerFrame = (ViewerFrame)SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.OUTPUT_DOC)) != null) {
                if (viewerFrame.getExtendedState() != 6 && viewerFrame.getExtendedState() != 1) {
                    viewerFrame.setExtendedState(0);
                }
                viewerFrame.toFront();
            }
        }
    }
}

