/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.actions.output;

import com.spss.java_client.core.documents.output.IOutputDocument;
import com.spss.java_client.core.documents.output.IOutputItem;
import com.spss.java_client.core.documents.output.header.HeaderItem;
import com.spss.java_client.ui.doc_types.ITopWindow;
import com.spss.java_client.ui.doc_types.actions.SpssAction;
import com.spss.java_client.ui.doc_types.output.ViewerDocument;
import com.spss.java_client.ui.doc_types.output.ViewerItem;
import com.spss.java_client.ui.doc_types.output.ViewerTreePane;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class OutlinePromoteDemoteAction
extends SpssAction {
    private boolean mPromoteFlag;
    private boolean mEnablePromoteFlag = false;
    private boolean mEnableDemoteFlag = false;
    private ArrayList<WeakReference<DefaultMutableTreeNode>> mSequenceList = new ArrayList();
    private WeakReference<ITopWindow> mwViewerFrame = null;
    private Vector<WeakReference<IOutputItem>> mCoreItems = new Vector();

    public OutlinePromoteDemoteAction(String string) {
        super(string);
        this.mPromoteFlag = string.equals("edit_outline_promote");
        this.configureAction(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        IOutputItem iOutputItem;
        ITopWindow iTopWindow = this.getTopWindow((Component)actionEvent.getSource());
        this.mwViewerFrame = new WeakReference<ITopWindow>(iTopWindow);
        WeakReference<JTree> weakReference = new WeakReference<JTree>(iTopWindow.getViewerTreePane().getViewerTree());
        JTree jTree = (JTree)weakReference.get();
        TreePath[] treePathArray = jTree.getSelectionPaths();
        ArrayList<DefaultMutableTreeNode> arrayList = new ArrayList<DefaultMutableTreeNode>();
        this.mSequenceList.clear();
        this.mCoreItems.clear();
        for (int i = 0; i < treePathArray.length; ++i) {
            arrayList.add(i, (DefaultMutableTreeNode)treePathArray[i].getLastPathComponent());
        }
        this.sortSelectedPaths((DefaultMutableTreeNode)jTree.getModel().getRoot(), arrayList);
        ViewerDocument viewerDocument = iTopWindow.getViewerDocument();
        IOutputDocument iOutputDocument = viewerDocument.getCoreDocument();
        Vector<WeakReference<IOutputItem>> vector = this.getCoreItems();
        final Vector vector2 = new Vector();
        for (WeakReference<IOutputItem> iOutputItem2 : vector) {
            vector2.add(iOutputItem2.get());
        }
        final IOutputItem iOutputItem3 = viewerDocument.getFocusedViewerItem().getCoreItem();
        if (this.mPromoteFlag) {
            if (vector2.size() > 0) {
                iOutputDocument.moveItemsTo(vector2, ((IOutputItem)vector2.get(0)).getParentItem());
            }
        } else if (vector2.size() > 0 && (iOutputItem = iOutputDocument.getPreviousSiblingItem((IOutputItem)vector2.get(0))) != null && iOutputItem instanceof HeaderItem) {
            iOutputDocument.moveItemsUnder(vector2, (HeaderItem)iOutputItem);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ViewerDocument viewerDocument = ((ITopWindow)OutlinePromoteDemoteAction.this.mwViewerFrame.get()).getViewerDocument();
                for (IOutputItem iOutputItem : vector2) {
                    viewerDocument.selectionChanged(OutlinePromoteDemoteAction.this.getViewerItem(iOutputItem), true, true);
                }
                viewerDocument.setFocusedViewerItem(OutlinePromoteDemoteAction.this.getViewerItem(iOutputItem3), true);
            }
        });
    }

    @Override
    public boolean getMenuItemEnableStatus(ITopWindow iTopWindow) {
        this.mwViewerFrame = new WeakReference<ITopWindow>(iTopWindow);
        try {
            this.setPromoteDemoteEnableFlag();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.mPromoteFlag) {
            return this.mEnablePromoteFlag;
        }
        return this.mEnableDemoteFlag;
    }

    private Vector<WeakReference<IOutputItem>> getCoreItems() {
        for (WeakReference<DefaultMutableTreeNode> weakReference : this.mSequenceList) {
            IOutputItem iOutputItem = ((ViewerTreePane.NavTreeNode)((DefaultMutableTreeNode)weakReference.get()).getUserObject()).getItem().getCoreItem();
            if (!this.coreItemsContains(iOutputItem)) {
                this.mCoreItems.add(new WeakReference<IOutputItem>(iOutputItem));
            }
            if (!((ITopWindow)this.mwViewerFrame.get()).getViewerTreePane().isHeaderNode((DefaultMutableTreeNode)weakReference.get())) continue;
            this.addChildren((DefaultMutableTreeNode)weakReference.get());
        }
        return this.mCoreItems;
    }

    boolean coreItemsContains(IOutputItem iOutputItem) {
        for (WeakReference<IOutputItem> weakReference : this.mCoreItems) {
            if (!iOutputItem.equals(weakReference.get())) continue;
            return true;
        }
        return false;
    }

    private void addChildren(DefaultMutableTreeNode defaultMutableTreeNode) {
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            IOutputItem iOutputItem = ((ViewerTreePane.NavTreeNode)defaultMutableTreeNode2.getUserObject()).getItem().getCoreItem();
            if (!this.coreItemsContains(iOutputItem)) {
                this.mCoreItems.add(new WeakReference<IOutputItem>(iOutputItem));
            }
            if (defaultMutableTreeNode2.getChildCount() <= 0) continue;
            this.addChildren(defaultMutableTreeNode2);
        }
    }

    private ArrayList<WeakReference<DefaultMutableTreeNode>> sortSelectedPaths(DefaultMutableTreeNode defaultMutableTreeNode, ArrayList<DefaultMutableTreeNode> arrayList) {
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            if (defaultMutableTreeNode2.getChildCount() > 0) {
                if (arrayList.contains(defaultMutableTreeNode2)) {
                    this.mSequenceList.add(new WeakReference<DefaultMutableTreeNode>(defaultMutableTreeNode2));
                }
                this.sortSelectedPaths(defaultMutableTreeNode2, arrayList);
                continue;
            }
            if (!arrayList.contains(defaultMutableTreeNode2)) continue;
            this.mSequenceList.add(new WeakReference<DefaultMutableTreeNode>(defaultMutableTreeNode2));
        }
        return this.mSequenceList;
    }

    private void setPromoteDemoteEnableFlag() {
        if (this.mwViewerFrame == null || this.mwViewerFrame.get() == null) {
            assert (false);
            return;
        }
        WeakReference<JTree> weakReference = new WeakReference<JTree>(((ITopWindow)this.mwViewerFrame.get()).getViewerTreePane().getViewerTree());
        JTree jTree = (JTree)weakReference.get();
        this.mEnableDemoteFlag = false;
        this.mEnablePromoteFlag = false;
        this.mSequenceList.clear();
        TreePath[] treePathArray = jTree.getSelectionPaths();
        ArrayList<DefaultMutableTreeNode> arrayList = new ArrayList<DefaultMutableTreeNode>();
        if (treePathArray != null) {
            for (int i = 0; i < treePathArray.length; ++i) {
                arrayList.add(i, (DefaultMutableTreeNode)treePathArray[i].getLastPathComponent());
            }
            if (arrayList.contains(jTree.getModel().getRoot())) {
                return;
            }
            if (!this.isContinuousSelection(jTree.getSelectionRows())) {
                return;
            }
            ArrayList<WeakReference<DefaultMutableTreeNode>> arrayList2 = this.sortSelectedPaths((DefaultMutableTreeNode)jTree.getModel().getRoot(), arrayList);
            DefaultMutableTreeNode defaultMutableTreeNode = this.getParentOfSelectedNode((DefaultMutableTreeNode)arrayList2.get(arrayList2.size() - 1).get(), arrayList2);
            DefaultMutableTreeNode defaultMutableTreeNode2 = ((DefaultMutableTreeNode)arrayList2.get(0).get()).getPreviousSibling();
            if (defaultMutableTreeNode.getNextSibling() == null && !((DefaultMutableTreeNode)defaultMutableTreeNode.getParent()).isRoot()) {
                this.mEnablePromoteFlag = true;
            }
            if (defaultMutableTreeNode2 != null) {
                TreePath treePath = new TreePath(defaultMutableTreeNode2.getPath());
                if (((ITopWindow)this.mwViewerFrame.get()).getViewerTreePane().isHeaderNode(defaultMutableTreeNode2)) {
                    this.mEnableDemoteFlag = !jTree.isCollapsed(treePath) || defaultMutableTreeNode2.getChildCount() <= 0;
                }
            }
        }
    }

    private DefaultMutableTreeNode getParentOfSelectedNode(DefaultMutableTreeNode defaultMutableTreeNode, ArrayList<WeakReference<DefaultMutableTreeNode>> arrayList) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
        DefaultMutableTreeNode defaultMutableTreeNode3 = defaultMutableTreeNode2 != null && this.listContains(arrayList, defaultMutableTreeNode2) ? this.getParentOfSelectedNode(defaultMutableTreeNode2, arrayList) : defaultMutableTreeNode;
        return defaultMutableTreeNode3;
    }

    private boolean listContains(ArrayList<WeakReference<DefaultMutableTreeNode>> arrayList, DefaultMutableTreeNode defaultMutableTreeNode) {
        for (WeakReference<DefaultMutableTreeNode> weakReference : arrayList) {
            if (!((DefaultMutableTreeNode)weakReference.get()).equals(defaultMutableTreeNode)) continue;
            return true;
        }
        return false;
    }

    private boolean isContinuousSelection(int[] nArray) {
        if (nArray == null) {
            return false;
        }
        Arrays.sort(nArray);
        int n = nArray[0];
        for (int i = 1; i < nArray.length; ++i) {
            if (++n == nArray[i]) continue;
            return false;
        }
        return true;
    }

    private ViewerItem getViewerItem(IOutputItem iOutputItem) {
        ViewerItem viewerItem = null;
        ViewerDocument viewerDocument = ((ITopWindow)this.mwViewerFrame.get()).getViewerDocument();
        for (ViewerItem viewerItem2 : viewerDocument.getViewerItems()) {
            if (viewerItem2.getCoreItem() != iOutputItem) continue;
            viewerItem = viewerItem2;
            break;
        }
        return viewerItem;
    }
}

