/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.actions.output;

import com.spss.java_client.core.common.OutputItemAlignment;
import com.spss.java_client.ui.doc_types.ITopWindow;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.actions.SpssAction;
import com.spss.java_client.ui.doc_types.output.SelectSpssTreeNodes;
import com.spss.java_client.ui.doc_types.output.TextViewerItem;
import com.spss.java_client.ui.doc_types.output.ViewerDocument;
import com.spss.java_client.ui.doc_types.output.ViewerFrame;
import com.spss.java_client.ui.doc_types.output.ViewerItem;
import com.spss.java_client.ui.doc_types.output.undo.OutputUndoableEdit;
import com.spss.java_client.ui.texteditor.SpssTextPane;
import com.spss.shared.core_tools.format.CommonState;
import com.spss.shared.core_tools.system.OSInfo;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class LeftAlignmentAction
extends SpssAction {
    public LeftAlignmentAction(String string) {
        super(string);
        this.configureAction(false);
    }

    @Override
    public boolean getMenuItemEnableStatus(ITopWindow iTopWindow) {
        if (!(iTopWindow instanceof ViewerFrame) && CommonState.getApplicationType() != CommonState.AppType.MODELER && CommonState.getApplicationType() != CommonState.AppType.MODELERCLOUD) {
            return false;
        }
        SelectSpssTreeNodes selectSpssTreeNodes = new SelectSpssTreeNodes(iTopWindow);
        return selectSpssTreeNodes.enableAlignmentMenuItem();
    }

    @Override
    public JMenuItem getMenuItem() {
        return new JRadioButtonMenuItem(this);
    }

    @Override
    public boolean getMenuItemCheckStatus(SpssFrame spssFrame) {
        if (!(spssFrame instanceof ViewerFrame)) {
            return false;
        }
        return this.areAllSelectedItemsAlignedLeft(spssFrame);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ITopWindow iTopWindow = this.getTopWindow((Component)actionEvent.getSource());
        if (iTopWindow != null) {
            ViewerItem[] viewerItemArray = iTopWindow.getViewerDocument().getSelectedItems(true);
            HashMap<ViewerItem, OutputItemAlignment> hashMap = new HashMap<ViewerItem, OutputItemAlignment>();
            for (ViewerItem viewerItem : viewerItemArray) {
                hashMap.put(viewerItem, viewerItem.getCoreItem().getAlignment());
            }
            new OutputUndoableEdit(iTopWindow.getIViewerWindow(), viewerItemArray, hashMap, OutputItemAlignment.Left);
            for (ViewerItem viewerItem : viewerItemArray) {
                Container container;
                if (viewerItem == null || !viewerItem.isVisible() || viewerItem.getComponentType() == ViewerDocument.ComponentType.log || viewerItem.getComponentType() == ViewerDocument.ComponentType.text) continue;
                viewerItem.getCoreItem().setAlignment(OutputItemAlignment.Left);
                if (OSInfo.getOSType() == OSInfo.OSType.MAC && iTopWindow instanceof ViewerFrame) {
                    container = (ViewerFrame)iTopWindow;
                    ((ViewerFrame)container).getOutputPane().repaint();
                }
                if (!(viewerItem instanceof TextViewerItem)) continue;
                container = ((TextViewerItem)viewerItem).getTextPane();
                if (!((SpssTextPane)container).isHTMLDocument()) {
                    ((TextViewerItem)viewerItem).setUseHtmlDocument();
                }
                StyledDocument styledDocument = (StyledDocument)((JTextComponent)container).getDocument();
                SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                StyleConstants.setAlignment(simpleAttributeSet, 0);
                styledDocument.setParagraphAttributes(0, styledDocument.getLength(), simpleAttributeSet, false);
            }
        }
    }

    private boolean areAllSelectedItemsAlignedLeft(SpssFrame spssFrame) {
        boolean bl = true;
        if (spssFrame instanceof ViewerFrame) {
            ViewerFrame viewerFrame = (ViewerFrame)spssFrame;
            ViewerItem[] viewerItemArray = viewerFrame.getDocument().getSelectedItems(true);
            HashMap<ViewerItem, OutputItemAlignment> hashMap = new HashMap<ViewerItem, OutputItemAlignment>();
            for (ViewerItem viewerItem : viewerItemArray) {
                hashMap.put(viewerItem, viewerItem.getCoreItem().getAlignment());
            }
            for (ViewerItem viewerItem : viewerItemArray) {
                if (viewerItem == null || !viewerItem.isVisible()) continue;
                if (viewerItem.getComponentType() != ViewerDocument.ComponentType.log && viewerItem.getComponentType() != ViewerDocument.ComponentType.text) {
                    if (viewerItem.getCoreItem().getAlignment() == OutputItemAlignment.Left) continue;
                    return false;
                }
                bl = false;
            }
        }
        return bl;
    }
}

