/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.actions.output;

import com.spss.java_client.ui.doc_types.ITopWindow;
import com.spss.java_client.ui.doc_types.actions.output.OutputContextMenuAction;
import com.spss.java_client.ui.doc_types.output.MGOHelper;
import com.spss.java_client.ui.doc_types.output.ViewerDocument;
import com.spss.java_client.ui.doc_types.output.ViewerPanel;
import java.awt.Container;
import java.awt.event.ActionEvent;

public class ItemCopyAsAction
extends OutputContextMenuAction {
    private String mCopyAsType;

    public ItemCopyAsAction(String string) {
        super(string);
        this.mCopyAsType = string;
    }

    @Override
    public boolean getMenuItemEnableStatus(ITopWindow iTopWindow) {
        ViewerDocument viewerDocument = iTopWindow.getViewerDocument();
        if (viewerDocument != null) {
            if (viewerDocument.getSelectedItemCount(true) == 1) {
                boolean bl = ViewerDocument.ComponentType.chart == viewerDocument.getFocusedViewerItem().getComponentType();
                boolean bl2 = ViewerDocument.ComponentType.ltable == viewerDocument.getFocusedViewerItem().getComponentType();
                boolean bl3 = MGOHelper.canDoMGOForSelection(viewerDocument);
                if (this.mCopyAsType.equalsIgnoreCase("context_output_copy_as_mgo")) {
                    return bl3 && bl;
                }
                if (this.mCopyAsType.equalsIgnoreCase("context_output_copy_as_image")) {
                    return bl || bl2;
                }
                if (this.mCopyAsType.equalsIgnoreCase("context_output_copy_as_emf")) {
                    return bl || bl2;
                }
                if (this.mCopyAsType.equalsIgnoreCase("context_output_copy_as_biff")) {
                    return bl2;
                }
                if (this.mCopyAsType.equalsIgnoreCase("context_output_copy_as_text")) {
                    return bl2;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ITopWindow iTopWindow = this.getTopWindow(((Container)actionEvent.getSource()).getParent());
        ViewerPanel viewerPanel = iTopWindow.getViewerPanel();
        if (viewerPanel != null) {
            viewerPanel.doCopyWork(null, this.mCopyAsType);
        }
    }
}

