/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.actions.output;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.documents.output.GenericItem;
import com.spss.java_client.core.documents.output.IOutputDocument;
import com.spss.java_client.core.documents.output.IOutputItem;
import com.spss.java_client.core.documents.output.header.HeaderItem;
import com.spss.java_client.core.documents.output.text.PageTitleItem;
import com.spss.java_client.core.documents.output.text.TextItem;
import com.spss.java_client.core.documents.output.text.TitleItem;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.doc_types.ITopWindow;
import com.spss.java_client.ui.doc_types.actions.SpssAction;
import com.spss.java_client.ui.doc_types.output.TextViewerItem;
import com.spss.java_client.ui.doc_types.output.ViewerDocument;
import com.spss.java_client.ui.doc_types.output.ViewerItem;
import com.spss.java_client.ui.doc_types.output.ViewerTreePane;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.custom_gui.ui_builder.res.BuilderResUtil;
import com.spss.uitools.util.TraceSettings;
import java.awt.Component;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class InsertOutputItemAction
extends SpssAction {
    private static final int NEW_HEADING = 0;
    private static final int NEW_TITLE = 1;
    private static final int NEW_TEXT = 2;
    private static final int NEW_PAGE_TITLE = 3;
    private static final int NEW_TEXT_FILE = 4;
    private static final int NEW_IMAGE_FILE = 5;
    private int mActionId;
    private ITopWindow mTopWindow;

    public InsertOutputItemAction(String string) {
        super(string);
        this.configureAction(true);
        if (string.equals("insert_new_heading")) {
            this.mActionId = 0;
        } else if (string.equals("insert_new_text")) {
            this.mActionId = 2;
        } else if (string.equals("insert_new_title")) {
            this.mActionId = 1;
        } else if (string.equals("insert_new_page_title")) {
            this.mActionId = 3;
        } else if (string.equals("insert_text_file")) {
            this.mActionId = 4;
        } else if (string.equals("insert_text_file")) {
            this.mActionId = 4;
        } else if (string.equals("insert_image_file")) {
            this.mActionId = 5;
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        HeaderItem headerItem = null;
        switch (this.mActionId) {
            case 0: {
                headerItem = new HeaderItem();
                headerItem.setDescription(ResUtil.getString("IDS_VIEWER_ITEM_HEADING"));
                break;
            }
            case 1: {
                headerItem = new TitleItem();
                headerItem.setDescription(ResUtil.getString("IDS_VIEWER_ITEM_TITLE"));
                ((TextItem)headerItem).setContents("");
                break;
            }
            case 3: {
                headerItem = new PageTitleItem();
                headerItem.setDescription(ResUtil.getString("IDS_VIEWER_ITEM_PAGETITLE"));
                ((PageTitleItem)headerItem).setContents("");
                break;
            }
            case 2: {
                headerItem = new TextItem();
                headerItem.setDescription(ResUtil.getString("IDS_VIEWER_ITEM_TEXT"));
                ((TextItem)headerItem).setContents("");
                break;
            }
            case 4: {
                object = this.retrieveTextFile();
                if (object == null) break;
                headerItem = new TextItem();
                headerItem.setDescription(ResUtil.getString("IDS_VIEWER_ITEM_TEXT"));
                ((TextItem)headerItem).setContents((String)object);
                break;
            }
            case 5: {
                object = this.retrieveImageFile();
                if (object == null) break;
                headerItem = new GenericItem((Image)object);
                headerItem.setDescription(ResUtil.getString("IDS_VIEWER_ITEM_IMAGE"));
                break;
            }
            default: {
                return;
            }
        }
        this.mTopWindow = this.getTopWindow((Component)actionEvent.getSource());
        if (headerItem != null && this.mTopWindow instanceof ITopWindow) {
            IOutputItem iOutputItem;
            object = this.mTopWindow.getViewerDocument();
            IOutputDocument iOutputDocument = ((ViewerDocument)object).getCoreDocument();
            ViewerItem viewerItem = ((ViewerDocument)object).getFocusedViewerItem();
            if (viewerItem != null) {
                iOutputItem = viewerItem.getCoreItem();
                if (iOutputItem instanceof HeaderItem) {
                    DefaultMutableTreeNode defaultMutableTreeNode;
                    boolean bl;
                    HeaderItem headerItem2 = (HeaderItem)iOutputItem;
                    ViewerTreePane viewerTreePane = this.mTopWindow.getViewerTreePane();
                    JTree jTree = viewerTreePane.getViewerTree();
                    boolean bl2 = bl = jTree.isExpanded(new TreePath((defaultMutableTreeNode = viewerTreePane.findNode((DefaultMutableTreeNode)jTree.getModel().getRoot(), (IOutputItem)headerItem2)).getPath())) || defaultMutableTreeNode.getChildCount() == 0;
                    if (bl) {
                        iOutputDocument.insertItem((IOutputItem)headerItem, (IOutputItem)headerItem2);
                    } else {
                        iOutputDocument.insertItem((IOutputItem)headerItem, iOutputItem, true);
                    }
                } else {
                    iOutputDocument.insertItem((IOutputItem)headerItem, iOutputItem);
                }
            } else {
                iOutputDocument.insertItem((IOutputItem)headerItem, null);
            }
            iOutputItem = headerItem;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ViewerDocument viewerDocument = InsertOutputItemAction.this.mTopWindow.getViewerDocument();
                    Vector<ViewerItem> vector = viewerDocument.getViewerItems();
                    ViewerItem viewerItem = null;
                    for (ViewerItem viewerItem2 : vector) {
                        if (!iOutputItem.equals(viewerItem2.getCoreItem())) continue;
                        viewerItem = viewerItem2;
                        break;
                    }
                    if (viewerItem != null) {
                        viewerDocument.setFocusedViewerItem(viewerItem);
                        viewerDocument.selectionChanged(viewerItem, true, false);
                        if (viewerItem instanceof TextViewerItem) {
                            ((TextViewerItem)viewerItem).getTextPane().useHTMLDocument(false);
                            viewerItem.initiateEditing();
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String retrieveTextFile() {
        String string = null;
        RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.OpenFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getOtherFilesDirectoryPath(), false);
        RefFileFilter refFileFilter = new RefFileFilter(ResUtil.getString("IDS_VIEWER_TEXTFILE_DESCRIPTION"), ResUtil.getString("IDS_VIEWER_TEXTFILE_EXTENSION"));
        remoteFileChooser.setFileFilter((FileFilter)refFileFilter);
        remoteFileChooser.setAcceptAllFileFilterUsed(false);
        int n = remoteFileChooser.showOpenDialog((Window)((Object)this.mTopWindow));
        if (n == 0) {
            FileLocationsUtil.setOtherFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
            File file = remoteFileChooser.getSelectedFile();
            remoteFileChooser.setCurrentDirectory(file);
            FileInputStream fileInputStream = null;
            try {
                String string2;
                StringBuffer stringBuffer = new StringBuffer();
                fileInputStream = new FileInputStream(file);
                String string3 = this.getEncoding(fileInputStream);
                if (string3 == null) {
                    fileInputStream.close();
                    fileInputStream = new FileInputStream(file);
                    string3 = ComponentState.getCurrentCharsetName();
                }
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, string3));
                while ((string2 = bufferedReader.readLine()) != null) {
                    stringBuffer.append(string2);
                    stringBuffer.append("\n");
                }
                string = stringBuffer.toString();
                bufferedReader.close();
                fileInputStream = null;
            }
            catch (FileNotFoundException fileNotFoundException) {
                TraceSettings.trace1((String)fileNotFoundException.getMessage(), (int)15);
                String string4 = string;
                return string4;
            }
            catch (IOException iOException) {
                TraceSettings.trace1((String)iOException.getMessage(), (int)15);
                String string5 = string;
                return string5;
            }
            finally {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return string;
    }

    private Image retrieveImageFile() {
        RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.OpenFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getOtherFilesDirectoryPath(), false);
        ImageFilesFilter imageFilesFilter = new ImageFilesFilter();
        remoteFileChooser.setDialogTitle(BuilderResUtil.getString((String)"IDS_OPEN_IMAGE_TITLE"));
        remoteFileChooser.addChoosableFileFilter(imageFilesFilter);
        remoteFileChooser.setAcceptAllFileFilterUsed(false);
        remoteFileChooser.setFileFilter(imageFilesFilter);
        int n = remoteFileChooser.showOpenDialog((Window)((Object)this.mTopWindow));
        if (n == 0) {
            Image image = null;
            File file = remoteFileChooser.getSelectedFile();
            try {
                ImageIcon imageIcon = new ImageIcon(file.getPath());
                image = imageIcon.getImage();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                SpssAlertOptionPane.showErrorMessageDialog((Window)((Object)this.mTopWindow), ResUtil.getString("ERR_CANT_READ_IMAGE"), VersionInfo.getAppVersionString());
            }
            return image;
        }
        return null;
    }

    @Override
    public boolean getMenuItemEnableStatus(ITopWindow iTopWindow) {
        return iTopWindow instanceof ITopWindow;
    }

    private String getEncoding(InputStream inputStream) throws FileNotFoundException {
        String string = null;
        byte[] byArray = new byte[3];
        try {
            int n = inputStream.read(byArray, 0, 2);
            if (n > 1) {
                int n2;
                if (byArray[0] == -2 && byArray[1] == -1) {
                    string = "UTF-16BE";
                } else if (byArray[0] == -1 && byArray[1] == -2) {
                    string = "UTF-16LE";
                } else if (byArray[0] == -17 && byArray[1] == -69 && (n2 = inputStream.read()) == 191) {
                    string = "UTF-8";
                }
            }
        }
        catch (IOException iOException) {
            throw new FileNotFoundException(iOException.getMessage());
        }
        return string;
    }

    class ImageFilesFilter
    extends FileFilter {
        ImageFilesFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase().endsWith(".gif") || file.getName().toLowerCase().endsWith(".jpg") || file.getName().toLowerCase().endsWith(".png");
        }

        @Override
        public String getDescription() {
            return ResUtil.getString("IDS_VIEWER_IMAGEFILE_DESCRIPTION");
        }
    }
}

