/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.actions.output;

import com.spss.java_client.core.common.OutputItemType;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.documents.MRUMgr;
import com.spss.java_client.core.documents.output.IOutputItem;
import com.spss.java_client.core.resources.CoreResUtil;
import com.spss.java_client.core.script.ScriptingFrameworkException;
import com.spss.java_client.core.script.autoscripts.AutoscriptEvent;
import com.spss.java_client.core.script.autoscripts.AutoscriptRegistry;
import com.spss.java_client.core.script.autoscripts.IAutoscriptRegistry;
import com.spss.java_client.core.script.autoscripts.IScriptFile;
import com.spss.java_client.core.script.autoscripts.ScriptFile;
import com.spss.java_client.core.script.engine.IScriptLanguage;
import com.spss.java_client.core.script.engine.IScriptLanguageMgr;
import com.spss.java_client.core.script.engine.ScriptEngine;
import com.spss.java_client.core.script.engine.ScriptLanguageMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.actions.SpssAction;
import com.spss.java_client.ui.doc_types.output.ViewerDocument;
import com.spss.java_client.ui.doc_types.output.ViewerFrame;
import com.spss.java_client.ui.doc_types.output.ViewerItem;
import com.spss.java_client.ui.resources.ResUtil;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.filechooser.FileFilter;

public class CreateEditAutoscriptAction
extends SpssAction {
    public CreateEditAutoscriptAction() {
        this("utilities_create_edit_script");
    }

    public CreateEditAutoscriptAction(String string) {
        super(string);
        this.configureAction(true);
    }

    public boolean getMenuItemEnableStatus(SpssFrame spssFrame) {
        if (!(spssFrame instanceof ViewerFrame)) {
            return false;
        }
        return this.getFirstSelectedViewerItem(spssFrame) != null && this.isAutoscriptingEnabled();
    }

    private boolean isAutoscriptingEnabled() {
        boolean bl = false;
        IScriptLanguageMgr iScriptLanguageMgr = ScriptLanguageMgr.getInstance();
        Vector vector = iScriptLanguageMgr.getAllLanguages();
        if (!vector.isEmpty()) {
            IAutoscriptRegistry iAutoscriptRegistry = AutoscriptRegistry.getInstance();
            bl = iAutoscriptRegistry.isAutoscriptingEnabled();
        }
        return bl;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        block8: {
            SpssFrame spssFrame = this.getFrame((Container)actionEvent.getSource());
            try {
                IScriptLanguageMgr iScriptLanguageMgr = ScriptLanguageMgr.getInstance();
                Vector vector = iScriptLanguageMgr.getAllLanguages();
                if (!vector.isEmpty()) {
                    IAutoscriptRegistry iAutoscriptRegistry = AutoscriptRegistry.getInstance();
                    String string = this.getEventSignature(this.getFirstSelectedViewerItem(this.getFrame(((Container)actionEvent.getSource()).getParent())).getCoreItem());
                    if (string != null && iAutoscriptRegistry.getScriptFile(string) != null) {
                        ScriptEngine.getScriptEngine().openScript(iAutoscriptRegistry.getScriptFile(string).getFile().getAbsolutePath());
                        MRUMgr.getMRUMgr().addOtherDocumentPath(iAutoscriptRegistry.getScriptFile(string).getFile().getCanonicalPath());
                    } else {
                        RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.OpenCreateFile, RemoteFileChooser.ChooserOption.Script, FileLocationsUtil.getOtherFilesDirectoryPath(), false);
                        remoteFileChooser.setDialogTitle(CoreResUtil.getString((String)"IDS_FILE_CHOOSER_SPECIFY_SCRIPT_TITLE"));
                        this.setFileFilters(remoteFileChooser, iScriptLanguageMgr.getDefaultLanguage().getLanguageName());
                        int n = remoteFileChooser.showOpenDialog(this.getFrame(((Container)actionEvent.getSource()).getParent()));
                        if (n == 0) {
                            FileLocationsUtil.setOtherFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
                            IScriptFile iScriptFile = this.createScriptFile(remoteFileChooser.getSelectedFile());
                            if (iScriptFile != null) {
                                iAutoscriptRegistry.setScriptFile(string, iScriptFile);
                                iAutoscriptRegistry.writeToPersistentStore();
                                ScriptEngine.getScriptEngine().openScript(iScriptFile.getFile().getAbsolutePath());
                                MRUMgr.getMRUMgr().addOtherDocumentPath(remoteFileChooser.getSelectedFile().getCanonicalPath());
                            }
                        }
                    }
                } else {
                    SpssAlertOptionPane.showErrorMessageDialog(spssFrame, ResUtil.getString("ERR_NO_SCRIPTING_LANGUAGE_AVAILABLE_TO_EDIT"), VersionInfo.getAppVersionString());
                }
            }
            catch (Exception exception) {
                if (exception.getMessage() == null) break block8;
                SpssAlertOptionPane.showErrorMessageDialog(spssFrame, exception.getMessage(), VersionInfo.getAppVersionString());
            }
        }
    }

    private void setFileFilters(RemoteFileChooser remoteFileChooser, String string) {
        IScriptLanguageMgr iScriptLanguageMgr = ScriptLanguageMgr.getInstance();
        Vector vector = iScriptLanguageMgr.getAllLanguages();
        if (!vector.isEmpty()) {
            RefFileFilter refFileFilter = null;
            for (IScriptLanguage iScriptLanguage : vector) {
                RefFileFilter refFileFilter2;
                Vector vector2 = iScriptLanguage.getFileExtensions();
                StringBuffer stringBuffer = new StringBuffer();
                if (vector2.size() != 0) {
                    refFileFilter2 = iScriptLanguage.getFileExtensions().iterator();
                    stringBuffer.append((String)refFileFilter2.next());
                    while (refFileFilter2.hasNext()) {
                        String string2 = (String)refFileFilter2.next();
                        stringBuffer.append(";");
                        stringBuffer.append(string2);
                    }
                }
                if (stringBuffer.length() <= 0) continue;
                refFileFilter2 = new RefFileFilter(iScriptLanguage.getLanguageName() + " (" + stringBuffer.toString() + ")", stringBuffer.toString(), ";");
                remoteFileChooser.addChoosableFileFilter((FileFilter)refFileFilter2);
                if (!iScriptLanguage.getLanguageName().equalsIgnoreCase(string)) continue;
                refFileFilter = refFileFilter2;
            }
            remoteFileChooser.setAcceptAllFileFilterUsed(true);
            if (refFileFilter != null) {
                remoteFileChooser.setFileFilter((FileFilter)refFileFilter);
            }
        }
    }

    private String getEventSignature(IOutputItem iOutputItem) {
        return AutoscriptEvent.buildEventSignature((String)iOutputItem.getProcedureName(), (OutputItemType)iOutputItem.getType(), (String)iOutputItem.getSubType());
    }

    private ViewerItem getFirstSelectedViewerItem(SpssFrame spssFrame) {
        ViewerItem viewerItem;
        ViewerFrame viewerFrame;
        ViewerItem viewerItem2 = null;
        if (spssFrame instanceof ViewerFrame && (viewerFrame = (ViewerFrame)spssFrame).getDocument() != null && (viewerItem = viewerFrame.getDocument().getFirstSelectedItem()) != null && ViewerDocument.ComponentType.log != viewerItem.getComponentType() && ViewerDocument.ComponentType.title != viewerItem.getComponentType() && ViewerDocument.ComponentType.text != viewerItem.getComponentType()) {
            viewerItem2 = viewerItem;
        }
        return viewerItem2;
    }

    private IScriptFile createScriptFile(File file) {
        int n;
        ScriptFile scriptFile = null;
        IScriptLanguageMgr iScriptLanguageMgr = ScriptLanguageMgr.getInstance();
        IScriptLanguage iScriptLanguage = iScriptLanguageMgr.getDefaultLanguage();
        String string = file.getAbsolutePath();
        String string2 = string.substring((n = string.lastIndexOf(46)) + 1);
        if (string2 != null && !string2.equals("") && (iScriptLanguage = ScriptLanguageMgr.getInstance().getLanguageByExtention(string2)) == null) {
            iScriptLanguage = ScriptLanguageMgr.getInstance().getDefaultLanguage();
        }
        try {
            scriptFile = new ScriptFile(file, iScriptLanguage);
        }
        catch (ScriptingFrameworkException scriptingFrameworkException) {
            scriptingFrameworkException.printStackTrace();
        }
        return scriptFile;
    }
}

