/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.actions.output;

import com.ibm.statistics.lighttable.data.FatTable;
import com.spss.java_client.core.common.OutputItemType;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.documents.output.IOutputItem;
import com.spss.java_client.core.documents.output.lighttable.LightTableItem;
import com.spss.java_client.core.documents.output.table.NotesItem;
import com.spss.java_client.core.documents.output.table.TableItem;
import com.spss.java_client.core.documents.output.table.WarningItem;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.actions.output.OutputContextMenuAction;
import com.spss.java_client.ui.doc_types.output.ConvertToFatTableDlg;
import com.spss.java_client.ui.doc_types.output.LightTableViewerItem;
import com.spss.java_client.ui.doc_types.output.ViewerDocument;
import com.spss.java_client.ui.doc_types.output.ViewerFrame;
import com.spss.java_client.ui.doc_types.output.ViewerItem;
import com.spss.shared.core_tools.utils.ZipUtil;
import com.spss.shared.export.table_look.TableProperties;
import com.spss.uitools.util.CharacterUtil;
import com.spss.uitools.util.TraceSettings;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.prefs.Preferences;

public class ConvertLightTableAction
extends OutputContextMenuAction {
    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 1989, 2013.\n\n";
    }

    public ConvertLightTableAction() {
        super("edit_convert_table");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        SpssFrame spssFrame = this.getFrame((Container)actionEvent.getSource());
        if (spssFrame instanceof ViewerFrame) {
            ViewerFrame viewerFrame = (ViewerFrame)spssFrame;
            this.doConversion(viewerFrame);
        }
    }

    public boolean doConversion(ViewerFrame viewerFrame) {
        ViewerDocument viewerDocument = viewerFrame.getDocument();
        ViewerItem viewerItem = viewerDocument.getFocusedViewerItem();
        if (!(viewerItem instanceof LightTableViewerItem)) {
            return false;
        }
        if (!ConvertToFatTableDlg.runConvertQuery(viewerFrame)) {
            return false;
        }
        LightTableViewerItem lightTableViewerItem = (LightTableViewerItem)viewerItem;
        LightTableItem lightTableItem = lightTableViewerItem.getCoreItem();
        return null != this.doConversion(viewerFrame, lightTableViewerItem, lightTableItem);
    }

    public TableItem doConversion(ViewerFrame viewerFrame, LightTableViewerItem lightTableViewerItem, LightTableItem lightTableItem) {
        File file;
        ViewerDocument viewerDocument = viewerFrame.getDocument();
        FatTable fatTable = lightTableItem.getLightPivotTable().convertToFatTable();
        if (fatTable.getViZml() == null || fatTable.getVdp() == null) {
            TraceSettings.trace1((String)"==> Error converting light table <==", (int)15);
            return null;
        }
        if (lightTableViewerItem != null && lightTableViewerItem.isInEditMode()) {
            lightTableViewerItem.endEdit();
        }
        viewerFrame.getUndoManager().discardAllEdits();
        TableItem tableItem = this.makeFatTableItem(lightTableItem, fatTable);
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs().node("options").node("tables");
        String string = preferences.get("table_look_path", "None");
        if (string.startsWith("'") && string.endsWith("'")) {
            string = CharacterUtil.unSmartQuote((String)string);
        }
        if ((file = new File(string)).exists()) {
            TableProperties tableProperties = TableProperties.createTableProperties((File)file);
            String string2 = String.valueOf(System.currentTimeMillis());
            tableItem.setTableLookId(string2);
            tableItem.setDisplayedTableProperties(tableProperties);
        }
        try {
            tableItem.applyTableLook();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (!viewerDocument.getCoreDocument().insertItem((IOutputItem)tableItem, (IOutputItem)lightTableItem)) {
            return null;
        }
        viewerDocument.getCoreDocument().deleteItem((IOutputItem)lightTableItem);
        return tableItem;
    }

    private TableItem makeFatTableItem(LightTableItem lightTableItem, FatTable fatTable) {
        Object object = lightTableItem.getType() == OutputItemType.NOTE ? new NotesItem() : (lightTableItem.getType() == OutputItemType.WARNING ? new WarningItem() : new TableItem());
        object.setAlignment(lightTableItem.getAlignment());
        object.setAppliedTableLook(false);
        object.setCompressedXML(ByteBuffer.wrap(ZipUtil.compressBytes((byte[])fatTable.getViZml())));
        object.setVDPData(ByteBuffer.wrap(ZipUtil.compressBytes((byte[])fatTable.getVdp())));
        object.setDescription(lightTableItem.getDescription());
        object.setEditable(true);
        object.setPageBreak(lightTableItem.getPageBreak());
        object.setProcedureName(lightTableItem.getProcedureName());
        object.setSelected(true);
        object.setSubType(lightTableItem.getSubType());
        object.setValid(true);
        object.setVDPid(System.currentTimeMillis());
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        object.setVizSourceId(String.valueOf(System.currentTimeMillis()));
        return object;
    }
}

