/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.actions.output;

import com.spss.java_client.core.common.OutputItemType;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.documents.output.IOutputItem;
import com.spss.java_client.core.resources.CoreResUtil;
import com.spss.java_client.core.script.ScriptingFrameworkException;
import com.spss.java_client.core.script.autoscripts.AutoscriptEvent;
import com.spss.java_client.core.script.autoscripts.AutoscriptRegistry;
import com.spss.java_client.core.script.autoscripts.IAutoscriptRegistry;
import com.spss.java_client.core.script.autoscripts.IScriptFile;
import com.spss.java_client.core.script.autoscripts.ScriptFile;
import com.spss.java_client.core.script.engine.IScriptLanguage;
import com.spss.java_client.core.script.engine.IScriptLanguageMgr;
import com.spss.java_client.core.script.engine.ScriptLanguageMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.doc_types.ITopWindow;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.actions.SpssAction;
import com.spss.java_client.ui.doc_types.output.ViewerDocument;
import com.spss.java_client.ui.doc_types.output.ViewerFrame;
import com.spss.java_client.ui.doc_types.output.ViewerItem;
import com.spss.java_client.ui.resources.ResUtil;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.filechooser.FileFilter;

public class AssociateAutoscriptAction
extends SpssAction {
    public AssociateAutoscriptAction() {
        this("utilities_associate_autoscript");
    }

    public AssociateAutoscriptAction(String string) {
        super(string);
        this.configureAction(true);
    }

    @Override
    public boolean getMenuItemEnableStatus(ITopWindow iTopWindow) {
        if (!(iTopWindow instanceof ViewerFrame)) {
            return false;
        }
        return this.hasProperSelections((ViewerFrame)iTopWindow) && this.isAutoscriptingEnabled();
    }

    private boolean isAutoscriptingEnabled() {
        boolean bl = false;
        IScriptLanguageMgr iScriptLanguageMgr = ScriptLanguageMgr.getInstance();
        Vector vector = iScriptLanguageMgr.getAllLanguages();
        if (!vector.isEmpty()) {
            IAutoscriptRegistry iAutoscriptRegistry = AutoscriptRegistry.getInstance();
            bl = iAutoscriptRegistry.isAutoscriptingEnabled();
        }
        return bl;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        block10: {
            SpssFrame spssFrame = this.getFrame((Container)actionEvent.getSource());
            try {
                IScriptLanguageMgr iScriptLanguageMgr = ScriptLanguageMgr.getInstance();
                Vector vector = iScriptLanguageMgr.getAllLanguages();
                IAutoscriptRegistry iAutoscriptRegistry = AutoscriptRegistry.getInstance();
                ViewerItem[] viewerItemArray = this.getSelectedViewerItems(this.getFrame(((Container)actionEvent.getSource()).getParent()));
                if (!vector.isEmpty() && iAutoscriptRegistry != null && viewerItemArray != null && viewerItemArray.length > 0) {
                    for (ViewerItem viewerItemArray2 : viewerItemArray) {
                        String string = this.getEventSignature(viewerItemArray2.getCoreItem());
                        if (string == null || iAutoscriptRegistry.getScriptFile(string) == null) continue;
                        String string2 = ResUtil.getString("ERR_ASSOCIATE_AUTOSCRIPT_CHANGE_QUERY");
                        String string3 = String.format(string2, viewerItemArray.length);
                        int n = SpssAlertOptionPane.showConfirmDialog(spssFrame, string3, VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION);
                        if (n != 3 && n != -1) break;
                        viewerItemArray = null;
                        break;
                    }
                    if (viewerItemArray != null) {
                        RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.OpenFile, RemoteFileChooser.ChooserOption.Script, FileLocationsUtil.getOtherFilesDirectoryPath(), false);
                        remoteFileChooser.setDialogTitle(CoreResUtil.getString((String)"IDS_FILE_CHOOSER_SELECT_AUTOSCRIPT_TITLE"));
                        remoteFileChooser.setApproveButtonText(CoreResUtil.getString((String)"IDS_FILE_CHOOSER_APPLY_BUTTON"));
                        remoteFileChooser.setApproveButtonMnemonic(CoreResUtil.getDlgAccessKey((String)"IDK_FILE_CHOOSER_APPLY_BUTTON"));
                        this.setFileFilters(remoteFileChooser, iScriptLanguageMgr.getDefaultLanguage().getLanguageName());
                        int n = remoteFileChooser.showOpenDialog(this.getFrame(((Container)actionEvent.getSource()).getParent()));
                        if (n == 0) {
                            FileLocationsUtil.setOtherFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
                            IScriptFile iScriptFile = this.createScriptFile(remoteFileChooser.getSelectedFile());
                            if (iScriptFile != null) {
                                for (ViewerItem viewerItem : viewerItemArray) {
                                    String string = this.getEventSignature(viewerItem.getCoreItem());
                                    if (string == null) continue;
                                    iAutoscriptRegistry.setScriptFile(string, iScriptFile);
                                }
                                iAutoscriptRegistry.writeToPersistentStore();
                            }
                        }
                    }
                } else if (vector.isEmpty()) {
                    SpssAlertOptionPane.showErrorMessageDialog(spssFrame, ResUtil.getString("ERR_NO_SCRIPTING_LANGUAGE_AVAILABLE_TO_EDIT"), VersionInfo.getAppVersionString());
                }
            }
            catch (Exception exception) {
                if (exception.getMessage() == null) break block10;
                SpssAlertOptionPane.showErrorMessageDialog(spssFrame, exception.getMessage(), VersionInfo.getAppVersionString());
            }
        }
    }

    private void setFileFilters(RemoteFileChooser remoteFileChooser, String string) {
        IScriptLanguageMgr iScriptLanguageMgr = ScriptLanguageMgr.getInstance();
        Vector vector = iScriptLanguageMgr.getAllLanguages();
        if (!vector.isEmpty()) {
            RefFileFilter refFileFilter = null;
            for (IScriptLanguage iScriptLanguage : vector) {
                RefFileFilter refFileFilter2;
                Vector vector2 = iScriptLanguage.getFileExtensions();
                StringBuffer stringBuffer = new StringBuffer();
                if (vector2.size() != 0) {
                    refFileFilter2 = iScriptLanguage.getFileExtensions().iterator();
                    stringBuffer.append((String)refFileFilter2.next());
                    while (refFileFilter2.hasNext()) {
                        String string2 = (String)refFileFilter2.next();
                        stringBuffer.append(";");
                        stringBuffer.append(string2);
                    }
                }
                if (stringBuffer.length() <= 0) continue;
                refFileFilter2 = new RefFileFilter(iScriptLanguage.getLanguageName() + " (" + stringBuffer.toString() + ")", stringBuffer.toString(), ";");
                remoteFileChooser.addChoosableFileFilter((FileFilter)refFileFilter2);
                if (!iScriptLanguage.getLanguageName().equalsIgnoreCase(string)) continue;
                refFileFilter = refFileFilter2;
            }
            remoteFileChooser.setAcceptAllFileFilterUsed(true);
            if (refFileFilter != null) {
                remoteFileChooser.setFileFilter((FileFilter)refFileFilter);
            }
        }
    }

    private String getEventSignature(IOutputItem iOutputItem) {
        return AutoscriptEvent.buildEventSignature((String)iOutputItem.getProcedureName(), (OutputItemType)iOutputItem.getType(), (String)iOutputItem.getSubType());
    }

    private ViewerItem[] getSelectedViewerItems(SpssFrame spssFrame) {
        ViewerFrame viewerFrame;
        ViewerItem[] viewerItemArray = null;
        if (spssFrame instanceof ViewerFrame && (viewerFrame = (ViewerFrame)spssFrame).getDocument() != null && (viewerItemArray = viewerFrame.getDocument().getSelectedItems(false)) != null) {
            for (ViewerItem viewerItem : viewerItemArray) {
                if (ViewerDocument.ComponentType.log != viewerItem.getComponentType() && ViewerDocument.ComponentType.title != viewerItem.getComponentType() && ViewerDocument.ComponentType.text != viewerItem.getComponentType()) continue;
                viewerItemArray = null;
                break;
            }
        }
        return viewerItemArray;
    }

    private boolean hasProperSelections(SpssFrame spssFrame) {
        if (!(spssFrame instanceof ViewerFrame)) {
            return false;
        }
        int n = 0;
        ViewerFrame viewerFrame = (ViewerFrame)spssFrame;
        if (viewerFrame.getDocument() == null) {
            return false;
        }
        Vector<ViewerItem> vector = viewerFrame.getDocument().getViewerItems();
        for (ViewerItem viewerItem : vector) {
            if (!viewerItem.isSelected()) continue;
            if (ViewerDocument.ComponentType.log == viewerItem.getComponentType() || ViewerDocument.ComponentType.title == viewerItem.getComponentType() || ViewerDocument.ComponentType.text == viewerItem.getComponentType()) {
                return false;
            }
            ++n;
        }
        return n > 0;
    }

    private IScriptFile createScriptFile(File file) {
        int n;
        ScriptFile scriptFile = null;
        IScriptLanguageMgr iScriptLanguageMgr = ScriptLanguageMgr.getInstance();
        IScriptLanguage iScriptLanguage = iScriptLanguageMgr.getDefaultLanguage();
        String string = file.getAbsolutePath();
        String string2 = string.substring((n = string.lastIndexOf(46)) + 1);
        if (string2 != null && !string2.equals("") && (iScriptLanguage = ScriptLanguageMgr.getInstance().getLanguageByExtention(string2)) == null) {
            iScriptLanguage = ScriptLanguageMgr.getInstance().getDefaultLanguage();
        }
        try {
            scriptFile = new ScriptFile(file, iScriptLanguage);
        }
        catch (ScriptingFrameworkException scriptingFrameworkException) {
            scriptingFrameworkException.printStackTrace();
        }
        return scriptFile;
    }
}

