/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.actions.data;

import com.spss.java_client.ui.doc_types.ITopWindow;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.actions.SpssAction;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.doc_types.data.DataView;
import com.spss.java_client.ui.doc_types.syntax.SyntaxFrame;
import com.spss.java_client.ui.doc_types.syntax.SyntaxView;
import com.spss.java_client.ui.resources.ResUtil;
import java.awt.Container;
import java.awt.event.ActionEvent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JToggleButton;

public class WndSplitAction
extends SpssAction {
    public static final String REMOVE_SPLIT = ResUtil.getString("window_remove");

    public WndSplitAction() {
        this("window_split");
    }

    public WndSplitAction(String string) {
        super(string);
        this.configureAction(true);
    }

    @Override
    public void updateMenuText(JMenuItem jMenuItem) {
        SpssFrame spssFrame = this.getFrame(jMenuItem.getParent());
        if (spssFrame instanceof DataFrame) {
            this.isDataDividerOn((DataFrame)spssFrame);
        } else if (spssFrame instanceof SyntaxFrame) {
            this.updateSyntaxDividerText(this.isSyntaxDividerOn((SyntaxFrame)spssFrame));
        }
    }

    @Override
    public boolean getMenuItemCheckStatus(SpssFrame spssFrame) {
        boolean bl = false;
        if (spssFrame instanceof SyntaxFrame) {
            bl = this.isSyntaxDividerOn((SyntaxFrame)spssFrame);
        }
        return bl;
    }

    private void isDataDividerOn(DataFrame dataFrame) {
        DataView dataView = dataFrame.getDataView();
        String string = ResUtil.getString(this.mActionId);
        if (dataView.isDividerOn()) {
            string = REMOVE_SPLIT;
            this.putValue("Name", string);
        } else {
            this.putValue("Name", string);
        }
    }

    private boolean isSyntaxDividerOn(SyntaxFrame syntaxFrame) {
        boolean bl = false;
        SyntaxView syntaxView = syntaxFrame.getSyntaxView();
        if (syntaxView.isDividerOn()) {
            bl = true;
        }
        return bl;
    }

    private void updateSyntaxDividerText(boolean bl) {
        String string = ResUtil.getString(this.mActionId);
        if (bl) {
            bl = true;
            string = ResUtil.getString("window_remove");
            this.putValue("Name", string);
        } else {
            this.putValue("Name", string);
        }
    }

    @Override
    public boolean getMenuItemEnableStatus(ITopWindow iTopWindow) {
        boolean bl = false;
        if (iTopWindow instanceof DataFrame) {
            DataFrame dataFrame = (DataFrame)iTopWindow;
            DataView dataView = dataFrame.getDataView();
            if (dataView != null && dataView.getActiveView() == 0) {
                bl = true;
            }
            return bl;
        }
        return iTopWindow instanceof SyntaxFrame;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        SpssFrame spssFrame = this.getFrame((Container)actionEvent.getSource());
        if (spssFrame instanceof DataFrame) {
            this.toggleDataDivider((DataFrame)spssFrame);
        } else if (spssFrame instanceof SyntaxFrame) {
            Object object = actionEvent.getSource();
            boolean bl = object instanceof JToggleButton ? ((JToggleButton)object).isSelected() : !((String)this.getValue("Name")).equalsIgnoreCase(REMOVE_SPLIT);
            ((SyntaxFrame)spssFrame).doSyntaxDivider(bl);
        }
    }

    private void toggleDataDivider(JFrame jFrame) {
        DataView dataView;
        DataFrame dataFrame = (DataFrame)jFrame;
        dataView.showDivider(!(dataView = dataFrame.getDataView()).isDividerOn());
    }
}

