/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.actions.data;

import com.spss.java_client.core.documents.syntax.SyntaxMgr;
import com.spss.java_client.ui.dialogs.documents.data.SaveVariableOrderDlg;
import com.spss.java_client.ui.doc_types.ITopWindow;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.actions.SpssAction;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.doc_types.data.DataView;
import com.spss.java_client.ui.doc_types.data.VarViewTable;
import com.spss.java_client.ui.doc_types.data.VarViewTableModel;
import java.awt.Container;
import java.awt.event.ActionEvent;
import javax.swing.JTable;

public class SortDataAction
extends SpssAction {
    private boolean mSortAscending;

    public SortDataAction(String string) {
        super(string);
        this.mSortAscending = string.equals("context_sort_ascend");
        this.configureAction(false);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        SpssFrame spssFrame = this.getFrame((Container)actionEvent.getSource());
        if (spssFrame instanceof DataFrame) {
            DataFrame dataFrame = (DataFrame)spssFrame;
            DataView dataView = dataFrame.getDataView();
            if (dataView.getActiveView() == 0) {
                this.doDataViewSort(dataFrame);
            } else {
                this.doVariableViewSort(dataFrame);
            }
        }
    }

    private void doDataViewSort(DataFrame dataFrame) {
        int[] nArray;
        DataView dataView = dataFrame.getDataView();
        StringBuffer stringBuffer = new StringBuffer("SORT CASES BY");
        StringBuffer stringBuffer2 = new StringBuffer();
        String string = this.mSortAscending ? "(A)" : "(D)";
        int n = dataView.getDataSrc().columnCount();
        JTable jTable = dataView.getDataTables()[0];
        for (int n2 : nArray = jTable.getSelectedColumns()) {
            if (n <= n2) continue;
            stringBuffer2.append(" ").append(jTable.getColumnModel().getColumn(n2).getHeaderValue().toString());
            stringBuffer2.append(" ").append(string);
        }
        if (stringBuffer2.length() > 0) {
            stringBuffer.append(stringBuffer2).append(".\n");
            SyntaxMgr.getSyntaxMgr().executeSyntax(stringBuffer.toString());
        }
        dataFrame.getUndoManager().discardAllEdits();
        dataFrame.updateToolbarEnableStatus();
    }

    private void doVariableViewSort(DataFrame dataFrame) {
        VarViewTable varViewTable = (VarViewTable)dataFrame.getDataView().getDataTable(1);
        int n = varViewTable.getSelectedColumn();
        if (n < 0) {
            return;
        }
        SaveVariableOrderDlg saveVariableOrderDlg = new SaveVariableOrderDlg(dataFrame);
        saveVariableOrderDlg.setVisible(true);
        if (saveVariableOrderDlg.okToProceed()) {
            VarViewTableModel varViewTableModel = (VarViewTableModel)varViewTable.getModel();
            if (n < 0) {
                return;
            }
            String string = varViewTableModel.columnIndexToColumnId(n);
            if (string == null) {
                return;
            }
            String string2 = string.startsWith("@") ? "ATTRIBUTE " + string.substring(1) : string.toUpperCase();
            if (string2.equals("TYPE")) {
                string2 = "FORMAT";
            }
            String string3 = "SORT VARIABLES BY " + string2 + (this.mSortAscending ? " (A)" : " (D)") + ".\n";
            SyntaxMgr.getSyntaxMgr().executeSyntax(string3);
            dataFrame.getUndoManager().discardAllEdits();
            dataFrame.updateToolbarEnableStatus();
        }
    }

    @Override
    public boolean getMenuItemEnableStatus(ITopWindow iTopWindow) {
        return iTopWindow instanceof DataFrame;
    }
}

