/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.actions.data;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.ICoreDocument;
import com.spss.java_client.core.documents.MRUMgr;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.syntax.SyntaxMgr;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.actions.SpssAction;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.doc_types.doc_util.DocUtil;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;

public class SaveAllDataAction
extends SpssAction {
    public SaveAllDataAction() {
        this("file_save_all_data");
    }

    public SaveAllDataAction(String string) {
        super(string);
        this.configureAction(true);
    }

    public boolean getMenuItemEnableStatus(SpssFrame spssFrame) {
        if (spssFrame instanceof DataFrame) {
            DataFrame dataFrame = (DataFrame)spssFrame;
            return dataFrame.getDataView().getDataRowCount() > 0L;
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        LocallyUniqueId locallyUniqueId = DataMgr.getDataMgr().getActiveBackendDocumentId();
        SpssFrame[] spssFrameArray = SpssFrameMgr.getSpssFrameMgr().getOpenDocuments();
        boolean bl = false;
        for (SpssFrame spssFrame : spssFrameArray) {
            ICoreDocument iCoreDocument;
            if (!spssFrame.docType().equals((Object)DocType.DE_DOC) || (iCoreDocument = spssFrame.getCoreDocument()) == null || !iCoreDocument.getModifiedFlag()) continue;
            File file = iCoreDocument.getFileSpec();
            if (file == null) {
                bl = true;
            }
            DataFrame dataFrame = (DataFrame)spssFrame;
            String string = "DATASET ACTIVATE " + dataFrame.getDatasetName() + ".\n";
            SyntaxMgr.getSyntaxMgr().executeSyntax(string);
            SpssFrameMgr.getSpssFrameMgr().designateWindow(dataFrame);
            spssFrame.updateToolbarEnableStatus();
            if (bl ? !this.dataFileSaveAs(dataFrame) : !this.dataFileSave(dataFrame)) break;
        }
        DataFrame dataFrame = SpssFrameMgr.getSpssFrameMgr().getDataFrame(locallyUniqueId);
        String string = ((DataFrame)dataFrame).getDatasetName();
        String string2 = "DATASET ACTIVATE " + string + ".\n";
        SyntaxMgr.getSyntaxMgr().executeSyntax(string2);
        SpssFrameMgr.getSpssFrameMgr().designateWindow(dataFrame);
        dataFrame.updateToolbarEnableStatus();
    }

    private boolean dataFileSave(DataFrame dataFrame) {
        return DocUtil.saveCoreDocument(dataFrame);
    }

    private boolean dataFileSaveAs(DataFrame dataFrame) {
        boolean bl = true;
        ICoreDocument iCoreDocument = dataFrame.getCoreDocument();
        RemoteFileChooser remoteFileChooser = DocUtil.getDocTypeFileChooser(RemoteFileChooser.ChooserType.SaveFile, dataFrame.docType());
        int n = remoteFileChooser.showSaveDialog(dataFrame, dataFrame.getDatasetName());
        if (n != 0) {
            return false;
        }
        if (iCoreDocument != null) {
            try {
                File file = remoteFileChooser.getSelectedFile();
                if (iCoreDocument.saveDocument(file, remoteFileChooser.isPasteSelected())) {
                    if (dataFrame.docType().equals((Object)DocType.DE_DOC)) {
                        MRUMgr.getMRUMgr().addDataDocumentPath(file.getPath());
                    } else {
                        MRUMgr.getMRUMgr().addOtherDocumentPath(file.getCanonicalPath());
                    }
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return bl;
    }
}

