/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.actions.data;

import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.core.documents.syntax.SyntaxMgr;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.doc_types.ITopWindow;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.actions.SpssAction;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.doc_types.data.DataView;
import com.spss.java_client.ui.doc_types.data.DataViewTable;
import com.spss.java_client.ui.doc_types.data.DataViewTableModel;
import com.spss.java_client.ui.doc_types.data.VarViewTable;
import com.spss.java_client.ui.doc_types.output.ViewerFrame;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import javax.swing.JTable;

public class QuickDescriptivesAction
extends SpssAction {
    private int VAR_TYPE_STRING_UNKNOWN_NOMINAL = 0;
    private int VAR_TYPE_NUMERIC_UNKNOWN_NOMINAL = 1;
    private int VAR_TYPE_ORDINAL_NOMINAL = 2;
    private int VAR_TYPE_SCALE = 3;
    private ArrayList[] mVarLists = new ArrayList[this.VAR_TYPE_SCALE + 1];

    public QuickDescriptivesAction() {
        super("context_data_descriptives");
        this.configureAction(false);
        for (int i = 0; i < this.mVarLists.length; ++i) {
            this.mVarLists[i] = new ArrayList();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ViewerFrame viewerFrame;
        String string = this.generateQuickSyntax(actionEvent);
        SyntaxMgr.getSyntaxMgr().executeSyntax(string);
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs().node("options").node("general");
        if (preferences.getBoolean("raise_viewer_window", true) && SpssFrameMgr.getSpssFrameMgr().openDocumentCount(DocType.OUTPUT_DOC) > 0 && (viewerFrame = (ViewerFrame)SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.OUTPUT_DOC)) != null) {
            if (viewerFrame.getExtendedState() != 6) {
                viewerFrame.setExtendedState(0);
            }
            viewerFrame.toFront();
        }
    }

    @Override
    public boolean getMenuItemEnableStatus(ITopWindow iTopWindow) {
        JTable jTable;
        DataView dataView;
        boolean bl = false;
        if (iTopWindow instanceof DataFrame && (dataView = ((DataFrame)iTopWindow).getDataView()) != null && (jTable = dataView.getDataTable(dataView.getActiveView())) != null && dataView.getDataSrc() != null) {
            int n = dataView.getDataSrc().columnCount();
            bl = this.hasValidSelection(jTable, n);
        }
        return bl;
    }

    protected void initVariableLists(ActionEvent actionEvent) {
        block2: {
            int[] nArray;
            JTable jTable;
            DataView dataView;
            block3: {
                this.clearVarLists();
                SpssFrame spssFrame = this.getFrame((Container)actionEvent.getSource());
                DataFrame dataFrame = (DataFrame)spssFrame;
                dataView = dataFrame.getDataView();
                if (dataView == null) break block2;
                jTable = dataView.getDataTable(dataView.getActiveView());
                int[] nArray2 = jTable.getSelectedColumns();
                nArray = jTable.getSelectedRows();
                if (!(jTable instanceof DataViewTable)) break block3;
                DataViewTableModel dataViewTableModel = (DataViewTableModel)jTable.getModel();
                ISpssDataSrc iSpssDataSrc = dataViewTableModel.getDataSource();
                for (int n : nArray2) {
                    ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(n);
                    this.addVarToVarLists(iSpssVariable);
                }
                break block2;
            }
            if (!(jTable instanceof VarViewTable)) break block2;
            for (int n : nArray) {
                ISpssVariable iSpssVariable = dataView.getDataSrc().getVariable(n);
                this.addVarToVarLists(iSpssVariable);
            }
        }
    }

    protected void clearVarLists() {
        for (ArrayList arrayList : this.mVarLists) {
            arrayList.clear();
        }
    }

    protected void addVarToVarLists(ISpssVariable iSpssVariable) {
        if (iSpssVariable == null) {
            return;
        }
        MeasurementLevel measurementLevel = iSpssVariable.getMeasurementLevel();
        short s = iSpssVariable.getType();
        int n = 0;
        if (measurementLevel == MeasurementLevel.unknown || measurementLevel == MeasurementLevel.nominal) {
            n = s == 0 ? this.VAR_TYPE_NUMERIC_UNKNOWN_NOMINAL : this.VAR_TYPE_STRING_UNKNOWN_NOMINAL;
        } else if (measurementLevel == MeasurementLevel.ordinal) {
            n = this.VAR_TYPE_ORDINAL_NOMINAL;
        } else if (measurementLevel == MeasurementLevel.scale) {
            n = this.VAR_TYPE_SCALE;
        }
        this.mVarLists[n].add(iSpssVariable);
    }

    private StringBuffer getVarList(ArrayList arrayList) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!(arrayList.get(i) instanceof ISpssVariable)) continue;
            stringBuffer.append(((ISpssVariable)arrayList.get(i)).getName());
            if (i >= arrayList.size() - 1) continue;
            stringBuffer.append(" ");
        }
        return stringBuffer;
    }

    private String generateQuickSyntax(ActionEvent actionEvent) {
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs().node("options").node("output_labels");
        this.initVariableLists(actionEvent);
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        if (!this.isVarListsEmpty()) {
            for (int i = 0; i < this.mVarLists.length; ++i) {
                if (this.mVarLists[i].isEmpty()) continue;
                StringBuffer stringBuffer2 = this.getVarList(this.mVarLists[i]);
                this.makeFreqenciesSyntax(stringBuffer, preferences, stringBuffer2, i);
            }
        }
        return stringBuffer.toString();
    }

    private boolean isVarListsEmpty() {
        boolean bl = true;
        for (ArrayList arrayList : this.mVarLists) {
            if (arrayList.isEmpty()) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private void makeFreqenciesSyntax(StringBuffer stringBuffer, Preferences preferences, StringBuffer stringBuffer2, int n) {
        stringBuffer.append(SyntaxUtil.getMainCommand("FREQUENCIES"));
        stringBuffer.append(SyntaxUtil.getMainCommandParamters("VARIABLES="));
        stringBuffer.append(stringBuffer2);
        if (n == this.VAR_TYPE_NUMERIC_UNKNOWN_NOMINAL) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/STATISTICS=RANGE MINIMUM MAXIMUM MODE"));
        } else if (n == this.VAR_TYPE_ORDINAL_NOMINAL) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/STATISTICS=RANGE MINIMUM MAXIMUM MEDIAN MEAN MODE"));
        } else if (n == this.VAR_TYPE_SCALE) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/STATISTICS=RANGE MINIMUM MAXIMUM STDDEV MEAN MEDIAN"));
        }
        Boolean bl = preferences.getBoolean("descriptives_suppress_tables", true);
        if (bl != null && bl.booleanValue() && n == this.VAR_TYPE_SCALE) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/FORMAT=NOTABLE"));
        }
        if ((bl = Boolean.valueOf(preferences.getBoolean("descriptives_include_chart", false))) != null && bl.booleanValue()) {
            stringBuffer.append("\n");
            if (n == this.VAR_TYPE_SCALE) {
                stringBuffer.append(SyntaxUtil.getSubCommand("/HISTOGRAM NORMAL "));
            } else {
                stringBuffer.append(SyntaxUtil.getSubCommand("/BARCHART FREQ "));
            }
        }
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/ORDER=ANALYSIS"));
        stringBuffer.append(SyntaxUtil.terminateSyntax());
    }

    private boolean hasValidSelection(JTable jTable, int n) {
        boolean bl = false;
        if (jTable instanceof DataViewTable) {
            int[] nArray = jTable.getSelectedColumns();
            if (nArray.length == jTable.getColumnCount()) {
                return false;
            }
            bl = this.hasValidIndex(nArray, n);
        } else if (jTable instanceof VarViewTable) {
            int[] nArray = jTable.getSelectedRows();
            if (nArray.length == jTable.getRowCount()) {
                return false;
            }
            bl = this.hasValidIndex(nArray, n);
        }
        return bl;
    }

    private boolean hasValidIndex(int[] nArray, int n) {
        boolean bl = false;
        for (int n2 : nArray) {
            if (n2 >= n) continue;
            bl = true;
            break;
        }
        return bl;
    }
}

