/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.actions.data;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.comp_util.OutDataStream;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.server.IDataStream;
import com.spss.java_client.ui.dialogs.base.edit.PasteVariablesDlg;
import com.spss.java_client.ui.doc_types.ITopWindow;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.actions.SpssAction;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.doc_types.data.DataView;
import com.spss.java_client.ui.doc_types.data.VarViewTable;
import com.spss.java_client.ui.doc_types.data.serialize.DataSerializer;
import com.spss.java_client.ui.doc_types.data.serialize.DataSerializerPasteVariables;
import com.spss.uitools.util.TraceSettings;
import java.awt.Container;
import java.awt.event.ActionEvent;
import javax.swing.JTable;

public class PasteVariablesAction
extends SpssAction {
    private DataSerializerPasteVariables mSerializer;

    public PasteVariablesAction(String string) {
        super(string);
        this.configureAction(true);
        this.mSerializer = new DataSerializerPasteVariables();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        SpssFrame spssFrame = this.getFrame(((Container)actionEvent.getSource()).getParent());
        PasteVariablesDlg pasteVariablesDlg = new PasteVariablesDlg(spssFrame);
        ISpssVariable iSpssVariable = this.mSerializer.getCopiedItems().get(0);
        pasteVariablesDlg.getVariableNameTextField().setText(iSpssVariable.getName());
        DataView dataView = ((DataFrame)spssFrame).getDataView();
        VarViewTable varViewTable = (VarViewTable)dataView.getDataTable(1);
        pasteVariablesDlg.getNumberOfVarsCreated().setText("" + varViewTable.getSelectedRowCount());
        pasteVariablesDlg.setVisible(true);
        if (pasteVariablesDlg.isOkPressed()) {
            PasteVariablesDlg.DataModel dataModel = pasteVariablesDlg.getData();
            int n = dataModel.getNoOfVariablesToCreate();
            int n2 = dataModel.getVariableSuffix();
            String string = dataModel.getVarName();
            OutDataStream outDataStream = new OutDataStream();
            outDataStream.setCharSetName(ComponentState.getCurrentCharsetName());
            outDataStream.process(DataSerializer.SelectionType.VAR_ROWS.name());
            outDataStream.process(n);
            for (int i = 0; i < n; ++i) {
                ISpssVariable iSpssVariable2;
                try {
                    iSpssVariable2 = iSpssVariable.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    TraceSettings.trace1((String)cloneNotSupportedException.getMessage(), (int)15);
                    return;
                }
                iSpssVariable2.setName(string + n2++);
                iSpssVariable2.serialize((IDataStream)outDataStream);
            }
            DataSerializer.VariableRows variableRows = new DataSerializer.VariableRows(outDataStream.getStreamAsBytes());
            outDataStream.reset();
            this.mSerializer.deserializeVariableViewSelection(varViewTable, variableRows);
        }
    }

    @Override
    public boolean getMenuItemEnableStatus(ITopWindow iTopWindow) {
        if (iTopWindow instanceof DataFrame) {
            DataFrame dataFrame = (DataFrame)iTopWindow;
            DataView dataView = dataFrame.getDataView();
            int n = dataView.getActiveView();
            JTable jTable = dataView.getDataTable(1);
            if (n == 1 && jTable.getSelectedColumnCount() == jTable.getColumnCount()) {
                int n2 = 0;
                if (DataSerializer.varRowsAvailable()) {
                    n2 = this.mSerializer.numberOfElementsSelected(DataSerializer.VAR_ROW_FLAVOR);
                } else if (DataSerializer.dataColsAvailable()) {
                    n2 = this.mSerializer.numberOfElementsSelected(DataSerializer.DATA_COL_FLAVOR);
                } else if (DataSerializer.dataColsAvailable()) {
                    n2 = this.mSerializer.numberOfElementsSelected(DataSerializer.DATA_COL_FLAVOR);
                }
                return n2 == 1;
            }
        }
        return false;
    }
}

