/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.actions.data;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.comp_util.RemoteFileStatus;
import com.spss.java_client.core.comp_util.RemoteFileSysUtil;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.ICoreDocument;
import com.spss.java_client.core.documents.MRUMgr;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.syntax.SyntaxMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.doc_types.ITopWindow;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.actions.SpssAction;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.doc_types.doc_util.DocUtil;
import com.spss.java_client.ui.resources.ResUtil;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;

public class MarkReadOnlyAction
extends SpssAction {
    private RemoteFileStatus mRemoteFileStatus = null;
    private String mLastFileSpecChecked = "##_old_##";

    public MarkReadOnlyAction() {
        this("file_read_only_data");
    }

    public MarkReadOnlyAction(String string) {
        super(string);
        this.configureAction(true);
    }

    @Override
    public void updateMenuText(JMenuItem jMenuItem) {
        SpssFrame spssFrame = this.getFrame(jMenuItem.getParent());
        if (!(spssFrame instanceof DataFrame)) {
            return;
        }
        DataFrame dataFrame = (DataFrame)spssFrame;
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(dataFrame.getDatasetId());
        if (iSpssDataSrc != null) {
            String string = ResUtil.getString(this.mActionId);
            if (!this.isFileReadOnly(iSpssDataSrc.getFileSpec())) {
                this.putValue("Name", string);
            } else {
                this.putValue("Name", ResUtil.getString("IDS_READ_WRITE"));
            }
        }
    }

    @Override
    public boolean getMenuItemEnableStatus(ITopWindow iTopWindow) {
        if (!(iTopWindow instanceof DataFrame)) {
            return false;
        }
        boolean bl = false;
        DataFrame dataFrame = (DataFrame)iTopWindow;
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(dataFrame.getDatasetId());
        if (iSpssDataSrc != null && iSpssDataSrc.getFileSpec().length() > 0) {
            RemoteFileSysUtil remoteFileSysUtil;
            boolean bl2 = false;
            if (this.mLastFileSpecChecked.equals(iSpssDataSrc.getFileSpec())) {
                bl2 = true;
            } else {
                this.mLastFileSpecChecked = iSpssDataSrc.getFileSpec();
                remoteFileSysUtil = RemoteFileSysUtil.getRemoteFileSysUtil();
                this.mRemoteFileStatus = remoteFileSysUtil.validateFile(iSpssDataSrc.getFileSpec());
                boolean bl3 = bl2 = !this.mRemoteFileStatus.errorOccurred();
            }
            if (bl2 && !(remoteFileSysUtil = this.mRemoteFileStatus.getFileStatus()).equals((Object)RemoteFileStatus.FileNodeStatus.RFS_DOES_NOT_EXIST)) {
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        SpssFrame spssFrame = this.getFrame(((Container)actionEvent.getSource()).getParent());
        if (!(spssFrame instanceof DataFrame)) {
            return;
        }
        final DataFrame dataFrame = (DataFrame)spssFrame;
        dataFrame.commitEdit();
        final ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(dataFrame.getDatasetId());
        if (iSpssDataSrc != null) {
            if (iSpssDataSrc.isModified() && !this.isFileReadOnly(iSpssDataSrc.getFileSpec())) {
                int n = SpssAlertOptionPane.showConfirmDialog(dataFrame, ResUtil.getCommonDlgString("ERR_SAVE_FIRST_MSG"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eQuestion, SpssAlertOptionPane.OptionType.YES_NO_CANCEL_OPTION);
                switch (n) {
                    case 1: {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ICoreDocument iCoreDocument = dataFrame.getCoreDocument();
                                RemoteFileChooser remoteFileChooser = DocUtil.getDocTypeFileChooser(RemoteFileChooser.ChooserType.SaveFile, dataFrame.docType());
                                String string = iCoreDocument.getDocName();
                                remoteFileChooser.setDialogType(1);
                                int n = remoteFileChooser.showDialog(dataFrame, null, string);
                                if (n == 0 && iCoreDocument != null) {
                                    try {
                                        File file = remoteFileChooser.getSelectedFile();
                                        if (iCoreDocument.saveDocument(file, remoteFileChooser.isPasteSelected())) {
                                            if (dataFrame.docType().equals((Object)DocType.DE_DOC)) {
                                                MRUMgr.getMRUMgr().addDataDocumentPath(file.getPath());
                                            } else {
                                                MRUMgr.getMRUMgr().addOtherDocumentPath(file.getCanonicalPath());
                                            }
                                            dataFrame.updateToolbarEnableStatus();
                                            MarkReadOnlyAction.this.doSyntax(iSpssDataSrc);
                                        }
                                    }
                                    catch (IOException iOException) {
                                        iOException.printStackTrace();
                                    }
                                }
                            }
                        });
                        break;
                    }
                    case 2: {
                        this.doSyntax(iSpssDataSrc);
                        break;
                    }
                }
            } else {
                this.doSyntax(iSpssDataSrc);
                this.mLastFileSpecChecked = "##_old_##";
            }
        }
    }

    private void doSyntax(ISpssDataSrc iSpssDataSrc) {
        String string;
        String string2 = this.GeneratePermissionsSyntax(string, !this.isFileReadOnly(string = iSpssDataSrc.getFileSpec()));
        SyntaxMgr.getSyntaxMgr().executeSyntax(string2);
    }

    private String GeneratePermissionsSyntax(String string, boolean bl) {
        String string2 = "PERMISSIONS FILE = ";
        char c = '\'';
        string2 = string2 + c;
        string2 = string2 + string;
        string2 = string2 + c;
        string2 = string2 + " /PERMISSIONS ";
        string2 = bl ? string2 + "READONLY." : string2 + "WRITEABLE.";
        return string2;
    }

    private boolean isFileReadOnly(String string) {
        boolean bl = false;
        if (this.mLastFileSpecChecked.equals(string)) {
            bl = true;
        } else {
            this.mLastFileSpecChecked = string;
            RemoteFileSysUtil remoteFileSysUtil = RemoteFileSysUtil.getRemoteFileSysUtil();
            this.mRemoteFileStatus = remoteFileSysUtil.validateFile(string);
            bl = !this.mRemoteFileStatus.errorOccurred();
        }
        boolean bl2 = false;
        if (bl) {
            RemoteFileStatus.FileNodeStatus fileNodeStatus = this.mRemoteFileStatus.getFileStatus();
            RemoteFileStatus.FileNodeStatus fileNodeStatus2 = this.mRemoteFileStatus.getParentDirStatus();
            if (fileNodeStatus.equals((Object)RemoteFileStatus.FileNodeStatus.RFS_READ_ONLY) || fileNodeStatus2.equals((Object)RemoteFileStatus.FileNodeStatus.RFS_READ_ONLY)) {
                bl2 = true;
            }
        }
        return bl2;
    }
}

