/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.actions.data;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.ui.doc_types.ITopWindow;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.actions.SpssAction;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.doc_types.data.DataView;
import com.spss.java_client.ui.doc_types.data.VarViewTable;
import com.spss.java_client.ui.doc_types.data.undo.VariableInsertEdit;
import java.awt.Container;
import java.awt.event.ActionEvent;
import javax.swing.JTable;

public class InsertVariablesAction
extends SpssAction {
    public InsertVariablesAction(String string) {
        super(string);
        this.configureAction(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        SpssFrame spssFrame = this.getFrame((Container)actionEvent.getSource());
        if (spssFrame instanceof DataFrame) {
            int[] nArray;
            DataFrame dataFrame = (DataFrame)spssFrame;
            DataView dataView = dataFrame.getDataView();
            if (!dataView.canAddNewVariable()) {
                return;
            }
            boolean bl = dataView.getActiveView() == 0;
            int n = dataView.getDataSrc().columnCount();
            JTable jTable = dataView.getDataTables()[0];
            if (bl) {
                nArray = jTable.getSelectedColumns();
            } else {
                nArray = jTable.getSelectedRows();
                dataView.selectNewVarRow(true);
            }
            if (nArray.length > 0) {
                if (nArray[0] >= n) {
                    int n2 = nArray[0] - n + 1;
                    if (!dataFrame.checkDataLimit(false, n2)) {
                        return;
                    }
                    new VariableInsertEdit(spssFrame.getUndoManager(), dataView.getDataSrc(), n, n2, 0);
                } else {
                    if (!dataFrame.checkDataLimit(false, 1L)) {
                        return;
                    }
                    new VariableInsertEdit(spssFrame.getUndoManager(), dataView.getDataSrc(), nArray[0], 1, 0);
                }
            } else {
                ComponentState.trace1((String)"No rows/columns selected for insertion", (int)15);
            }
        }
    }

    @Override
    public boolean getMenuItemEnableStatus(ITopWindow iTopWindow) {
        boolean bl = false;
        JTable jTable = null;
        if (iTopWindow instanceof DataFrame) {
            DataView dataView = ((DataFrame)iTopWindow).getDataView();
            if (dataView != null) {
                jTable = dataView.getActiveView() == 0 ? dataView.getDataTables()[0] : (VarViewTable)dataView.getDataTable(1);
            }
            if (jTable != null) {
                int[] nArray = jTable.getSelectedColumns();
                bl = nArray.length > 0;
            }
        }
        return bl;
    }
}

