/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.actions;

import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.doc_types.ITopWindow;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.actions.SpssAction;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.shared.core_tools.system.OSInfo;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.FocusManager;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenuItem;

public class WindowMenuAction
extends SpssAction {
    private JFrame mFrame;

    public WindowMenuAction(JFrame jFrame, int n) {
        super("window_document");
        this.mFrame = jFrame;
        Integer n2 = n + 1;
        this.putValue("Name", String.format("%d %s", n2, this.mFrame.getTitle()));
        if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
            this.putValue("MnemonicKey", 48 + n2);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.mFrame.getState() == 1) {
            this.mFrame.setState(0);
        }
        if (!this.mFrame.isVisible()) {
            this.mFrame.setVisible(true);
        }
        this.mFrame.toFront();
    }

    @Override
    public JMenuItem getMenuItem() {
        return new JCheckBoxMenuItem(this);
    }

    public boolean getMenuItemCheckStatus() {
        Window window = FocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
        return this.mFrame == window;
    }

    @Override
    public boolean getMenuItemCheckStatus(SpssFrame spssFrame) {
        return this.getMenuItemCheckStatus();
    }

    @Override
    public boolean getMenuItemEnableStatus(ITopWindow iTopWindow) {
        if (this.mFrame instanceof DataFrame) {
            return ((DataFrame)this.mFrame).getDatasetId().equals((Object)DataMgr.getDataMgr().getActiveDocumentId()) || !ProcedureDlgMgr.getMgr().anyProcedureDialogsRunning(true);
        }
        return super.getMenuItemEnableStatus(iTopWindow);
    }
}

