/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.actions;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.comp_util.UtilityProxy;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.output.IOutputDocument;
import com.spss.java_client.core.documents.output.OutputManager;
import com.spss.java_client.core.documents.syntax.ISyntaxDocument;
import com.spss.java_client.core.documents.syntax.SyntaxMgr;
import com.spss.java_client.core.script.ScriptingFrameworkException;
import com.spss.java_client.core.script.ScriptingUtil;
import com.spss.java_client.core.script.engine.IScriptCompletionListener;
import com.spss.java_client.core.script.engine.IScriptCompletionResult;
import com.spss.java_client.core.script.engine.ScriptEngine;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.controlbar.ToolbarsUtil;
import com.spss.java_client.ui.controlbar.UserTool;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.doc_types.ITopWindow;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.actions.SpssAction;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.shared.core_tools.utils.ConsumeStream;
import com.spss.uitools.help.BrowserLaunch;
import com.spss.uitools.help.StatsHelp;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;

public class UserMenuAction
extends SpssAction
implements IScriptCompletionListener {
    private UserTool mUserTool;
    private String mFileExtension;
    private static String JAVA_CLIENT_PORT = "JAVA_CLIENT_PORT";

    public UserMenuAction(String string) {
        super(string);
        this.mUserTool = ToolbarsUtil.getUserDefinedTool(string);
        if (this.mUserTool != null) {
            this.configureAction(false);
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            this.putValue("Name", stringTokenizer.nextToken());
            if (stringTokenizer.hasMoreElements()) {
                this.putValue("MnemonicKey", Integer.parseInt(stringTokenizer.nextToken()));
            }
        }
    }

    @Override
    public boolean getMenuItemEnableStatus(ITopWindow iTopWindow) {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.mUserTool != null) {
            String string = this.mUserTool.getFileName();
            string = string.replace("\"", "");
            boolean bl = true;
            if (this.mUserTool.getLaunchType().equals("application")) {
                this.launchApplication(string, bl);
            } else if (this.mUserTool.getLaunchType().equals("syntax") && this.checkLaunchTargetExists(string)) {
                SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedFrame(DocType.SYNTAX_DOC);
                ISyntaxDocument iSyntaxDocument = SyntaxMgr.getSyntaxMgr().openSyntaxDocument(new File(string));
                if (iSyntaxDocument != null) {
                    SyntaxMgr.getSyntaxMgr().executeSyntax(iSyntaxDocument.getSyntax());
                    iSyntaxDocument.closeDocument();
                    if (spssFrame != null) {
                        SpssFrameMgr.getSpssFrameMgr().designateWindow(spssFrame);
                    }
                }
            } else if (this.mUserTool.getLaunchType().equals("script")) {
                try {
                    ScriptEngine.getScriptEngine().runScript(string, (IScriptCompletionListener)this);
                }
                catch (ScriptingFrameworkException scriptingFrameworkException) {
                    IOutputDocument iOutputDocument = OutputManager.getOutputManager().getDesignatedDocument();
                    iOutputDocument.notifyOutputLog("\n");
                    iOutputDocument.notifyOutputLog("(" + scriptingFrameworkException.getErrorCode() + ") " + scriptingFrameworkException.getMessage());
                    iOutputDocument.notifyOutputLog("\n");
                }
            }
        }
    }

    public static void launchExecutable(Vector<String> vector) {
        if (vector != null && !vector.isEmpty() && vector.firstElement().length() > 0) {
            try {
                Object object;
                Vector<String> vector2 = new Vector<String>();
                ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
                if (OSInfo.getOSType() == OSInfo.OSType.WIN) {
                    vector2.addAll(vector);
                    object = processBuilder.environment();
                    object.put((String)JAVA_CLIENT_PORT, (String)(ScriptingUtil.getJCRpcId() + ""));
                } else if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                    vector2.add("open");
                    vector2.addAll(vector);
                } else {
                    vector2.addAll(vector);
                }
                processBuilder.command(vector2);
                object = processBuilder.start();
                new ConsumeStream(((Process)object).getInputStream(), System.out).start();
                new ConsumeStream(((Process)object).getErrorStream(), System.err).start();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static void launchDocument(Vector<String> vector) {
        if (vector != null && !vector.isEmpty() && vector.firstElement().length() > 0) {
            try {
                Object object;
                Vector<String> vector2 = new Vector<String>();
                ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
                if (OSInfo.getOSType() == OSInfo.OSType.WIN) {
                    vector2.add("rundll32");
                    vector2.add("url.dll,FileProtocolHandler");
                    vector2.addAll(vector);
                    object = processBuilder.environment();
                    object.put((String)JAVA_CLIENT_PORT, (String)(ScriptingUtil.getJCRpcId() + ""));
                } else if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                    vector2.add("open");
                    vector2.addAll(vector);
                } else {
                    if (vector.firstElement().endsWith(".pdf")) {
                        BrowserLaunch browserLaunch = BrowserLaunch.getBrowserLaunch();
                        browserLaunch.openURL(vector.firstElement());
                        return;
                    }
                    vector2.addAll(vector);
                }
                processBuilder.command(vector2);
                object = processBuilder.start();
                new ConsumeStream(((Process)object).getInputStream(), System.out).start();
                new ConsumeStream(((Process)object).getErrorStream(), System.err).start();
            }
            catch (Exception exception) {
                BrowserLaunch browserLaunch = BrowserLaunch.getBrowserLaunch();
                browserLaunch.openURL(vector.firstElement());
            }
        }
    }

    @Override
    public void enableToolTip() {
        this.putValue("ShortDescription", this.mUserTool.getName());
    }

    @Override
    protected void configureAction(boolean bl) {
        int n;
        Object object;
        if (bl && (object = ResUtil.getImageURL(this.mUserTool.getImageKey())) != null) {
            this.putValue("SmallIcon", new ImageIcon((URL)object));
        }
        if ((object = this.mUserTool.getName()) != null) {
            this.putValue("Name", object);
        }
        if (OSInfo.getOSType() != OSInfo.OSType.MAC && (n = this.mUserTool.getMnemonicKey()) != 0) {
            this.putValue("MnemonicKey", n);
        }
    }

    private void launchApplication(String string, boolean bl) {
        boolean bl2;
        if (string.startsWith("http:")) {
            bl2 = true;
        } else {
            bl2 = new File(string).exists();
            if (!bl2) {
                if (string.contains("AmosGraphicsCLI.exe")) {
                    int n = string.indexOf("AmosGraphicsCLI.exe");
                    String string2 = string.substring(0, n + "AmosGraphicsCLI.exe".length());
                    bl2 = new File(string2).exists();
                    try {
                        if (bl2) {
                            SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
                            if (spssFrame != null && !spssFrame.getCoreDocument().isDocumentEmpty()) {
                                String string3 = spssFrame.getCoreDocument().getFileSpec().getAbsolutePath();
                                string = string.replaceAll("%1", "");
                                StringBuffer stringBuffer = new StringBuffer(string);
                                stringBuffer.append("\"").append(string3).append("\"");
                                Runtime.getRuntime().exec(stringBuffer.toString());
                            } else {
                                BrowserLaunch browserLaunch = BrowserLaunch.getBrowserLaunch();
                                browserLaunch.openURL(string2, bl);
                            }
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    return;
                }
                if (OSInfo.getOSType() == OSInfo.OSType.WIN && string.startsWith("hh.exe")) {
                    int n = string.indexOf("::");
                    if (string.length() < 5 || n < 0) {
                        return;
                    }
                    String string4 = string.substring(n + 2, string.length() - 4);
                    StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, string4);
                    return;
                }
                string = !string.startsWith(File.separator) ? System.getProperty("application.home") + File.separator + string : System.getProperty("application.home") + string;
                bl2 = this.checkLaunchTargetExists(string);
            }
        }
        if (bl2) {
            Vector<String> vector = new Vector<String>();
            if (this.mUserTool.getDataExportFormat().equals("none")) {
                vector.add(string);
                UserMenuAction.launchDocument(vector);
            } else {
                UtilityProxy utilityProxy = UtilityProxy.getUtilProxy();
                String string5 = utilityProxy.getServerTemporaryFileName();
                boolean bl3 = SyntaxMgr.getSyntaxMgr().executeSynchronousSyntax(this.getSaveFileSyntax(this.mUserTool.getDataExportFormat(), string5));
                if (bl3) {
                    String string6 = PrefsMgr.getPrefsMgr().getTempPath();
                    String string7 = "SPSS";
                    int n = 1;
                    String string8 = string6 + string7 + n + this.mFileExtension;
                    while (new File(string8).exists()) {
                        string8 = string6 + string7 + ++n + this.mFileExtension;
                    }
                    new File(string8).deleteOnExit();
                    boolean bl4 = utilityProxy.copyServerFile(string5, string8, false);
                    if (bl4) {
                        vector.add(string);
                        vector.add(string8);
                    }
                    utilityProxy.deleteServerFile(string5);
                }
                UserMenuAction.launchExecutable(vector);
            }
        }
    }

    private boolean checkLaunchTargetExists(String string) {
        boolean bl = new File(string).exists();
        if (!bl) {
            String string2 = ResUtil.getCommonDlgString("ERR_CANNOT_START").replace("%s", string);
            SpssAlertOptionPane.showWarningMessageDialog(SpssFrameMgr.getSpssFrameMgr().getLastActiveFrame(), string2, VersionInfo.getAppVersionString());
        }
        return bl;
    }

    private String getSaveFileSyntax(String string, String string2) {
        String string3;
        if (string.equals("spss_data_file")) {
            string3 = "SAVE OUTFILE='" + string2 + "' /UNSELECTED DELETE.EXECUTE.";
            this.mFileExtension = ".sav";
        } else {
            String string4 = null;
            if (string.equals("xls_excel")) {
                string4 = "XLS";
                this.mFileExtension = ".xls";
            } else if (string.equals("sylk")) {
                string4 = "SLK";
                this.mFileExtension = ".slk";
            } else if (string.equals("lotus_123_release_3")) {
                string4 = "WK3";
                this.mFileExtension = ".wks";
            } else if (string.equals("tab_delimited")) {
                string4 = "TAB";
                this.mFileExtension = ".dat";
            } else if (string.equals("dbase_iv")) {
                string4 = "DB4";
                this.mFileExtension = ".dbf";
            }
            string3 = "SAVE TRANSLATE OUTFILE='" + string2 + "'\n /TYPE=" + string4 + "\n /REPLACE \n/FIELDNAMES \n/CELLS=VALUES. \nEXECUTE.";
        }
        return string3;
    }

    public void notifyScriptCompletion(IScriptCompletionResult iScriptCompletionResult) {
        IOutputDocument iOutputDocument = OutputManager.getOutputManager().getDesignatedDocument();
        if (iScriptCompletionResult.isErrorOccured()) {
            iOutputDocument.notifyOutputLog("\n");
            iOutputDocument.notifyOutputLog("\nERROR : (" + iScriptCompletionResult.getErrorCode() + ") " + iScriptCompletionResult.getErrorMessage());
            iOutputDocument.notifyOutputLog("\n");
        }
        String string = iScriptCompletionResult.getScriptOutput();
        String string2 = iScriptCompletionResult.getScriptErrors();
        if (string != null && !string.trim().equals("")) {
            iOutputDocument.notifyOutputLog("\n");
            iOutputDocument.notifyOutputLog(string);
            iOutputDocument.notifyOutputLog("\n");
        }
        if (string2 != null && !string2.trim().equals("")) {
            iOutputDocument.notifyOutputLog("\n");
            iOutputDocument.notifyOutputLog(string2);
            iOutputDocument.notifyOutputLog("\n");
        }
    }
}

