/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.actions;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.actions.SpssAction;
import com.spss.java_client.ui.doc_types.actions.syntax.RunAction;
import com.spss.java_client.ui.doc_types.syntax.SyntaxFrame;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.help.StatsHelp;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;

public class SyntaxHelpAction
extends SpssAction {
    public SyntaxHelpAction(String string) {
        super(string);
        this.configureAction(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        SpssFrame spssFrame = this.getFrame((Container)actionEvent.getSource());
        SyntaxHelpAction.doHelpForSyntaxFrame((SyntaxFrame)spssFrame);
    }

    private static ArrayList<File> getExtensionInstallPath() {
        Object object2;
        String[] stringArray;
        ArrayList<File> arrayList = new ArrayList<File>();
        String string = System.getenv("SPSS_EXTENSIONS_PATH");
        if (string != null) {
            object2 = stringArray = string.split(File.pathSeparator);
            int n = ((String[])object2).length;
            for (int i = 0; i < n; ++i) {
                String string2 = object2[i];
                arrayList.add(new File(string2));
            }
        }
        if ((stringArray = System.getenv("SPSSEX_EXTENSIONS_PATH")) != null) {
            for (String object3 : object2 = stringArray.split(File.pathSeparator)) {
                arrayList.add(new File(object3));
            }
        }
        if ((object2 = FileLocationsUtil.getAppdataExtensionsDirectoryForAllUsers()) != null) {
            File file = new File((String)object2);
            arrayList.add(file);
        }
        File file = new File(FileLocationsUtil.getAppdataExtensionsDirectory());
        arrayList.add(file);
        String string3 = System.getProperty("std_deployment.home");
        if (string3 == null) {
            string3 = "";
        }
        StringBuilder stringBuilder = new StringBuilder(string3);
        if (!string3.endsWith(File.separator)) {
            stringBuilder.append(File.separator);
        }
        stringBuilder.append("extensions").append(File.separator);
        File file2 = new File(stringBuilder.toString());
        arrayList.add(file2);
        return arrayList;
    }

    private static boolean IsExtensionCommand(String string) {
        for (File file : SyntaxHelpAction.getExtensionInstallPath()) {
            File[] fileArray;
            if (file == null || !file.exists() || (fileArray = file.listFiles()) == null) continue;
            for (File file2 : fileArray) {
                if (!file2.getName().endsWith("xml") || !string.toUpperCase().contains(file2.getName().substring(0, file2.getName().lastIndexOf(".")).toUpperCase())) continue;
                return true;
            }
        }
        return false;
    }

    public static void doHelpForSyntaxFrame(SyntaxFrame syntaxFrame) {
        String string = syntaxFrame.getCommandHelpFileNameForSyntaxSegment(SyntaxFrame.SyntaxSegment.CURRENT);
        if (string != null && string.length() > 0) {
            if (SyntaxHelpAction.IsExtensionCommand(string)) {
                if (DataServerProxy.getDataProxy().isRemoteConnection()) {
                    String string2 = ResUtil.getCommonDlgString("ERR_DISTRIBUTE_EXTENSION_HELP_MSG");
                    String string3 = ResUtil.getCommonDlgString("IDS_OK");
                    SpssAlertOptionPane.showWarningMessageDialog(syntaxFrame, string2, VersionInfo.getAppVersionString());
                } else {
                    RunAction.doRunForSegmentToGetExtensionHelp(syntaxFrame, SyntaxFrame.SyntaxSegment.CURRENT);
                }
            } else {
                StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.SYNTAX, string);
            }
        }
    }
}

