/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.actions;

import com.spss.java_client.core.common.LicenseOption;
import com.spss.java_client.ui.doc_types.ITopWindow;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.doc_util.OptionLocator;
import com.spss.java_client.ui.doc_types.doc_util.ProcedureDialogLoader;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import java.awt.Component;
import java.io.Serializable;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public abstract class SpssAction
extends AbstractAction
implements Cloneable {
    protected String mActionId = null;
    protected ProcedureDialogLoader.ProcDialogListener mProcDialogListener;

    public SpssAction(String string) {
        this.mActionId = string;
    }

    public String getActionId() {
        return this.mActionId;
    }

    public LicenseOption getLicenseOption() {
        return OptionLocator.getOption(this.getActionId());
    }

    public SpssFrame getFrame(Component component) {
        SpssFrame spssFrame = null;
        while (component != null && !(component instanceof SpssFrame)) {
            Component component2 = component;
            if (component instanceof JPopupMenu) {
                component = ((JPopupMenu)component).getInvoker();
                continue;
            }
            component = component2.getParent();
        }
        if (component != null) {
            spssFrame = (SpssFrame)component;
        }
        return spssFrame;
    }

    public ITopWindow getTopWindow(Component component) {
        ITopWindow iTopWindow = null;
        while (component != null && !(component instanceof ITopWindow)) {
            Component component2 = component;
            if (component instanceof JPopupMenu) {
                component = ((JPopupMenu)component).getInvoker();
                continue;
            }
            component = component2.getParent();
        }
        if (component != null) {
            iTopWindow = (ITopWindow)((Object)component);
        }
        return iTopWindow;
    }

    public JFrame getJFrame(Component component) {
        while (component != null && !(component instanceof JFrame)) {
            Component component2 = component;
            if (component instanceof JPopupMenu) {
                component = ((JPopupMenu)component).getInvoker();
                continue;
            }
            component = component2.getParent();
        }
        return (JFrame)component;
    }

    public JMenuItem getMenuItem() {
        return new JMenuItem(this);
    }

    public boolean getMenuItemCheckStatus(SpssFrame spssFrame) {
        return false;
    }

    public boolean getMenuItemEnableStatus(ITopWindow iTopWindow) {
        return true;
    }

    public void updateMenuText(JMenuItem jMenuItem) {
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        SpssAction spssAction = (SpssAction)super.clone();
        spssAction.changeSupport = null;
        return spssAction;
    }

    protected void configureAction(boolean bl) {
        try {
            Serializable serializable;
            Object object;
            if (bl && (object = ResUtil.getImageURL(this.mActionId)) != null) {
                this.putValue("SmallIcon", new ImageIcon((URL)object));
            }
            if ((object = ResUtil.getString(this.mActionId)) != null) {
                this.putValue("Name", object);
            }
            if (OSInfo.getOSType() != OSInfo.OSType.MAC && (serializable = ResUtil.getAccessKey(this.mActionId)) != null) {
                this.putValue("MnemonicKey", serializable);
            }
            if ((serializable = ResUtil.getShortcut(this.mActionId)) != null) {
                this.putValue("AcceleratorKey", serializable);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void enableToolTip() {
        String string = ResUtil.getTooltip(this.mActionId);
        if (string != null) {
            this.putValue("ShortDescription", string);
        }
    }

    public boolean showMenu() {
        return true;
    }

    public ProcedureDialogLoader.ProcDialogListener getProcDialogListener() {
        return this.mProcDialogListener;
    }

    public void setProcDialogListener(ProcedureDialogLoader.ProcDialogListener procDialogListener) {
        this.mProcDialogListener = procDialogListener;
    }

    public boolean careMeasurementLevel() {
        return false;
    }

    public boolean careDVP() {
        return false;
    }
}

