/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.actions;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.documents.output.IOutputDocument;
import com.spss.java_client.core.documents.output.OutputManager;
import com.spss.java_client.core.resources.CoreResUtil;
import com.spss.java_client.core.script.ScriptingFrameworkException;
import com.spss.java_client.core.script.engine.IScriptCompletionListener;
import com.spss.java_client.core.script.engine.IScriptCompletionResult;
import com.spss.java_client.core.script.engine.IScriptLanguage;
import com.spss.java_client.core.script.engine.IScriptLanguageMgr;
import com.spss.java_client.core.script.engine.ScriptEngine;
import com.spss.java_client.core.script.engine.ScriptLanguageMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.actions.SpssAction;
import com.spss.java_client.ui.resources.ResUtil;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.filechooser.FileFilter;

public class RunScriptAction
extends SpssAction
implements IScriptCompletionListener {
    public RunScriptAction() {
        this("utilities_run_script");
    }

    public RunScriptAction(String string) {
        super(string);
        this.configureAction(true);
    }

    public boolean getMenuItemEnableStatus(SpssFrame spssFrame) {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        SpssFrame spssFrame = this.getFrame((Container)actionEvent.getSource());
        IScriptLanguageMgr iScriptLanguageMgr = ScriptLanguageMgr.getInstance();
        Vector vector = iScriptLanguageMgr.getAllLanguages();
        if (!vector.isEmpty()) {
            RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.OpenFile, RemoteFileChooser.ChooserOption.Script, FileLocationsUtil.getOtherFilesDirectoryPath(), false);
            remoteFileChooser.setDialogTitle(CoreResUtil.getString((String)"IDS_FILE_CHOOSER_RUN_SCRIPT_TITLE"));
            remoteFileChooser.setApproveButtonText(CoreResUtil.getString((String)"IDS_FILE_CHOOSER_RUN_BUTTON"));
            remoteFileChooser.setApproveButtonMnemonic(CoreResUtil.getDlgAccessKey((String)"IDK_FILE_CHOOSER_RUN_BUTTON"));
            String string = iScriptLanguageMgr.getDefaultLanguage().getLanguageName();
            this.setFileFilters(remoteFileChooser, string);
            this.setPythonVersion(remoteFileChooser, string);
            remoteFileChooser.setPythonVersionControlsVisible(iScriptLanguageMgr.isPythonScriptInstalled());
            int n = remoteFileChooser.showOpenDialog(this.getFrame(((Container)actionEvent.getSource()).getParent()));
            if (n == 0) {
                FileLocationsUtil.setOtherFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
                ScriptEngine.getScriptEngine().setSelectedPythonVersion(remoteFileChooser.getPythonVersionSelection());
                try {
                    ScriptEngine.getScriptEngine().runScript(remoteFileChooser.getSelectedFilePath(), (IScriptCompletionListener)this);
                }
                catch (ScriptingFrameworkException scriptingFrameworkException) {
                    IOutputDocument iOutputDocument = OutputManager.getOutputManager().getDesignatedDocument();
                    iOutputDocument.notifyOutputLog("\n");
                    iOutputDocument.notifyOutputLog("(" + scriptingFrameworkException.getErrorCode() + ") " + scriptingFrameworkException.getMessage());
                    iOutputDocument.notifyOutputLog("\n");
                }
            }
        } else {
            SpssAlertOptionPane.showErrorMessageDialog(spssFrame, ResUtil.getString("ERR_NO_SCRIPTING_LANGUAGE_AVAILABLE_TO_RUN"), VersionInfo.getAppVersionString());
        }
    }

    private void setFileFilters(RemoteFileChooser remoteFileChooser, String string) {
        IScriptLanguageMgr iScriptLanguageMgr = ScriptLanguageMgr.getInstance();
        Vector vector = iScriptLanguageMgr.getAllLanguages();
        if (!vector.isEmpty()) {
            RefFileFilter refFileFilter = null;
            String string2 = string.contains("Python") ? "Python" : string;
            for (IScriptLanguage iScriptLanguage : vector) {
                RefFileFilter refFileFilter2;
                String string3;
                if (iScriptLanguage.getLanguageName().equalsIgnoreCase("Python2")) {
                    string3 = "Python";
                } else {
                    if (iScriptLanguage.getLanguageName().equalsIgnoreCase("Python3")) continue;
                    string3 = iScriptLanguage.getLanguageName();
                }
                Vector vector2 = iScriptLanguage.getFileExtensions();
                StringBuffer stringBuffer = new StringBuffer();
                if (vector2.size() != 0) {
                    refFileFilter2 = iScriptLanguage.getFileExtensions().iterator();
                    stringBuffer.append((String)refFileFilter2.next());
                    while (refFileFilter2.hasNext()) {
                        String string4 = (String)refFileFilter2.next();
                        stringBuffer.append(";");
                        stringBuffer.append(string4);
                    }
                }
                if (stringBuffer.length() <= 0) continue;
                refFileFilter2 = new RefFileFilter(string3 + " (" + stringBuffer.toString() + ")", stringBuffer.toString(), ";");
                remoteFileChooser.addChoosableFileFilter((FileFilter)refFileFilter2);
                if (!iScriptLanguage.getLanguageName().toLowerCase().contains(string2.toLowerCase())) continue;
                refFileFilter = refFileFilter2;
            }
            remoteFileChooser.setAcceptAllFileFilterUsed(true);
            if (refFileFilter != null) {
                remoteFileChooser.setFileFilter((FileFilter)refFileFilter);
            }
        }
    }

    @Override
    public boolean showMenu() {
        return true;
    }

    public void notifyScriptCompletion(IScriptCompletionResult iScriptCompletionResult) {
        IOutputDocument iOutputDocument = OutputManager.getOutputManager().getDesignatedDocument();
        if (iScriptCompletionResult.isErrorOccured()) {
            iOutputDocument.notifyOutputLog("\n");
            iOutputDocument.notifyOutputLog("\nERROR : (" + iScriptCompletionResult.getErrorCode() + ") " + iScriptCompletionResult.getErrorMessage());
            iOutputDocument.notifyOutputLog("\n");
        }
        String string = iScriptCompletionResult.getScriptOutput();
        String string2 = iScriptCompletionResult.getScriptErrors();
        if (string != null && !string.trim().equals("")) {
            iOutputDocument.notifyOutputLog("\n");
            iOutputDocument.notifyOutputLog(string);
            iOutputDocument.notifyOutputLog("\n");
        }
        if (string2 != null && !string2.trim().equals("")) {
            iOutputDocument.notifyOutputLog("\n");
            iOutputDocument.notifyOutputLog(string2);
            iOutputDocument.notifyOutputLog("\n");
        }
    }

    private void setPythonVersion(RemoteFileChooser remoteFileChooser, String string) {
        if (string.toLowerCase().contains("python")) {
            remoteFileChooser.setPythonVersionSelection(string.substring(6));
        }
    }
}

