/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.actions;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.documents.data.data_access.DacMgr;
import com.spss.java_client.core.documents.data.data_access.DacType;
import com.spss.java_client.core.documents.data.data_access.ODBC.ODBCDacProxy;
import com.spss.java_client.core.documents.syntax.SyntaxMgr;
import com.spss.java_client.ui.dialogs.base.file.openquery.DBWizardDataReader;
import com.spss.java_client.ui.dialogs.base.file.openquery.DBWizardDlgType;
import com.spss.java_client.ui.dialogs.base.file.openquery.KeyDoesNotExistsException;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.odbc.ODBC;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.GenerateSyntax;
import com.spss.java_client.ui.dialogs.base.file.res.FileResBundle;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.doc_types.ITopWindow;
import com.spss.java_client.ui.doc_types.actions.SpssAction;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;

public class RunQueryAction
extends SpssAction {
    public RunQueryAction() {
        this("file_run_query");
    }

    public RunQueryAction(String string) {
        super(string);
        this.configureAction(true);
    }

    @Override
    public boolean getMenuItemEnableStatus(ITopWindow iTopWindow) {
        ODBCDacProxy oDBCDacProxy;
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        boolean bl = false;
        if (DacMgr.getDacMgr().isDacPackageInstalled(DacType.DAC_ODBC) && (oDBCDacProxy = ODBCDacProxy.getODBCDacProxy()).isServerPackageLoaded()) {
            ODBCDacProxy.SqlReturnCode sqlReturnCode = new ODBCDacProxy.SqlReturnCode(oDBCDacProxy);
            oDBCDacProxy.getDataSources(vector, sqlReturnCode);
            if (OSInfo.getOSType() == OSInfo.OSType.WIN) {
                ODBCDacProxy.getODBCDacProxy().getOleDbDataSources(vector2, sqlReturnCode);
                bl = vector2.size() > 0;
            }
        }
        return ComponentState.getProcessorAvailable() && !ComponentState.getProcessorBusy() && (vector.size() > 0 || bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        Component component;
        JFrame jFrame = this.getFrame((Container)actionEvent.getSource());
        if (jFrame == null) {
            for (component = (Component)actionEvent.getSource(); component != null && !(component instanceof JFrame); component = component.getParent()) {
            }
            if (component instanceof JFrame) {
                jFrame = (JFrame)component;
                object = new ImageIcon(ResUtil.getImageURL("IDI_DE_WINDOW_ACTIVE"));
                jFrame.setIconImage(((ImageIcon)object).getImage());
            }
        }
        DBWizardDlgType.setDBWizardDlgType(DBWizardDlgType.DBWizardDialogTypeEnum.eRunQueryDlg);
        component = new RemoteFileChooser(RemoteFileChooser.ChooserType.OpenFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getOtherFilesDirectoryPath(), false);
        object = ResUtil.getBundle(FileResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        RefFileFilter refFileFilter = new RefFileFilter(ResUtil.getString((ResourceBundle)object, "IDS_DB_COMMON_DATABASE_QUERY"), ResUtil.getString((ResourceBundle)object, "IDS_DB_COMMON_SPQ"));
        ((RemoteFileChooser)component).addChoosableFileFilter((FileFilter)refFileFilter);
        ((RemoteFileChooser)component).setAcceptAllFileFilterUsed(true);
        ((RemoteFileChooser)component).setFileFilter((FileFilter)refFileFilter);
        ((JFileChooser)component).setDialogTitle(VersionInfo.getAppVersionString());
        int n = ((JFileChooser)component).showOpenDialog(jFrame);
        if (n == 0) {
            FileLocationsUtil.setOtherFilesDirectoryPath((String)((RemoteFileChooser)component).getCurrentDirectory().getAbsolutePath());
            String string = ((RemoteFileChooser)component).getSelectedFilePath();
            if (string.length() > 0) {
                try {
                    boolean bl = DBWizardDataReader.readSerializedData(string);
                    if (bl) {
                        GenerateSyntax generateSyntax = GenerateSyntax.getGenerateSyntax();
                        String string2 = generateSyntax.generateSPSSSyntax();
                        string2 = generateSyntax.handlePrompts(string2);
                        SyntaxMgr.getSyntaxMgr().executeSyntax(string2);
                    }
                }
                catch (KeyDoesNotExistsException keyDoesNotExistsException) {
                    SpssAlertOptionPane.showWarningMessageDialog(jFrame, MessageFormat.format(ResUtil.getString((ResourceBundle)object, "ERR_DB_COMMON_INCOMPITIBLE_FORMAT"), string), ResUtil.getString((ResourceBundle)object, "IDS_DBWIZARD_WARNING_TITLE"));
                }
                catch (IOException iOException) {
                    SpssAlertOptionPane.showWarningMessageDialog(jFrame, MessageFormat.format(ResUtil.getString((ResourceBundle)object, "ERR_DB_COMMON_INCOMPITIBLE_FORMAT"), string), ResUtil.getString((ResourceBundle)object, "IDS_DBWIZARD_WARNING_TITLE"));
                }
                finally {
                    ODBC.getODBC().disconnect();
                }
            }
        }
    }
}

