/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.actions;

import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.command.ActionCatalog;
import com.spss.java_client.ui.doc_types.ITopWindow;
import com.spss.java_client.ui.doc_types.actions.SpssAction;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.doc_types.doc_util.ProcedureDialogLoader;
import com.spss.java_client.ui.resources.ResUtil;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.prefs.Preferences;
import javax.swing.ImageIcon;

public class ProcedureAction
extends SpssAction
implements Cloneable {
    protected String mDialogPath;

    public ProcedureAction(String string) {
        super(string);
        this.mDialogPath = null;
        if (!ActionCatalog.isNonMenuAction(string)) {
            this.configureAction(true);
        }
    }

    public ProcedureAction(String string, String string2) {
        super(string);
        this.mDialogPath = string2;
        if (!ActionCatalog.isNonMenuAction(string)) {
            this.configureAction(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof Container) {
            Container container = (Container)object;
            ProcedureDialogLoader.showDialog(this, this.getJFrame(container.getParent()));
        }
    }

    public String getDlgLaunchPath() {
        return this.mDialogPath;
    }

    @Override
    public ProcedureDialogLoader.ProcDialogListener getProcDialogListener() {
        return super.getProcDialogListener();
    }

    @Override
    public void setProcDialogListener(ProcedureDialogLoader.ProcDialogListener procDialogListener) {
        super.setProcDialogListener(procDialogListener);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public boolean getMenuItemEnableStatus(ITopWindow iTopWindow) {
        if (!ActionCatalog.isNonMenuAction(this.mActionId)) {
            this.swapMultipleImputationIcons();
        }
        return super.getMenuItemEnableStatus(iTopWindow);
    }

    public void swapMultipleImputationIcons() {
        if (this.isPoolingIcon(this.mActionId)) {
            if (this.isMultiplImputationOn()) {
                this.putValue("SmallIcon", new ImageIcon(ResUtil.getImageResource("multiple_imputation_procedure_icon.png")));
            } else {
                URL uRL = ResUtil.getImageURL(this.mActionId);
                if (uRL != null) {
                    this.putValue("SmallIcon", new ImageIcon(uRL));
                }
            }
        }
    }

    public boolean isMultiplImputationOn() {
        ISpssDataSrc iSpssDataSrc;
        boolean bl = false;
        DataFrame dataFrame = (DataFrame)SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
        if (dataFrame != null && dataFrame.getDatasetId() != null && (iSpssDataSrc = DataMgr.getDataMgr().getDataSource(dataFrame.getDatasetId())) != null && iSpssDataSrc.columnCount() > 0 && iSpssDataSrc.isMultipleImputation()) {
            bl = true;
        }
        return bl;
    }

    public boolean isPoolingIcon(String string) {
        boolean bl = false;
        if (string.equals("analyze_desc_stat_frequency") || string.equals("analyze_desc_stat_descriptive") || string.equals("analyze_desc_stat_crosstab") || string.equals("analyze_comp_means_means") || string.equals("analyze_comp_means_one_ttest") || string.equals("analyze_comp_means_indep_ttest") || string.equals("analyze_comp_means_paired_ttest") || string.equals("analyze_comp_means_one_anova") || string.equals("analyze_gen_linear_univariate") || string.equals("analyze_mixed_linear") || string.equals("analyze_generalized_linear_model_glm") || string.equals("analyze_generalized_linear_model_gee") || string.equals("analyze_correlate_bivariate") || string.equals("analyze_correlate_partial") || string.equals("analyze_regression_linear") || string.equals("analyze_regression_binary_logist") || string.equals("analyze_regression_multi_logist") || string.equals("analyze_regression_ordinal") || string.equals("analyze_classify_discriminant") || string.equals("analyze_nonparam_tests_chi_square") || string.equals("analyze_nonparam_tests_binomial") || string.equals("analyze_nonparam_tests_runs") || string.equals("analyze_nonparam_tests_1_ks") || string.equals("analyze_nonparam_tests_2_indep") || string.equals("analyze_nonparam_tests_k_indep") || string.equals("analyze_nonparam_tests_2_relat") || string.equals("analyze_nonparam_tests_k_relat") || string.equals("analyze_survival_cox_reg") || string.equals("analyze_survival_cox_time_cov")) {
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean careMeasurementLevel() {
        boolean bl = false;
        if (this.mActionId.equals("graphs_chart_builder") || this.mActionId.equals("analyze_classify_tree") || this.mActionId.equals("analyze_classify_nearest_neighbor") || this.mActionId.equals("analyze_neural_networks_multilayer_perceptron") || this.mActionId.equals("analyze_neural_networks_radial_basis_function") || this.mActionId.equals("analyze_multiple_imputation_impute_missing_data") || this.mActionId.equals("analyze_tables_cust_tables") || this.mActionId.equals("data_identify_unusual_cases") || this.mActionId.equals("data_validation_validate_data")) {
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean careDVP() {
        boolean bl = false;
        if (this.mActionId.equals("graphs_chart_builder") || this.mActionId.equals("analyze_tables_cust_tables") || this.mActionId.equals("analyze_classify_tree") || this.mActionId.equals("analyze_temporal_causal_modeling_model") || this.mActionId.equals("analyze_time_series_exploration")) {
            bl = true;
        }
        return bl;
    }

    public boolean skipDVPAlert() {
        boolean bl;
        boolean bl2 = false;
        if (this.mActionId.equals("analyze_classify_tree")) {
            Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
            Preferences preferences2 = preferences.node("dialog_settings/trees");
            boolean bl3 = preferences2.getBoolean("dont_show_trees_warning", false);
            if (bl3 || CommandLine.isClementineCaller()) {
                bl2 = true;
            }
        } else if (this.mActionId.equals("graphs_chart_builder")) {
            bl2 = PrefsMgr.getPrefsMgr().getDialogBooleanPref("chart_builder", "dont_show_chart_builder_warning");
        } else if (this.mActionId.equals("analyze_tables_cust_tables") && ((bl = PrefsMgr.getPrefsMgr().getDialogBooleanPref("custom_table", "dont_show_ctables_warning")) || CommandLine.isExternalCaller())) {
            bl2 = true;
        }
        return bl2;
    }
}

