/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.actions;

import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.comp_util.PES_Repository;
import com.spss.java_client.core.comp_util.PesFile;
import com.spss.java_client.core.comp_util.StatisticsRepositoryFileType;
import com.spss.java_client.core.documents.ICoreDocument;
import com.spss.java_client.core.documents.output.IOutputDocument;
import com.spss.java_client.core.documents.output.OutputDocument;
import com.spss.java_client.core.documents.output.OutputManager;
import com.spss.java_client.core.documents.syntax.SyntaxDocument;
import com.spss.java_client.core.documents.syntax.SyntaxMgr;
import com.spss.java_client.ui.doc_types.ITopWindow;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.actions.PerConnectAction;
import com.spss.java_client.ui.doc_types.actions.SpssAction;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.doc_types.output.ViewerFrame;
import com.spss.java_client.ui.doc_types.syntax.SyntaxFrame;
import com.spss.pes.jaxws.PESBrowser;
import com.spss.pes.jaxws.ResultObjectInfo;
import com.spss.pes.util.RepositoryFileType;
import com.spss.pes.util.jaxws.ResourceAttributes;
import com.spss.repository.client.application.jaxws.Repository;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JFrame;

public class PerStoreAction
extends SpssAction {
    private ResourceAttributes mAttributes;
    private String mURIName = "";
    private String mPerAttributes = null;

    public PerStoreAction() {
        this("file_per_store");
    }

    public PerStoreAction(String string) {
        super(string);
        this.configureAction(true);
    }

    @Override
    public boolean getMenuItemEnableStatus(ITopWindow iTopWindow) {
        return iTopWindow.getCoreDocument() != null && !iTopWindow.getCoreDocument().isDocumentEmpty();
    }

    public String GetURIName() {
        return this.mURIName;
    }

    public DialogResult doStoreDialog(ActionEvent actionEvent, int n, String string, boolean bl) {
        DialogResult dialogResult;
        Object object;
        try {
            object = this.getFrame(((Container)actionEvent.getSource()).getParent());
            PESBrowser.setParentFrame((JFrame)object);
        }
        catch (ClassCastException classCastException) {
            ComponentState.trace((String)"Warning: Unable to get SpssFrame object; processing continues.");
        }
        if (PESBrowser.getLoginCount() == 0) {
            object = new PerConnectAction();
            ((PerConnectAction)object).actionPerformed(actionEvent);
        }
        if (PESBrowser.getLoginCount() == 0) {
            return DialogResult.CANCEL;
        }
        if (PESBrowser.getLoginCount() > 0 && !PerConnectAction.isBackendPESConnected()) {
            PerConnectAction.doBackendPESConnect();
        }
        object = string != null ? string : "";
        Repository repository = PES_Repository.getRepository();
        if (repository != null) {
            repository.refresh();
        }
        String string2 = ComponentState.getCurrentCharsetName();
        RepositoryFileType[] repositoryFileTypeArray = StatisticsRepositoryFileType.mapMimeToRepositoryFileType((int)n);
        PESBrowser.setDesignatedFileTypes((RepositoryFileType[])repositoryFileTypeArray);
        ResultObjectInfo resultObjectInfo = PESBrowser.doStoreObject((String)"", (String)object, (RepositoryFileType)StatisticsRepositoryFileType.matchRepositoryFileType((int)n), (String)string2, (boolean)bl);
        if (resultObjectInfo.getWhichOK() != -1) {
            dialogResult = DialogResult.OK;
        } else if (resultObjectInfo.getWhichPaste() != -1) {
            dialogResult = DialogResult.PASTE;
        } else {
            return DialogResult.CANCEL;
        }
        PesFile pesFile = new PesFile(resultObjectInfo.getPrimaryPastedSyntax());
        pesFile.setExtendedAttributes(resultObjectInfo.getResourceAttributes());
        pesFile.getResourceAtrributes().setMimeType(n);
        pesFile.getResourceAtrributes().setCodePage(string2);
        this.mURIName = resultObjectInfo.getPrimaryPastedSyntax();
        this.mPerAttributes = resultObjectInfo.getSecondaryPastedSyntax();
        pesFile.setResourceAttributesSyntax(this.mPerAttributes);
        this.mAttributes = resultObjectInfo.getResourceAttributes();
        PES_Repository.addUriToPesFileMapItem((PesFile)pesFile);
        return dialogResult;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        SpssFrame spssFrame = this.getFrame(((Container)actionEvent.getSource()).getParent());
        PESBrowser.setParentFrame((JFrame)spssFrame);
        if (PESBrowser.getLoginCount() == 0) {
            PerConnectAction perConnectAction = new PerConnectAction();
            perConnectAction.actionPerformed(actionEvent);
        }
        if (PESBrowser.getLoginCount() == 0) {
            return;
        }
        if (PESBrowser.getLoginCount() > 0 && !PerConnectAction.isBackendPESConnected()) {
            PerConnectAction.doBackendPESConnect();
        }
        boolean bl = !CommandLine.isExternalCaller();
        int n = 3;
        if (spssFrame instanceof SyntaxFrame) {
            bl &= false;
            n = 0;
        } else if (spssFrame instanceof ViewerFrame) {
            bl &= true;
            n = 8;
        }
        String string = spssFrame.getCoreDocument().getDocName();
        string = string != null ? string : "";
        DialogResult dialogResult = this.doStoreDialog(actionEvent, n, string, bl);
        if (dialogResult != DialogResult.CANCEL) {
            if (bl) {
                OutputDocument outputDocument;
                ICoreDocument iCoreDocument;
                StringBuffer stringBuffer = new StringBuffer();
                if (spssFrame instanceof ViewerFrame) {
                    iCoreDocument = spssFrame.getCoreDocument();
                    assert (iCoreDocument instanceof OutputDocument);
                    outputDocument = (OutputDocument)iCoreDocument;
                    stringBuffer.append("\nOUTPUT SAVE NAME=");
                    stringBuffer.append(outputDocument.getOutputDocumentName());
                    stringBuffer.append("\n  OUTFILE=");
                    stringBuffer.append(CharacterUtil.smartQuote((String)this.mURIName));
                    stringBuffer.append(".");
                } else {
                    stringBuffer.append("\nSAVE OUTFILE=");
                    stringBuffer.append(CharacterUtil.smartQuote((String)this.mURIName));
                    stringBuffer.append("\n /COMPRESSED.");
                }
                if (this.mPerAttributes != null) {
                    stringBuffer.append("\nREPOSITORY ATTRIBUTES\n  FILE=");
                    stringBuffer.append(CharacterUtil.smartQuote((String)this.mURIName));
                    stringBuffer.append(this.mPerAttributes);
                    stringBuffer.append(".");
                }
                if (dialogResult == DialogResult.PASTE) {
                    SyntaxMgr.getSyntaxMgr().pasteSyntax(stringBuffer.toString());
                } else if (spssFrame instanceof ViewerFrame) {
                    iCoreDocument = spssFrame.getCoreDocument();
                    assert (iCoreDocument instanceof OutputDocument);
                    outputDocument = (OutputDocument)iCoreDocument;
                    File file = new File(this.mURIName);
                    PesFile pesFile = new PesFile(this.mURIName);
                    pesFile.setExtendedAttributes(this.mAttributes);
                    PES_Repository.addUriToPesFileMapItem((PesFile)pesFile);
                    OutputManager.getOutputManager().saveDocument((IOutputDocument)outputDocument, file, false);
                } else if (spssFrame instanceof DataFrame) {
                    SyntaxMgr.getSyntaxMgr().executeSyntax(stringBuffer.toString());
                }
            } else {
                ICoreDocument iCoreDocument = spssFrame.getCoreDocument();
                assert (iCoreDocument instanceof SyntaxDocument);
                SyntaxDocument syntaxDocument = (SyntaxDocument)iCoreDocument;
                File file = new File(this.mURIName);
                PesFile pesFile = new PesFile(this.mURIName);
                pesFile.setExtendedAttributes(this.mAttributes);
                PES_Repository.addUriToPesFileMapItem((PesFile)pesFile);
                syntaxDocument.saveDocument(file, false);
            }
        }
    }

    public static enum DialogResult {
        CANCEL,
        OK,
        PASTE;

    }
}

