/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.actions;

import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.comp_util.PES_Repository;
import com.spss.java_client.core.comp_util.PesFile;
import com.spss.java_client.core.comp_util.StatisticsRepositoryFileType;
import com.spss.java_client.core.documents.MRUMgr;
import com.spss.java_client.core.documents.data.DataDocument;
import com.spss.java_client.core.documents.output.IOutputDocument;
import com.spss.java_client.core.documents.output.OutputManager;
import com.spss.java_client.core.documents.syntax.ISyntaxDocument;
import com.spss.java_client.core.documents.syntax.SyntaxMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.actions.PerConnectAction;
import com.spss.java_client.ui.doc_types.actions.SpssAction;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.doc_types.output.ViewerFrame;
import com.spss.java_client.ui.doc_types.syntax.SyntaxFrame;
import com.spss.pes.jaxws.PESBrowser;
import com.spss.pes.jaxws.ResultObjectInfo;
import com.spss.pes.util.RepositoryFileType;
import com.spss.pes.util.jaxws.ResourceAttributes;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import javax.swing.JFrame;

public class PerRetrieveAction
extends SpssAction {
    private String mURIName = "";
    private boolean mLockEnabled = false;

    public PerRetrieveAction() {
        this("file_per_retrieve");
    }

    public PerRetrieveAction(String string) {
        super(string);
        this.configureAction(true);
    }

    public String GetURIName() {
        return this.mURIName;
    }

    public boolean isLockEnabled() {
        return this.mLockEnabled;
    }

    public DialogResult doRetrieveDialog(ActionEvent actionEvent, int n, boolean bl) {
        DialogResult dialogResult;
        Serializable serializable;
        try {
            serializable = this.getFrame(((Container)actionEvent.getSource()).getParent());
            PESBrowser.setParentFrame((JFrame)serializable);
        }
        catch (ClassCastException classCastException) {
            ComponentState.trace((String)"Warning: Unable to get SpssFrame object; processing continues.");
        }
        if (PESBrowser.getLoginCount() == 0) {
            serializable = new PerConnectAction();
            ((PerConnectAction)serializable).actionPerformed(actionEvent);
        }
        if (PESBrowser.getLoginCount() == 0) {
            return DialogResult.CANCEL;
        }
        if (PESBrowser.getLoginCount() > 0 && !PerConnectAction.isBackendPESConnected()) {
            PerConnectAction.doBackendPESConnect();
        }
        if ((serializable = PES_Repository.getRepository()) != null) {
            serializable.refresh();
        }
        boolean bl2 = true;
        boolean bl3 = false;
        RepositoryFileType[] repositoryFileTypeArray = StatisticsRepositoryFileType.mapMimeToRepositoryFileType((int)n);
        if (n == 3) {
            // empty if block
        }
        PESBrowser.setDesignatedFileTypes((RepositoryFileType[])repositoryFileTypeArray);
        ResultObjectInfo resultObjectInfo = PESBrowser.doRetrieveObject((String)PrefsMgr.getPrefsMgr().getTempPath(), (RepositoryFileType)StatisticsRepositoryFileType.matchRepositoryFileType((int)n), (boolean)true, (int)0, (boolean)bl, (boolean)bl2, (boolean)bl3);
        if (resultObjectInfo.getWhichOK() != -1) {
            dialogResult = DialogResult.OK;
        } else if (resultObjectInfo.getWhichPaste() != -1) {
            dialogResult = DialogResult.PASTE;
        } else {
            return DialogResult.CANCEL;
        }
        this.mURIName = resultObjectInfo.getPrimaryPastedSyntax();
        ResourceAttributes resourceAttributes = resultObjectInfo.getResourceAttributes();
        this.mLockEnabled = resourceAttributes.getResourceLock();
        return dialogResult;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        SpssFrame spssFrame = this.getFrame(((Container)actionEvent.getSource()).getParent());
        PESBrowser.setParentFrame((JFrame)spssFrame);
        if (PESBrowser.getLoginCount() == 0) {
            PerConnectAction perConnectAction = new PerConnectAction();
            perConnectAction.actionPerformed(actionEvent);
        }
        if (PESBrowser.getLoginCount() == 0) {
            return;
        }
        if (PESBrowser.getLoginCount() > 0 && !PerConnectAction.isBackendPESConnected()) {
            PerConnectAction.doBackendPESConnect();
        }
        boolean bl = !CommandLine.isExternalCaller();
        int n = 3;
        if (spssFrame instanceof SyntaxFrame) {
            bl &= false;
            n = 0;
        } else if (spssFrame instanceof ViewerFrame) {
            bl &= true;
            n = 8;
        }
        DialogResult dialogResult = this.doRetrieveDialog(actionEvent, n, bl);
        if (dialogResult != DialogResult.CANCEL) {
            if (bl) {
                StringBuffer stringBuffer = new StringBuffer();
                if (spssFrame instanceof ViewerFrame) {
                    stringBuffer.append("\nOUTPUT OPEN\n  FILE='");
                    stringBuffer.append(this.mURIName);
                    stringBuffer.append("'\n  NAME=").append(OutputManager.getOutputManager().generateUniqueOutputDocumentName());
                    stringBuffer.append(" LOCK=").append(this.mLockEnabled ? "YES" : "NO").append(".\n");
                } else {
                    stringBuffer.append("\nGET\n  FILE='");
                    stringBuffer.append(this.mURIName);
                    stringBuffer.append("' LOCK=").append(this.mLockEnabled ? "YES" : "NO").append(".\n");
                    stringBuffer.append(".\nDATASET NAME ");
                    stringBuffer.append(DataDocument.getNextFreeDatasetName());
                    stringBuffer.append(" WINDOW=FRONT.");
                }
                if (dialogResult == DialogResult.PASTE) {
                    SyntaxMgr.getSyntaxMgr().pasteSyntax(stringBuffer.toString());
                } else if (spssFrame instanceof ViewerFrame) {
                    PesFile pesFile = new PesFile(this.mURIName);
                    String string = PES_Repository.RetrieveFromPES((PesFile)pesFile, (boolean)this.mLockEnabled);
                    File file = pesFile.getCacheFile();
                    if (file == null) {
                        SpssAlertOptionPane.showWarningMessageDialog(this.getFrame(((Container)actionEvent.getSource()).getParent()), string, VersionInfo.getAppVersionString());
                        return;
                    }
                    IOutputDocument iOutputDocument = OutputManager.getOutputManager().openDocument(file);
                    if (iOutputDocument != null) {
                        MRUMgr.getMRUMgr().addOtherDocumentPath(pesFile.getUri());
                    }
                } else if (spssFrame instanceof DataFrame) {
                    SyntaxMgr.getSyntaxMgr().executeSyntax(stringBuffer.toString());
                }
            } else {
                ISyntaxDocument iSyntaxDocument;
                PesFile pesFile = new PesFile(this.mURIName);
                String string = PES_Repository.RetrieveFromPES((PesFile)pesFile);
                File file = pesFile.getCacheFile();
                if (file == null) {
                    SpssAlertOptionPane.showWarningMessageDialog(this.getFrame(((Container)actionEvent.getSource()).getParent()), string, VersionInfo.getAppVersionString());
                    return;
                }
                String string2 = null;
                String string3 = pesFile.getMimeCodePage();
                if (string2 == null) {
                    string2 = ComponentState.getCurrentCharsetName();
                }
                if ((iSyntaxDocument = SyntaxMgr.getSyntaxMgr().openSyntaxDocument(file, Charset.forName(string2))) != null) {
                    MRUMgr.getMRUMgr().addOtherDocumentPath(pesFile.getUri());
                }
            }
        }
    }

    public static enum DialogResult {
        CANCEL,
        OK,
        PASTE;

    }
}

